/*
 * Decompiled with CFR 0.152.
 */
package com.hoiio.jenkins.plugin;

import com.hoiio.jenkins.plugin.PhoneNumberValidator;
import com.hoiio.sdk.Hoiio;
import com.hoiio.sdk.exception.HoiioException;
import hudson.Extension;
import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.BuildListener;
import hudson.model.Descriptor;
import hudson.model.Result;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.BuildStepMonitor;
import hudson.tasks.Notifier;
import hudson.tasks.Publisher;
import hudson.util.FormValidation;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import javax.servlet.ServletException;
import net.sf.json.JSONObject;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;

public class SMSNotification
extends Notifier {
    private final String recipients;

    @DataBoundConstructor
    public SMSNotification(String recipients) {
        this.recipients = recipients;
    }

    public boolean perform(AbstractBuild build, Launcher launcher, BuildListener listener) {
        if (build.getResult() == Result.FAILURE || build.getResult() == Result.UNSTABLE) {
            String appId = this.getDescriptor().getAppId();
            String accessToken = this.getDescriptor().getAccessToken();
            if (this.isEmpty(this.recipients)) {
                listener.error("No recipients");
                return true;
            }
            if (this.isEmpty(appId) || this.isEmpty(accessToken)) {
                listener.error("Hoiio credentials not configured; cannot send SMS notification");
                return true;
            }
            String message = "Jenkins Build failed: " + build.getProject().getDisplayName() + " at " + this.getDateString(build.getTime());
            if (message.length() > 150) {
                message = "Jenkins Build failed: " + build.getProject().getDisplayName().substring(0, 100) + "... " + " at " + this.getDateString(build.getTime());
            }
            ArrayList<String> receiverList = new ArrayList<String>();
            String recipientStr = this.recipients.trim().replaceAll("\\s", "");
            receiverList.addAll(Arrays.asList(recipientStr.split(",")));
            try {
                Hoiio hoiio = new Hoiio(appId, accessToken);
                hoiio.getSmsService().sendBulk(receiverList, message);
            }
            catch (HoiioException e) {
                listener.error("Failed to send SMS notification: " + e.getMessage());
                build.setResult(Result.UNSTABLE);
            }
        }
        return true;
    }

    public DescriptorImpl getDescriptor() {
        return (DescriptorImpl)super.getDescriptor();
    }

    public String getRecipients() {
        return this.recipients;
    }

    public BuildStepMonitor getRequiredMonitorService() {
        return BuildStepMonitor.NONE;
    }

    private boolean isEmpty(String s) {
        return s == null || s.trim().length() == 0;
    }

    private String getDateString(Date d) {
        return new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(d);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @Extension
    public static final class DescriptorImpl
    extends BuildStepDescriptor<Publisher> {
        private String appId;
        private String accessToken;

        public DescriptorImpl() {
            super(SMSNotification.class);
            this.load();
        }

        public boolean isApplicable(Class<? extends AbstractProject> aClass) {
            return true;
        }

        public String getDisplayName() {
            return "SMS Notification";
        }

        public boolean configure(StaplerRequest req, JSONObject formData) throws Descriptor.FormException {
            this.appId = formData.getString("appId");
            this.accessToken = formData.getString("accessToken");
            this.save();
            return super.configure(req, formData);
        }

        public String getAppId() {
            return this.appId;
        }

        public void setAppId(String appId) {
            this.appId = appId;
        }

        public String getAccessToken() {
            return this.accessToken;
        }

        public void setAccessToken(String accessToken) {
            this.accessToken = accessToken;
        }

        public FormValidation doNumberCheck(@QueryParameter String param) throws IOException, ServletException {
            if (param == null || param.trim().length() == 0) {
                return FormValidation.warning((String)"You must fill recipients' numbers!");
            }
            param = param.trim().replaceAll("\\s", "");
            for (String p : param.split(",")) {
                if (PhoneNumberValidator.validatePhoneNumber(p)) continue;
                return FormValidation.error((String)"Formats of some recipients' numbers are invalid.");
            }
            return FormValidation.ok();
        }
    }
}

