/*
 * Decompiled with CFR 0.152.
 */
package cn.hlq.struggle.manager;

import android.app.DialogFragment;
import android.os.Bundle;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewStub;
import android.widget.TextView;
import cn.hlq.struggle.R;

public class HintDialog
extends DialogFragment {
    private TextView tvTitle;
    private TextView tvContent;
    private TextView tvCancelTextView;
    private TextView tvConfirmTextView;
    private TextView tvSingleTextView;
    private HintConfirmCallback confirmCallback;
    private HintCancelCallback cancelCallback;
    private HintSingleCallback singleCallback;
    private boolean isSingleButton = false;
    private boolean onTouchOutside = false;
    private String title = "\u63d0\u793a";
    private String content;
    private String confirm;
    private String cancel;

    public HintDialog setOnConfirmBtnText(String confirmMsg) {
        this.confirm = confirmMsg;
        return this;
    }

    public HintDialog setOnCancelBtnText(String cancelMsg) {
        this.cancel = cancelMsg;
        return this;
    }

    public HintDialog setIsSingleButton(boolean isSingle) {
        this.isSingleButton = isSingle;
        return this;
    }

    public HintDialog setOnTouchOutside(boolean onTouchOutside) {
        this.onTouchOutside = onTouchOutside;
        return this;
    }

    public HintDialog setTitle(String title) {
        if (!title.isEmpty()) {
            this.title = title;
        }
        return this;
    }

    public HintDialog setContent(String content) {
        this.content = content;
        return this;
    }

    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        this.getDialog().getWindow().setBackgroundDrawableResource(17170445);
        this.getDialog().requestWindowFeature(1);
        this.getDialog().setCanceledOnTouchOutside(this.onTouchOutside);
        View hintView = inflater.inflate(R.layout.hlq_dialog_hint, null);
        this.initView(hintView);
        return hintView;
    }

    private void initView(View hintView) {
        this.tvTitle = (TextView)hintView.findViewById(R.id.tv_hint_dialog_title);
        this.tvContent = (TextView)hintView.findViewById(R.id.tv_hint_dialog_content);
        this.tvTitle.setText((CharSequence)this.title);
        this.tvContent.setText((CharSequence)this.content);
        if (this.isSingleButton) {
            ViewStub vsSingleButton = (ViewStub)hintView.findViewById(R.id.vs_single_button);
            vsSingleButton.inflate();
            this.tvSingleTextView = (TextView)hintView.findViewById(R.id.tv_single);
            this.tvSingleTextView.setOnClickListener(new View.OnClickListener(){

                public void onClick(View view) {
                    HintDialog.this.singleCallback.onClick();
                }
            });
        } else {
            ViewStub vsDoubleButton = (ViewStub)hintView.findViewById(R.id.vs_double_button);
            vsDoubleButton.inflate();
            this.tvCancelTextView = (TextView)hintView.findViewById(R.id.btn_hint_dialog_cancle);
            this.tvConfirmTextView = (TextView)hintView.findViewById(R.id.btn_hint_dialog_confirm);
            if (!"".equals(this.confirm) && this.confirm != null) {
                this.tvConfirmTextView.setText((CharSequence)this.confirm);
            }
            if (!"".equals(this.cancel) && this.cancel != null) {
                this.tvCancelTextView.setText((CharSequence)this.cancel);
            }
            this.tvConfirmTextView.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    HintDialog.this.confirmCallback.onClick();
                }
            });
            this.tvCancelTextView.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    HintDialog.this.cancelCallback.onClick();
                }
            });
        }
    }

    public HintDialog setOnConfirmClickListener(HintConfirmCallback confirmCallback) {
        this.confirmCallback = confirmCallback;
        return this;
    }

    public HintDialog setOnCancelClickListener(HintCancelCallback cancelCallback) {
        this.cancelCallback = cancelCallback;
        return this;
    }

    public HintDialog setOnSingleClickListener(HintSingleCallback singleCallback) {
        this.singleCallback = singleCallback;
        return this;
    }

    public static interface HintSingleCallback {
        public void onClick();
    }

    public static interface HintCancelCallback {
        public void onClick();
    }

    public static interface HintConfirmCallback {
        public void onClick();
    }
}

