/*
 * Decompiled with CFR 0.152.
 */
package com.hlab.animatedPullToRefresh;

import android.content.Context;
import android.graphics.Typeface;
import android.os.Handler;
import android.support.annotation.Nullable;
import android.util.AttributeSet;
import android.view.View;
import android.widget.LinearLayout;
import android.widget.TextView;
import com.hlab.animatedPullToRefresh.AnimatedPullToRefreshLayout;
import com.hlab.animatedPullToRefresh.enums.HeaderAnimSpeed;
import com.hlab.animatedPullToRefresh.enums.HeaderLoopAnim;
import com.hlab.animatedPullToRefresh.enums.HeaderState;
import com.hlab.animatedPullToRefresh.enums.HeaderTextAnim;
import com.hlab.animatedPullToRefresh.herlper.AnimationHelper;
import com.hlab.animatedPullToRefresh.herlper.ViewHelper;
import java.util.List;

class CharacterAnimatorHeaderView
extends LinearLayout
implements AnimatedPullToRefreshLayout.AnimatedPullToRefreshHeaderLayout {
    private List<TextView> characterViewList;
    private ViewHelper viewHelper;
    private AnimationHelper animationHelper;
    private boolean isInitialized = false;
    private int currentIndex = -1;
    private Handler mLoopHandler;
    private Runnable mLoopRunnable;
    private String headerText;
    private int headerBackgroundColor;

    public CharacterAnimatorHeaderView(Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
    }

    public CharacterAnimatorHeaderView(Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
    }

    public CharacterAnimatorHeaderView(Context context) {
        super(context);
        this.setWillNotDraw(false);
        this.viewHelper = new ViewHelper(context);
        this.animationHelper = new AnimationHelper();
    }

    public void initView() {
        this.isInitialized = true;
        this.removeAllViews();
        this.setOrientation(1);
        this.setGravity(80);
        this.setBackgroundColor(this.headerBackgroundColor);
        LinearLayout mContainer = this.viewHelper.generateContainerLayout();
        this.addView((View)mContainer);
        this.characterViewList = this.viewHelper.generateCharacterViewList(this.headerText);
        for (TextView textView : this.characterViewList) {
            mContainer.addView((View)textView);
        }
        this.setupAnimation();
    }

    public void setupAnimation() {
        this.mLoopHandler = new Handler();
        this.mLoopRunnable = new Runnable(){

            @Override
            public void run() {
                CharacterAnimatorHeaderView.this.currentIndex++;
                if (CharacterAnimatorHeaderView.this.currentIndex >= CharacterAnimatorHeaderView.this.characterViewList.size()) {
                    CharacterAnimatorHeaderView.this.currentIndex = -1;
                    if (!CharacterAnimatorHeaderView.this.animationHelper.shouldContinueTextIteration()) {
                        CharacterAnimatorHeaderView.this.playTextAnimation();
                    } else {
                        CharacterAnimatorHeaderView.this.mLoopHandler.postDelayed(CharacterAnimatorHeaderView.this.mLoopRunnable, 20L);
                    }
                } else if (!CharacterAnimatorHeaderView.this.animationHelper.shouldContinueLoopIteration()) {
                    CharacterAnimatorHeaderView.this.playLoopAnimation();
                } else {
                    CharacterAnimatorHeaderView.this.mLoopHandler.postDelayed(CharacterAnimatorHeaderView.this.mLoopRunnable, 20L);
                }
            }
        };
    }

    private void playLoopAnimation() {
        long wait = this.animationHelper.applyTextAnimation(this.characterViewList.get(this.currentIndex));
        this.mLoopHandler.postDelayed(this.mLoopRunnable, wait);
    }

    private void playTextAnimation() {
        long wait = this.animationHelper.applyLoopAnimation(this.characterViewList);
        this.mLoopHandler.postDelayed(this.mLoopRunnable, wait);
    }

    @Override
    public void onStateChange(HeaderState headerState, HeaderState lastHeaderState) {
        if (headerState == lastHeaderState) {
            return;
        }
        switch (headerState) {
            case HEADER_STATE_NORMAL: {
                break;
            }
            case HEADER_STATE_READY: {
                break;
            }
            case HEADER_STATE_REFRESHING: {
                this.mLoopHandler.post(this.mLoopRunnable);
                break;
            }
            case HEADER_STATE_COMPLETE: {
                this.mLoopHandler.removeCallbacks(this.mLoopRunnable);
            }
        }
    }

    public void setColorAnimationArray(int[] colorAnimationArray) {
        this.animationHelper.setColorAnimationArray(colorAnimationArray);
    }

    public void setHeaderText(String headerText) {
        this.headerText = headerText;
    }

    public void setHeaderBackgroundColor(int headerBackgroundColor) {
        this.headerBackgroundColor = headerBackgroundColor;
        this.setBackgroundColor(headerBackgroundColor);
    }

    public void setHeaderTextSize(int headerTextSize) {
        this.viewHelper.setHeaderTextSize(headerTextSize);
        if (this.isInitialized) {
            this.initView();
        }
    }

    public void setHeaderTextColor(int headerTextColor) {
        this.viewHelper.setHeaderTextColor(headerTextColor);
        this.animationHelper.setOriginalColor(headerTextColor);
        if (this.isInitialized) {
            this.initView();
        }
    }

    private void setHeaderPaddingTop(int headerPaddingTop) {
        this.viewHelper.setHeaderPaddingTop(headerPaddingTop);
    }

    private void setHeaderPaddingBottom(int headerPaddingBottom) {
        this.viewHelper.setHeaderPaddingBottom(headerPaddingBottom);
    }

    public void setHeaderTextAnim(HeaderTextAnim headerTextAnim) {
        this.animationHelper.setHeaderTextAnim(headerTextAnim);
    }

    public void setHeaderLoopAnim(HeaderLoopAnim headerLoopAnim) {
        this.animationHelper.setHeaderLoopAnim(headerLoopAnim);
    }

    public void setHeaderTextAnimIteration(int headerTextAnimIteration) {
        this.animationHelper.setHeaderTextAnimIteration(headerTextAnimIteration);
    }

    public void setHeaderLoopAnimIteration(int headerLoopAnimIteration) {
        this.animationHelper.setHeaderLoopAnimIteration(headerLoopAnimIteration);
    }

    public void setColorAnimEnable(boolean colorAnimEnable) {
        this.animationHelper.setColorAnimEnable(colorAnimEnable);
    }

    public void setAnimationSpeed(HeaderAnimSpeed animationSpeed) {
        this.animationHelper.setAnimationSpeed(animationSpeed);
    }

    public void setHeaderTextTypeface(Typeface mTitleTypeface) {
        if (mTitleTypeface != null) {
            this.viewHelper.setHeaderTextTypeface(mTitleTypeface);
            if (this.isInitialized) {
                this.initView();
            }
        }
    }
}

