/*
 * Decompiled with CFR 0.152.
 */
package com.hlab.animatedPullToRefresh;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Rect;
import android.graphics.Typeface;
import android.os.Build;
import android.support.v4.content.res.ResourcesCompat;
import android.support.v4.view.ViewCompat;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewConfiguration;
import android.view.ViewGroup;
import android.view.animation.Animation;
import android.view.animation.Transformation;
import com.hlab.animatedPullToRefresh.AnimationListener;
import com.hlab.animatedPullToRefresh.CharacterAnimatorHeaderView;
import com.hlab.animatedPullToRefresh.R;
import com.hlab.animatedPullToRefresh.enums.HeaderAnimSpeed;
import com.hlab.animatedPullToRefresh.enums.HeaderLoopAnim;
import com.hlab.animatedPullToRefresh.enums.HeaderState;
import com.hlab.animatedPullToRefresh.enums.HeaderTextAnim;

public class AnimatedPullToRefreshLayout
extends ViewGroup {
    private final Animation mAnimateStayComplete = new Animation(){

        public void applyTransformation(float interpolatedTime, Transformation t) {
        }
    };
    private HeaderState currentHeaderState = HeaderState.HEADER_STATE_NORMAL;
    private HeaderState lastHeaderState = HeaderState.HEADER_STATE_DEFAULT;
    private int mTargetOriginalTop;
    private int mFrom;
    private int mTouchSlop;
    private int mDistanceToTriggerSync = -1;
    private int mCurrentTargetOffsetTop = 0;
    private float mPrevY;
    private int mTriggerOffset = 0;
    private boolean mInReturningAnimation;
    private final AnimationListener mReturningAnimationListener = new AnimationListener(){

        @Override
        public void onAnimationEnd(Animation animation) {
            AnimatedPullToRefreshLayout.this.mInReturningAnimation = false;
        }
    };
    private boolean mRefreshing = false;
    private boolean isHorizontalScroll;
    private boolean mCheckValidMotionFlag = true;
    private OnRefreshListener mListener;
    private MotionEvent mDownEvent;
    private RefreshCheckHandler mRefreshCheckHandler;
    private ScrollUpHandler mScrollUpHandler;
    private View mHeadview;
    private View mTarget = null;
    private final Runnable mStayRefreshCompletePosition = new Runnable(){

        @Override
        public void run() {
            AnimatedPullToRefreshLayout.this.animateStayComplete(AnimatedPullToRefreshLayout.this.mStayCompleteListener);
        }
    };
    private final Animation mAnimateToStartPosition = new Animation(){

        public void applyTransformation(float interpolatedTime, Transformation t) {
            int currentTop;
            int offset;
            int targetTop = AnimatedPullToRefreshLayout.this.mTargetOriginalTop;
            if (AnimatedPullToRefreshLayout.this.mFrom != AnimatedPullToRefreshLayout.this.mTargetOriginalTop) {
                targetTop = AnimatedPullToRefreshLayout.this.mFrom + (int)((float)(AnimatedPullToRefreshLayout.this.mTargetOriginalTop - AnimatedPullToRefreshLayout.this.mFrom) * interpolatedTime);
            }
            if ((offset = targetTop - AnimatedPullToRefreshLayout.this.mTarget.getTop()) + (currentTop = AnimatedPullToRefreshLayout.this.mTarget.getTop()) < 0) {
                offset = 0 - currentTop;
            }
            AnimatedPullToRefreshLayout.this.setTargetOffsetTop(offset, true);
        }
    };
    private final Runnable mReturnToStartPosition = new Runnable(){

        @Override
        public void run() {
            AnimatedPullToRefreshLayout.this.mInReturningAnimation = true;
            AnimatedPullToRefreshLayout.this.animateOffsetToStartPosition(AnimatedPullToRefreshLayout.this.mTarget.getTop(), AnimatedPullToRefreshLayout.this.mReturningAnimationListener);
        }
    };
    private final AnimationListener mStayCompleteListener = new AnimationListener(){

        @Override
        public void onAnimationEnd(Animation animation) {
            AnimatedPullToRefreshLayout.this.mReturnToStartPosition.run();
            AnimatedPullToRefreshLayout.this.mRefreshing = false;
        }
    };
    private final Runnable mCancel = new Runnable(){

        @Override
        public void run() {
            AnimatedPullToRefreshLayout.this.mInReturningAnimation = true;
            AnimatedPullToRefreshLayout.this.animateOffsetToStartPosition(AnimatedPullToRefreshLayout.this.mTarget.getTop(), AnimatedPullToRefreshLayout.this.mReturningAnimationListener);
        }
    };
    private final Animation mAnimateToTriggerPosition = new Animation(){

        public void applyTransformation(float interpolatedTime, Transformation t) {
            int currentTop;
            int offset;
            int targetTop = AnimatedPullToRefreshLayout.this.mDistanceToTriggerSync;
            if (AnimatedPullToRefreshLayout.this.mFrom > AnimatedPullToRefreshLayout.this.mDistanceToTriggerSync) {
                targetTop = AnimatedPullToRefreshLayout.this.mFrom + (int)((float)(AnimatedPullToRefreshLayout.this.mDistanceToTriggerSync - AnimatedPullToRefreshLayout.this.mFrom) * interpolatedTime);
            }
            if ((offset = targetTop - AnimatedPullToRefreshLayout.this.mTarget.getTop()) + (currentTop = AnimatedPullToRefreshLayout.this.mTarget.getTop()) < 0) {
                offset = 0 - currentTop;
            }
            AnimatedPullToRefreshLayout.this.setTargetOffsetTop(offset, true);
        }
    };
    private final Runnable mReturnToTrigerPosition = new Runnable(){

        @Override
        public void run() {
            AnimatedPullToRefreshLayout.this.mInReturningAnimation = true;
            AnimatedPullToRefreshLayout.this.animateOffsetToTrigerPosition(AnimatedPullToRefreshLayout.this.mTarget.getTop(), AnimatedPullToRefreshLayout.this.mReturningAnimationListener);
        }
    };
    private CharacterAnimatorHeaderView headerView;

    public AnimatedPullToRefreshLayout(Context context) {
        this(context, null);
    }

    public AnimatedPullToRefreshLayout(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public AnimatedPullToRefreshLayout(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.mTouchSlop = ViewConfiguration.get((Context)context).getScaledTouchSlop();
        this.setWillNotDraw(false);
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.AnimatedPullToRefreshLayout);
        if (a != null) {
            int fontId;
            String headerText = a.getString(R.styleable.AnimatedPullToRefreshLayout_headerText);
            int headerTextSize = a.getDimensionPixelSize(R.styleable.AnimatedPullToRefreshLayout_headerTextSize, (int)this.getResources().getDimension(R.dimen.headerTextSize));
            int headerTextColor = a.getColor(R.styleable.AnimatedPullToRefreshLayout_headerTextColor, this.getColor(0x1060000));
            int headerBackgroundColor = a.getColor(R.styleable.AnimatedPullToRefreshLayout_headerBackgroundColor, this.getColor(17170445));
            HeaderAnimSpeed headerAnimSpeed = HeaderAnimSpeed.fromId(a.getInt(R.styleable.AnimatedPullToRefreshLayout_animationSpeed, HeaderAnimSpeed.FAST.getSpeed()));
            HeaderTextAnim headerTextAnim = HeaderTextAnim.fromId(a.getInt(R.styleable.AnimatedPullToRefreshLayout_headerTextAnimation, HeaderTextAnim.ROTATE_CW.getAnimType()));
            HeaderLoopAnim headerLoopAnim = HeaderLoopAnim.fromId(a.getInt(R.styleable.AnimatedPullToRefreshLayout_headerLoopAnimation, HeaderLoopAnim.ZOOM.getAnimType()));
            int headerTextAnimIteration = a.getInt(R.styleable.AnimatedPullToRefreshLayout_headerTextAnimIteration, HeaderTextAnim.ROTATE_CW.getAnimType());
            int headerLoopAnimIteration = a.getInt(R.styleable.AnimatedPullToRefreshLayout_headerLoopAnimIteration, HeaderLoopAnim.ZOOM.getAnimType());
            boolean isColorAnimEnabled = a.getBoolean(R.styleable.AnimatedPullToRefreshLayout_headerTextColorAnimationEnabled, true);
            Typeface mTitleTypeface = null;
            if (a.hasValue(R.styleable.AnimatedPullToRefreshLayout_headerTextFontFamily) && (fontId = a.getResourceId(R.styleable.AnimatedPullToRefreshLayout_headerTextFontFamily, -1)) != -1) {
                mTitleTypeface = ResourcesCompat.getFont((Context)context, (int)fontId);
            }
            a.recycle();
            if (this.isInEditMode()) {
                return;
            }
            this.headerView = new CharacterAnimatorHeaderView(this.getContext());
            this.headerView.setHeaderText(headerText);
            this.headerView.setHeaderTextSize(headerTextSize);
            this.headerView.setHeaderTextColor(headerTextColor);
            this.headerView.setHeaderBackgroundColor(headerBackgroundColor);
            this.headerView.setHeaderTextAnim(headerTextAnim);
            this.headerView.setHeaderLoopAnim(headerLoopAnim);
            this.headerView.setHeaderTextAnimIteration(headerTextAnimIteration);
            this.headerView.setHeaderLoopAnimIteration(headerLoopAnimIteration);
            this.headerView.setColorAnimEnable(isColorAnimEnabled);
            this.headerView.setAnimationSpeed(headerAnimSpeed);
            this.headerView.setHeaderTextTypeface(mTitleTypeface);
            this.setHeaderView((View)this.headerView);
        }
    }

    private void animateStayComplete(AnimationListener listener) {
        this.mAnimateStayComplete.reset();
        this.mAnimateStayComplete.setDuration(200L);
        this.mAnimateStayComplete.setAnimationListener((Animation.AnimationListener)listener);
        this.mTarget.startAnimation(this.mAnimateStayComplete);
    }

    private void animateOffsetToTrigerPosition(int from, AnimationListener listener) {
        this.mFrom = from;
        this.mAnimateToTriggerPosition.reset();
        this.mAnimateToTriggerPosition.setDuration(200L);
        this.mAnimateToTriggerPosition.setAnimationListener((Animation.AnimationListener)listener);
        this.mTarget.startAnimation(this.mAnimateToTriggerPosition);
    }

    private void animateOffsetToStartPosition(int from, AnimationListener listener) {
        this.mFrom = from;
        this.mAnimateToStartPosition.reset();
        this.mAnimateToStartPosition.setDuration(200L);
        this.mAnimateToStartPosition.setAnimationListener((Animation.AnimationListener)listener);
        this.mTarget.startAnimation(this.mAnimateToStartPosition);
    }

    private boolean canViewScrollUp(View view, MotionEvent event) {
        boolean canViewScrollUp;
        event.offsetLocation((float)(view.getScrollX() - view.getLeft()), (float)(view.getScrollY() - view.getTop()));
        if (this.mScrollUpHandler != null && (canViewScrollUp = this.mScrollUpHandler.canScrollUp(view))) {
            return true;
        }
        boolean ret = ViewCompat.canScrollVertically((View)view, (int)-1) || this.canChildrenScrollUp(view, event);
        return ret;
    }

    private boolean canChildrenScrollUp(View view, MotionEvent event) {
        if (view instanceof ViewGroup) {
            ViewGroup viewgroup = (ViewGroup)view;
            int count = viewgroup.getChildCount();
            for (int i = 0; i < count; ++i) {
                View child = viewgroup.getChildAt(i);
                Rect bounds = new Rect();
                child.getHitRect(bounds);
                if (!bounds.contains((int)event.getX(), (int)event.getY())) continue;
                return this.canViewScrollUp(child, event);
            }
        }
        return false;
    }

    private void setHeaderView(View headerView) {
        if (this.mHeadview != null) {
            if (this.mHeadview == headerView) {
                return;
            }
            this.removeView(this.mHeadview);
        }
        this.mHeadview = headerView;
        this.addView(this.mHeadview, (ViewGroup.LayoutParams)new ViewGroup.MarginLayoutParams(-1, -2));
        this.headerView.initView();
    }

    public void onAttachedToWindow() {
        super.onAttachedToWindow();
        this.removeCallbacks(this.mCancel);
        this.removeCallbacks(this.mReturnToStartPosition);
    }

    public void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        this.removeCallbacks(this.mReturnToStartPosition);
        this.removeCallbacks(this.mCancel);
    }

    public void setOnRefreshListener(OnRefreshListener listener) {
        this.mListener = listener;
    }

    private void setRefreshState(HeaderState state) {
        this.currentHeaderState = state;
        ((AnimatedPullToRefreshHeaderLayout)this.mHeadview).onStateChange(this.currentHeaderState, this.lastHeaderState);
        this.lastHeaderState = state;
    }

    private void updateHeadViewState(boolean changeHeightOnly) {
        if (changeHeightOnly) {
            this.setRefreshState(this.currentHeaderState);
        } else if (this.mTarget.getTop() > this.mDistanceToTriggerSync) {
            this.setRefreshState(HeaderState.HEADER_STATE_READY);
        } else {
            this.setRefreshState(HeaderState.HEADER_STATE_NORMAL);
        }
    }

    public void refreshComplete() {
        this.setRefreshing(false);
    }

    public boolean isRefreshing() {
        return this.mRefreshing;
    }

    protected void setRefreshing(boolean refreshing) {
        if (this.mRefreshing != refreshing) {
            this.ensureTarget();
            this.mRefreshing = refreshing;
            if (this.mRefreshing) {
                this.mReturnToTrigerPosition.run();
            } else {
                this.mRefreshing = true;
                this.removeCallbacks(this.mReturnToStartPosition);
                this.removeCallbacks(this.mCancel);
                this.mStayRefreshCompletePosition.run();
                this.setRefreshState(HeaderState.HEADER_STATE_COMPLETE);
            }
        }
    }

    private View getContentView() {
        return this.getChildAt(0) == this.mHeadview ? this.getChildAt(1) : this.getChildAt(0);
    }

    private void ensureTarget() {
        if (this.mTarget == null) {
            if (this.getChildCount() > 2 && !this.isInEditMode()) {
                throw new IllegalStateException("AnimatedPullToRefresh can host ONLY one direct child");
            }
            this.mTarget = this.getContentView();
            this.mTargetOriginalTop = this.mTarget.getTop();
        }
        if (this.mDistanceToTriggerSync == -1 && this.getParent() != null && ((View)this.getParent()).getHeight() > 0) {
            DisplayMetrics metrics = this.getResources().getDisplayMetrics();
            this.mTriggerOffset = (int)(100.0f * metrics.density);
            this.mDistanceToTriggerSync = (int)Math.min((float)((View)this.getParent()).getHeight() * 0.3f, (float)(this.mTriggerOffset + this.mTargetOriginalTop));
        }
    }

    protected void onLayout(boolean changed, int left, int top, int right, int bottom) {
        if (this.getChildCount() == 0) {
            return;
        }
        ViewGroup.MarginLayoutParams lp = (ViewGroup.MarginLayoutParams)this.mHeadview.getLayoutParams();
        int headViewLeft = this.getPaddingLeft() + lp.leftMargin;
        int headViewTop = this.mCurrentTargetOffsetTop - this.mHeadview.getMeasuredHeight() + this.getPaddingTop() + lp.topMargin;
        int headViewRight = headViewLeft + this.mHeadview.getMeasuredWidth();
        int headViewBottom = headViewTop + this.mHeadview.getMeasuredHeight();
        this.mHeadview.layout(headViewLeft, headViewTop, headViewRight, headViewBottom);
        View content = this.getContentView();
        lp = (ViewGroup.MarginLayoutParams)content.getLayoutParams();
        int childLeft = this.getPaddingLeft() + lp.leftMargin;
        int childTop = this.mCurrentTargetOffsetTop + this.getPaddingTop() + lp.topMargin;
        int childRight = childLeft + content.getMeasuredWidth();
        int childBottom = childTop + content.getMeasuredHeight();
        content.layout(childLeft, childTop, childRight, childBottom);
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        if (this.getChildCount() > 2 && !this.isInEditMode()) {
            throw new IllegalStateException("AnimatedPullToRefresh can host one child content view.");
        }
        this.measureChildWithMargins(this.mHeadview, widthMeasureSpec, 0, heightMeasureSpec, 0);
        View content = this.getContentView();
        if (this.getChildCount() > 0) {
            ViewGroup.MarginLayoutParams lp = (ViewGroup.MarginLayoutParams)content.getLayoutParams();
            content.measure(View.MeasureSpec.makeMeasureSpec((int)(this.getMeasuredWidth() - this.getPaddingLeft() - this.getPaddingRight() - lp.leftMargin - lp.rightMargin), (int)0x40000000), View.MeasureSpec.makeMeasureSpec((int)(this.getMeasuredHeight() - this.getPaddingTop() - this.getPaddingBottom() - lp.topMargin - lp.bottomMargin), (int)0x40000000));
        }
    }

    protected boolean checkLayoutParams(ViewGroup.LayoutParams p) {
        return p instanceof ViewGroup.MarginLayoutParams;
    }

    protected ViewGroup.LayoutParams generateDefaultLayoutParams() {
        return new ViewGroup.MarginLayoutParams(-1, -1);
    }

    protected ViewGroup.LayoutParams generateLayoutParams(ViewGroup.LayoutParams p) {
        return new ViewGroup.MarginLayoutParams(p);
    }

    public ViewGroup.LayoutParams generateLayoutParams(AttributeSet attrs) {
        return new ViewGroup.MarginLayoutParams(this.getContext(), attrs);
    }

    public void addView(View child, int index, ViewGroup.LayoutParams params) {
        if (this.getChildCount() > 1 && !this.isInEditMode()) {
            throw new IllegalStateException("AnimatedPullToRefresh can host ONLY one child content view");
        }
        super.addView(child, index, params);
    }

    private boolean checkCanDoRefresh() {
        return this.mRefreshCheckHandler == null || this.mRefreshCheckHandler.canRefresh();
    }

    public boolean dispatchTouchEvent(MotionEvent event) {
        boolean ret = super.dispatchTouchEvent(event);
        if (event.getAction() == 0) {
            ret = true;
        }
        return ret;
    }

    public boolean onInterceptTouchEvent(MotionEvent ev) {
        float yDiff;
        this.ensureTarget();
        boolean handled = false;
        float curY = ev.getY();
        if (!this.isEnabled()) {
            return false;
        }
        if (ev.getAction() == 0) {
            this.mDownEvent = MotionEvent.obtain((MotionEvent)ev);
            this.mPrevY = this.mDownEvent.getY();
            this.mCheckValidMotionFlag = true;
        } else if (ev.getAction() == 2) {
            if (this.mDownEvent != null) {
                yDiff = Math.abs(curY - this.mDownEvent.getY());
                float xDiff = Math.abs(ev.getX() - this.mDownEvent.getX());
                if (this.isHorizontalScroll) {
                    this.mPrevY = curY;
                    return false;
                }
                if (xDiff <= (float)this.mTouchSlop) {
                    return false;
                }
                if (yDiff < (float)this.mTouchSlop) {
                    this.mPrevY = curY;
                    return false;
                }
            }
        } else if (ev.getAction() == 1 && this.mDownEvent != null) {
            yDiff = Math.abs(curY - this.mDownEvent.getY());
            if (this.isHorizontalScroll) {
                this.isHorizontalScroll = false;
                this.mPrevY = ev.getY();
                return false;
            }
            if (yDiff < (float)this.mTouchSlop) {
                this.mPrevY = curY;
                return false;
            }
        }
        MotionEvent event = MotionEvent.obtain((MotionEvent)ev);
        if (!this.mInReturningAnimation && !this.canViewScrollUp(this.mTarget, event)) {
            handled = this.onTouchEvent(ev);
        } else {
            this.mPrevY = ev.getY();
        }
        return handled || super.onInterceptTouchEvent(ev);
    }

    public void requestDisallowInterceptTouchEvent(boolean b) {
    }

    @SuppressLint(value={"ClickableViewAccessibility"})
    public boolean onTouchEvent(MotionEvent event) {
        if (!this.isEnabled()) {
            return false;
        }
        int action = event.getAction();
        boolean handled = false;
        int curTargetTop = this.mTarget.getTop();
        this.mCurrentTargetOffsetTop = curTargetTop - this.mTargetOriginalTop;
        switch (action) {
            case 2: {
                boolean isScrollUp;
                if (this.mDownEvent == null || this.mInReturningAnimation) break;
                float eventY = event.getY();
                float yDiff = eventY - this.mDownEvent.getY();
                boolean bl = isScrollUp = eventY - this.mPrevY > 0.0f;
                if (this.mCheckValidMotionFlag && (yDiff > (float)this.mTouchSlop || yDiff < (float)(-this.mTouchSlop))) {
                    this.mCheckValidMotionFlag = false;
                } else if (this.isRefreshing()) {
                    this.mPrevY = event.getY();
                    handled = false;
                    break;
                }
                if (curTargetTop >= this.mDistanceToTriggerSync) {
                    this.removeCallbacks(this.mCancel);
                } else {
                    if (!isScrollUp && curTargetTop < this.mTargetOriginalTop + 1) {
                        this.removeCallbacks(this.mCancel);
                        this.mPrevY = event.getY();
                        handled = false;
                        break;
                    }
                    this.updatePositionTimeout(true);
                }
                handled = true;
                if (curTargetTop >= this.mTargetOriginalTop && !this.isRefreshing()) {
                    this.setTargetOffsetTop((int)((eventY - this.mPrevY) * 0.4f), false);
                } else {
                    this.setTargetOffsetTop((int)(eventY - this.mPrevY), true);
                }
                this.mPrevY = event.getY();
                break;
            }
            case 1: {
                if (this.mRefreshing) break;
                if (this.mCurrentTargetOffsetTop >= this.mTriggerOffset) {
                    this.startRefresh();
                    handled = true;
                    break;
                }
                this.updatePositionTimeout(false);
                handled = true;
                break;
            }
            case 3: {
                if (this.mDownEvent == null) break;
                this.mDownEvent.recycle();
                this.mDownEvent = null;
            }
        }
        return handled;
    }

    private void startRefresh() {
        if (!this.checkCanDoRefresh()) {
            this.updatePositionTimeout(false);
            return;
        }
        this.removeCallbacks(this.mCancel);
        this.setRefreshState(HeaderState.HEADER_STATE_REFRESHING);
        this.setRefreshing(true);
        if (this.mListener != null) {
            this.mListener.onRefresh();
        }
    }

    private void updateContentOffsetTop(int targetTop, boolean changeHeightOnly) {
        int currentTop = this.mTarget.getTop();
        if (targetTop < this.mTargetOriginalTop) {
            targetTop = this.mTargetOriginalTop;
        }
        this.setTargetOffsetTop(targetTop - currentTop, changeHeightOnly);
    }

    private void setTargetOffsetTop(int offset, boolean changeHeightOnly) {
        if (offset == 0) {
            return;
        }
        if (this.mCurrentTargetOffsetTop + offset >= 0) {
            this.mTarget.offsetTopAndBottom(offset);
            this.mHeadview.offsetTopAndBottom(offset);
            this.mCurrentTargetOffsetTop += offset;
            this.mHeadview.getLayoutParams().height = (int)((float)this.mHeadview.getMeasuredHeight() + (float)offset * 0.8f);
            this.mHeadview.requestLayout();
            this.invalidate();
        } else {
            this.updateContentOffsetTop(this.mTargetOriginalTop, changeHeightOnly);
        }
        this.updateHeadViewState(changeHeightOnly);
    }

    private void updatePositionTimeout(boolean isDelayed) {
        this.removeCallbacks(this.mCancel);
        this.postDelayed(this.mCancel, isDelayed ? 200L : 0L);
    }

    private int getColor(int colorResId) {
        if (Build.VERSION.SDK_INT >= 23) {
            this.getResources().getColor(colorResId, this.getContext().getTheme());
        } else {
            this.getResources().getColor(colorResId);
        }
        return colorResId;
    }

    public void setColorAnimationArray(int[] colorAnimationArray) {
        this.headerView.setColorAnimationArray(colorAnimationArray);
    }

    public void setHeaderText(String headerText) {
        if (this.headerView != null) {
            this.headerView.setHeaderText(headerText);
            this.headerView.initView();
        }
    }

    public void setHeaderTextSize(int headerTextSize) {
        if (this.headerView != null) {
            this.headerView.setHeaderTextSize(headerTextSize);
            this.headerView.invalidate();
        }
    }

    public void setHeaderTextColor(int headerTextColor) {
        if (this.headerView != null) {
            this.headerView.setHeaderTextColor(headerTextColor);
            this.headerView.invalidate();
        }
    }

    public void setHeaderBackgroundColor(int headerBackgroundColor) {
        if (this.headerView != null) {
            this.headerView.setHeaderBackgroundColor(headerBackgroundColor);
            this.headerView.invalidate();
        }
    }

    public void setHeaderTextAnim(HeaderTextAnim headerTextAnim) {
        if (this.headerView != null) {
            this.headerView.setHeaderTextAnim(headerTextAnim);
            this.headerView.invalidate();
        }
    }

    public void setHeaderLoopAnim(HeaderLoopAnim headerLoopAnim) {
        if (this.headerView != null) {
            this.headerView.setHeaderLoopAnim(headerLoopAnim);
            this.headerView.invalidate();
        }
    }

    public void setHeaderTextAnimIteration(int headerTextAnimIteration) {
        if (this.headerView != null) {
            this.headerView.setHeaderTextAnimIteration(headerTextAnimIteration);
            this.headerView.invalidate();
        }
    }

    public void setHeaderLoopAnimIteration(int headerLoopAnimIteration) {
        if (this.headerView != null) {
            this.headerView.setHeaderLoopAnimIteration(headerLoopAnimIteration);
            this.headerView.invalidate();
        }
    }

    public void setColorAnimEnable(boolean colorAnimEnable) {
        if (this.headerView != null) {
            this.headerView.setColorAnimEnable(colorAnimEnable);
            this.headerView.invalidate();
        }
    }

    public void setAnimationSpeed(HeaderAnimSpeed animationSpeed) {
        if (this.headerView != null) {
            this.headerView.setAnimationSpeed(animationSpeed);
            this.headerView.invalidate();
        }
    }

    public void setHeaderTextTypeface(Typeface mTitleTypeface) {
        if (this.headerView != null) {
            this.headerView.setHeaderTextTypeface(mTitleTypeface);
            this.headerView.invalidate();
        }
    }

    static interface AnimatedPullToRefreshHeaderLayout {
        public void onStateChange(HeaderState var1, HeaderState var2);
    }

    static interface ScrollUpHandler {
        public boolean canScrollUp(View var1);
    }

    static interface RefreshCheckHandler {
        public boolean canRefresh();
    }

    public static interface OnRefreshListener {
        public void onRefresh();
    }
}

