/*
 * Decompiled with CFR 0.152.
 */
package com.hlab.animatedPullToRefresh.herlper;

import android.content.Context;
import android.content.res.AssetManager;
import android.graphics.Typeface;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import android.widget.TextView;
import com.hlab.animatedPullToRefresh.R;
import java.util.ArrayList;
import java.util.List;

public class ViewHelper {
    private Context context;
    private LinearLayout.LayoutParams tvParams;
    private LinearLayout.LayoutParams containerParams;
    private int headerTextSize;
    private int headerTextColor;
    private int headerPaddingTop;
    private int headerPaddingBottom;
    private String headerTextFontPath;

    public ViewHelper(Context context) {
        this.context = context;
        this.containerParams = new LinearLayout.LayoutParams(-1, -1);
        this.tvParams = new LinearLayout.LayoutParams(-2, -2);
        this.tvParams.setMargins(context.getResources().getDimensionPixelSize(R.dimen.headerPaddingLeft), context.getResources().getDimensionPixelSize(R.dimen.headerPaddingTop), context.getResources().getDimensionPixelSize(R.dimen.headerPaddingRight), 0);
    }

    public LinearLayout generateContainerLayout() {
        LinearLayout container = new LinearLayout(this.context);
        container.setLayoutParams((ViewGroup.LayoutParams)this.containerParams);
        container.setGravity(17);
        container.setOrientation(0);
        return container;
    }

    private TextView generateCharacterTextView(char c) {
        TextView textView = new TextView(this.context);
        textView.setText((CharSequence)String.valueOf(c));
        textView.setTextColor(this.headerTextColor);
        textView.setLayoutParams((ViewGroup.LayoutParams)this.tvParams);
        textView.setTextSize((float)this.headerTextSize);
        if (this.headerTextFontPath != null) {
            Typeface font = Typeface.createFromAsset((AssetManager)this.context.getResources().getAssets(), (String)this.headerTextFontPath);
            textView.setTypeface(font);
        }
        return textView;
    }

    public List<TextView> generateCharacterViewList(String text) {
        if (text == null) {
            text = "";
        }
        ArrayList<TextView> characterViewList = new ArrayList<TextView>();
        for (char c : text.toCharArray()) {
            characterViewList.add(this.generateCharacterTextView(c));
        }
        return characterViewList;
    }

    public int getHeaderTextSize() {
        return this.headerTextSize;
    }

    public void setHeaderTextSize(int headerTextSize) {
        this.headerTextSize = headerTextSize;
    }

    public int getHeaderTextColor() {
        return this.headerTextColor;
    }

    public void setHeaderTextColor(int headerTextColor) {
        this.headerTextColor = headerTextColor;
    }

    public int getHeaderPaddingTop() {
        return this.headerPaddingTop;
    }

    public void setHeaderPaddingTop(int headerPaddingTop) {
        this.tvParams.topMargin = headerPaddingTop;
        this.headerPaddingTop = headerPaddingTop;
    }

    public int getHeaderPaddingBottom() {
        return this.headerPaddingBottom;
    }

    public void setHeaderPaddingBottom(int headerPaddingBottom) {
        this.headerPaddingBottom = headerPaddingBottom;
    }

    public String getHeaderTextFontPath() {
        return this.headerTextFontPath;
    }

    public void setHeaderTextFontPath(String headerTextFontPath) {
        this.headerTextFontPath = headerTextFontPath;
    }
}

