/*
 * Decompiled with CFR 0.152.
 */
package com.hlab.animatedPullToRefresh.herlper;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.ArgbEvaluator;
import android.animation.TypeEvaluator;
import android.animation.ValueAnimator;
import android.support.v4.view.animation.LinearOutSlowInInterpolator;
import android.view.animation.AlphaAnimation;
import android.view.animation.Animation;
import android.view.animation.AnimationSet;
import android.view.animation.Interpolator;
import android.view.animation.RotateAnimation;
import android.view.animation.ScaleAnimation;
import android.widget.TextView;
import com.hlab.animatedPullToRefresh.enums.HeaderAnimSpeed;
import com.hlab.animatedPullToRefresh.enums.HeaderLoopAnim;
import com.hlab.animatedPullToRefresh.enums.HeaderTextAnim;
import java.util.List;

public class AnimationHelper {
    private long CHARACTER_ANIM_DURATION = 50L;
    private Interpolator interpolator;
    private int originalColor = -16777216;
    private int[] colorAnimationArray;
    private int colorIndex = 0;
    private int currentTextIteration = 0;
    private int currentLoopIteration = 0;
    private float SCALE_AMOUNT = 1.2f;
    private float FADE_MOUNT = 0.5f;
    private float ROTATION_ANGLE = 20.0f;
    private HeaderTextAnim headerTextAnim = HeaderTextAnim.ROTATE_CW;
    private HeaderLoopAnim headerLoopAnim = HeaderLoopAnim.ZOOM;
    private HeaderAnimSpeed headerAnimSpeed = HeaderAnimSpeed.FAST;
    private int headerTextAnimIteration = 1;
    private int headerLoopAnimIteration = 1;
    private boolean isColorAnimEnable = true;

    public AnimationHelper() {
        this.interpolator = new LinearOutSlowInInterpolator();
        this.colorAnimationArray = new int[]{-16711681};
    }

    public long applyTextAnimation(final TextView target) {
        long duration = (long)((float)this.CHARACTER_ANIM_DURATION * 2.1f);
        if (this.isColorAnimEnable && this.colorAnimationArray != null) {
            ValueAnimator colorAnimation = ValueAnimator.ofObject((TypeEvaluator)new ArgbEvaluator(), (Object[])new Object[]{this.originalColor, this.colorAnimationArray[this.colorIndex]});
            colorAnimation.setDuration(duration);
            colorAnimation.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

                public void onAnimationUpdate(ValueAnimator animator) {
                    target.setTextColor(((Integer)animator.getAnimatedValue()).intValue());
                }
            });
            colorAnimation.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

                public void onAnimationEnd(Animator animation) {
                    super.onAnimationEnd(animation);
                    target.setTextColor(AnimationHelper.this.originalColor);
                }
            });
            colorAnimation.start();
            this.colorIndex = (this.colorIndex + 1) % this.colorAnimationArray.length;
        }
        AnimationSet set = new AnimationSet(true);
        if (this.headerTextAnim == HeaderTextAnim.ROTATE_CW) {
            this.ROTATION_ANGLE = 20.0f;
            this.addTextRotateAnimations(set);
        } else if (this.headerTextAnim == HeaderTextAnim.ROTATE_ACW) {
            this.ROTATION_ANGLE = -20.0f;
            this.addTextRotateAnimations(set);
        } else if (this.headerTextAnim == HeaderTextAnim.FADE) {
            this.addTextFadeAnimations(set);
        } else if (this.headerTextAnim == HeaderTextAnim.ZOOM) {
            this.addTextZoomAnimations(set);
        }
        target.startAnimation((Animation)set);
        this.currentTextIteration = (this.currentTextIteration + 1) % this.headerTextAnimIteration;
        return duration + this.CHARACTER_ANIM_DURATION;
    }

    private void addTextRotateAnimations(AnimationSet set) {
        RotateAnimation mRotateUpAnim = new RotateAnimation(0.0f, this.ROTATION_ANGLE, 1, 0.5f, 1, 0.5f);
        mRotateUpAnim.setDuration(this.CHARACTER_ANIM_DURATION);
        set.addAnimation((Animation)mRotateUpAnim);
        RotateAnimation mRotateDownAnim = new RotateAnimation(this.ROTATION_ANGLE, 0.0f, 1, 0.5f, 1, 0.5f);
        mRotateDownAnim.setDuration(this.CHARACTER_ANIM_DURATION);
        mRotateDownAnim.setStartOffset(this.CHARACTER_ANIM_DURATION + 20L);
        mRotateDownAnim.setFillAfter(true);
        set.addAnimation((Animation)mRotateDownAnim);
        set.setInterpolator(this.interpolator);
    }

    private void addTextFadeAnimations(AnimationSet set) {
        AlphaAnimation mFadeInAnim = new AlphaAnimation(1.0f, this.FADE_MOUNT);
        mFadeInAnim.setDuration(this.CHARACTER_ANIM_DURATION);
        set.addAnimation((Animation)mFadeInAnim);
        AlphaAnimation mFadeOutAnim = new AlphaAnimation(this.FADE_MOUNT, 1.0f);
        mFadeOutAnim.setDuration(this.CHARACTER_ANIM_DURATION);
        mFadeOutAnim.setStartOffset(this.CHARACTER_ANIM_DURATION + 20L);
        mFadeOutAnim.setFillAfter(true);
        set.addAnimation((Animation)mFadeOutAnim);
        set.setInterpolator(this.interpolator);
    }

    private void addTextZoomAnimations(AnimationSet set) {
        ScaleAnimation mScaleAnim = new ScaleAnimation(1.0f, this.SCALE_AMOUNT, 1.0f, this.SCALE_AMOUNT, 1, 0.5f, 1, 0.5f);
        mScaleAnim.setDuration(this.CHARACTER_ANIM_DURATION);
        set.addAnimation((Animation)mScaleAnim);
        ScaleAnimation mScaleDownAnim = new ScaleAnimation(1.0f, this.SCALE_AMOUNT, 1.0f, this.SCALE_AMOUNT, 1, 0.5f, 1, 0.5f);
        mScaleDownAnim.setDuration(this.CHARACTER_ANIM_DURATION);
        mScaleDownAnim.setStartOffset(this.CHARACTER_ANIM_DURATION + 20L);
        mScaleDownAnim.setFillAfter(true);
        set.addAnimation((Animation)mScaleDownAnim);
        set.setInterpolator(this.interpolator);
    }

    public long applyLoopAnimation(List<TextView> targetList) {
        long duration = (long)((float)this.CHARACTER_ANIM_DURATION * 5.0f);
        for (TextView target : targetList) {
            AnimationSet set = new AnimationSet(true);
            if (this.headerLoopAnim == HeaderLoopAnim.ZOOM) {
                this.addLoopScaleAnimations(duration, set);
            } else if (this.headerLoopAnim == HeaderLoopAnim.FADE) {
                this.addLoopFadeAnimations(duration, set);
            }
            target.startAnimation((Animation)set);
        }
        this.currentLoopIteration = (this.currentLoopIteration + 1) % this.headerLoopAnimIteration;
        return (long)((float)duration * 2.1f + 300.0f);
    }

    private void addLoopScaleAnimations(long duration, AnimationSet set) {
        ScaleAnimation mScaleAnim = new ScaleAnimation(1.0f, this.SCALE_AMOUNT, 1.0f, this.SCALE_AMOUNT, 1, 0.5f, 1, 0.5f);
        mScaleAnim.setDuration(duration);
        set.addAnimation((Animation)mScaleAnim);
        ScaleAnimation mScaleDownAnim = new ScaleAnimation(this.SCALE_AMOUNT, 1.0f, this.SCALE_AMOUNT, 1.0f, 1, 0.5f, 1, 0.5f);
        mScaleDownAnim.setDuration(duration);
        mScaleDownAnim.setStartOffset(duration + 50L);
        set.addAnimation((Animation)mScaleDownAnim);
        set.setInterpolator(this.interpolator);
    }

    private void addLoopFadeAnimations(long duration, AnimationSet set) {
        AlphaAnimation mFadeInAnim = new AlphaAnimation(1.0f, this.FADE_MOUNT);
        mFadeInAnim.setDuration(duration);
        set.addAnimation((Animation)mFadeInAnim);
        AlphaAnimation mFadeOutAnim = new AlphaAnimation(this.FADE_MOUNT, 1.0f);
        mFadeOutAnim.setDuration(duration);
        mFadeOutAnim.setStartOffset(duration + 50L);
        set.addAnimation((Animation)mFadeOutAnim);
        set.setInterpolator(this.interpolator);
    }

    public boolean shouldContinueTextIteration() {
        return this.currentTextIteration != 0;
    }

    public boolean shouldContinueLoopIteration() {
        return this.currentLoopIteration != 0;
    }

    public void setColorAnimationArray(int[] colorAnimationArray) {
        this.colorAnimationArray = colorAnimationArray;
    }

    public void setOriginalColor(int originalColor) {
        this.originalColor = originalColor;
    }

    public HeaderTextAnim getHeaderTextAnim() {
        return this.headerTextAnim;
    }

    public void setHeaderTextAnim(HeaderTextAnim headerTextAnim) {
        this.headerTextAnim = headerTextAnim;
    }

    public HeaderLoopAnim getHeaderLoopAnim() {
        return this.headerLoopAnim;
    }

    public void setHeaderLoopAnim(HeaderLoopAnim headerLoopAnim) {
        this.headerLoopAnim = headerLoopAnim;
    }

    public int getHeaderTextAnimIteration() {
        return this.headerTextAnimIteration;
    }

    public void setHeaderTextAnimIteration(int headerTextAnimIteration) {
        this.headerTextAnimIteration = headerTextAnimIteration;
    }

    public int getHeaderLoopAnimIteration() {
        return this.headerLoopAnimIteration;
    }

    public void setHeaderLoopAnimIteration(int headerLoopAnimIteration) {
        this.headerLoopAnimIteration = headerLoopAnimIteration;
    }

    public boolean isColorAnimEnable() {
        return this.isColorAnimEnable;
    }

    public void setColorAnimEnable(boolean colorAnimEnable) {
        this.isColorAnimEnable = colorAnimEnable;
    }

    public void setAnimationSpeed(HeaderAnimSpeed animationSpeed) {
        this.headerAnimSpeed = animationSpeed;
        if (animationSpeed == HeaderAnimSpeed.FAST) {
            this.CHARACTER_ANIM_DURATION = 50L;
        } else if (animationSpeed == HeaderAnimSpeed.SLOW) {
            this.CHARACTER_ANIM_DURATION = 100L;
        }
    }
}

