/*
 * Decompiled with CFR 0.152.
 */
package com.androidnetworking.internal;

import com.androidnetworking.common.ANRequest;
import com.androidnetworking.common.Priority;
import com.androidnetworking.core.Core;
import com.androidnetworking.internal.InternalRunnable;
import java.util.Collections;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;

public class ANRequestQueue {
    private final Set<ANRequest> mCurrentRequests = Collections.newSetFromMap(new ConcurrentHashMap());
    private AtomicInteger mSequenceGenerator = new AtomicInteger();
    private static ANRequestQueue sInstance = null;

    public static void initialize() {
        ANRequestQueue.getInstance();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ANRequestQueue getInstance() {
        if (sInstance != null) return sInstance;
        Class<ANRequestQueue> clazz = ANRequestQueue.class;
        synchronized (ANRequestQueue.class) {
            if (sInstance != null) return sInstance;
            sInstance = new ANRequestQueue();
            // ** MonitorExit[var0] (shouldn't be in output)
            return sInstance;
        }
    }

    private void cancel(RequestFilter filter, boolean forceCancel) {
        try {
            Iterator<ANRequest> iterator = this.mCurrentRequests.iterator();
            while (iterator.hasNext()) {
                ANRequest request = iterator.next();
                if (!filter.apply(request)) continue;
                request.cancel(forceCancel);
                if (!request.isCanceled()) continue;
                request.destroy();
                iterator.remove();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void cancelAll(boolean forceCancel) {
        try {
            Iterator<ANRequest> iterator = this.mCurrentRequests.iterator();
            while (iterator.hasNext()) {
                ANRequest request = iterator.next();
                request.cancel(forceCancel);
                if (!request.isCanceled()) continue;
                request.destroy();
                iterator.remove();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void cancelRequestWithGivenTag(final Object tag, boolean forceCancel) {
        try {
            if (tag == null) {
                return;
            }
            this.cancel(new RequestFilter(){

                @Override
                public boolean apply(ANRequest request) {
                    return ANRequestQueue.this.isRequestWithTheGivenTag(request, tag);
                }
            }, forceCancel);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public int getSequenceNumber() {
        return this.mSequenceGenerator.incrementAndGet();
    }

    public ANRequest addRequest(ANRequest request) {
        try {
            this.mCurrentRequests.add(request);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            request.setSequenceNumber(this.getSequenceNumber());
            if (request.getPriority() == Priority.IMMEDIATE) {
                request.setFuture(Core.getInstance().getExecutorSupplier().forImmediateNetworkTasks().submit(new InternalRunnable(request)));
            } else {
                request.setFuture(Core.getInstance().getExecutorSupplier().forNetworkTasks().submit(new InternalRunnable(request)));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return request;
    }

    public void finish(ANRequest request) {
        try {
            this.mCurrentRequests.remove(request);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public boolean isRequestRunning(Object tag) {
        try {
            for (ANRequest request : this.mCurrentRequests) {
                if (!this.isRequestWithTheGivenTag(request, tag) || !request.isRunning()) continue;
                return true;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return false;
    }

    private boolean isRequestWithTheGivenTag(ANRequest request, Object tag) {
        if (request.getTag() == null) {
            return false;
        }
        if (request.getTag() instanceof String && tag instanceof String) {
            String tempRequestTag = (String)request.getTag();
            String tempTag = (String)tag;
            return tempRequestTag.equals(tempTag);
        }
        return request.getTag().equals(tag);
    }

    public static interface RequestFilter {
        public boolean apply(ANRequest var1);
    }
}

