/*
 * Decompiled with CFR 0.152.
 */
package com.hjq.http;

import android.os.Handler;
import android.os.Looper;
import com.hjq.http.EasyLog;
import com.hjq.http.annotation.HttpIgnore;
import com.hjq.http.annotation.HttpRename;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.security.DigestInputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import okhttp3.RequestBody;

public final class EasyUtils {
    private static final Handler HANDLER = new Handler(Looper.getMainLooper());

    public static boolean runOnUiThread(boolean execute, Runnable r) {
        if (execute) {
            return EasyUtils.runOnUiThread(r);
        }
        return false;
    }

    public static boolean runOnUiThread(Runnable r) {
        return HANDLER.post(r);
    }

    public static boolean postDelayed(Runnable r, long delayMillis) {
        return HANDLER.postDelayed(r, delayMillis);
    }

    public static void closeStream(Closeable closeable) {
        if (closeable == null) {
            return;
        }
        try {
            closeable.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static boolean createFolder(File targetFolder) {
        if (targetFolder.exists()) {
            if (targetFolder.isDirectory()) {
                return true;
            }
            targetFolder.delete();
        }
        return targetFolder.mkdirs();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getFileMD5(File file) {
        if (file == null) {
            return null;
        }
        DigestInputStream dis = null;
        try {
            FileInputStream fis = new FileInputStream(file);
            MessageDigest md = MessageDigest.getInstance("MD5");
            dis = new DigestInputStream(fis, md);
            byte[] buffer = new byte[262144];
            while (dis.read(buffer) > 0) {
            }
            md = dis.getMessageDigest();
            byte[] md5 = md.digest();
            StringBuilder sb = new StringBuilder();
            for (byte b : md5) {
                sb.append(String.format("%02X", b));
            }
            String string = sb.toString().toLowerCase();
            EasyUtils.closeStream(dis);
            return string;
        }
        catch (IOException | NoSuchAlgorithmException e) {
            EasyLog.print(e);
        }
        finally {
            EasyUtils.closeStream(dis);
        }
        return null;
    }

    public static boolean isBeanType(Object object) {
        return !(object instanceof Number) && !(object instanceof CharSequence) && !(object instanceof Boolean) && !(object instanceof List) && !(object instanceof Map) && !(object instanceof File) && !(object instanceof InputStream) && !(object instanceof RequestBody) && !(object instanceof Character);
    }

    public static HashMap<String, Object> beanToHashMap(Object object) {
        Field[] fields;
        HashMap<String, Object> data = null;
        for (Field field : fields = object.getClass().getDeclaredFields()) {
            field.setAccessible(true);
            try {
                String key;
                Object value = field.get(object);
                if (value == null) continue;
                if (field.isAnnotationPresent(HttpRename.class)) {
                    key = field.getAnnotation(HttpRename.class).value();
                } else {
                    key = field.getName();
                    if (object.getClass().toString().startsWith(field.getType().toString())) continue;
                }
                if (field.isAnnotationPresent(HttpIgnore.class)) continue;
                if (data == null) {
                    data = new HashMap<String, Object>(fields.length);
                }
                if (EasyUtils.isBeanType(value)) {
                    data.put(key, EasyUtils.beanToHashMap(value));
                    continue;
                }
                data.put(key, value);
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        }
        return data;
    }
}

