/*
 * Decompiled with CFR 0.152.
 */
package com.hjq.http.request;

import android.content.Context;
import com.hjq.http.EasyConfig;
import com.hjq.http.callback.DefaultCallback;
import com.hjq.http.listener.OnHttpListener;
import com.hjq.http.model.CallProxy;
import com.hjq.http.model.HttpHeaders;
import com.hjq.http.model.HttpParams;
import com.hjq.http.request.BaseRequest;
import okhttp3.HttpUrl;
import okhttp3.Request;

public final class GetRequest
extends BaseRequest<GetRequest> {
    private CallProxy mCallProxy;

    public GetRequest(Context context) {
        super(context);
    }

    @Override
    protected Request create(String url, String tag, HttpParams params, HttpHeaders headers) {
        Request.Builder request = new Request.Builder();
        if (tag != null) {
            request.tag((Object)tag);
        }
        if (!headers.isEmpty()) {
            for (String key : headers.getNames()) {
                request.addHeader(key, headers.get(key));
            }
        }
        HttpUrl.Builder builder = HttpUrl.get((String)url).newBuilder();
        if (!params.isEmpty()) {
            for (String key : params.getNames()) {
                builder.addEncodedQueryParameter(key, params.get(key).toString());
            }
        }
        request.get().url(builder.build());
        return request.build();
    }

    public GetRequest request(OnHttpListener listener) {
        this.mCallProxy = new CallProxy(this.create());
        EasyConfig.getInstance().getHandler().requestStart(this.getContext(), this.mCallProxy);
        this.mCallProxy.enqueue(new DefaultCallback(this.getContext(), this.mCallProxy, listener));
        return this;
    }

    public void cancel() {
        this.mCallProxy.cancel();
    }
}

