/*
 * Decompiled with CFR 0.152.
 */
package com.hjq.gson.factory.data;

import com.google.gson.TypeAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;

public class BooleanTypeAdapter
extends TypeAdapter<Boolean> {
    public Boolean read(JsonReader in) throws IOException {
        switch (in.peek()) {
            case BOOLEAN: {
                return in.nextBoolean();
            }
            case STRING: {
                return Boolean.parseBoolean(in.nextString());
            }
            case NUMBER: {
                return in.nextInt() != 0;
            }
            case NULL: {
                in.nextNull();
                return null;
            }
        }
        in.skipValue();
        throw new IllegalArgumentException();
    }

    public void write(JsonWriter out, Boolean value) throws IOException {
        out.value(value);
    }
}

