/*
 * Decompiled with CFR 0.152.
 */
package com.hjq.gson.factory.data;

import com.google.gson.TypeAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.math.BigDecimal;

public class IntegerTypeAdapter
extends TypeAdapter<Integer> {
    public Integer read(JsonReader in) throws IOException {
        switch (in.peek()) {
            case NUMBER: {
                try {
                    return in.nextInt();
                }
                catch (NumberFormatException e) {
                    return (int)in.nextDouble();
                }
            }
            case STRING: {
                String result = in.nextString();
                if (result == null || "".equals(result)) {
                    return 0;
                }
                try {
                    return Integer.parseInt(result);
                }
                catch (NumberFormatException e) {
                    return (int)new BigDecimal(result).floatValue();
                }
            }
            case NULL: {
                in.nextNull();
                return null;
            }
        }
        in.skipValue();
        throw new IllegalArgumentException();
    }

    public void write(JsonWriter out, Integer value) throws IOException {
        out.value((Number)value);
    }
}

