/*
 * Decompiled with CFR 0.152.
 */
package com.hjq.gson.factory;

import com.google.gson.FieldNamingPolicy;
import com.google.gson.FieldNamingStrategy;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.InstanceCreator;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.internal.ConstructorConstructor;
import com.google.gson.internal.Excluder;
import com.google.gson.internal.bind.TypeAdapters;
import com.hjq.gson.factory.JsonCallback;
import com.hjq.gson.factory.data.BigDecimalTypeAdapter;
import com.hjq.gson.factory.data.BooleanTypeAdapter;
import com.hjq.gson.factory.data.DoubleTypeAdapter;
import com.hjq.gson.factory.data.FloatTypeAdapter;
import com.hjq.gson.factory.data.IntegerTypeAdapter;
import com.hjq.gson.factory.data.LongTypeAdapter;
import com.hjq.gson.factory.data.StringTypeAdapter;
import com.hjq.gson.factory.element.CollectionTypeAdapterFactory;
import com.hjq.gson.factory.element.ReflectiveTypeAdapterFactory;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public final class GsonFactory {
    private static final HashMap<Type, InstanceCreator<?>> INSTANCE_CREATORS = new HashMap(0);
    private static final List<TypeAdapterFactory> TYPE_ADAPTER_FACTORIES = new ArrayList<TypeAdapterFactory>();
    private static JsonCallback sJsonCallback;
    private static volatile Gson sGson;

    private GsonFactory() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Gson getSingletonGson() {
        if (sGson != null) return sGson;
        Class<GsonFactory> clazz = GsonFactory.class;
        synchronized (GsonFactory.class) {
            if (sGson != null) return sGson;
            sGson = GsonFactory.createGsonBuilder().create();
            // ** MonitorExit[var0] (shouldn't be in output)
            return sGson;
        }
    }

    public static void setSingletonGson(Gson gson) {
        sGson = gson;
    }

    public static void registerTypeAdapterFactory(TypeAdapterFactory factory) {
        TYPE_ADAPTER_FACTORIES.add(factory);
    }

    public static void setExceptionListener(JsonCallback callback) {
        sJsonCallback = callback;
    }

    public static JsonCallback getCallback() {
        return sJsonCallback;
    }

    public static void registerInstanceCreator(Type type, InstanceCreator<?> creator) {
        INSTANCE_CREATORS.put(type, creator);
    }

    public static GsonBuilder createGsonBuilder() {
        GsonBuilder gsonBuilder = new GsonBuilder();
        for (TypeAdapterFactory typeAdapterFactory : TYPE_ADAPTER_FACTORIES) {
            gsonBuilder.registerTypeAdapterFactory(typeAdapterFactory);
        }
        ConstructorConstructor constructor = new ConstructorConstructor(INSTANCE_CREATORS);
        return gsonBuilder.registerTypeAdapterFactory(TypeAdapters.newFactory(String.class, (TypeAdapter)new StringTypeAdapter())).registerTypeAdapterFactory(TypeAdapters.newFactory(Boolean.TYPE, Boolean.class, (TypeAdapter)new BooleanTypeAdapter())).registerTypeAdapterFactory(TypeAdapters.newFactory(Integer.TYPE, Integer.class, (TypeAdapter)new IntegerTypeAdapter())).registerTypeAdapterFactory(TypeAdapters.newFactory(Long.TYPE, Long.class, (TypeAdapter)new LongTypeAdapter())).registerTypeAdapterFactory(TypeAdapters.newFactory(Float.TYPE, Float.class, (TypeAdapter)new FloatTypeAdapter())).registerTypeAdapterFactory(TypeAdapters.newFactory(Double.TYPE, Double.class, (TypeAdapter)new DoubleTypeAdapter())).registerTypeAdapterFactory(TypeAdapters.newFactory(BigDecimal.class, (TypeAdapter)new BigDecimalTypeAdapter())).registerTypeAdapterFactory((TypeAdapterFactory)new CollectionTypeAdapterFactory(constructor)).registerTypeAdapterFactory((TypeAdapterFactory)new ReflectiveTypeAdapterFactory(constructor, (FieldNamingStrategy)FieldNamingPolicy.IDENTITY, Excluder.DEFAULT));
    }
}

