/*
 * Decompiled with CFR 0.152.
 */
package com.hjq.gson.factory.element;

import com.google.gson.FieldNamingStrategy;
import com.google.gson.Gson;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.internal.;
import com.google.gson.internal.ConstructorConstructor;
import com.google.gson.internal.Excluder;
import com.google.gson.reflect.TypeToken;
import com.hjq.gson.factory.element.BoundField;
import com.hjq.gson.factory.element.ReflectiveTypeAdapter;
import com.hjq.gson.factory.element.ReflectiveTypeTools;
import java.lang.reflect.Field;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class ReflectiveTypeAdapterFactory
implements TypeAdapterFactory {
    private final ConstructorConstructor constructorConstructor;
    private final FieldNamingStrategy fieldNamingPolicy;
    private final Excluder excluder;

    public ReflectiveTypeAdapterFactory(ConstructorConstructor constructorConstructor, FieldNamingStrategy fieldNamingPolicy, Excluder excluder) {
        this.constructorConstructor = constructorConstructor;
        this.fieldNamingPolicy = fieldNamingPolicy;
        this.excluder = excluder;
    }

    public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
        Class raw = type.getRawType();
        if (ReflectiveTypeTools.containsClass(raw)) {
            return null;
        }
        if (type.getType() instanceof GenericArrayType || type.getType() instanceof Class && ((Class)type.getType()).isArray()) {
            return null;
        }
        if (!Object.class.isAssignableFrom(raw)) {
            return null;
        }
        if (Collection.class.isAssignableFrom(raw)) {
            return null;
        }
        if (Map.class.isAssignableFrom(raw)) {
            return null;
        }
        JsonAdapter annotation = raw.getAnnotation(JsonAdapter.class);
        if (annotation != null) {
            return null;
        }
        if (Enum.class.isAssignableFrom(raw) && raw != Enum.class) {
            return null;
        }
        return new ReflectiveTypeAdapter(this.constructorConstructor.get(type), this.getBoundFields(gson, type, raw));
    }

    private Map<String, BoundField> getBoundFields(Gson context, TypeToken<?> type, Class<?> raw) {
        LinkedHashMap<String, BoundField> result = new LinkedHashMap<String, BoundField>();
        if (raw.isInterface()) {
            return result;
        }
        Type declaredType = type.getType();
        while (raw != Object.class) {
            Field[] fields;
            for (Field field : fields = raw.getDeclaredFields()) {
                boolean serialize = this.excludeField(field, true);
                boolean deserialize = this.excludeField(field, false);
                if (!serialize && !deserialize) continue;
                field.setAccessible(true);
                Type fieldType = .Gson.Types.resolve((Type)type.getType(), (Class)raw, (Type)field.getGenericType());
                List<String> fieldNames = this.getFieldNames(field);
                BoundField previous = null;
                for (int i = 0; i < fieldNames.size(); ++i) {
                    String name = fieldNames.get(i);
                    if (i != 0) {
                        serialize = false;
                    }
                    BoundField boundField = ReflectiveTypeTools.createBoundField(context, this.constructorConstructor, field, name, TypeToken.get((Type)fieldType), serialize, deserialize);
                    BoundField replaced = result.put(name, boundField);
                    if (previous != null) continue;
                    previous = replaced;
                }
                if (previous == null) continue;
                throw new IllegalArgumentException(declaredType + " declares multiple JSON fields named " + previous.getName());
            }
            type = TypeToken.get((Type).Gson.Types.resolve((Type)type.getType(), raw, (Type)raw.getGenericSuperclass()));
            raw = type.getRawType();
        }
        return result;
    }

    private boolean excludeField(Field f, boolean serialize) {
        return ReflectiveTypeAdapterFactory.excludeField(f, serialize, this.excluder);
    }

    private static boolean excludeField(Field f, boolean serialize, Excluder excluder) {
        return !excluder.excludeClass(f.getType(), serialize) && !excluder.excludeField(f, serialize);
    }

    private List<String> getFieldNames(Field f) {
        return ReflectiveTypeTools.getFieldName(this.fieldNamingPolicy, f);
    }
}

