/*
 * Decompiled with CFR 0.152.
 */
package com.hjq.gson.factory.element;

import com.google.gson.JsonSyntaxException;
import com.google.gson.TypeAdapter;
import com.google.gson.internal.ObjectConstructor;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import com.hjq.gson.factory.element.BoundField;
import java.io.IOException;
import java.util.Map;

public class ReflectiveTypeAdapter<T>
extends TypeAdapter<T> {
    private final ObjectConstructor<T> constructor;
    private final Map<String, BoundField> boundFields;

    public ReflectiveTypeAdapter(ObjectConstructor<T> constructor, Map<String, BoundField> boundFields) {
        this.constructor = constructor;
        this.boundFields = boundFields;
    }

    public T read(JsonReader in) throws IOException {
        if (in.peek() == JsonToken.NULL) {
            in.nextNull();
            return null;
        }
        if (in.peek() != JsonToken.BEGIN_OBJECT) {
            in.skipValue();
            return null;
        }
        Object instance = this.constructor.construct();
        try {
            in.beginObject();
            while (in.hasNext()) {
                String name = in.nextName();
                BoundField field = this.boundFields.get(name);
                if (field == null || !field.isDeserialized()) {
                    in.skipValue();
                    continue;
                }
                field.read(in, instance);
            }
        }
        catch (IllegalStateException e) {
            throw new JsonSyntaxException((Throwable)e);
        }
        catch (IllegalAccessException e) {
            throw new AssertionError((Object)e);
        }
        in.endObject();
        return (T)instance;
    }

    public void write(JsonWriter out, T value) throws IOException {
        if (value == null) {
            out.nullValue();
            return;
        }
        out.beginObject();
        try {
            for (BoundField boundField : this.boundFields.values()) {
                if (!boundField.writeField(value)) continue;
                out.name(boundField.getName());
                boundField.write(out, value);
            }
        }
        catch (IllegalAccessException e) {
            throw new AssertionError((Object)e);
        }
        out.endObject();
    }
}

