/*
 * Decompiled with CFR 0.152.
 */
package com.hjq.gson.factory.element;

import com.google.gson.Gson;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.internal.;
import com.google.gson.internal.ConstructorConstructor;
import com.google.gson.internal.ObjectConstructor;
import com.google.gson.reflect.TypeToken;
import com.hjq.gson.factory.element.CollectionTypeAdapter;
import com.hjq.gson.factory.element.ReflectiveTypeTools;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.Type;
import java.util.Collection;

public class CollectionTypeAdapterFactory
implements TypeAdapterFactory {
    private final ConstructorConstructor constructorConstructor;

    public CollectionTypeAdapterFactory(ConstructorConstructor constructorConstructor) {
        this.constructorConstructor = constructorConstructor;
    }

    public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> typeToken) {
        Type type = typeToken.getType();
        Class rawType = typeToken.getRawType();
        if (ReflectiveTypeTools.containsClass(rawType)) {
            return null;
        }
        if (typeToken.getType() instanceof GenericArrayType || typeToken.getType() instanceof Class && ((Class)typeToken.getType()).isArray()) {
            return null;
        }
        if (!Collection.class.isAssignableFrom(rawType)) {
            return null;
        }
        Type elementType = .Gson.Types.getCollectionElementType((Type)type, (Class)rawType);
        TypeAdapter elementTypeAdapter = gson.getAdapter(TypeToken.get((Type)elementType));
        ObjectConstructor constructor = this.constructorConstructor.get(typeToken);
        CollectionTypeAdapter result = new CollectionTypeAdapter(gson, elementType, elementTypeAdapter, constructor);
        return result;
    }
}

