/*
 * Decompiled with CFR 0.152.
 */
package com.hjq.gson.factory;

import com.google.gson.TypeAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;

public class DoubleTypeAdapter
extends TypeAdapter<Number> {
    public Number read(JsonReader in) throws IOException {
        switch (in.peek()) {
            case NUMBER: {
                return in.nextDouble();
            }
            case STRING: {
                try {
                    return Double.parseDouble(in.nextString());
                }
                catch (NumberFormatException e) {
                    return 0;
                }
            }
            case NULL: {
                in.nextNull();
                return null;
            }
        }
        in.skipValue();
        return 0;
    }

    public void write(JsonWriter out, Number value) throws IOException {
        out.value(value);
    }
}

