/*
 * Decompiled with CFR 0.152.
 */
package com.hippocall;

import android.content.Context;
import android.content.Intent;
import android.os.Build;
import android.text.TextUtils;
import android.util.Log;
import androidx.localbroadcastmanager.content.LocalBroadcastManager;
import com.hippo.CaptureUserData;
import com.hippo.HippoConfig;
import com.hippo.OnGroupSessionListener;
import com.hippo.constant.FuguAppConstant;
import com.hippo.eventbus.BusProvider;
import com.hippo.helper.FayeMessage;
import com.hippo.langs.Restring;
import com.hippo.model.FuguPutUserDetailsResponse;
import com.hippocall.AppContants;
import com.hippocall.CommonData;
import com.hippocall.HippoCallConfig;
import com.hippocall.VideoCallModel;
import com.hippocall.WebRTCCallConstants;
import com.hippocall.confcall.HippoAudioManager;
import com.hippocall.confcall.HungUpBroadcast;
import com.hippocall.confcall.OngoingCallService;
import com.hippocall.confcall.PushReceiver;
import com.hippocall.model.FragmentFlow;
import com.hippocall.model.Message;
import faye.ConnectionManager;
import faye.ConnectionUtils;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONObject;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0011\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\"\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\b\u0010\u0019\u001a\u0004\u0018\u00010\u00042\b\u0010\u001a\u001a\u0004\u0018\u00010\u0004J\u0010\u0010\u001b\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\u001f\u0010\u001c\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\b\u0010\u001d\u001a\u0004\u0018\u00010\nH\u0002\u00a2\u0006\u0002\u0010\u001eJ\u001f\u0010\u001f\u001a\u00020\u00162\u0006\u0010 \u001a\u00020\u00182\b\u0010\u001d\u001a\u0004\u0018\u00010\nH\u0002\u00a2\u0006\u0002\u0010\u001eJ\u0010\u0010!\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\u0010\u0010\"\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\u0010\u0010#\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\u0010\u0010$\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\u0010\u0010%\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\u0010\u0010&\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\u0010\u0010'\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\u0010\u0010(\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0002R\u001a\u0010\u0003\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\bR\u001a\u0010\t\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u001a\u0010\u000f\u001a\u00020\u0010X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014\u00a8\u0006)"}, d2={"Lcom/hippocall/HippoCallingFlow;", "", "()V", "answerFor", "", "getAnswerFor", "()Ljava/lang/String;", "setAnswerFor", "(Ljava/lang/String;)V", "callStatus", "", "getCallStatus", "()I", "setCallStatus", "(I)V", "msgFlag", "", "getMsgFlag", "()Z", "setMsgFlag", "(Z)V", "callingFlow", "", "data", "Lorg/json/JSONObject;", "msg", "channel", "closeConference", "emitReadyToConnect", "userId", "(Lorg/json/JSONObject;Ljava/lang/Integer;)V", "emitUserBusy", "jsonObject", "endSessionConference", "hungupConference", "offerConference", "openGroupCall", "rejectConference", "rejectGroupConference", "removeCallView", "startConference", "hippocall_release"})
public final class HippoCallingFlow {
    private static int callStatus;
    @NotNull
    private static String answerFor;
    private static boolean msgFlag;
    public static final HippoCallingFlow INSTANCE;

    public final int getCallStatus() {
        return callStatus;
    }

    public final void setCallStatus(int n) {
        callStatus = n;
    }

    @NotNull
    public final String getAnswerFor() {
        return answerFor;
    }

    public final void setAnswerFor(@NotNull String string2) {
        Intrinsics.checkParameterIsNotNull((Object)string2, (String)"<set-?>");
        answerFor = string2;
    }

    public final void callingFlow(@NotNull JSONObject data, @Nullable String msg, @Nullable String channel) {
        Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
        Log.e((String)"VIDEO_CALL_TYPE", (String)("VIDEO_CALL_TYPE = " + data.getString("video_call_type")));
        String string2 = data.getString("video_call_type");
        if (Intrinsics.areEqual((Object)string2, (Object)FuguAppConstant.JitsiCallType.START_CONFERENCE.toString())) {
            this.startConference(data);
        } else if (Intrinsics.areEqual((Object)string2, (Object)FuguAppConstant.JitsiCallType.OFFER_CONFERENCE.toString())) {
            this.offerConference(data);
        } else if (Intrinsics.areEqual((Object)string2, (Object)FuguAppConstant.JitsiCallType.REJECT_CONFERENCE.toString())) {
            this.rejectConference(data);
        } else if (Intrinsics.areEqual((Object)string2, (Object)FuguAppConstant.JitsiCallType.HUNGUP_CONFERENCE.toString())) {
            this.hungupConference(data);
        } else if (Intrinsics.areEqual((Object)string2, (Object)FuguAppConstant.JitsiCallType.USER_BUSY_CONFERENCE.toString())) {
            if (!TextUtils.isEmpty((CharSequence)msg)) {
                BusProvider.getInstance().post((Object)new FayeMessage(FuguAppConstant.FayeBusEvent.MESSAGE_RECEIVED.toString(), channel, msg));
            }
            HippoConfig hippoConfig = HippoConfig.getInstance();
            Intrinsics.checkExpressionValueIsNotNull((Object)hippoConfig, (String)"HippoConfig.getInstance()");
            CaptureUserData captureUserData = hippoConfig.getUserData();
            Intrinsics.checkExpressionValueIsNotNull((Object)captureUserData, (String)"HippoConfig.getInstance().userData");
            Long finalUserId1 = captureUserData.getUserId();
            HippoCallConfig hippoCallConfig = HippoCallConfig.getInstance();
            Intrinsics.checkExpressionValueIsNotNull((Object)hippoCallConfig, (String)"HippoCallConfig.getInstance()");
            String deviceId = CommonData.getUniqueIMEIId(hippoCallConfig.getContext());
            String remoteDeviceId = data.getJSONObject("device_payload").optString("device_id");
            if ((int)finalUserId1.longValue() == data.optInt("user_id", -1) && Intrinsics.areEqual((Object)deviceId, (Object)remoteDeviceId) ^ true) {
                Intent mIntent2 = new Intent("video_conference_hungup_intent");
                mIntent2.putExtra("invite_link", data.getString("invite_link"));
                mIntent2.putExtra("jitsi_url", data.optString("jitsi_url"));
                HippoCallConfig hippoCallConfig2 = HippoCallConfig.getInstance();
                Intrinsics.checkExpressionValueIsNotNull((Object)hippoCallConfig2, (String)"HippoCallConfig.getInstance()");
                LocalBroadcastManager.getInstance((Context)hippoCallConfig2.getContext()).sendBroadcast(mIntent2);
                HippoCallConfig hippoCallConfig3 = HippoCallConfig.getInstance();
                Intrinsics.checkExpressionValueIsNotNull((Object)hippoCallConfig3, (String)"HippoCallConfig.getInstance()");
                Context context = hippoCallConfig3.getContext();
                Intrinsics.checkExpressionValueIsNotNull((Object)context, (String)"HippoCallConfig.getInstance().context");
                if (ConnectionUtils.INSTANCE.isMyServiceRunning(context, OngoingCallService.class)) {
                    HippoCallConfig hippoCallConfig4 = HippoCallConfig.getInstance();
                    Intrinsics.checkExpressionValueIsNotNull((Object)hippoCallConfig4, (String)"HippoCallConfig.getInstance()");
                    HippoAudioManager.getInstance(hippoCallConfig4.getContext()).stop(false);
                    HippoCallConfig hippoCallConfig5 = HippoCallConfig.getInstance();
                    Intrinsics.checkExpressionValueIsNotNull((Object)hippoCallConfig5, (String)"HippoCallConfig.getInstance()");
                    Intent startIntent = new Intent(hippoCallConfig5.getContext(), OngoingCallService.class);
                    HippoCallConfig hippoCallConfig6 = HippoCallConfig.getInstance();
                    Intrinsics.checkExpressionValueIsNotNull((Object)hippoCallConfig6, (String)"HippoCallConfig.getInstance()");
                    hippoCallConfig6.getContext().stopService(startIntent);
                }
                HippoCallConfig hippoCallConfig7 = HippoCallConfig.getInstance();
                Intrinsics.checkExpressionValueIsNotNull((Object)hippoCallConfig7, (String)"HippoCallConfig.getInstance()");
                Context context2 = hippoCallConfig7.getContext();
                Intrinsics.checkExpressionValueIsNotNull((Object)context2, (String)"HippoCallConfig.getInstance().context");
                if (!ConnectionUtils.INSTANCE.isAppRunning(context2)) {
                    ConnectionManager.INSTANCE.onClose();
                }
            }
        } else if (Intrinsics.areEqual((Object)string2, (Object)FuguAppConstant.JitsiCallType.ANSWER_CONFERENCE.toString())) {
            HippoConfig hippoConfig = HippoConfig.getInstance();
            Intrinsics.checkExpressionValueIsNotNull((Object)hippoConfig, (String)"HippoConfig.getInstance()");
            CaptureUserData captureUserData = hippoConfig.getUserData();
            Intrinsics.checkExpressionValueIsNotNull((Object)captureUserData, (String)"HippoConfig.getInstance().userData");
            Long finalUserId1 = captureUserData.getUserId();
            HippoCallConfig hippoCallConfig = HippoCallConfig.getInstance();
            Intrinsics.checkExpressionValueIsNotNull((Object)hippoCallConfig, (String)"HippoCallConfig.getInstance()");
            String deviceId = CommonData.getUniqueIMEIId(hippoCallConfig.getContext());
            String remoteDeviceId = "";
            try {
                String string3 = data.getJSONObject("device_payload").optString("device_id");
                Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"data.getJSONObject(\"devi\u2026\").optString(\"device_id\")");
                remoteDeviceId = string3;
            }
            catch (Exception mIntent2) {
                // empty catch block
            }
            if ((int)finalUserId1.longValue() == data.optInt("user_id", -1) && Intrinsics.areEqual((Object)deviceId, (Object)remoteDeviceId) ^ true) {
                Intent mIntent2 = new Intent("video_conference_hungup_intent");
                mIntent2.putExtra("invite_link", data.getString("invite_link"));
                mIntent2.putExtra("jitsi_url", data.optString("jitsi_url"));
                HippoCallConfig hippoCallConfig8 = HippoCallConfig.getInstance();
                Intrinsics.checkExpressionValueIsNotNull((Object)hippoCallConfig8, (String)"HippoCallConfig.getInstance()");
                LocalBroadcastManager.getInstance((Context)hippoCallConfig8.getContext()).sendBroadcast(mIntent2);
                HippoCallConfig hippoCallConfig9 = HippoCallConfig.getInstance();
                Intrinsics.checkExpressionValueIsNotNull((Object)hippoCallConfig9, (String)"HippoCallConfig.getInstance()");
                Context context = hippoCallConfig9.getContext();
                Intrinsics.checkExpressionValueIsNotNull((Object)context, (String)"HippoCallConfig.getInstance().context");
                if (ConnectionUtils.INSTANCE.isMyServiceRunning(context, OngoingCallService.class)) {
                    HippoCallConfig hippoCallConfig10 = HippoCallConfig.getInstance();
                    Intrinsics.checkExpressionValueIsNotNull((Object)hippoCallConfig10, (String)"HippoCallConfig.getInstance()");
                    HippoAudioManager.getInstance(hippoCallConfig10.getContext()).stop(false);
                    HippoCallConfig hippoCallConfig11 = HippoCallConfig.getInstance();
                    Intrinsics.checkExpressionValueIsNotNull((Object)hippoCallConfig11, (String)"HippoCallConfig.getInstance()");
                    Intent startIntent = new Intent(hippoCallConfig11.getContext(), OngoingCallService.class);
                    HippoCallConfig hippoCallConfig12 = HippoCallConfig.getInstance();
                    Intrinsics.checkExpressionValueIsNotNull((Object)hippoCallConfig12, (String)"HippoCallConfig.getInstance()");
                    hippoCallConfig12.getContext().stopService(startIntent);
                }
                HippoCallConfig hippoCallConfig13 = HippoCallConfig.getInstance();
                Intrinsics.checkExpressionValueIsNotNull((Object)hippoCallConfig13, (String)"HippoCallConfig.getInstance()");
                Context context3 = hippoCallConfig13.getContext();
                Intrinsics.checkExpressionValueIsNotNull((Object)context3, (String)"HippoCallConfig.getInstance().context");
                if (!ConnectionUtils.INSTANCE.isAppRunning(context3)) {
                    ConnectionManager.INSTANCE.onClose();
                }
            } else if (!TextUtils.isEmpty((CharSequence)msg)) {
                BusProvider.getInstance().post((Object)new FayeMessage(FuguAppConstant.FayeBusEvent.MESSAGE_RECEIVED.toString(), channel, msg));
            }
        } else if (Intrinsics.areEqual((Object)string2, (Object)WebRTCCallConstants.VideoCallType.START_CALL.toString())) {
            HippoCallConfig.getInstance().oldSDKCall(msg, channel);
        } else if (Intrinsics.areEqual((Object)string2, (Object)WebRTCCallConstants.VideoCallType.VIDEO_OFFER.toString())) {
            HippoCallConfig.getInstance().oldSDKCall(msg, channel);
        } else if (Intrinsics.areEqual((Object)string2, (Object)WebRTCCallConstants.VideoCallType.START_GROUP_CALL.toString())) {
            this.openGroupCall(data);
        } else if (Intrinsics.areEqual((Object)string2, (Object)WebRTCCallConstants.VideoCallType.REJECT_GROUP_CALL.toString())) {
            this.rejectGroupConference(data);
        } else if (Intrinsics.areEqual((Object)string2, (Object)WebRTCCallConstants.VideoCallType.END_GROUP_CALL.toString())) {
            this.endSessionConference(data);
        } else if (Intrinsics.areEqual((Object)string2, (Object)WebRTCCallConstants.VideoCallType.JOIN_GROUP_CALL.toString())) {
            this.closeConference(data);
        } else if (Intrinsics.areEqual((Object)string2, (Object)WebRTCCallConstants.JitsiCallType.READY_TO_CONNECT_CONFERENCE.toString())) {
            BusProvider.getInstance().post((Object)new FayeMessage(FuguAppConstant.FayeBusEvent.MESSAGE_RECEIVED.toString(), channel, msg));
            if (StringsKt.equals((String)OngoingCallService.CallState.INSTANCE.getMuid(), (String)data.optString("muid"), (boolean)true)) {
                OngoingCallService.CallState.INSTANCE.setReadyToConnect(1);
            }
        } else if (!TextUtils.isEmpty((CharSequence)msg)) {
            BusProvider.getInstance().post((Object)new FayeMessage(FuguAppConstant.FayeBusEvent.MESSAGE_RECEIVED.toString(), channel, msg));
        }
    }

    private final void startConference(JSONObject data) {
        HippoConfig hippoConfig = HippoConfig.getInstance();
        Intrinsics.checkExpressionValueIsNotNull((Object)hippoConfig, (String)"HippoConfig.getInstance()");
        CaptureUserData captureUserData = hippoConfig.getUserData();
        Intrinsics.checkExpressionValueIsNotNull((Object)captureUserData, (String)"HippoConfig.getInstance().userData");
        Long finalUserId1 = captureUserData.getUserId();
        if (finalUserId1.longValue() != data.optLong("user_id", -1L) && !OngoingCallService.NotificationServiceState.INSTANCE.isConferenceConnected()) {
            boolean flag = true;
            if (StringsKt.equals((String)OngoingCallService.CallState.INSTANCE.getMuid(), (String)data.optString("muid"), (boolean)true) && OngoingCallService.CallState.INSTANCE.getReadyToConnect() == 1) {
                flag = false;
            }
            if (flag) {
                this.emitReadyToConnect(data, (int)finalUserId1.longValue());
            }
            return;
        }
        if (OngoingCallService.NotificationServiceState.INSTANCE.isConferenceConnected() && !answerFor.equals(data.optString("muid"))) {
            this.emitUserBusy(data, (int)finalUserId1.longValue());
        }
    }

    private final void offerConference(JSONObject data) {
        Long finalUserId1 = HippoConfig.getInstance().getUserData().getUserId();
        if (finalUserId1.longValue() != data.optLong("user_id", -1L) && !OngoingCallService.NotificationServiceState.INSTANCE.isConferenceConnected()) {
            Message turnCredentials = new AppContants().getTurnCredentials();
            CaptureUserData captureUserData = HippoConfig.getInstance().getUserData();
            Intrinsics.checkExpressionValueIsNotNull((Object)captureUserData, (String)"HippoConfig.getInstance().getUserData()");
            String myName = captureUserData.getFullName();
            String myImage = com.hippo.database.CommonData.getImagePath();
            Long l = finalUserId1;
            Intrinsics.checkExpressionValueIsNotNull((Object)l, (String)"finalUserId1");
            long userId = data.optLong("user_id", l.longValue());
            String fullname = data.optString("full_name");
            long channelId = data.optLong("channel_id");
            String messageUniqueId = data.optString("muid");
            String videoCallType = data.optString("video_call_type", "");
            String callType = data.optString("call_type", "");
            String activityLaunchState = WebRTCCallConstants.AcitivityLaunchState.OTHER.toString();
            String userImage = data.optString("user_thumbnail_image");
            String jitsiUrl = data.optString("jitsi_url");
            String string2 = data.optString("user_thumbnail_image");
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"data.optString(\"user_thumbnail_image\")");
            String string3 = data.optString("full_name");
            Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"data.optString(\"full_name\")");
            String string4 = fullname;
            Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"fullname");
            String string5 = turnCredentials.getTurnApiKey();
            Intrinsics.checkExpressionValueIsNotNull((Object)string5, (String)"turnCredentials.getTurnApiKey()");
            String string6 = turnCredentials.getUsername();
            Intrinsics.checkExpressionValueIsNotNull((Object)string6, (String)"turnCredentials.getUsername()");
            String string7 = turnCredentials.getCredentials();
            Intrinsics.checkExpressionValueIsNotNull((Object)string7, (String)"turnCredentials.getCredentials()");
            ArrayList arrayList = new ArrayList();
            ArrayList arrayList2 = new ArrayList();
            String string8 = callType;
            Intrinsics.checkExpressionValueIsNotNull((Object)string8, (String)"callType");
            String string9 = string8;
            String string10 = messageUniqueId;
            String string11 = activityLaunchState;
            ArrayList arrayList3 = arrayList2;
            ArrayList arrayList4 = arrayList;
            String string12 = string7;
            String string13 = string6;
            String string14 = string5;
            String string15 = string4;
            long l2 = -1L;
            long l3 = userId;
            String string16 = string3;
            String string17 = string2;
            long l4 = channelId;
            boolean bl = false;
            String string18 = string9;
            if (string18 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
            }
            String string19 = string18.toUpperCase();
            Intrinsics.checkExpressionValueIsNotNull((Object)string19, (String)"(this as java.lang.String).toUpperCase()");
            String string20 = string19;
            DefaultConstructorMarker defaultConstructorMarker = null;
            int n = 0x200000;
            boolean bl2 = false;
            boolean bl3 = false;
            Boolean bl4 = false;
            String string21 = myImage;
            String string22 = myName;
            String string23 = "";
            String string24 = jitsiUrl;
            String string25 = "";
            String string26 = string20;
            String string27 = string10;
            String string28 = string11;
            ArrayList arrayList5 = arrayList3;
            ArrayList arrayList6 = arrayList4;
            String string29 = string12;
            String string30 = string13;
            String string31 = string14;
            String string32 = string15;
            long l5 = l2;
            long l6 = l3;
            String string33 = string16;
            String string34 = string17;
            long l7 = l4;
            VideoCallModel videoCallModel = new VideoCallModel(l7, string34, string33, l6, l5, string32, string31, string30, string29, arrayList6, arrayList5, string28, string27, string26, string25, string24, string23, string22, string21, bl4, bl3, bl2, n, defaultConstructorMarker);
            if (Intrinsics.areEqual((Object)OngoingCallService.NotificationServiceState.INSTANCE.getMuid(), (Object)data.getString("muid"))) {
                return;
            }
            String string35 = data.getString("muid");
            Intrinsics.checkExpressionValueIsNotNull((Object)string35, (String)"data.getString(MESSAGE_UNIQUE_ID)");
            OngoingCallService.NotificationServiceState.INSTANCE.setMuid(string35);
            String string36 = data.getString("invite_link");
            Intrinsics.checkExpressionValueIsNotNull((Object)string36, (String)"data.getString(\"invite_link\")");
            OngoingCallService.NotificationServiceState.INSTANCE.setInviteLink(string36);
            PushReceiver fuguNotificationConfig = new PushReceiver().getInstance();
            HippoCallConfig hippoCallConfig = HippoCallConfig.getInstance();
            Intrinsics.checkExpressionValueIsNotNull((Object)hippoCallConfig, (String)"HippoCallConfig.getInstance()");
            Context context = hippoCallConfig.getContext();
            Intrinsics.checkExpressionValueIsNotNull((Object)context, (String)"HippoCallConfig.getInstance().context");
            fuguNotificationConfig.incomingCallNotification(context, data, videoCallModel);
        }
    }

    private final void closeConference(JSONObject data) {
        HippoConfig hippoConfig = HippoConfig.getInstance();
        Intrinsics.checkExpressionValueIsNotNull((Object)hippoConfig, (String)"HippoConfig.getInstance()");
        CaptureUserData captureUserData = hippoConfig.getUserData();
        Intrinsics.checkExpressionValueIsNotNull((Object)captureUserData, (String)"HippoConfig.getInstance().userData");
        Long finalUserId1 = captureUserData.getUserId();
        HippoCallConfig hippoCallConfig = HippoCallConfig.getInstance();
        Intrinsics.checkExpressionValueIsNotNull((Object)hippoCallConfig, (String)"HippoCallConfig.getInstance()");
        String deviceId = CommonData.getUniqueIMEIId(hippoCallConfig.getContext());
        String remoteDeviceId = data.getJSONObject("device_payload").optString("device_id");
        if ((int)finalUserId1.longValue() == data.optInt("user_id", -1) && Intrinsics.areEqual((Object)deviceId, (Object)remoteDeviceId) ^ true) {
            Intent mIntent2 = new Intent("video_conference_hungup_intent");
            mIntent2.putExtra("invite_link", data.getString("invite_link"));
            HippoCallConfig hippoCallConfig2 = HippoCallConfig.getInstance();
            Intrinsics.checkExpressionValueIsNotNull((Object)hippoCallConfig2, (String)"HippoCallConfig.getInstance()");
            LocalBroadcastManager.getInstance((Context)hippoCallConfig2.getContext()).sendBroadcast(mIntent2);
            if (Build.VERSION.SDK_INT > 28) {
                HippoCallConfig hippoCallConfig3 = HippoCallConfig.getInstance();
                Intrinsics.checkExpressionValueIsNotNull((Object)hippoCallConfig3, (String)"HippoCallConfig.getInstance()");
                HippoAudioManager.getInstance(hippoCallConfig3.getContext()).stop(false);
                HippoCallConfig hippoCallConfig4 = HippoCallConfig.getInstance();
                Intrinsics.checkExpressionValueIsNotNull((Object)hippoCallConfig4, (String)"HippoCallConfig.getInstance()");
                Intent startIntent = new Intent(hippoCallConfig4.getContext(), OngoingCallService.class);
                HippoCallConfig hippoCallConfig5 = HippoCallConfig.getInstance();
                Intrinsics.checkExpressionValueIsNotNull((Object)hippoCallConfig5, (String)"HippoCallConfig.getInstance()");
                hippoCallConfig5.getContext().stopService(startIntent);
            }
            HippoCallConfig hippoCallConfig6 = HippoCallConfig.getInstance();
            Intrinsics.checkExpressionValueIsNotNull((Object)hippoCallConfig6, (String)"HippoCallConfig.getInstance()");
            Context context = hippoCallConfig6.getContext();
            Intrinsics.checkExpressionValueIsNotNull((Object)context, (String)"HippoCallConfig.getInstance().context");
            if (!ConnectionUtils.INSTANCE.isAppRunning(context)) {
                ConnectionManager.INSTANCE.onClose();
            }
        }
    }

    private final void endSessionConference(JSONObject data) {
        if (data.optString("video_call_type").equals("END_GROUP_CALL")) {
            HippoConfig hippoConfig = HippoConfig.getInstance();
            Intrinsics.checkExpressionValueIsNotNull((Object)hippoConfig, (String)"HippoConfig.getInstance()");
            if (hippoConfig.getGroupSessionListener() != null) {
                HippoConfig hippoConfig2 = HippoConfig.getInstance();
                Intrinsics.checkExpressionValueIsNotNull((Object)hippoConfig2, (String)"HippoConfig.getInstance()");
                OnGroupSessionListener onGroupSessionListener = hippoConfig2.getGroupSessionListener();
                String string2 = data.optString("transaction_id");
                Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"data.optString(\"transaction_id\")");
                onGroupSessionListener.onSessionEnded(string2);
            }
        }
        if (Intrinsics.areEqual((Object)OngoingCallService.NotificationServiceState.INSTANCE.getTransactionId(), (Object)data.optString("transaction_id"))) {
            HippoCallConfig hippoCallConfig = HippoCallConfig.getInstance();
            Intrinsics.checkExpressionValueIsNotNull((Object)hippoCallConfig, (String)"HippoCallConfig.getInstance()");
            Intent hungupIntent = new Intent(hippoCallConfig.getContext(), HungUpBroadcast.class);
            hungupIntent.putExtra("action", "endSession");
            HippoCallConfig hippoCallConfig2 = HippoCallConfig.getInstance();
            Intrinsics.checkExpressionValueIsNotNull((Object)hippoCallConfig2, (String)"HippoCallConfig.getInstance()");
            hippoCallConfig2.getContext().sendBroadcast(hungupIntent);
            Intent mIntent = new Intent("CALL_HANGUP");
            HippoCallConfig hippoCallConfig3 = HippoCallConfig.getInstance();
            Intrinsics.checkExpressionValueIsNotNull((Object)hippoCallConfig3, (String)"HippoCallConfig.getInstance()");
            LocalBroadcastManager.getInstance((Context)hippoCallConfig3.getContext()).sendBroadcast(mIntent);
            Intent mIntent2 = new Intent("video_conference_hungup_intent");
            mIntent2.putExtra("invite_link", data.getString("invite_link"));
            HippoCallConfig hippoCallConfig4 = HippoCallConfig.getInstance();
            Intrinsics.checkExpressionValueIsNotNull((Object)hippoCallConfig4, (String)"HippoCallConfig.getInstance()");
            LocalBroadcastManager.getInstance((Context)hippoCallConfig4.getContext()).sendBroadcast(mIntent2);
            HippoCallConfig hippoCallConfig5 = HippoCallConfig.getInstance();
            Intrinsics.checkExpressionValueIsNotNull((Object)hippoCallConfig5, (String)"HippoCallConfig.getInstance()");
            Context context = hippoCallConfig5.getContext();
            Intrinsics.checkExpressionValueIsNotNull((Object)context, (String)"HippoCallConfig.getInstance().context");
            if (!ConnectionUtils.INSTANCE.isAppRunning(context)) {
                ConnectionManager.INSTANCE.onClose();
            }
            HippoCallConfig hippoCallConfig6 = HippoCallConfig.getInstance();
            Intrinsics.checkExpressionValueIsNotNull((Object)hippoCallConfig6, (String)"HippoCallConfig.getInstance()");
            HippoAudioManager.getInstance(hippoCallConfig6.getContext()).stop(false);
        }
    }

    private final void rejectConference(JSONObject data) {
        HippoCallConfig hippoCallConfig = HippoCallConfig.getInstance();
        Intrinsics.checkExpressionValueIsNotNull((Object)hippoCallConfig, (String)"HippoCallConfig.getInstance()");
        HippoAudioManager.getInstance(hippoCallConfig.getContext()).stop(false);
        HippoCallConfig.getInstance().stopTimerTask();
        HippoCallConfig hippoCallConfig2 = HippoCallConfig.getInstance();
        Intrinsics.checkExpressionValueIsNotNull((Object)hippoCallConfig2, (String)"HippoCallConfig.getInstance()");
        Context context = hippoCallConfig2.getContext();
        Intrinsics.checkExpressionValueIsNotNull((Object)context, (String)"HippoCallConfig.getInstance().context");
        if (ConnectionUtils.INSTANCE.isMyServiceRunning(context, OngoingCallService.class)) {
            HippoCallConfig hippoCallConfig3 = HippoCallConfig.getInstance();
            Intrinsics.checkExpressionValueIsNotNull((Object)hippoCallConfig3, (String)"HippoCallConfig.getInstance()");
            Intent startIntent = new Intent(hippoCallConfig3.getContext(), OngoingCallService.class);
            HippoCallConfig hippoCallConfig4 = HippoCallConfig.getInstance();
            Intrinsics.checkExpressionValueIsNotNull((Object)hippoCallConfig4, (String)"HippoCallConfig.getInstance()");
            hippoCallConfig4.getContext().stopService(startIntent);
        } else if (Intrinsics.areEqual((Object)OngoingCallService.NotificationServiceState.INSTANCE.getInviteLink(), (Object)data.optString("invite_link"))) {
            BusProvider.getInstance().post((Object)new FayeMessage(WebRTCCallConstants.BusFragmentType.CALL_HUNGUP.toString(), "", ""));
            HippoCallConfig hippoCallConfig5 = HippoCallConfig.getInstance();
            Intrinsics.checkExpressionValueIsNotNull((Object)hippoCallConfig5, (String)"HippoCallConfig.getInstance()");
            Context context2 = hippoCallConfig5.getContext();
            Intrinsics.checkExpressionValueIsNotNull((Object)context2, (String)"HippoCallConfig.getInstance().context");
            if (!ConnectionUtils.INSTANCE.isAppRunning(context2)) {
                ConnectionManager.INSTANCE.onClose();
            }
        }
    }

    private final void rejectGroupConference(JSONObject data) {
        long l = data.optLong("user_id");
        FuguPutUserDetailsResponse fuguPutUserDetailsResponse = com.hippo.database.CommonData.getUserDetails();
        Intrinsics.checkExpressionValueIsNotNull((Object)fuguPutUserDetailsResponse, (String)"com.hippo.database.CommonData.getUserDetails()");
        FuguPutUserDetailsResponse.Data data2 = fuguPutUserDetailsResponse.getData();
        Intrinsics.checkExpressionValueIsNotNull((Object)data2, (String)"com.hippo.database.Commo\u2026ata.getUserDetails().data");
        Long l2 = data2.getUserId();
        if (l2 == null || l != l2) {
            return;
        }
        HippoCallConfig hippoCallConfig = HippoCallConfig.getInstance();
        Intrinsics.checkExpressionValueIsNotNull((Object)hippoCallConfig, (String)"HippoCallConfig.getInstance()");
        HippoAudioManager.getInstance(hippoCallConfig.getContext()).stop(false);
        HippoCallConfig.getInstance().stopTimerTask();
        HippoCallConfig hippoCallConfig2 = HippoCallConfig.getInstance();
        Intrinsics.checkExpressionValueIsNotNull((Object)hippoCallConfig2, (String)"HippoCallConfig.getInstance()");
        Context context = hippoCallConfig2.getContext();
        Intrinsics.checkExpressionValueIsNotNull((Object)context, (String)"HippoCallConfig.getInstance().context");
        if (ConnectionUtils.INSTANCE.isMyServiceRunning(context, OngoingCallService.class)) {
            HippoCallConfig hippoCallConfig3 = HippoCallConfig.getInstance();
            Intrinsics.checkExpressionValueIsNotNull((Object)hippoCallConfig3, (String)"HippoCallConfig.getInstance()");
            Intent startIntent = new Intent(hippoCallConfig3.getContext(), OngoingCallService.class);
            HippoCallConfig hippoCallConfig4 = HippoCallConfig.getInstance();
            Intrinsics.checkExpressionValueIsNotNull((Object)hippoCallConfig4, (String)"HippoCallConfig.getInstance()");
            hippoCallConfig4.getContext().stopService(startIntent);
        } else if (Intrinsics.areEqual((Object)OngoingCallService.NotificationServiceState.INSTANCE.getInviteLink(), (Object)data.optString("invite_link"))) {
            BusProvider.getInstance().post((Object)new FayeMessage(WebRTCCallConstants.BusFragmentType.CALL_HUNGUP.toString(), "", ""));
            HippoCallConfig hippoCallConfig5 = HippoCallConfig.getInstance();
            Intrinsics.checkExpressionValueIsNotNull((Object)hippoCallConfig5, (String)"HippoCallConfig.getInstance()");
            Context context2 = hippoCallConfig5.getContext();
            Intrinsics.checkExpressionValueIsNotNull((Object)context2, (String)"HippoCallConfig.getInstance().context");
            if (!ConnectionUtils.INSTANCE.isAppRunning(context2)) {
                ConnectionManager.INSTANCE.onClose();
            }
        }
    }

    private final void hungupConference(JSONObject data) {
        HippoCallConfig hippoCallConfig = HippoCallConfig.getInstance();
        Intrinsics.checkExpressionValueIsNotNull((Object)hippoCallConfig, (String)"HippoCallConfig.getInstance()");
        HippoAudioManager.getInstance(hippoCallConfig.getContext()).stop(false);
        HippoCallConfig.getInstance().stopTimerTask();
        if (Intrinsics.areEqual((Object)OngoingCallService.NotificationServiceState.INSTANCE.getInviteLink(), (Object)data.optString("invite_link"))) {
            HippoCallConfig hippoCallConfig2 = HippoCallConfig.getInstance();
            Intrinsics.checkExpressionValueIsNotNull((Object)hippoCallConfig2, (String)"HippoCallConfig.getInstance()");
            Intent hungupIntent = new Intent(hippoCallConfig2.getContext(), HungUpBroadcast.class);
            hungupIntent.putExtra("action", "rejectCall");
            hungupIntent.putExtra("muid", data.getString("muid"));
            HippoCallConfig hippoCallConfig3 = HippoCallConfig.getInstance();
            Intrinsics.checkExpressionValueIsNotNull((Object)hippoCallConfig3, (String)"HippoCallConfig.getInstance()");
            hippoCallConfig3.getContext().sendBroadcast(hungupIntent);
            Intent mIntent = new Intent("CALL_HANGUP");
            HippoCallConfig hippoCallConfig4 = HippoCallConfig.getInstance();
            Intrinsics.checkExpressionValueIsNotNull((Object)hippoCallConfig4, (String)"HippoCallConfig.getInstance()");
            LocalBroadcastManager.getInstance((Context)hippoCallConfig4.getContext()).sendBroadcast(mIntent);
            Intent mIntent2 = new Intent("video_conference_hungup_intent");
            mIntent2.putExtra("invite_link", data.getString("invite_link"));
            HippoCallConfig hippoCallConfig5 = HippoCallConfig.getInstance();
            Intrinsics.checkExpressionValueIsNotNull((Object)hippoCallConfig5, (String)"HippoCallConfig.getInstance()");
            LocalBroadcastManager.getInstance((Context)hippoCallConfig5.getContext()).sendBroadcast(mIntent2);
        } else {
            HippoCallConfig hippoCallConfig6 = HippoCallConfig.getInstance();
            Intrinsics.checkExpressionValueIsNotNull((Object)hippoCallConfig6, (String)"HippoCallConfig.getInstance()");
            Context context = hippoCallConfig6.getContext();
            Intrinsics.checkExpressionValueIsNotNull((Object)context, (String)"HippoCallConfig.getInstance().context");
            if (!ConnectionUtils.INSTANCE.isAppRunning(context)) {
                ConnectionManager.INSTANCE.onClose();
            }
        }
    }

    private final void emitReadyToConnect(JSONObject data, Integer userId) {
        try {
            String string2 = data.getString("muid");
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"data.getString(FuguAppConstant.MESSAGE_UNIQUE_ID)");
            OngoingCallService.CallState.INSTANCE.setMuid(string2);
            JSONObject startCallJson = new JSONObject();
            startCallJson.put("is_silent", true);
            startCallJson.put("video_call_type", (Object)FuguAppConstant.JitsiCallType.READY_TO_CONNECT_CONFERENCE);
            startCallJson.put("user_id", (Object)userId);
            startCallJson.put("channel_id", (Object)data.getString("channel_id"));
            startCallJson.put("message_type", 18);
            startCallJson.put(WebRTCCallConstants.Companion.getCALL_TYPE(), (Object)"VIDEO");
            try {
                String string3 = WebRTCCallConstants.Companion.getDEVICE_PAYLOAD();
                HippoCallConfig hippoCallConfig = HippoCallConfig.getInstance();
                Intrinsics.checkExpressionValueIsNotNull((Object)hippoCallConfig, (String)"HippoCallConfig.getInstance()");
                startCallJson.put(string3, (Object)CommonData.deviceDetails(hippoCallConfig.getContext()));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            startCallJson.put("invite_link", (Object)data.getString("invite_link"));
            startCallJson.put("jitsi_url", (Object)data.optString("jitsi_url"));
            startCallJson.put("muid", (Object)data.getString("muid"));
            startCallJson.put(WebRTCCallConstants.Companion.getFULL_NAME(), (Object)data.optString("full_name", ""));
            startCallJson.put("message", (Object)"");
            startCallJson.put("is_typing", 0);
            String channelId = "/" + data.optLong("channel_id");
            ConnectionManager.INSTANCE.publish(channelId, startCallJson);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private final void emitUserBusy(JSONObject jsonObject, Integer userId) {
        try {
            JSONObject startCallJson = new JSONObject();
            startCallJson.put("is_silent", false);
            startCallJson.put("video_call_type", (Object)FuguAppConstant.JitsiCallType.USER_BUSY_CONFERENCE);
            startCallJson.put("user_id", (Object)userId);
            startCallJson.put("channel_id", (Object)jsonObject.optString("channel_id"));
            startCallJson.put("message_type", 18);
            startCallJson.put(WebRTCCallConstants.Companion.getCALL_TYPE(), (Object)"VIDEO");
            String string2 = WebRTCCallConstants.Companion.getDEVICE_PAYLOAD();
            HippoCallConfig hippoCallConfig = HippoCallConfig.getInstance();
            Intrinsics.checkExpressionValueIsNotNull((Object)hippoCallConfig, (String)"HippoCallConfig.getInstance()");
            startCallJson.put(string2, (Object)CommonData.deviceDetails(hippoCallConfig.getContext()));
            startCallJson.put("invite_link", (Object)jsonObject.optString("invite_link"));
            startCallJson.put("jitsi_url", (Object)jsonObject.optString("jitsi_url"));
            startCallJson.put("muid", (Object)jsonObject.optString("muid"));
            startCallJson.put(WebRTCCallConstants.Companion.getFULL_NAME(), (Object)jsonObject.optString("full_name", ""));
            startCallJson.put("message", (Object)"");
            startCallJson.put("is_typing", 0);
            startCallJson.put("user_type", 1);
            String channelId = "/" + jsonObject.optLong("channel_id");
            ConnectionManager.INSTANCE.publish(channelId, startCallJson);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private final void removeCallView(JSONObject data) {
    }

    public final boolean getMsgFlag() {
        return msgFlag;
    }

    public final void setMsgFlag(boolean bl) {
        msgFlag = bl;
    }

    private final void openGroupCall(JSONObject data) {
        Long finalUserId1 = HippoConfig.getInstance().getUserData().getUserId();
        if (finalUserId1.longValue() != data.optLong("user_id", -1L) && !OngoingCallService.NotificationServiceState.INSTANCE.isConferenceConnected()) {
            String key;
            String value;
            Pattern pattern;
            Object matcher;
            Message turnCredentials = new AppContants().getTurnCredentials();
            CaptureUserData captureUserData = HippoConfig.getInstance().getUserData();
            Intrinsics.checkExpressionValueIsNotNull((Object)captureUserData, (String)"HippoConfig.getInstance().getUserData()");
            String myName = captureUserData.getFullName();
            String myImage = com.hippo.database.CommonData.getImagePath();
            Long l = finalUserId1;
            Intrinsics.checkExpressionValueIsNotNull((Object)l, (String)"finalUserId1");
            long userId = data.optLong("user_id", l.longValue());
            String fullname = data.optString("full_name");
            long channelId = data.optLong("channel_id");
            String messageUniqueId = data.optString("muid");
            String videoCallType = data.optString("video_call_type", "");
            String callType = data.optString("call_type", "");
            String activityLaunchState = WebRTCCallConstants.AcitivityLaunchState.OTHER.toString();
            String userImage = data.optString("user_thumbnail_image");
            String jitsiUrl = data.optString("jitsi_url", "");
            boolean isVideoEnabled = data.optBoolean("is_video", true);
            boolean isAudioEnable = false;
            String string2 = jitsiUrl;
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"jitsiUrl");
            if (StringsKt.contains((CharSequence)string2, (CharSequence)"config.startWithVideoMuted=true", (boolean)true)) {
                isVideoEnabled = false;
            }
            if (StringsKt.contains((CharSequence)jitsiUrl, (CharSequence)"config.startWithAudioMuted=true", (boolean)true)) {
                isAudioEnable = true;
            }
            String message = data.optString("message", "");
            if (data.has("multi_lang_message") && ((Matcher)(matcher = (pattern = Pattern.compile("\\{\\{\\{(.*?)\\}\\}\\}")).matcher(data.optString("multi_lang_message", "")))).find() && !TextUtils.isEmpty((CharSequence)(value = Restring.getString((String)(key = ((Matcher)matcher).group(1)))))) {
                String oldStr = "{{{" + key + "}}}";
                String string3 = data.optString("multi_lang_message", "");
                Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"data.optString(\"multi_lang_message\", \"\")");
                String string4 = value;
                Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"value");
                message = StringsKt.replace$default((String)string3, (String)oldStr, (String)string4, (boolean)false, (int)4, null);
            }
            String string5 = data.optString("user_thumbnail_image");
            Intrinsics.checkExpressionValueIsNotNull((Object)string5, (String)"data.optString(\"user_thumbnail_image\")");
            String string6 = message;
            Intrinsics.checkExpressionValueIsNotNull((Object)string6, (String)"message");
            String string7 = fullname;
            Intrinsics.checkExpressionValueIsNotNull((Object)string7, (String)"fullname");
            String string8 = turnCredentials.getTurnApiKey();
            Intrinsics.checkExpressionValueIsNotNull((Object)string8, (String)"turnCredentials.getTurnApiKey()");
            String string9 = turnCredentials.getUsername();
            Intrinsics.checkExpressionValueIsNotNull((Object)string9, (String)"turnCredentials.getUsername()");
            String string10 = turnCredentials.getCredentials();
            Intrinsics.checkExpressionValueIsNotNull((Object)string10, (String)"turnCredentials.getCredentials()");
            ArrayList<String> arrayList = new ArrayList<String>();
            ArrayList<String> arrayList2 = new ArrayList<String>();
            String string11 = callType;
            Intrinsics.checkExpressionValueIsNotNull((Object)string11, (String)"callType");
            matcher = string11;
            String string12 = messageUniqueId;
            String string13 = activityLaunchState;
            ArrayList<String> arrayList3 = arrayList2;
            ArrayList<String> arrayList4 = arrayList;
            String string14 = string10;
            String string15 = string9;
            String string16 = string8;
            String string17 = string7;
            long l2 = -1L;
            long l3 = userId;
            String string18 = string6;
            String string19 = string5;
            long l4 = channelId;
            boolean bl = false;
            Object object = matcher;
            if (object == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
            }
            String string20 = ((String)object).toUpperCase();
            Intrinsics.checkExpressionValueIsNotNull((Object)string20, (String)"(this as java.lang.String).toUpperCase()");
            String string21 = string20;
            boolean bl2 = isAudioEnable;
            boolean bl3 = isVideoEnabled;
            Boolean bl4 = true;
            String string22 = myImage;
            String string23 = myName;
            String string24 = "";
            String string25 = jitsiUrl;
            String string26 = "";
            String string27 = string21;
            String string28 = string12;
            String string29 = string13;
            ArrayList<String> arrayList5 = arrayList3;
            ArrayList<String> arrayList6 = arrayList4;
            String string30 = string14;
            String string31 = string15;
            String string32 = string16;
            String string33 = string17;
            long l5 = l2;
            long l6 = l3;
            String string34 = string18;
            String string35 = string19;
            long l7 = l4;
            VideoCallModel videoCallModel = new VideoCallModel(l7, string35, string34, l6, l5, string33, string32, string31, string30, arrayList6, arrayList5, string29, string28, string27, string26, string25, string24, string23, string22, bl4, bl3, bl2);
            if (TextUtils.isEmpty((CharSequence)message)) {
                msgFlag = true;
            }
            if (Intrinsics.areEqual((Object)OngoingCallService.NotificationServiceState.INSTANCE.getMuid(), (Object)data.getString("muid"))) {
                if (msgFlag && !TextUtils.isEmpty((CharSequence)message)) {
                    msgFlag = false;
                    BusProvider.getInstance().post((Object)new FragmentFlow(WebRTCCallConstants.BusFragmentType.UPDATE_INCOMIMG_CONFIG.toString(), 1, null, message));
                }
                return;
            }
            HippoCallConfig hippoCallConfig = HippoCallConfig.getInstance();
            Intrinsics.checkExpressionValueIsNotNull((Object)hippoCallConfig, (String)"HippoCallConfig.getInstance()");
            if (hippoCallConfig.getListener() != null) {
                HippoCallConfig hippoCallConfig2 = HippoCallConfig.getInstance();
                Intrinsics.checkExpressionValueIsNotNull((Object)hippoCallConfig2, (String)"HippoCallConfig.getInstance()");
                hippoCallConfig2.getListener().callStatus(1);
            }
            String string36 = data.getString("muid");
            Intrinsics.checkExpressionValueIsNotNull((Object)string36, (String)"data.getString(MESSAGE_UNIQUE_ID)");
            OngoingCallService.NotificationServiceState.INSTANCE.setMuid(string36);
            String string37 = data.getString("invite_link");
            Intrinsics.checkExpressionValueIsNotNull((Object)string37, (String)"data.getString(\"invite_link\")");
            OngoingCallService.NotificationServiceState.INSTANCE.setInviteLink(string37);
            String string38 = data.optString("transaction_id");
            Intrinsics.checkExpressionValueIsNotNull((Object)string38, (String)"data.optString(\"transaction_id\")");
            OngoingCallService.NotificationServiceState.INSTANCE.setTransactionId(string38);
            OngoingCallService.NotificationServiceState.INSTANCE.setHasGroupCall(true);
            PushReceiver fuguNotificationConfig = new PushReceiver().getInstance();
            HippoCallConfig hippoCallConfig3 = HippoCallConfig.getInstance();
            Intrinsics.checkExpressionValueIsNotNull((Object)hippoCallConfig3, (String)"HippoCallConfig.getInstance()");
            Context context = hippoCallConfig3.getContext();
            Intrinsics.checkExpressionValueIsNotNull((Object)context, (String)"HippoCallConfig.getInstance().context");
            fuguNotificationConfig.incomingCallNotification(context, data, videoCallModel);
        }
        HippoConfig hippoConfig = HippoConfig.getInstance();
        Intrinsics.checkExpressionValueIsNotNull((Object)hippoConfig, (String)"HippoConfig.getInstance()");
        if (hippoConfig.getGroupSessionListener() != null) {
            HippoConfig hippoConfig2 = HippoConfig.getInstance();
            Intrinsics.checkExpressionValueIsNotNull((Object)hippoConfig2, (String)"HippoConfig.getInstance()");
            OnGroupSessionListener onGroupSessionListener = hippoConfig2.getGroupSessionListener();
            String string39 = data.optString("transaction_id", "");
            Intrinsics.checkExpressionValueIsNotNull((Object)string39, (String)"data.optString(\"transaction_id\", \"\")");
            onGroupSessionListener.onStartSession(string39);
        }
    }

    private HippoCallingFlow() {
    }

    static {
        HippoCallingFlow hippoCallingFlow;
        INSTANCE = hippoCallingFlow = new HippoCallingFlow();
        answerFor = "";
    }
}

