/*
 * Decompiled with CFR 0.152.
 */
package com.hippocall;

import android.content.Context;
import android.hardware.Sensor;
import android.hardware.SensorEvent;
import android.hardware.SensorEventListener;
import android.hardware.SensorManager;

public class ProximitySensorManager {
    private final ProximitySensorEventListener mProximitySensorListener;
    private boolean mManagerEnabled;
    private boolean mProximitySensorAvailable = true;

    public ProximitySensorManager(Context context, Listener listener) {
        SensorManager sensorManager = (SensorManager)context.getSystemService("sensor");
        Sensor proximitySensor = sensorManager.getDefaultSensor(8);
        if (proximitySensor == null) {
            this.mProximitySensorListener = null;
            this.mProximitySensorAvailable = false;
        } else {
            this.mProximitySensorAvailable = true;
            this.mProximitySensorListener = new ProximitySensorEventListener(sensorManager, proximitySensor, listener);
        }
    }

    public boolean hasProximitySensorAvailable() {
        return this.mProximitySensorAvailable;
    }

    public void enable() {
        if (this.mProximitySensorListener != null && !this.mManagerEnabled) {
            this.mProximitySensorListener.register();
            this.mManagerEnabled = true;
        }
    }

    public void disable(boolean waitForFarState) {
        if (this.mProximitySensorListener != null && this.mManagerEnabled) {
            if (waitForFarState) {
                this.mProximitySensorListener.unregisterWhenFar();
            } else {
                this.mProximitySensorListener.unregister();
            }
            this.mManagerEnabled = false;
        }
    }

    private static class ProximitySensorEventListener
    implements SensorEventListener {
        private static final float FAR_THRESHOLD = 5.0f;
        private final SensorManager mSensorManager;
        private final Sensor mProximitySensor;
        private final float mMaxValue;
        private final Listener mListener;
        private State mLastState;
        private boolean mWaitingForFarState;

        public ProximitySensorEventListener(SensorManager sensorManager, Sensor proximitySensor, Listener listener) {
            this.mSensorManager = sensorManager;
            this.mProximitySensor = proximitySensor;
            this.mMaxValue = proximitySensor.getMaximumRange();
            this.mListener = listener;
            this.mLastState = State.FAR;
            this.mWaitingForFarState = false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onSensorChanged(SensorEvent event) {
            if (event.values == null) {
                return;
            }
            if (event.values.length == 0) {
                return;
            }
            float value = event.values[0];
            State state = this.getStateFromValue(value);
            ProximitySensorEventListener proximitySensorEventListener = this;
            synchronized (proximitySensorEventListener) {
                if (state == this.mLastState) {
                    return;
                }
                this.mLastState = state;
                if (this.mWaitingForFarState && this.mLastState == State.FAR) {
                    this.unregisterWithoutNotification();
                }
            }
            switch (state) {
                case NEAR: {
                    this.mListener.onNear();
                    break;
                }
                case FAR: {
                    this.mListener.onFar();
                }
            }
        }

        public void onAccuracyChanged(Sensor sensor, int accuracy) {
        }

        private State getStateFromValue(float value) {
            return value > 5.0f || value == this.mMaxValue ? State.FAR : State.NEAR;
        }

        public synchronized void unregisterWhenFar() {
            if (this.mLastState == State.FAR) {
                this.unregisterWithoutNotification();
            } else {
                this.mWaitingForFarState = true;
            }
        }

        public synchronized void register() {
            this.mSensorManager.registerListener((SensorEventListener)this, this.mProximitySensor, 2);
            this.mWaitingForFarState = false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void unregister() {
            State lastState;
            ProximitySensorEventListener proximitySensorEventListener = this;
            synchronized (proximitySensorEventListener) {
                this.unregisterWithoutNotification();
                lastState = this.mLastState;
                this.mLastState = State.FAR;
            }
            if (lastState != State.FAR) {
                this.mListener.onFar();
            }
        }

        private void unregisterWithoutNotification() {
            this.mSensorManager.unregisterListener((SensorEventListener)this);
            this.mWaitingForFarState = false;
        }
    }

    public static enum State {
        NEAR,
        FAR;

    }

    public static interface Listener {
        public void onNear();

        public void onFar();
    }
}

