/*
 * Decompiled with CFR 0.152.
 */
package com.hippocall;

import android.app.ActivityManager;
import android.content.Context;
import android.content.Intent;
import android.media.AudioManager;
import android.os.Build;
import android.os.CountDownTimer;
import android.os.Parcelable;
import android.text.TextUtils;
import android.util.Log;
import android.widget.Toast;
import androidx.core.content.ContextCompat;
import androidx.fragment.app.Fragment;
import androidx.localbroadcastmanager.content.LocalBroadcastManager;
import com.google.gson.Gson;
import com.hippo.CallData;
import com.hippo.FayeCallDate;
import com.hippo.HippoConfig;
import com.hippo.constant.FuguAppConstant;
import com.hippo.langs.Restring;
import com.hippo.model.FuguCreateConversationParams;
import com.hippo.utils.DateUtils;
import com.hippo.utils.HippoLog;
import com.hippo.utils.UniqueIMEIID;
import com.hippocall.AppContants;
import com.hippocall.CommonData;
import com.hippocall.CustomDataAttributes;
import com.hippocall.FuguCallActivity;
import com.hippocall.HippoCallingFlow;
import com.hippocall.MainCallingActivity;
import com.hippocall.OnGroupCallListener;
import com.hippocall.OnScreenChangeListener;
import com.hippocall.R;
import com.hippocall.StringAttributes;
import com.hippocall.UpdateView;
import com.hippocall.VideoCallModel;
import com.hippocall.VideoCallService;
import com.hippocall.WebRTCCallConstants;
import com.hippocall.confcall.HippoAudioManager;
import com.hippocall.confcall.HungUpBroadcast;
import com.hippocall.confcall.OngoingCallService;
import com.hippocall.model.Message;
import faye.ConnectionManager;
import faye.ConnectionUtils;
import faye.FayeClient;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.UUID;
import org.jitsi.meet.sdk.JitsiMeet;
import org.jitsi.meet.sdk.JitsiMeetActivity;
import org.jitsi.meet.sdk.JitsiMeetConferenceOptions;
import org.jitsi.meet.sdk.JitsiMeetUserInfo;
import org.json.JSONArray;
import org.json.JSONObject;

public class HippoCallConfig
implements CallData,
FuguAppConstant,
FayeCallDate {
    private static HippoCallConfig instance;
    private UpdateView updateView;
    private Boolean state = true;
    private StringAttributes actionString;
    private Context mContext;
    private Context context;
    private JSONObject jsonObject;
    boolean emitUserBusy;
    private int hippoCallPushIcon = R.drawable.hippo_default_notif_icon;
    public static final String LOCAL_SURFACE = "hippo_local_status";
    public static final String REMOTE_SURFACE = "hippo_remote_status";
    public static final String FLIP_CAMERA = "hippo_flip_camera";
    private String INCOMING_CALL = "incoming Call";
    private String jitsiURL = "";
    private String openedMuid = "";
    private Fragment fragment;
    private OnGroupCallListener listener;
    private CountDownTimer timerTask;

    protected boolean isNetworkConnected() {
        return this.state;
    }

    private HippoCallConfig() {
    }

    public void hasExtraView(Boolean view) {
        CommonData.setExtraView(view);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static HippoCallConfig getInstance() {
        if (instance != null) return instance;
        Class<HippoCallConfig> clazz = HippoCallConfig.class;
        synchronized (HippoCallConfig.class) {
            if (instance != null) return instance;
            instance = new HippoCallConfig();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public String getJitsiURL() {
        if (TextUtils.isEmpty((CharSequence)this.jitsiURL) && com.hippo.database.CommonData.getUserDetails() != null && com.hippo.database.CommonData.getUserDetails().getData() != null && !TextUtils.isEmpty((CharSequence)com.hippo.database.CommonData.getUserDetails().getData().getJitsiUrl())) {
            this.jitsiURL = com.hippo.database.CommonData.getUserDetails().getData().getJitsiUrl();
        }
        return this.jitsiURL;
    }

    public Context getContext() {
        return this.mContext.getApplicationContext();
    }

    public void sendMessage(Long channelId, JSONObject jsonObject) {
        ConnectionManager.INSTANCE.publish("/" + channelId, jsonObject);
    }

    public void setScreenActionString(StringAttributes actionString) {
        this.actionString = actionString;
        CommonData.setScreenActionString(actionString);
    }

    public StringAttributes getStringAttributes() {
        if (this.actionString != null) {
            this.actionString = CommonData.getScreenActionString();
        }
        if (this.actionString == null) {
            this.actionString = this.getScreenString();
        }
        return this.actionString;
    }

    protected void setTimmerListener(UpdateView updateView) {
        this.updateView = updateView;
    }

    public void setCallBackListener(Context context) {
        this.mContext = context;
        this.setCallBackListener();
    }

    public void setCallBackListener() {
        HippoConfig.getInstance().setCallListener((CallData)this);
        HippoConfig.getInstance().setFayeCallDate((FayeCallDate)this);
    }

    private void sendUserBusyBroadcast(Context context, long channelId, String messageUniqueId, String videoCallType, long userId) {
        Intent videoCallIntent = new Intent("hippo_video_call_intent");
        videoCallIntent.putExtra("channel_id", channelId);
        videoCallIntent.putExtra("muid", messageUniqueId);
        videoCallIntent.putExtra("video_call_type", videoCallType);
        videoCallIntent.putExtra("user_id", userId);
        LocalBroadcastManager.getInstance((Context)context).sendBroadcast(videoCallIntent);
    }

    public void onNotificationReceived(Context context, JSONObject data) {
        block4: {
            try {
                if (data.optInt("notification_type", 1) == 14) {
                    this.onCallIncomming(context, data);
                } else {
                    this.onStartConferenceCall(context, data);
                }
            }
            catch (Exception e) {
                if (!HippoConfig.DEBUG) break block4;
                e.printStackTrace();
            }
        }
    }

    public void onConfNotificationReceived(Context context, JSONObject data) {
        block2: {
            try {
                this.onStartConferenceCall(context, data);
            }
            catch (Exception e) {
                if (!HippoConfig.DEBUG) break block2;
                e.printStackTrace();
            }
        }
    }

    public void networkStatus(int status) {
        this.state = status > 0;
        if (this.updateView != null) {
            HippoLog.e((String)"TAG", (String)">>>>>>>>>>No internet connection<<<<<<<");
            this.updateView.onNetworkStatusChange(status);
        }
    }

    public void onCallClick(Context context, int callType, Long channelId, Long userId, boolean isAgentFlow, boolean isAllowCall, String fullname, String image, String myImagePath) {
        this.context = context;
        if (!this.isMyServiceRunning(context, OngoingCallService.class)) {
            this.onConfCallClick(context, callType, channelId, userId, isAgentFlow, isAllowCall, fullname, image, myImagePath);
        }
    }

    private void onConfCallClick(Context context, int callType, Long channelId, Long userId, boolean isAgentFlow, boolean isAllowCall, String fullname, String image, String myImagePath) {
        Intent videoIntent = new Intent(context.getApplicationContext(), MainCallingActivity.class);
        videoIntent.addFlags(0x10000000);
        videoIntent.addFlags(0x800000);
        Message turnCredentials = new AppContants().getTurnCredentials();
        String messageUniqueId = UUID.randomUUID().toString();
        String activityLaunchState = WebRTCCallConstants.AcitivityLaunchState.SELF.toString();
        String typeCall = WebRTCCallConstants.CallType.VIDEO.toString();
        if (callType == 2) {
            typeCall = WebRTCCallConstants.CallType.AUDIO.toString();
        }
        String myname = "";
        if (!isAgentFlow) {
            myname = com.hippo.database.CommonData.getUpdatedDetails().getData().getFullName();
        }
        VideoCallModel videoCallModel = new VideoCallModel(channelId, image, fullname, userId, -1L, fullname, turnCredentials.getTurnApiKey(), turnCredentials.getUsername(), turnCredentials.getCredentials(), (ArrayList)turnCredentials.getIceServers().getStun(), (ArrayList)turnCredentials.getIceServers().getTurn(), activityLaunchState, messageUniqueId, typeCall, "", "", "", myname, myImagePath, false, false, false);
        videoIntent.putExtra("videoCallModel", (Parcelable)videoCallModel);
        context.startActivity(videoIntent);
    }

    private Long timeInMillis(String timeStamp) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'", Locale.US);
        Long timeInMilliseconds = 0L;
        try {
            Date mDate = sdf.parse(DateUtils.getInstance().convertToLocal(timeStamp));
            timeInMilliseconds = mDate.getTime();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return timeInMilliseconds;
    }

    private void sendBusyStatus(JSONObject jsonObject) {
        this.sendBusyStatus(jsonObject, 1);
    }

    private void sendBusyStatus(JSONObject jsonObject, int type) {
        try {
            Long userId = com.hippo.database.CommonData.getUserDetails().getData().getUserId();
            JSONObject startCallJson = new JSONObject();
            startCallJson.put("is_silent", false);
            if (type == 1) {
                startCallJson.put("video_call_type", (Object)FuguAppConstant.JitsiCallType.USER_BUSY_CONFERENCE);
                startCallJson.put("message_type", 18);
            } else {
                startCallJson.put("video_call_type", (Object)WebRTCCallConstants.VideoCallType.REJECT_GROUP_CALL);
                startCallJson.put("message_type", 27);
            }
            startCallJson.put("user_id", (Object)userId);
            startCallJson.put("channel_id", (Object)jsonObject.optString("channel_id"));
            startCallJson.put(WebRTCCallConstants.Companion.getCALL_TYPE(), (Object)"VIDEO");
            startCallJson.put(WebRTCCallConstants.Companion.getDEVICE_PAYLOAD(), (Object)this.getDeviceDetails(this.context));
            startCallJson.put("invite_link", (Object)jsonObject.optString("invite_link"));
            startCallJson.put("muid", (Object)jsonObject.optString("muid"));
            startCallJson.put(WebRTCCallConstants.Companion.getFULL_NAME(), (Object)jsonObject.optString("full_name", ""));
            startCallJson.put("message", (Object)"");
            startCallJson.put("is_typing", 0);
            startCallJson.put("user_type", 1);
            this.sendMessage(jsonObject.optLong("channel_id"), startCallJson);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void onStartConferenceCall(Context context, JSONObject jsonObject) throws Exception {
        HippoLog.v((String)"TAG", (String)("jsonObject = " + jsonObject.toString()));
        this.context = context;
        this.jsonObject = jsonObject;
        if (jsonObject.has("video_call_type")) {
            if (jsonObject.getString("video_call_type").equals(FuguAppConstant.JitsiCallType.START_CONFERENCE.toString())) {
                if (OngoingCallService.NotificationServiceState.INSTANCE.isConferenceConnected()) {
                    this.emitUserBusy = true;
                    this.sendBusyStatus(jsonObject);
                } else {
                    Long channelId = jsonObject.optLong("channel_id");
                    ConnectionManager.INSTANCE.initFayeConnection();
                    ConnectionManager.INSTANCE.subScribeChannel("/" + com.hippo.database.CommonData.getUserDetails().getData().getUserChannel());
                    ConnectionManager.INSTANCE.unsubScribeChannel("/" + channelId);
                    ConnectionManager.INSTANCE.subScribeChannel("/" + channelId);
                }
            } else if (jsonObject.getString("video_call_type").equals(FuguAppConstant.JitsiCallType.HUNGUP_CONFERENCE.toString())) {
                if (OngoingCallService.NotificationServiceState.INSTANCE.getInviteLink().equals(jsonObject.optString("invite_link"))) {
                    Intent hungupIntent = new Intent(context, HungUpBroadcast.class);
                    hungupIntent.putExtra("action", "rejectCall");
                    hungupIntent.putExtra("muid", jsonObject.getString("muid"));
                    context.sendBroadcast(hungupIntent);
                    Intent mIntent = new Intent("CALL_HANGUP");
                    LocalBroadcastManager.getInstance((Context)context).sendBroadcast(mIntent);
                    Intent mIntent2 = new Intent("video_conference_hungup_intent");
                    mIntent2.putExtra("invite_link", jsonObject.getString("invite_link"));
                    mIntent2.putExtra("jitsi_url", jsonObject.optString("jitsi_url"));
                    LocalBroadcastManager.getInstance((Context)context).sendBroadcast(mIntent2);
                } else if (!ConnectionUtils.INSTANCE.isAppRunning(context)) {
                    ConnectionManager.INSTANCE.onClose();
                }
            } else if (jsonObject.getString("video_call_type").equals(FuguAppConstant.JitsiCallType.REJECT_CONFERENCE.toString())) {
                if (OngoingCallService.NotificationServiceState.INSTANCE.getInviteLink().equals(jsonObject.optString("invite_link"))) {
                    Intent hungupIntent = new Intent(context, HungUpBroadcast.class);
                    hungupIntent.putExtra("action", "rejectCall");
                    hungupIntent.putExtra("muid", jsonObject.getString("muid"));
                    context.sendBroadcast(hungupIntent);
                    Intent mIntent = new Intent("CALL_HANGUP");
                    LocalBroadcastManager.getInstance((Context)context).sendBroadcast(mIntent);
                    Intent mIntent2 = new Intent("video_conference_hungup_intent");
                    mIntent2.putExtra("invite_link", jsonObject.getString("invite_link"));
                    mIntent2.putExtra("jitsi_url", jsonObject.optString("jitsi_url"));
                    LocalBroadcastManager.getInstance((Context)context).sendBroadcast(mIntent2);
                } else if (!ConnectionUtils.INSTANCE.isAppRunning(context)) {
                    ConnectionManager.INSTANCE.onClose();
                }
            } else if (jsonObject.getString("video_call_type").equals(FuguAppConstant.JitsiCallType.START_GROUP_CALL.toString())) {
                Long channelId = jsonObject.optLong("channel_id");
                ConnectionManager.INSTANCE.initFayeConnection();
                ConnectionManager.INSTANCE.subScribeChannel("/" + com.hippo.database.CommonData.getUserDetails().getData().getUserChannel());
                ConnectionManager.INSTANCE.subScribeChannel("/" + channelId);
            }
        }
    }

    private void onCallIncomming(Context context, JSONObject jsonObject) throws Exception {
        this.context = context;
        this.jsonObject = jsonObject;
        HippoLog.v((String)"TAG", (String)("jsonObject = " + jsonObject.toString()));
        ActivityManager mngr = (ActivityManager)context.getSystemService("activity");
        List taskList = mngr.getRunningTasks(10);
        Long userId = com.hippo.database.CommonData.getUserDetails().getData().getUserId();
        String fullname = jsonObject.optString("full_name");
        Long channelId = jsonObject.optLong("channel_id");
        String messageUniqueId = jsonObject.optString("muid");
        String videoCallType = jsonObject.optString("video_call_type", "");
        if (!((ActivityManager.RunningTaskInfo)taskList.get((int)0)).topActivity.getClassName().equals("com.hippocall.FuguCallActivity") && !this.isMyServiceRunning(context, VideoCallService.class) && jsonObject.getInt("notification_type") == 14 && jsonObject.has("video_call_type") && jsonObject.optString("video_call_type").equals("START_CALL") && userId.compareTo(-1L) != 0 && !jsonObject.optString("device_id", "").equals(UniqueIMEIID.getUniqueIMEIId((Context)context)) && userId.compareTo(jsonObject.optLong("user_id")) != 0 && System.currentTimeMillis() - this.timeInMillis(jsonObject.getString("date_time")) < 30000L) {
            ConnectionManager.INSTANCE.initFayeConnection();
            ConnectionManager.INSTANCE.subScribeChannel("/" + com.hippo.database.CommonData.getUserDetails().getData().getUserChannel());
            ConnectionManager.INSTANCE.unsubScribeChannel("/" + channelId);
            ConnectionManager.INSTANCE.subScribeChannel("/" + channelId);
        } else if (jsonObject.getInt("notification_type") == 14 && jsonObject.has("video_call_type") && jsonObject.optString("video_call_type").equals("START_CALL")) {
            ConnectionManager.INSTANCE.initFayeConnection();
            try {
                JSONObject json = new JSONObject();
                json.put("video_call_type", (Object)WebRTCCallConstants.VideoCallType.USER_BUSY.toString());
                json.put("is_silent", true);
                json.put("user_id", (Object)userId);
                json.put("full_name", (Object)fullname);
                json.put("message_type", 18);
                json.put("is_typing", 0);
                json.put("muid", (Object)messageUniqueId);
                JSONObject devicePayload = new JSONObject();
                devicePayload.put("device_id", (Object)CommonData.getUniqueIMEIId(context));
                devicePayload.put("device_type", 1);
                devicePayload.put("app_version", (Object)"2.6.2");
                devicePayload.put("device_details", (Object)CommonData.deviceDetails(context));
                json.put("device_payload", (Object)devicePayload);
                ConnectionManager.INSTANCE.publish("/" + channelId, json);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else {
            this.sendUserBusyBroadcast(context, channelId, messageUniqueId, videoCallType, userId);
        }
    }

    protected boolean isCallActive(Context context) {
        AudioManager manager = (AudioManager)context.getSystemService("audio");
        return manager.getMode() == 2;
    }

    public void oldSDKCall(String message, String channel) {
        Message turnCredentials = new AppContants().getTurnCredentials();
        Long userId = com.hippo.database.CommonData.getUserDetails().getData().getUserId();
        String fullname = this.jsonObject.optString("full_name");
        Long channelId = this.jsonObject.optLong("channel_id");
        String messageUniqueId = this.jsonObject.optString("muid");
        String videoCallType = this.jsonObject.optString("video_call_type", "");
        String callType = this.jsonObject.optString("call_type", "");
        String activityLaunchState = WebRTCCallConstants.AcitivityLaunchState.OTHER.toString();
        String userImage = !TextUtils.isEmpty((CharSequence)this.jsonObject.optString("user_image")) ? this.jsonObject.optString("user_image") : (!TextUtils.isEmpty((CharSequence)this.jsonObject.optString("thumbnail_url")) ? this.jsonObject.optString("thumbnail_url") : this.jsonObject.optString("image_url", ""));
        Intent videoIntent = new Intent(this.context.getApplicationContext(), FuguCallActivity.class);
        VideoCallModel videoCallModel = new VideoCallModel(channelId, userImage, fullname, userId, -1L, fullname, turnCredentials.getTurnApiKey(), turnCredentials.getUsername(), turnCredentials.getCredentials(), (ArrayList)turnCredentials.getIceServers().getStun(), (ArrayList)turnCredentials.getIceServers().getTurn(), activityLaunchState, messageUniqueId, callType.toUpperCase(), "", "", "", "", "", false, false, false);
        videoIntent.addFlags(0x10000000);
        videoIntent.addFlags(0x800000);
        videoIntent.putExtra("videoCallModel", (Parcelable)videoCallModel);
        this.callRecieved(this.context, message, videoIntent, this.jsonObject, videoCallModel, userId);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void callRecieved(Context context, String messageJson, Intent videoIntent, JSONObject notificationJson, VideoCallModel videoCallModel, Long myUserId) {
        try {
            JSONObject json = new JSONObject(messageJson);
            if (!json.has("message_type") || json.getInt("message_type") != 18 || !json.getString("muid").equals(notificationJson.getString("muid"))) return;
            HippoLog.e((String)"VIDEO_JSON", (String)json.toString());
            if (json.getString("video_call_type").equals("START_CALL")) {
                JSONObject readyToConnectJson = new JSONObject();
                readyToConnectJson.put("video_call_type", (Object)"READY_TO_CONNECT");
                readyToConnectJson.put("is_silent", true);
                readyToConnectJson.put("user_id", (Object)myUserId);
                readyToConnectJson.put("message_type", 18);
                readyToConnectJson.put("is_typing", 0);
                readyToConnectJson.put("muid", (Object)notificationJson.getString("muid"));
                this.addTurnCredentialsAndDeviceDetails(context, readyToConnectJson, videoCallModel, notificationJson.getString("channel_id"), videoCallModel.getCallType());
                return;
            }
            if (json.getString("video_call_type").equals("VIDEO_OFFER")) {
                if (!this.isCallActive(context)) {
                    ActivityManager mngr = (ActivityManager)context.getSystemService("activity");
                    List taskList = mngr.getRunningTasks(10);
                    if (((ActivityManager.RunningTaskInfo)taskList.get((int)0)).topActivity.getClassName().equals("com.hippocall.FuguCallActivity") || this.isMyServiceRunning(context, VideoCallService.class) || ((ActivityManager.RunningTaskInfo)taskList.get((int)0)).topActivity.getClassName().contains("GrantPermissionsActivity")) return;
                    videoIntent.putExtra("video_offer", messageJson);
                    if (Build.VERSION.SDK_INT > 28) {
                        if (this.openedMuid.equalsIgnoreCase(json.getString("muid"))) return;
                        this.openedMuid = json.getString("muid");
                        this.startCallForegroundService(context, this.INCOMING_CALL, videoCallModel, messageJson);
                        return;
                    } else {
                        if (this.openedMuid.equalsIgnoreCase(json.getString("muid"))) return;
                        this.openedMuid = json.getString("muid");
                        context.startActivity(videoIntent);
                    }
                    return;
                } else {
                    JSONObject readyToConnectJson = new JSONObject();
                    readyToConnectJson.put("video_call_type", (Object)"USER_BUSY");
                    readyToConnectJson.put("is_silent", true);
                    readyToConnectJson.put("user_id", (Object)myUserId);
                    readyToConnectJson.put("message_type", 18);
                    readyToConnectJson.put("is_typing", 0);
                    readyToConnectJson.put("muid", (Object)notificationJson.getString("muid"));
                    this.addTurnCredentialsAndDeviceDetails(context, readyToConnectJson, videoCallModel, notificationJson.getString("channel_id"), videoCallModel.getCallType());
                }
                return;
            }
            if (!json.getString("video_call_type").equals("CALL_HUNG_UP")) return;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void addTurnCredentialsAndDeviceDetails(Context context, JSONObject readyToConnectJson, VideoCallModel videoCallModel, String channelId, String callType) {
        try {
            int i;
            JSONArray stunServers = new JSONArray();
            JSONArray turnServers = new JSONArray();
            JSONObject videoCallCredentials = new JSONObject();
            videoCallCredentials.put("turnApiKey", (Object)videoCallModel.getTurnApiKey());
            videoCallCredentials.put("username", (Object)videoCallModel.getTurnUserName());
            videoCallCredentials.put("credential", (Object)videoCallModel.getTurnCredential());
            for (i = 0; i < videoCallModel.getStunServers().size(); ++i) {
                stunServers.put((Object)videoCallModel.getStunServers().get(i));
            }
            for (i = 0; i < videoCallModel.getTurnServers().size(); ++i) {
                turnServers.put((Object)videoCallModel.getTurnServers().get(i));
            }
            JSONObject devicePayload = new JSONObject();
            devicePayload.put("device_id", (Object)UniqueIMEIID.getUniqueIMEIId((Context)context));
            devicePayload.put("device_type", 1);
            devicePayload.put("app_version", (Object)"2.0.5");
            devicePayload.put("device_details", (Object)CommonData.deviceDetails(context));
            videoCallCredentials.put("stun", (Object)stunServers);
            videoCallCredentials.put("turn", (Object)turnServers);
            readyToConnectJson.put("turn_creds", (Object)videoCallCredentials);
            readyToConnectJson.put("device_payload", (Object)devicePayload);
            readyToConnectJson.put("call_type", (Object)callType);
            this.publishSignalToFaye(channelId, readyToConnectJson);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void publishSignalToFaye(String channelId, JSONObject signalJson) {
        ConnectionManager.INSTANCE.publish("/" + channelId, signalJson);
    }

    public void directAgentCallHooks(Context context, String callType, String transactionId, String userUniqueKey, String agentEmail, String agentName, String agentImage) {
        if (callType.equalsIgnoreCase("video") && !com.hippo.database.CommonData.getVideoCallStatus()) {
            Toast.makeText((Context)context, (CharSequence)"This feature not supported", (int)0).show();
            return;
        }
        if (callType.equalsIgnoreCase("audio") && !com.hippo.database.CommonData.getAudioCallStatus()) {
            Toast.makeText((Context)context, (CharSequence)"This feature not supported", (int)0).show();
            return;
        }
        if (TextUtils.isEmpty((CharSequence)transactionId)) {
            Toast.makeText((Context)context, (CharSequence)"TransactionId can't be null", (int)0).show();
            return;
        }
        if (TextUtils.isEmpty((CharSequence)userUniqueKey)) {
            Toast.makeText((Context)context, (CharSequence)"User unique key can't be null", (int)0).show();
            return;
        }
        ArrayList<String> otherUserUniqueKeys = new ArrayList<String>();
        otherUserUniqueKeys.add(userUniqueKey);
        FuguCreateConversationParams fuguPeerChatParams = new FuguCreateConversationParams(HippoConfig.getInstance().getAppKey(), transactionId, agentEmail, otherUserUniqueKeys);
        Long userId = com.hippo.database.CommonData.getUserDetails().getData().getUserId();
        this.onAgentCallInit(context, callType, userId, new Gson().toJson((Object)fuguPeerChatParams, FuguCreateConversationParams.class), agentName, agentImage);
    }

    private void onAgentCallInit(Context context, String callType, Long userId, String fuguPeerChatParams, String agentName, String agentImage) {
        int callValue = 1;
        String activityLaunchState = WebRTCCallConstants.AcitivityLaunchState.SELF.toString();
        if (callType.equalsIgnoreCase("audio")) {
            callValue = 2;
        } else if (callType.equalsIgnoreCase("video")) {
            callValue = 1;
        } else {
            Toast.makeText((Context)context, (CharSequence)"Call type should be audio/video", (int)0).show();
            return;
        }
        Intent videoIntent = new Intent(context, FuguCallActivity.class);
        videoIntent.addFlags(0x10000000);
        videoIntent.addFlags(0x800000);
        videoIntent.putExtra("user_agent_call", true);
        videoIntent.putExtra("peer_chat_params", fuguPeerChatParams);
        if (!this.isMyServiceRunning(context, VideoCallService.class)) {
            Message turnCredentials = new AppContants().getTurnCredentials();
            String messageUniqueId = UUID.randomUUID().toString();
            VideoCallModel videoCallModel = new VideoCallModel(-1L, agentImage, "", userId, -1L, agentName, turnCredentials.getTurnApiKey(), turnCredentials.getUsername(), turnCredentials.getCredentials(), (ArrayList)turnCredentials.getIceServers().getStun(), (ArrayList)turnCredentials.getIceServers().getTurn(), activityLaunchState, messageUniqueId, callType.toUpperCase(), "", "", "", "", "", false, false, false);
            videoIntent.putExtra("videoCallModel", (Parcelable)videoCallModel);
        }
        context.startActivity(videoIntent);
    }

    public void onExternalClick(Context context, String callType, Long userId, String otherUserName, String fuguPeerChatParams, String otheruserImageUrl, String otherUserImage) {
        int callValue = 1;
        String activityLaunchState = WebRTCCallConstants.AcitivityLaunchState.SELF.toString();
        if (callType.equalsIgnoreCase("audio")) {
            callValue = 2;
        } else if (callType.equalsIgnoreCase("video")) {
            callValue = 1;
        } else {
            Toast.makeText((Context)context, (CharSequence)"Call type should be audio/video", (int)0).show();
            return;
        }
        String path = otheruserImageUrl;
        if (TextUtils.isEmpty((CharSequence)path)) {
            path = "";
        }
        Intent videoIntent = new Intent(context, FuguCallActivity.class);
        videoIntent.addFlags(0x10000000);
        videoIntent.addFlags(0x800000);
        videoIntent.putExtra("peer_chat_params", fuguPeerChatParams);
        if (!this.isMyServiceRunning(context, VideoCallService.class)) {
            Message turnCredentials = new AppContants().getTurnCredentials();
            String messageUniqueId = UUID.randomUUID().toString();
            VideoCallModel videoCallModel = new VideoCallModel(-1L, path, otherUserName, userId, -1L, otherUserName, turnCredentials.getTurnApiKey(), turnCredentials.getUsername(), turnCredentials.getCredentials(), (ArrayList)turnCredentials.getIceServers().getStun(), (ArrayList)turnCredentials.getIceServers().getTurn(), activityLaunchState, messageUniqueId, callType.toUpperCase(), "", "", "", "", "", false, false, false);
            videoIntent.putExtra("videoCallModel", (Parcelable)videoCallModel);
        }
        context.startActivity(videoIntent);
    }

    public void setFragment(Fragment fragment) {
        this.fragment = fragment;
        if (this.updateView != null) {
            this.updateView.updateFragment(fragment);
        }
    }

    public void timerVisibility(int status) {
        if (this.updateView != null) {
            this.updateView.timerVisibilityStatus(status);
        }
    }

    public void setTimer(String txt) {
        if (this.updateView != null) {
            this.updateView.updateTimer(txt);
        }
    }

    public void openOnGoingCall(Context context, OnScreenChangeListener changeListener) {
        if (this.isMyServiceRunning(context, VideoCallService.class)) {
            Intent videoIntent = new Intent(context.getApplicationContext(), FuguCallActivity.class);
            videoIntent.addFlags(0x10000000);
            videoIntent.addFlags(0x800000);
            context.startActivity(videoIntent);
            if (changeListener != null) {
                changeListener.onScreenStatus(true);
            }
        } else if (changeListener != null) {
            changeListener.onScreenStatus(false);
        }
    }

    public void sendCustomData(Context context, CustomDataAttributes data) {
        if (this.updateView == null) {
            try {
                Intent videoCallIntent = new Intent("hippo_video_call_intent");
                videoCallIntent.putExtra("custom_data", "CUSTOM_DATA");
                JSONObject json = new JSONObject();
                json.put("unique_id", (Object)data.getUniqueId());
                json.put("flag", (Object)data.getFlag());
                if (!TextUtils.isEmpty((CharSequence)data.getMessage())) {
                    json.put("message", (Object)data.getMessage());
                }
                videoCallIntent.putExtra("data", json.toString());
                LocalBroadcastManager.getInstance((Context)context).sendBroadcast(videoCallIntent);
            }
            catch (Exception videoCallIntent) {}
        } else {
            try {
                JSONObject json = new JSONObject();
                json.put("unique_id", (Object)data.getUniqueId());
                json.put("flag", (Object)data.getFlag());
                if (!TextUtils.isEmpty((CharSequence)data.getMessage())) {
                    json.put("message", (Object)data.getMessage());
                }
                this.updateView.sendCustomData(json);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void setHippoCallPushIcon(int hippoCallPushIcon) {
        this.hippoCallPushIcon = hippoCallPushIcon;
    }

    public int getHippoCallPushIcon() {
        return this.hippoCallPushIcon;
    }

    protected Fragment getFragment() {
        return this.fragment;
    }

    protected boolean isMyServiceRunning(Context context, Class<?> serviceClass) {
        ActivityManager manager = (ActivityManager)context.getSystemService("activity");
        for (ActivityManager.RunningServiceInfo service : manager.getRunningServices(Integer.MAX_VALUE)) {
            if (!serviceClass.getName().equals(service.service.getClassName())) continue;
            return true;
        }
        return false;
    }

    private StringAttributes getScreenString() {
        StringAttributes attributes = new StringAttributes.Builder().setAndString("and").setMuteString("sound mute").setCameraOffString("camera closed").setVideoPaused("Video paused").showUserName(true).build();
        return attributes;
    }

    public void setSurfaceMirror(boolean localSurfaceMirror, boolean remoteSurfaceMirror) {
        CommonData.setMirrorStatus(LOCAL_SURFACE, localSurfaceMirror);
        CommonData.setMirrorStatus(REMOTE_SURFACE, remoteSurfaceMirror);
    }

    public void setFlipCameraIcons(boolean flipCamera) {
        CommonData.setMirrorStatus(FLIP_CAMERA, flipCamera);
    }

    private void emitReadyToConnect(FayeClient mClient, JSONObject data, Long userId) {
        try {
            JSONObject startCallJson = new JSONObject();
            startCallJson.put("is_silent", true);
            startCallJson.put("video_call_type", (Object)FuguAppConstant.JitsiCallType.READY_TO_CONNECT_CONFERENCE);
            startCallJson.put("user_id", (Object)userId);
            startCallJson.put("channel_id", (Object)data.getString("channel_id"));
            startCallJson.put("message_type", 18);
            startCallJson.put(WebRTCCallConstants.Companion.getCALL_TYPE(), (Object)"VIDEO");
            startCallJson.put(WebRTCCallConstants.Companion.getDEVICE_PAYLOAD(), (Object)this.getDeviceDetails(this.context));
            startCallJson.put("invite_link", (Object)data.getString("invite_link"));
            startCallJson.put("jitsi_url", (Object)data.optString("invite_link"));
            startCallJson.put("muid", (Object)data.getString("muid"));
            startCallJson.put(WebRTCCallConstants.Companion.getFULL_NAME(), (Object)data.optString("full_name", ""));
            startCallJson.put("message", (Object)"");
            startCallJson.put("is_typing", 0);
            startCallJson.put("user_type", 1);
            String channelId = "/" + data.optLong("channel_id");
            mClient.publish(channelId, startCallJson);
            Log.e((String)"Video_CONF-->", (String)startCallJson.toString());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void emitUserBusy(FayeClient mClient, Context context, JSONObject data, Long userId) {
        try {
            JSONObject startCallJson = new JSONObject();
            startCallJson.put("is_silent", false);
            startCallJson.put("video_call_type", (Object)FuguAppConstant.JitsiCallType.USER_BUSY_CONFERENCE);
            startCallJson.put("user_id", (Object)userId);
            startCallJson.put("channel_id", (Object)data.getString("channel_id"));
            startCallJson.put("message_type", 18);
            startCallJson.put(WebRTCCallConstants.Companion.getCALL_TYPE(), (Object)"VIDEO");
            startCallJson.put(WebRTCCallConstants.Companion.getDEVICE_PAYLOAD(), (Object)this.getDeviceDetails(context));
            startCallJson.put("invite_link", (Object)data.getString("invite_link"));
            startCallJson.put("jitsi_url", (Object)data.optString("jitsi_url"));
            startCallJson.put("muid", (Object)data.getString("muid"));
            startCallJson.put(WebRTCCallConstants.Companion.getFULL_NAME(), (Object)data.optString("full_name", ""));
            startCallJson.put("message", (Object)"");
            startCallJson.put("is_typing", 0);
            startCallJson.put("user_type", 1);
            String channelId = "/" + data.optLong("channel_id");
            mClient.publish(channelId, startCallJson);
            Log.e((String)"Video_CONF-->", (String)startCallJson.toString());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public JSONObject getDeviceDetails(Context context) {
        try {
            JSONObject devicePayload = new JSONObject();
            devicePayload.put("device_id", (Object)UniqueIMEIID.getUniqueIMEIId((Context)context));
            devicePayload.put("device_type", 1);
            devicePayload.put("app_version", (Object)"2.6.2");
            devicePayload.put("device_details", (Object)CommonData.deviceDetails(context));
            return devicePayload;
        }
        catch (Exception e) {
            return new JSONObject();
        }
    }

    protected void initOldCall(VideoCallModel videoCallModel) {
        try {
            Intent videoIntent = new Intent(this.context.getApplicationContext(), FuguCallActivity.class);
            if (!this.isMyServiceRunning(this.context, VideoCallService.class)) {
                videoIntent.putExtra("videoCallModel", (Parcelable)videoCallModel);
            }
            this.context.startActivity(videoIntent);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void startCallForegroundService(Context context, String status, final VideoCallModel videoCallModel, String messageJson) {
        Intent startIntent = new Intent(context.getApplicationContext(), VideoCallService.class);
        String channelName = "";
        channelName = videoCallModel.getChannelName();
        startIntent.setAction("com.fuguchat.start");
        startIntent.putExtra("call_status", status);
        startIntent.putExtra("channel_name", channelName);
        startIntent.putExtra("video_Call_model", (Parcelable)videoCallModel);
        startIntent.putExtra("init_full_screen_service", true);
        startIntent.putExtra("messageJson", messageJson);
        new Thread(new Runnable(){

            @Override
            public void run() {
                CommonData.setVideoCallModel(videoCallModel);
            }
        }).start();
        try {
            ContextCompat.startForegroundService((Context)context, (Intent)startIntent);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void callingFlow(JSONObject data, String msg, String channel) {
        HippoCallingFlow.INSTANCE.callingFlow(data, msg, channel);
    }

    public boolean isCallServiceRunning() {
        if (this.getContext() == null) {
            return false;
        }
        return this.isMyServiceRunning(this.getContext(), OngoingCallService.class);
    }

    public void startGroupCall(JSONObject data, String msg, String channel) {
        HippoCallingFlow.INSTANCE.callingFlow(data, msg, channel);
    }

    public void onGroupNotificationReceived(Context context, JSONObject data) {
        try {
            this.onGroupCall(context, data);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public OnGroupCallListener getListener() {
        return this.listener;
    }

    public void onGroupCallListener(OnGroupCallListener listener) {
        this.listener = listener;
    }

    private void onGroupCall(Context context, JSONObject jsonObject) throws Exception {
        if (jsonObject.has("video_call_type") && jsonObject.getString("video_call_type").equals(FuguAppConstant.JitsiCallType.START_GROUP_CALL.toString()) && !OngoingCallService.NotificationServiceState.INSTANCE.isConferenceConnected()) {
            ConnectionManager.INSTANCE.initFayeConnection();
            ConnectionManager.INSTANCE.subScribeChannel("/" + com.hippo.database.CommonData.getUserDetails().getData().getUserChannel());
        }
    }

    public void openDirectLink(Context context, String roomId, String userName, String callType, String imagePath, Long channelId, String transactionId, int isAudioEnabled, int isVideoEnabled) {
        if (!TextUtils.isEmpty((CharSequence)com.hippo.database.CommonData.getUserDetails().getData().getEn_user_id()) && !TextUtils.isEmpty((CharSequence)roomId)) {
            this.joinSession(context, roomId, userName, callType, imagePath, channelId, transactionId, isAudioEnabled, isVideoEnabled);
        }
    }

    public void leaveGroupCall(Context context, String transactionId) {
        Intent hungupIntent = new Intent(context, HungUpBroadcast.class);
        hungupIntent.putExtra("action", "leaveSession");
        hungupIntent.putExtra("transactionId", transactionId);
        context.sendBroadcast(hungupIntent);
    }

    private URL getServerUrl() {
        URL serverURL;
        if (!TextUtils.isEmpty((CharSequence)this.getJitsiURL())) {
            try {
                URL serverURL2 = new URL(this.getJitsiURL());
                return serverURL2;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        try {
            serverURL = new URL("https://conference.hippochat.io");
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
            throw new RuntimeException("Invalid server URL!");
        }
        return serverURL;
    }

    private void joinSession(Context context, String roomName, String title, String callType, String imagePath, Long channelId, String transactionId, int isAudioEnabled, int isVideoEnable) {
        if (OngoingCallService.NotificationServiceState.INSTANCE.isConferenceConnected()) {
            return;
        }
        String link = "https://conference.hippochat.io/" + roomName;
        String jitsiLink = "";
        if (!TextUtils.isEmpty((CharSequence)this.getJitsiURL())) {
            jitsiLink = this.getJitsiURL() + "/" + roomName;
        }
        this.answerGroupCall(context, channelId, link, jitsiLink, title, transactionId);
        URL serverURL = this.getServerUrl();
        JitsiMeetUserInfo userInfo = new JitsiMeetUserInfo();
        try {
            userInfo.setDisplayName(title);
            if (!TextUtils.isEmpty((CharSequence)imagePath)) {
                userInfo.setAvatar(new URL(imagePath));
            }
        }
        catch (Exception e) {
            userInfo.setDisplayName("Fellow User");
        }
        try {
            JitsiMeetConferenceOptions defaultOptions;
            if (isVideoEnable == 0) {
                defaultOptions = new JitsiMeetConferenceOptions.Builder().setServerURL(serverURL).setWelcomePageEnabled(false).setAudioOnly(true).setAudioMuted(isAudioEnabled == 0).setFeatureFlag("chat.enabled", false).setFeatureFlag("invite.enabled", false).setUserInfo(userInfo).build();
                JitsiMeet.setDefaultConferenceOptions((JitsiMeetConferenceOptions)defaultOptions);
            } else {
                defaultOptions = new JitsiMeetConferenceOptions.Builder().setServerURL(serverURL).setWelcomePageEnabled(false).setAudioOnly(false).setAudioMuted(isAudioEnabled == 0).setFeatureFlag("chat.enabled", false).setFeatureFlag("invite.enabled", false).setUserInfo(userInfo).build();
                JitsiMeet.setDefaultConferenceOptions((JitsiMeetConferenceOptions)defaultOptions);
            }
        }
        catch (Exception e) {
            JitsiMeetConferenceOptions defaultOptions = new JitsiMeetConferenceOptions.Builder().setServerURL(serverURL).setWelcomePageEnabled(false).setAudioOnly(false).setFeatureFlag("chat.enabled", false).setFeatureFlag("invite.enabled", false).setUserInfo(userInfo).build();
            JitsiMeet.setDefaultConferenceOptions((JitsiMeetConferenceOptions)defaultOptions);
        }
        JitsiMeetConferenceOptions options = new JitsiMeetConferenceOptions.Builder().setRoom(roomName).build();
        JitsiMeetActivity.launch((Context)context, (JitsiMeetConferenceOptions)options, (String)Restring.getString((Context)context, (int)R.string.hippo_calling_connection));
    }

    private void startOngoingCallService(Context context, String signalUniqueId, String inviteLink, Long channelId, String muid, String transactionId) {
        OngoingCallService.NotificationServiceState.INSTANCE.setConferenceConnected(true);
        OngoingCallService.NotificationServiceState.INSTANCE.setChannelId(channelId);
        OngoingCallService.NotificationServiceState.INSTANCE.setConferenceServiceRunning(true);
        OngoingCallService.NotificationServiceState.INSTANCE.setHasGroupCall(true);
        OngoingCallService.NotificationServiceState.INSTANCE.setInviteLink(inviteLink);
        OngoingCallService.NotificationServiceState.INSTANCE.setMuid(muid);
        OngoingCallService.NotificationServiceState.INSTANCE.setTransactionId(transactionId);
        Intent startIntent = new Intent(context, OngoingCallService.class);
        startIntent.setAction("com.hippochat.notification.start");
        startIntent.putExtra("muid", signalUniqueId);
        startIntent.putExtra("invite_link", inviteLink);
        startIntent.putExtra("channel_id", (Serializable)channelId);
        ContextCompat.startForegroundService((Context)context, (Intent)startIntent);
        try {
            if (HippoCallConfig.getInstance().context != null) {
                HippoAudioManager.getInstance(HippoCallConfig.getInstance().context).stop(false);
            } else {
                HippoAudioManager.getInstance(context).stop(false);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void answerGroupCall(Context context, Long channelId, String inviteLink, String jitsiLink, String fullName, String transactionId) {
        Long userId = com.hippo.database.CommonData.getUserDetails().getData().getUserId();
        String muid = UUID.randomUUID().toString();
        this.startOngoingCallService(context, muid, inviteLink, channelId, muid, transactionId);
        try {
            JSONObject startCallJson = new JSONObject();
            startCallJson.put("is_silent", true);
            startCallJson.put("video_call_type", (Object)WebRTCCallConstants.VideoCallType.JOIN_GROUP_CALL.toString());
            startCallJson.put("user_id", (Object)userId);
            startCallJson.put("channel_id", (Object)channelId);
            startCallJson.put("message_type", 27);
            startCallJson.put("call_type", (Object)"VIDEO");
            startCallJson.put("muid", (Object)muid);
            startCallJson.put("device_payload", (Object)this.getDeviceDetails(context));
            startCallJson.put("invite_link", (Object)inviteLink);
            startCallJson.put("message", (Object)"");
            startCallJson.put("is_typing", 0);
            startCallJson.put("user_type", 1);
            startCallJson.put("full_name", (Object)fullName);
            ConnectionManager.INSTANCE.publish("/" + channelId, startCallJson);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void startTimerTask() {
    }

    public void stopTimerTask() {
    }
}

