/*
 * Decompiled with CFR 0.152.
 */
package com.hippocall.confcall;

import android.annotation.TargetApi;
import android.content.Context;
import android.media.AudioManager;
import android.media.MediaPlayer;
import android.net.Uri;
import android.os.Vibrator;
import android.util.Log;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.hippo.utils.HippoLog;
import com.hippo.utils.Utils;
import java.io.IOException;

public class IncomingRinger {
    private static final String TAG = IncomingRinger.class.getSimpleName();
    private static final long[] VIBRATE_PATTERN = new long[]{0L, 1000L, 1000L};
    private final Context context;
    private final Vibrator vibrator;
    private MediaPlayer player;

    IncomingRinger(Context context) {
        this.context = context.getApplicationContext();
        this.vibrator = (Vibrator)context.getSystemService("vibrator");
    }

    public void start(@Nullable Uri uri, boolean vibrate) {
        block8: {
            int ringerMode;
            AudioManager audioManager = Utils.getAudioManager((Context)this.context);
            if (this.player != null) {
                this.player.release();
            }
            if (uri != null) {
                this.player = this.createPlayer(uri);
            }
            if (this.shouldVibrate(this.context, this.player, ringerMode = audioManager.getRingerMode(), vibrate)) {
                HippoLog.i((String)TAG, (String)"Starting vibration");
                this.vibrator.vibrate(VIBRATE_PATTERN, 1);
            }
            if (this.player != null && ringerMode == 2) {
                try {
                    if (!this.player.isPlaying()) {
                        this.player.prepare();
                        this.player.start();
                        HippoLog.i((String)TAG, (String)"Playing ringtone now...");
                        break block8;
                    }
                    HippoLog.w((String)TAG, (String)"Ringtone is already playing, declining to restart.");
                }
                catch (IOException | IllegalStateException e) {
                    Log.w((String)TAG, (String)"ERROR ", (Throwable)e);
                    this.player = null;
                }
            } else {
                HippoLog.w((String)TAG, (String)("Not ringing, mode: " + ringerMode));
            }
        }
    }

    public void stop() {
        if (this.player != null) {
            HippoLog.i((String)TAG, (String)"Stopping ringer");
            this.player.release();
            this.player = null;
        }
        HippoLog.i((String)TAG, (String)"Cancelling vibrator");
        this.vibrator.cancel();
    }

    private boolean shouldVibrate(Context context, MediaPlayer player, int ringerMode, boolean vibrate) {
        if (player == null) {
            return true;
        }
        return this.shouldVibrateNew(context, ringerMode, vibrate);
    }

    @TargetApi(value=11)
    private boolean shouldVibrateNew(Context context, int ringerMode, boolean vibrate) {
        Vibrator vibrator = (Vibrator)context.getSystemService("vibrator");
        if (vibrator == null || !vibrator.hasVibrator()) {
            return false;
        }
        if (vibrate) {
            return ringerMode != 0;
        }
        return ringerMode == 1;
    }

    private boolean shouldVibrateOld(Context context, boolean vibrate) {
        AudioManager audioManager = Utils.getAudioManager((Context)context);
        return vibrate && audioManager.shouldVibrate(0);
    }

    private MediaPlayer createPlayer(@NonNull Uri ringtoneUri) {
        try {
            MediaPlayer mediaPlayer = new MediaPlayer();
            mediaPlayer.setOnErrorListener((MediaPlayer.OnErrorListener)new MediaPlayerErrorListener());
            mediaPlayer.setDataSource(this.context, ringtoneUri);
            mediaPlayer.setLooping(true);
            mediaPlayer.setAudioStreamType(2);
            return mediaPlayer;
        }
        catch (IOException e) {
            HippoLog.e((String)TAG, (String)"Failed to create player for incoming call ringer");
            return null;
        }
    }

    private class MediaPlayerErrorListener
    implements MediaPlayer.OnErrorListener {
        private MediaPlayerErrorListener() {
        }

        public boolean onError(MediaPlayer mp, int what, int extra) {
            HippoLog.w((String)TAG, (String)("onError(" + mp + ", " + what + ", " + extra));
            IncomingRinger.this.player = null;
            return false;
        }
    }
}

