/*
 * Decompiled with CFR 0.152.
 */
package com.hippocall;

import android.content.Context;
import android.content.Intent;
import android.os.Build;
import android.text.TextUtils;
import androidx.localbroadcastmanager.content.LocalBroadcastManager;
import com.hippo.CaptureUserData;
import com.hippo.HippoConfig;
import com.hippo.OnGroupSessionListener;
import com.hippo.constant.FuguAppConstant;
import com.hippo.eventbus.BusProvider;
import com.hippo.helper.FayeMessage;
import com.hippo.langs.Restring;
import com.hippo.utils.HippoLog;
import com.hippocall.AppContants;
import com.hippocall.CommonData;
import com.hippocall.HippoCallConfig;
import com.hippocall.VideoCallModel;
import com.hippocall.WebRTCCallConstants;
import com.hippocall.confcall.HippoAudioManager;
import com.hippocall.confcall.HungUpBroadcast;
import com.hippocall.confcall.OngoingCallService;
import com.hippocall.confcall.PushReceiver;
import com.hippocall.model.Message;
import faye.ConnectionManager;
import faye.ConnectionUtils;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONObject;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u000b\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\"\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\b2\b\u0010\t\u001a\u0004\u0018\u00010\bJ\u0010\u0010\n\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u001f\u0010\u000b\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\b\u0010\f\u001a\u0004\u0018\u00010\rH\u0002\u00a2\u0006\u0002\u0010\u000eJ\u001f\u0010\u000f\u001a\u00020\u00042\u0006\u0010\u0010\u001a\u00020\u00062\b\u0010\f\u001a\u0004\u0018\u00010\rH\u0002\u00a2\u0006\u0002\u0010\u000eJ\u0010\u0010\u0011\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u0010\u0010\u0012\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u0010\u0010\u0013\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u0010\u0010\u0014\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u0010\u0010\u0015\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u0010\u0010\u0016\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u0010\u0010\u0017\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002\u00a8\u0006\u0018"}, d2={"Lcom/hippocall/HippoCallingFlow;", "", "()V", "callingFlow", "", "data", "Lorg/json/JSONObject;", "msg", "", "channel", "closeConference", "emitReadyToConnect", "userId", "", "(Lorg/json/JSONObject;Ljava/lang/Integer;)V", "emitUserBusy", "jsonObject", "endSessionConference", "hungupConference", "offerConference", "openGroupCall", "rejectConference", "removeCallView", "startConference", "hippocall_release"})
public final class HippoCallingFlow {
    public static final HippoCallingFlow INSTANCE;

    public final void callingFlow(@NotNull JSONObject data, @Nullable String msg, @Nullable String channel) {
        Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
        String string2 = data.getString("video_call_type");
        if (Intrinsics.areEqual((Object)string2, (Object)FuguAppConstant.JitsiCallType.START_CONFERENCE.toString())) {
            this.startConference(data);
        } else if (Intrinsics.areEqual((Object)string2, (Object)FuguAppConstant.JitsiCallType.OFFER_CONFERENCE.toString())) {
            this.offerConference(data);
        } else if (Intrinsics.areEqual((Object)string2, (Object)FuguAppConstant.JitsiCallType.REJECT_CONFERENCE.toString())) {
            this.rejectConference(data);
        } else if (Intrinsics.areEqual((Object)string2, (Object)FuguAppConstant.JitsiCallType.HUNGUP_CONFERENCE.toString())) {
            this.hungupConference(data);
        } else if (Intrinsics.areEqual((Object)string2, (Object)FuguAppConstant.JitsiCallType.ANSWER_CONFERENCE.toString())) {
            HippoConfig hippoConfig = HippoConfig.getInstance();
            Intrinsics.checkExpressionValueIsNotNull((Object)hippoConfig, (String)"HippoConfig.getInstance()");
            CaptureUserData captureUserData = hippoConfig.getUserData();
            Intrinsics.checkExpressionValueIsNotNull((Object)captureUserData, (String)"HippoConfig.getInstance().userData");
            Long finalUserId1 = captureUserData.getUserId();
            HippoCallConfig hippoCallConfig = HippoCallConfig.getInstance();
            Intrinsics.checkExpressionValueIsNotNull((Object)hippoCallConfig, (String)"HippoCallConfig.getInstance()");
            String deviceId = CommonData.getUniqueIMEIId(hippoCallConfig.getContext());
            String remoteDeviceId = data.getJSONObject("device_payload").optString("device_id");
            if ((int)finalUserId1.longValue() == data.optInt("user_id", -1) && Intrinsics.areEqual((Object)deviceId, (Object)remoteDeviceId) ^ true) {
                Intent mIntent2 = new Intent("video_conference_hungup_intent");
                mIntent2.putExtra("invite_link", data.getString("invite_link"));
                HippoCallConfig hippoCallConfig2 = HippoCallConfig.getInstance();
                Intrinsics.checkExpressionValueIsNotNull((Object)hippoCallConfig2, (String)"HippoCallConfig.getInstance()");
                LocalBroadcastManager.getInstance((Context)hippoCallConfig2.getContext()).sendBroadcast(mIntent2);
                HippoCallConfig hippoCallConfig3 = HippoCallConfig.getInstance();
                Intrinsics.checkExpressionValueIsNotNull((Object)hippoCallConfig3, (String)"HippoCallConfig.getInstance()");
                Context context = hippoCallConfig3.getContext();
                Intrinsics.checkExpressionValueIsNotNull((Object)context, (String)"HippoCallConfig.getInstance().context");
                if (ConnectionUtils.INSTANCE.isMyServiceRunning(context, OngoingCallService.class)) {
                    HippoCallConfig hippoCallConfig4 = HippoCallConfig.getInstance();
                    Intrinsics.checkExpressionValueIsNotNull((Object)hippoCallConfig4, (String)"HippoCallConfig.getInstance()");
                    HippoAudioManager.getInstance(hippoCallConfig4.getContext()).stop(false);
                    HippoCallConfig hippoCallConfig5 = HippoCallConfig.getInstance();
                    Intrinsics.checkExpressionValueIsNotNull((Object)hippoCallConfig5, (String)"HippoCallConfig.getInstance()");
                    Intent startIntent = new Intent(hippoCallConfig5.getContext(), OngoingCallService.class);
                    HippoCallConfig hippoCallConfig6 = HippoCallConfig.getInstance();
                    Intrinsics.checkExpressionValueIsNotNull((Object)hippoCallConfig6, (String)"HippoCallConfig.getInstance()");
                    hippoCallConfig6.getContext().stopService(startIntent);
                }
                HippoCallConfig hippoCallConfig7 = HippoCallConfig.getInstance();
                Intrinsics.checkExpressionValueIsNotNull((Object)hippoCallConfig7, (String)"HippoCallConfig.getInstance()");
                Context context2 = hippoCallConfig7.getContext();
                Intrinsics.checkExpressionValueIsNotNull((Object)context2, (String)"HippoCallConfig.getInstance().context");
                if (!ConnectionUtils.INSTANCE.isAppRunning(context2)) {
                    ConnectionManager.INSTANCE.onClose();
                }
            } else if (!TextUtils.isEmpty((CharSequence)msg)) {
                BusProvider.getInstance().post((Object)new FayeMessage(FuguAppConstant.FayeBusEvent.MESSAGE_RECEIVED.toString(), channel, msg));
            }
        } else if (Intrinsics.areEqual((Object)string2, (Object)WebRTCCallConstants.VideoCallType.START_CALL.toString())) {
            HippoCallConfig.getInstance().oldSDKCall(msg, channel);
        } else if (Intrinsics.areEqual((Object)string2, (Object)WebRTCCallConstants.VideoCallType.VIDEO_OFFER.toString())) {
            HippoCallConfig.getInstance().oldSDKCall(msg, channel);
        } else if (Intrinsics.areEqual((Object)string2, (Object)WebRTCCallConstants.VideoCallType.START_GROUP_CALL.toString())) {
            this.openGroupCall(data);
        } else if (Intrinsics.areEqual((Object)string2, (Object)WebRTCCallConstants.VideoCallType.REJECT_GROUP_CALL.toString())) {
            this.rejectConference(data);
        } else if (Intrinsics.areEqual((Object)string2, (Object)WebRTCCallConstants.VideoCallType.END_GROUP_CALL.toString())) {
            this.endSessionConference(data);
        } else if (Intrinsics.areEqual((Object)string2, (Object)WebRTCCallConstants.VideoCallType.JOIN_GROUP_CALL.toString())) {
            this.closeConference(data);
        } else {
            if (!TextUtils.isEmpty((CharSequence)msg)) {
                BusProvider.getInstance().post((Object)new FayeMessage(FuguAppConstant.FayeBusEvent.MESSAGE_RECEIVED.toString(), channel, msg));
            }
            HippoLog.e((String)"msg", (String)"~~&~^*&^~*&^~*&^~*^~*~^*~^*~&^~*^~*&^~*&~^*~&^&*~");
        }
    }

    private final void startConference(JSONObject data) {
        HippoConfig hippoConfig = HippoConfig.getInstance();
        Intrinsics.checkExpressionValueIsNotNull((Object)hippoConfig, (String)"HippoConfig.getInstance()");
        CaptureUserData captureUserData = hippoConfig.getUserData();
        Intrinsics.checkExpressionValueIsNotNull((Object)captureUserData, (String)"HippoConfig.getInstance().userData");
        Long finalUserId1 = captureUserData.getUserId();
        if (finalUserId1.longValue() != data.optLong("user_id", -1L) && !OngoingCallService.NotificationServiceState.INSTANCE.isConferenceConnected()) {
            this.emitReadyToConnect(data, (int)finalUserId1.longValue());
            return;
        }
        if (OngoingCallService.NotificationServiceState.INSTANCE.isConferenceConnected()) {
            this.emitUserBusy(data, (int)finalUserId1.longValue());
        }
    }

    private final void offerConference(JSONObject data) {
        Long finalUserId1 = HippoConfig.getInstance().getUserData().getUserId();
        if (finalUserId1.longValue() != data.optLong("user_id", -1L) && !OngoingCallService.NotificationServiceState.INSTANCE.isConferenceConnected()) {
            Message turnCredentials = new AppContants().getTurnCredentials();
            CaptureUserData captureUserData = HippoConfig.getInstance().getUserData();
            Intrinsics.checkExpressionValueIsNotNull((Object)captureUserData, (String)"HippoConfig.getInstance().getUserData()");
            String myName = captureUserData.getFullName();
            String myImage = com.hippo.database.CommonData.getImagePath();
            Long l = finalUserId1;
            Intrinsics.checkExpressionValueIsNotNull((Object)l, (String)"finalUserId1");
            long userId = data.optLong("user_id", l.longValue());
            String fullname = data.optString("full_name");
            long channelId = data.optLong("channel_id");
            String messageUniqueId = data.optString("muid");
            String videoCallType = data.optString("video_call_type", "");
            String callType = data.optString("call_type", "");
            String activityLaunchState = WebRTCCallConstants.AcitivityLaunchState.OTHER.toString();
            String userImage = data.optString("user_thumbnail_image");
            String string2 = data.optString("user_thumbnail_image");
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"data.optString(\"user_thumbnail_image\")");
            String string3 = data.optString("full_name");
            Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"data.optString(\"full_name\")");
            String string4 = fullname;
            Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"fullname");
            String string5 = turnCredentials.getTurnApiKey();
            Intrinsics.checkExpressionValueIsNotNull((Object)string5, (String)"turnCredentials.getTurnApiKey()");
            String string6 = turnCredentials.getUsername();
            Intrinsics.checkExpressionValueIsNotNull((Object)string6, (String)"turnCredentials.getUsername()");
            String string7 = turnCredentials.getCredentials();
            Intrinsics.checkExpressionValueIsNotNull((Object)string7, (String)"turnCredentials.getCredentials()");
            ArrayList arrayList = new ArrayList();
            ArrayList arrayList2 = new ArrayList();
            String string8 = callType;
            Intrinsics.checkExpressionValueIsNotNull((Object)string8, (String)"callType");
            String string9 = string8;
            String string10 = messageUniqueId;
            String string11 = activityLaunchState;
            ArrayList arrayList3 = arrayList2;
            ArrayList arrayList4 = arrayList;
            String string12 = string7;
            String string13 = string6;
            String string14 = string5;
            String string15 = string4;
            long l2 = -1L;
            long l3 = userId;
            String string16 = string3;
            String string17 = string2;
            long l4 = channelId;
            boolean bl = false;
            String string18 = string9;
            if (string18 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
            }
            String string19 = string18.toUpperCase();
            Intrinsics.checkExpressionValueIsNotNull((Object)string19, (String)"(this as java.lang.String).toUpperCase()");
            String string20 = string19;
            DefaultConstructorMarker defaultConstructorMarker = null;
            int n = 262144;
            Boolean bl2 = null;
            String string21 = myImage;
            String string22 = myName;
            String string23 = "";
            String string24 = "";
            String string25 = string20;
            String string26 = string10;
            String string27 = string11;
            ArrayList arrayList5 = arrayList3;
            ArrayList arrayList6 = arrayList4;
            String string28 = string12;
            String string29 = string13;
            String string30 = string14;
            String string31 = string15;
            long l5 = l2;
            long l6 = l3;
            String string32 = string16;
            String string33 = string17;
            long l7 = l4;
            VideoCallModel videoCallModel = new VideoCallModel(l7, string33, string32, l6, l5, string31, string30, string29, string28, arrayList6, arrayList5, string27, string26, string25, string24, string23, string22, string21, bl2, n, defaultConstructorMarker);
            if (Intrinsics.areEqual((Object)OngoingCallService.NotificationServiceState.INSTANCE.getMuid(), (Object)data.getString("muid"))) {
                return;
            }
            String string34 = data.getString("muid");
            Intrinsics.checkExpressionValueIsNotNull((Object)string34, (String)"data.getString(MESSAGE_UNIQUE_ID)");
            OngoingCallService.NotificationServiceState.INSTANCE.setMuid(string34);
            String string35 = data.getString("invite_link");
            Intrinsics.checkExpressionValueIsNotNull((Object)string35, (String)"data.getString(\"invite_link\")");
            OngoingCallService.NotificationServiceState.INSTANCE.setInviteLink(string35);
            PushReceiver fuguNotificationConfig = new PushReceiver().getInstance();
            HippoCallConfig hippoCallConfig = HippoCallConfig.getInstance();
            Intrinsics.checkExpressionValueIsNotNull((Object)hippoCallConfig, (String)"HippoCallConfig.getInstance()");
            Context context = hippoCallConfig.getContext();
            Intrinsics.checkExpressionValueIsNotNull((Object)context, (String)"HippoCallConfig.getInstance().context");
            fuguNotificationConfig.incomingCallNotification(context, data, videoCallModel);
        }
    }

    private final void closeConference(JSONObject data) {
        HippoConfig hippoConfig = HippoConfig.getInstance();
        Intrinsics.checkExpressionValueIsNotNull((Object)hippoConfig, (String)"HippoConfig.getInstance()");
        CaptureUserData captureUserData = hippoConfig.getUserData();
        Intrinsics.checkExpressionValueIsNotNull((Object)captureUserData, (String)"HippoConfig.getInstance().userData");
        Long finalUserId1 = captureUserData.getUserId();
        HippoCallConfig hippoCallConfig = HippoCallConfig.getInstance();
        Intrinsics.checkExpressionValueIsNotNull((Object)hippoCallConfig, (String)"HippoCallConfig.getInstance()");
        String deviceId = CommonData.getUniqueIMEIId(hippoCallConfig.getContext());
        String remoteDeviceId = data.getJSONObject("device_payload").optString("device_id");
        if ((int)finalUserId1.longValue() == data.optInt("user_id", -1) && Intrinsics.areEqual((Object)deviceId, (Object)remoteDeviceId) ^ true) {
            Intent mIntent2 = new Intent("video_conference_hungup_intent");
            mIntent2.putExtra("invite_link", data.getString("invite_link"));
            HippoCallConfig hippoCallConfig2 = HippoCallConfig.getInstance();
            Intrinsics.checkExpressionValueIsNotNull((Object)hippoCallConfig2, (String)"HippoCallConfig.getInstance()");
            LocalBroadcastManager.getInstance((Context)hippoCallConfig2.getContext()).sendBroadcast(mIntent2);
            if (Build.VERSION.SDK_INT > 28) {
                HippoCallConfig hippoCallConfig3 = HippoCallConfig.getInstance();
                Intrinsics.checkExpressionValueIsNotNull((Object)hippoCallConfig3, (String)"HippoCallConfig.getInstance()");
                HippoAudioManager.getInstance(hippoCallConfig3.getContext()).stop(false);
                HippoCallConfig hippoCallConfig4 = HippoCallConfig.getInstance();
                Intrinsics.checkExpressionValueIsNotNull((Object)hippoCallConfig4, (String)"HippoCallConfig.getInstance()");
                Intent startIntent = new Intent(hippoCallConfig4.getContext(), OngoingCallService.class);
                HippoCallConfig hippoCallConfig5 = HippoCallConfig.getInstance();
                Intrinsics.checkExpressionValueIsNotNull((Object)hippoCallConfig5, (String)"HippoCallConfig.getInstance()");
                hippoCallConfig5.getContext().stopService(startIntent);
            }
            HippoCallConfig hippoCallConfig6 = HippoCallConfig.getInstance();
            Intrinsics.checkExpressionValueIsNotNull((Object)hippoCallConfig6, (String)"HippoCallConfig.getInstance()");
            Context context = hippoCallConfig6.getContext();
            Intrinsics.checkExpressionValueIsNotNull((Object)context, (String)"HippoCallConfig.getInstance().context");
            if (!ConnectionUtils.INSTANCE.isAppRunning(context)) {
                ConnectionManager.INSTANCE.onClose();
            }
        }
    }

    private final void endSessionConference(JSONObject data) {
        HippoCallConfig.getInstance().stopTimerTask();
        if (Intrinsics.areEqual((Object)OngoingCallService.NotificationServiceState.INSTANCE.getTransactionId(), (Object)data.optString("transaction_id"))) {
            HippoCallConfig hippoCallConfig = HippoCallConfig.getInstance();
            Intrinsics.checkExpressionValueIsNotNull((Object)hippoCallConfig, (String)"HippoCallConfig.getInstance()");
            Intent hungupIntent = new Intent(hippoCallConfig.getContext(), HungUpBroadcast.class);
            hungupIntent.putExtra("action", "endSession");
            HippoCallConfig hippoCallConfig2 = HippoCallConfig.getInstance();
            Intrinsics.checkExpressionValueIsNotNull((Object)hippoCallConfig2, (String)"HippoCallConfig.getInstance()");
            hippoCallConfig2.getContext().sendBroadcast(hungupIntent);
            Intent mIntent = new Intent("CALL_HANGUP");
            HippoCallConfig hippoCallConfig3 = HippoCallConfig.getInstance();
            Intrinsics.checkExpressionValueIsNotNull((Object)hippoCallConfig3, (String)"HippoCallConfig.getInstance()");
            LocalBroadcastManager.getInstance((Context)hippoCallConfig3.getContext()).sendBroadcast(mIntent);
            Intent mIntent2 = new Intent("video_conference_hungup_intent");
            mIntent2.putExtra("invite_link", data.getString("invite_link"));
            HippoCallConfig hippoCallConfig4 = HippoCallConfig.getInstance();
            Intrinsics.checkExpressionValueIsNotNull((Object)hippoCallConfig4, (String)"HippoCallConfig.getInstance()");
            LocalBroadcastManager.getInstance((Context)hippoCallConfig4.getContext()).sendBroadcast(mIntent2);
        } else {
            HippoCallConfig hippoCallConfig = HippoCallConfig.getInstance();
            Intrinsics.checkExpressionValueIsNotNull((Object)hippoCallConfig, (String)"HippoCallConfig.getInstance()");
            Context context = hippoCallConfig.getContext();
            Intrinsics.checkExpressionValueIsNotNull((Object)context, (String)"HippoCallConfig.getInstance().context");
            if (!ConnectionUtils.INSTANCE.isAppRunning(context)) {
                ConnectionManager.INSTANCE.onClose();
            }
        }
        if (data.optString("video_call_type").equals("END_GROUP_CALL")) {
            HippoConfig hippoConfig = HippoConfig.getInstance();
            Intrinsics.checkExpressionValueIsNotNull((Object)hippoConfig, (String)"HippoConfig.getInstance()");
            if (hippoConfig.getGroupSessionListener() != null) {
                HippoConfig hippoConfig2 = HippoConfig.getInstance();
                Intrinsics.checkExpressionValueIsNotNull((Object)hippoConfig2, (String)"HippoConfig.getInstance()");
                OnGroupSessionListener onGroupSessionListener = hippoConfig2.getGroupSessionListener();
                String string2 = data.optString("transaction_id");
                Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"data.optString(\"transaction_id\")");
                onGroupSessionListener.onSessionEnded(string2);
            }
        }
        HippoCallConfig hippoCallConfig = HippoCallConfig.getInstance();
        Intrinsics.checkExpressionValueIsNotNull((Object)hippoCallConfig, (String)"HippoCallConfig.getInstance()");
        HippoAudioManager.getInstance(hippoCallConfig.getContext()).stop(false);
    }

    private final void rejectConference(JSONObject data) {
        HippoCallConfig hippoCallConfig = HippoCallConfig.getInstance();
        Intrinsics.checkExpressionValueIsNotNull((Object)hippoCallConfig, (String)"HippoCallConfig.getInstance()");
        HippoAudioManager.getInstance(hippoCallConfig.getContext()).stop(false);
        HippoCallConfig.getInstance().stopTimerTask();
        HippoCallConfig hippoCallConfig2 = HippoCallConfig.getInstance();
        Intrinsics.checkExpressionValueIsNotNull((Object)hippoCallConfig2, (String)"HippoCallConfig.getInstance()");
        Context context = hippoCallConfig2.getContext();
        Intrinsics.checkExpressionValueIsNotNull((Object)context, (String)"HippoCallConfig.getInstance().context");
        if (ConnectionUtils.INSTANCE.isMyServiceRunning(context, OngoingCallService.class)) {
            HippoCallConfig hippoCallConfig3 = HippoCallConfig.getInstance();
            Intrinsics.checkExpressionValueIsNotNull((Object)hippoCallConfig3, (String)"HippoCallConfig.getInstance()");
            Intent startIntent = new Intent(hippoCallConfig3.getContext(), OngoingCallService.class);
            HippoCallConfig hippoCallConfig4 = HippoCallConfig.getInstance();
            Intrinsics.checkExpressionValueIsNotNull((Object)hippoCallConfig4, (String)"HippoCallConfig.getInstance()");
            hippoCallConfig4.getContext().stopService(startIntent);
        } else if (Intrinsics.areEqual((Object)OngoingCallService.NotificationServiceState.INSTANCE.getInviteLink(), (Object)data.optString("invite_link"))) {
            BusProvider.getInstance().post((Object)new FayeMessage(WebRTCCallConstants.BusFragmentType.CALL_HUNGUP.toString(), "", ""));
            HippoCallConfig hippoCallConfig5 = HippoCallConfig.getInstance();
            Intrinsics.checkExpressionValueIsNotNull((Object)hippoCallConfig5, (String)"HippoCallConfig.getInstance()");
            Context context2 = hippoCallConfig5.getContext();
            Intrinsics.checkExpressionValueIsNotNull((Object)context2, (String)"HippoCallConfig.getInstance().context");
            if (!ConnectionUtils.INSTANCE.isAppRunning(context2)) {
                ConnectionManager.INSTANCE.onClose();
            }
        }
    }

    private final void hungupConference(JSONObject data) {
        HippoCallConfig hippoCallConfig = HippoCallConfig.getInstance();
        Intrinsics.checkExpressionValueIsNotNull((Object)hippoCallConfig, (String)"HippoCallConfig.getInstance()");
        HippoAudioManager.getInstance(hippoCallConfig.getContext()).stop(false);
        HippoCallConfig.getInstance().stopTimerTask();
        if (Intrinsics.areEqual((Object)OngoingCallService.NotificationServiceState.INSTANCE.getInviteLink(), (Object)data.optString("invite_link"))) {
            HippoCallConfig hippoCallConfig2 = HippoCallConfig.getInstance();
            Intrinsics.checkExpressionValueIsNotNull((Object)hippoCallConfig2, (String)"HippoCallConfig.getInstance()");
            Intent hungupIntent = new Intent(hippoCallConfig2.getContext(), HungUpBroadcast.class);
            hungupIntent.putExtra("action", "rejectCall");
            hungupIntent.putExtra("muid", data.getString("muid"));
            HippoCallConfig hippoCallConfig3 = HippoCallConfig.getInstance();
            Intrinsics.checkExpressionValueIsNotNull((Object)hippoCallConfig3, (String)"HippoCallConfig.getInstance()");
            hippoCallConfig3.getContext().sendBroadcast(hungupIntent);
            Intent mIntent = new Intent("CALL_HANGUP");
            HippoCallConfig hippoCallConfig4 = HippoCallConfig.getInstance();
            Intrinsics.checkExpressionValueIsNotNull((Object)hippoCallConfig4, (String)"HippoCallConfig.getInstance()");
            LocalBroadcastManager.getInstance((Context)hippoCallConfig4.getContext()).sendBroadcast(mIntent);
            Intent mIntent2 = new Intent("video_conference_hungup_intent");
            mIntent2.putExtra("invite_link", data.getString("invite_link"));
            HippoCallConfig hippoCallConfig5 = HippoCallConfig.getInstance();
            Intrinsics.checkExpressionValueIsNotNull((Object)hippoCallConfig5, (String)"HippoCallConfig.getInstance()");
            LocalBroadcastManager.getInstance((Context)hippoCallConfig5.getContext()).sendBroadcast(mIntent2);
        } else {
            HippoCallConfig hippoCallConfig6 = HippoCallConfig.getInstance();
            Intrinsics.checkExpressionValueIsNotNull((Object)hippoCallConfig6, (String)"HippoCallConfig.getInstance()");
            Context context = hippoCallConfig6.getContext();
            Intrinsics.checkExpressionValueIsNotNull((Object)context, (String)"HippoCallConfig.getInstance().context");
            if (!ConnectionUtils.INSTANCE.isAppRunning(context)) {
                ConnectionManager.INSTANCE.onClose();
            }
        }
    }

    private final void emitReadyToConnect(JSONObject data, Integer userId) {
        try {
            JSONObject startCallJson = new JSONObject();
            startCallJson.put("is_silent", true);
            startCallJson.put("video_call_type", (Object)FuguAppConstant.JitsiCallType.READY_TO_CONNECT_CONFERENCE);
            startCallJson.put("user_id", (Object)userId);
            startCallJson.put("channel_id", (Object)data.getString("channel_id"));
            startCallJson.put("message_type", 18);
            startCallJson.put(WebRTCCallConstants.Companion.getCALL_TYPE(), (Object)"VIDEO");
            try {
                String string2 = WebRTCCallConstants.Companion.getDEVICE_PAYLOAD();
                HippoCallConfig hippoCallConfig = HippoCallConfig.getInstance();
                Intrinsics.checkExpressionValueIsNotNull((Object)hippoCallConfig, (String)"HippoCallConfig.getInstance()");
                startCallJson.put(string2, (Object)CommonData.deviceDetails(hippoCallConfig.getContext()));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            startCallJson.put("invite_link", (Object)data.getString("invite_link"));
            startCallJson.put("muid", (Object)data.getString("muid"));
            startCallJson.put(WebRTCCallConstants.Companion.getFULL_NAME(), (Object)data.optString("full_name", ""));
            startCallJson.put("message", (Object)"");
            startCallJson.put("is_typing", 0);
            String channelId = "/" + data.optLong("channel_id");
            ConnectionManager.INSTANCE.publish(channelId, startCallJson);
            HippoLog.e((String)"Video_CONF-->", (String)startCallJson.toString());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private final void emitUserBusy(JSONObject jsonObject, Integer userId) {
        try {
            JSONObject startCallJson = new JSONObject();
            startCallJson.put("is_silent", false);
            startCallJson.put("video_call_type", (Object)FuguAppConstant.JitsiCallType.USER_BUSY_CONFERENCE);
            startCallJson.put("user_id", (Object)userId);
            startCallJson.put("channel_id", (Object)jsonObject.optString("channel_id"));
            startCallJson.put("message_type", 18);
            startCallJson.put(WebRTCCallConstants.Companion.getCALL_TYPE(), (Object)"VIDEO");
            String string2 = WebRTCCallConstants.Companion.getDEVICE_PAYLOAD();
            HippoCallConfig hippoCallConfig = HippoCallConfig.getInstance();
            Intrinsics.checkExpressionValueIsNotNull((Object)hippoCallConfig, (String)"HippoCallConfig.getInstance()");
            startCallJson.put(string2, (Object)CommonData.deviceDetails(hippoCallConfig.getContext()));
            startCallJson.put("invite_link", (Object)jsonObject.optString("invite_link"));
            startCallJson.put("muid", (Object)jsonObject.optString("muid"));
            startCallJson.put(WebRTCCallConstants.Companion.getFULL_NAME(), (Object)jsonObject.optString("full_name", ""));
            startCallJson.put("message", (Object)"");
            startCallJson.put("is_typing", 0);
            startCallJson.put("user_type", 1);
            String channelId = "/" + jsonObject.optLong("channel_id");
            ConnectionManager.INSTANCE.publish(channelId, startCallJson);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private final void removeCallView(JSONObject data) {
    }

    private final void openGroupCall(JSONObject data) {
        Long finalUserId1 = HippoConfig.getInstance().getUserData().getUserId();
        if (finalUserId1.longValue() != data.optLong("user_id", -1L) && !OngoingCallService.NotificationServiceState.INSTANCE.isConferenceConnected()) {
            String key;
            String value;
            Pattern pattern;
            Object matcher;
            Message turnCredentials = new AppContants().getTurnCredentials();
            CaptureUserData captureUserData = HippoConfig.getInstance().getUserData();
            Intrinsics.checkExpressionValueIsNotNull((Object)captureUserData, (String)"HippoConfig.getInstance().getUserData()");
            String myName = captureUserData.getFullName();
            String myImage = com.hippo.database.CommonData.getImagePath();
            Long l = finalUserId1;
            Intrinsics.checkExpressionValueIsNotNull((Object)l, (String)"finalUserId1");
            long userId = data.optLong("user_id", l.longValue());
            String fullname = data.optString("full_name");
            long channelId = data.optLong("channel_id");
            String messageUniqueId = data.optString("muid");
            String videoCallType = data.optString("video_call_type", "");
            String callType = data.optString("call_type", "");
            String activityLaunchState = WebRTCCallConstants.AcitivityLaunchState.OTHER.toString();
            String userImage = data.optString("user_thumbnail_image");
            String message = data.optString("message", "");
            if (data.has("multi_lang_message") && ((Matcher)(matcher = (pattern = Pattern.compile("\\{\\{\\{(.*?)\\}\\}\\}")).matcher(data.optString("multi_lang_message", "")))).find() && !TextUtils.isEmpty((CharSequence)(value = Restring.getString((String)(key = ((Matcher)matcher).group(1)))))) {
                String oldStr = "{{{" + key + "}}}";
                String string2 = data.optString("multi_lang_message", "");
                Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"data.optString(\"multi_lang_message\", \"\")");
                String string3 = value;
                Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"value");
                message = StringsKt.replace$default((String)string2, (String)oldStr, (String)string3, (boolean)false, (int)4, null);
            }
            String string4 = data.optString("user_thumbnail_image");
            Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"data.optString(\"user_thumbnail_image\")");
            String string5 = message;
            Intrinsics.checkExpressionValueIsNotNull((Object)string5, (String)"message");
            String string6 = fullname;
            Intrinsics.checkExpressionValueIsNotNull((Object)string6, (String)"fullname");
            String string7 = turnCredentials.getTurnApiKey();
            Intrinsics.checkExpressionValueIsNotNull((Object)string7, (String)"turnCredentials.getTurnApiKey()");
            String string8 = turnCredentials.getUsername();
            Intrinsics.checkExpressionValueIsNotNull((Object)string8, (String)"turnCredentials.getUsername()");
            String string9 = turnCredentials.getCredentials();
            Intrinsics.checkExpressionValueIsNotNull((Object)string9, (String)"turnCredentials.getCredentials()");
            ArrayList<String> arrayList = new ArrayList<String>();
            ArrayList<String> arrayList2 = new ArrayList<String>();
            String string10 = callType;
            Intrinsics.checkExpressionValueIsNotNull((Object)string10, (String)"callType");
            matcher = string10;
            String string11 = messageUniqueId;
            String string12 = activityLaunchState;
            ArrayList<String> arrayList3 = arrayList2;
            ArrayList<String> arrayList4 = arrayList;
            String string13 = string9;
            String string14 = string8;
            String string15 = string7;
            String string16 = string6;
            long l2 = -1L;
            long l3 = userId;
            String string17 = string5;
            String string18 = string4;
            long l4 = channelId;
            boolean bl = false;
            Object object = matcher;
            if (object == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
            }
            String string19 = ((String)object).toUpperCase();
            Intrinsics.checkExpressionValueIsNotNull((Object)string19, (String)"(this as java.lang.String).toUpperCase()");
            String string20 = string19;
            Boolean bl2 = true;
            String string21 = myImage;
            String string22 = myName;
            String string23 = "";
            String string24 = "";
            String string25 = string20;
            String string26 = string11;
            String string27 = string12;
            ArrayList<String> arrayList5 = arrayList3;
            ArrayList<String> arrayList6 = arrayList4;
            String string28 = string13;
            String string29 = string14;
            String string30 = string15;
            String string31 = string16;
            long l5 = l2;
            long l6 = l3;
            String string32 = string17;
            String string33 = string18;
            long l7 = l4;
            VideoCallModel videoCallModel = new VideoCallModel(l7, string33, string32, l6, l5, string31, string30, string29, string28, arrayList6, arrayList5, string27, string26, string25, string24, string23, string22, string21, bl2);
            if (Intrinsics.areEqual((Object)OngoingCallService.NotificationServiceState.INSTANCE.getMuid(), (Object)data.getString("muid"))) {
                return;
            }
            HippoCallConfig hippoCallConfig = HippoCallConfig.getInstance();
            Intrinsics.checkExpressionValueIsNotNull((Object)hippoCallConfig, (String)"HippoCallConfig.getInstance()");
            if (hippoCallConfig.getListener() != null) {
                HippoCallConfig hippoCallConfig2 = HippoCallConfig.getInstance();
                Intrinsics.checkExpressionValueIsNotNull((Object)hippoCallConfig2, (String)"HippoCallConfig.getInstance()");
                hippoCallConfig2.getListener().callStatus(1);
            }
            String string34 = data.getString("muid");
            Intrinsics.checkExpressionValueIsNotNull((Object)string34, (String)"data.getString(MESSAGE_UNIQUE_ID)");
            OngoingCallService.NotificationServiceState.INSTANCE.setMuid(string34);
            String string35 = data.getString("invite_link");
            Intrinsics.checkExpressionValueIsNotNull((Object)string35, (String)"data.getString(\"invite_link\")");
            OngoingCallService.NotificationServiceState.INSTANCE.setInviteLink(string35);
            String string36 = data.optString("transaction_id");
            Intrinsics.checkExpressionValueIsNotNull((Object)string36, (String)"data.optString(\"transaction_id\")");
            OngoingCallService.NotificationServiceState.INSTANCE.setTransactionId(string36);
            OngoingCallService.NotificationServiceState.INSTANCE.setHasGroupCall(true);
            PushReceiver fuguNotificationConfig = new PushReceiver().getInstance();
            HippoCallConfig hippoCallConfig3 = HippoCallConfig.getInstance();
            Intrinsics.checkExpressionValueIsNotNull((Object)hippoCallConfig3, (String)"HippoCallConfig.getInstance()");
            Context context = hippoCallConfig3.getContext();
            Intrinsics.checkExpressionValueIsNotNull((Object)context, (String)"HippoCallConfig.getInstance().context");
            fuguNotificationConfig.incomingCallNotification(context, data, videoCallModel);
        }
        HippoConfig hippoConfig = HippoConfig.getInstance();
        Intrinsics.checkExpressionValueIsNotNull((Object)hippoConfig, (String)"HippoConfig.getInstance()");
        if (hippoConfig.getGroupSessionListener() != null) {
            HippoConfig hippoConfig2 = HippoConfig.getInstance();
            Intrinsics.checkExpressionValueIsNotNull((Object)hippoConfig2, (String)"HippoConfig.getInstance()");
            OnGroupSessionListener onGroupSessionListener = hippoConfig2.getGroupSessionListener();
            String string37 = data.optString("transaction_id", "");
            Intrinsics.checkExpressionValueIsNotNull((Object)string37, (String)"data.optString(\"transaction_id\", \"\")");
            onGroupSessionListener.onStartSession(string37);
        }
    }

    private HippoCallingFlow() {
    }

    static {
        HippoCallingFlow hippoCallingFlow;
        INSTANCE = hippoCallingFlow = new HippoCallingFlow();
    }
}

