/*
 * Decompiled with CFR 0.152.
 */
package com.hippocall.confcall;

import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.os.Environment;
import android.os.StrictMode;
import android.text.TextUtils;
import com.hippo.utils.Utils;
import com.hippocall.CommonData;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u0010\u0010\u0007\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\b"}, d2={"Lcom/hippocall/confcall/NotificationImageManager;", "", "()V", "createBitmapFromLink", "Landroid/graphics/Bitmap;", "link", "", "getImageBitmap", "hippocall_release"})
public final class NotificationImageManager {
    @Nullable
    public final Bitmap getImageBitmap(@NotNull String link) {
        Intrinsics.checkParameterIsNotNull((Object)link, (String)"link");
        String notificationImageLink = CommonData.getNotificationImage(link);
        Bitmap imageBitmap = null;
        try {
            StrictMode.ThreadPolicy policy = new StrictMode.ThreadPolicy.Builder().permitAll().build();
            StrictMode.setThreadPolicy((StrictMode.ThreadPolicy)policy);
            if (TextUtils.isEmpty((CharSequence)notificationImageLink) || !new File(notificationImageLink).exists()) {
                File noemedia;
                UUID randomName = UUID.randomUUID();
                URL imageUrl = new URL(link);
                Bitmap bitmap = BitmapFactory.decodeStream((InputStream)imageUrl.openConnection().getInputStream());
                Intrinsics.checkExpressionValueIsNotNull((Object)bitmap, (String)"BitmapFactory\n          \u2026ction().getInputStream())");
                Bitmap bitmap2 = bitmap;
                ByteArrayOutputStream bytes = new ByteArrayOutputStream();
                bitmap2.compress(Bitmap.CompressFormat.JPEG, 100, (OutputStream)bytes);
                File folder = new File(Environment.getExternalStorageDirectory(), "Hippo");
                if (!folder.exists()) {
                    folder.mkdirs();
                }
                if (!(noemedia = new File(Environment.getExternalStorageDirectory().toString() + File.separator + "Hippo" + "/.nomedia")).exists()) {
                    noemedia.createNewFile();
                }
                File f = new File(Environment.getExternalStorageDirectory(), "Hippo" + File.separator + randomName + ".png");
                f.createNewFile();
                FileOutputStream fo = new FileOutputStream(f);
                fo.write(bytes.toByteArray());
                fo.close();
                notificationImageLink = Environment.getExternalStorageDirectory().toString() + File.separator + "Hippo" + File.separator + randomName + ".png";
                CommonData.setNotificationImagesMap(link, notificationImageLink);
            }
        }
        catch (Exception e) {
            notificationImageLink = "";
            e.printStackTrace();
        }
        String string2 = notificationImageLink;
        if (string2 == null) {
            Intrinsics.throwNpe();
        }
        imageBitmap = this.createBitmapFromLink(string2);
        return imageBitmap;
    }

    private final Bitmap createBitmapFromLink(String link) {
        try {
            BitmapFactory.Options bmOptions = new BitmapFactory.Options();
            return Utils.getCircleBitmap((Bitmap)BitmapFactory.decodeFile((String)link, (BitmapFactory.Options)bmOptions));
        }
        catch (Exception e) {
            return null;
        }
    }
}

