package com.hippocall

import android.content.BroadcastReceiver
import android.content.Context
import android.content.Intent
import android.content.IntentFilter
import android.media.AudioManager
import android.media.MediaPlayer
import android.os.Bundle
import android.os.Handler
import android.text.TextUtils
import android.view.WindowManager
import android.widget.Toast
import androidx.appcompat.app.AppCompatActivity
import androidx.core.content.ContextCompat
import androidx.localbroadcastmanager.content.LocalBroadcastManager
import com.google.gson.Gson
import com.hippo.BuildConfig
import com.hippo.HippoConfig
import com.hippo.constant.FuguAppConstant
import com.hippo.eventbus.BusProvider
import com.hippo.helper.BusEvents
import com.hippo.helper.FayeMessage
import com.hippo.utils.HippoLog
import com.hippo.utils.UniqueIMEIID
import com.hippocall.confcall.*
import com.hippocall.model.FragmentFlow
import com.squareup.otto.Subscribe
import faye.ConnectionManager
import faye.FayeCallClientListener
import faye.FayeClient
import org.jitsi.meet.sdk.JitsiMeet
import org.jitsi.meet.sdk.JitsiMeetActivity
import org.jitsi.meet.sdk.JitsiMeetConferenceOptions
import org.jitsi.meet.sdk.JitsiMeetUserInfo
import org.json.JSONObject
import java.net.MalformedURLException
import java.net.URL
import java.util.*
import kotlin.collections.ArrayList

/**
 * Created by gurmail on 2020-04-09.
 * @author gurmail
 */

class MainCallingActivity: AppCompatActivity() {

    private var videoCallModel: VideoCallModel? = null
    private var needToStartCall: Boolean = false
    private var initOldCall = false

    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
        setContentView(R.layout.hippo_activity_maincalling)
        val win = window
        win.addFlags(WindowManager.LayoutParams.FLAG_SHOW_WHEN_LOCKED or WindowManager.LayoutParams.FLAG_DISMISS_KEYGUARD)
        win.addFlags(WindowManager.LayoutParams.FLAG_TURN_SCREEN_ON)
        initOldCall = false
        if (intent.hasExtra("videoCallModel")) {
            videoCallModel = intent.extras.getParcelable("videoCallModel") as VideoCallModel

            if(intent.hasExtra("answer_call")) {
                needToStartCall = false

            } else if(intent.hasExtra("incomming_call")) {
                // check the link if empty don't do anything
                needToStartCall = false
            } else {
                needToStartCall = true
                val linkArray = randomVideoConferenceLink()
                var inviteLink = linkArray[0] + "/" + linkArray[1]
                if (videoCallModel?.callType!! == "AUDIO") {
                    inviteLink += "#config.startWithVideoMuted=true"
                }
                videoCallModel?.inviteLink = inviteLink
            }
        }

        ConnectionManager.initFayeConnection()
        ConnectionManager.subScribeChannel("/${videoCallModel?.channelId!!}")

        if(intent.hasExtra("incomming_call")) {
            openIncommingCallFragment()
            startMedia()
            val serverURL: URL = getServerUrl()
            preInitCall(serverURL)
        } else if(intent.hasExtra("answer_call")) {
            onVideoConfActivityCreate(false)
        } else {
            openJitsiFragment()
            if(ConnectionManager.isConnected()) {
                Handler().postDelayed({
                    onStartCall()
                }, 200)
            }
        }
    }

    private fun onStartCall() {
        if(needToStartCall) {
            Handler().postDelayed({
                BusProvider.getInstance().post(FragmentFlow(WebRTCCallConstants.BusFragmentType.MAIN_CALL.toString(),
                    1, JSONObject(), ""))
                needToStartCall = false
            }, 500)
        }
    }

    override fun onResume() {
        super.onResume()

    }

    override fun onPause() {
        super.onPause()

    }

    override fun onStart() {
        super.onStart()
        BusProvider.getInstance().register(this)
    }

    override fun onStop() {
        super.onStop()
        BusProvider.getInstance().unregister(this)
    }

    override fun onBackPressed() {

    }

    override fun onDestroy() {
        super.onDestroy()
        HippoAudioManager.getInstance(this@MainCallingActivity).stop(false)
    }


    private fun openJitsiFragment() {
        var fragment = JitsiCallActivity()
        val bundle = Bundle()
        //bundle.putString("data", data)
        bundle.putParcelable("videoCallModel", videoCallModel)
        fragment.arguments = bundle

        supportFragmentManager.beginTransaction()
            .add(R.id.main_layout, fragment, JitsiCallActivity::class.java.simpleName)
            .addToBackStack(JitsiCallActivity::class.java.simpleName)
            .commitAllowingStateLoss()
    }

    private fun openIncommingCallFragment() {
        var fragment = IncomingJitsiCallActivity()
        val bundle = Bundle()
        //bundle.putString("data", data)
        bundle.putParcelable("videoCallModel", videoCallModel)
        fragment.arguments = bundle

        supportFragmentManager.beginTransaction()
            .add(R.id.main_layout, fragment, IncomingJitsiCallActivity::class.java.simpleName)
            .addToBackStack(IncomingJitsiCallActivity::class.java.simpleName)
            .commitAllowingStateLoss()
    }

    public fun sendMessage(channelId: Long, jsonObject: JSONObject) {
        ConnectionManager.publish("/$channelId", jsonObject)
    }

    @Subscribe
    public fun onBusFragmentType(data: FragmentFlow) {
        when(data.fragmentType) {
            WebRTCCallConstants.BusFragmentType.INCOMMING_JITSI_CALL.toString() -> {
                incomingBusOpration(data.type)
            }
            WebRTCCallConstants.BusFragmentType.JITSI_CALL.toString() -> {
                jitsiActivityOperation(data)
            }
            WebRTCCallConstants.BusFragmentType.INCOMING_VIDEO_CONF.toString() -> {

            }

        }
    }


    @Subscribe
    public fun onFayeMessageEvent(event: FayeMessage) {
        HippoLog.d("onFayeMessageEvent", "onFayeMessageEvent -> "+event.type);
        when (event.type) {
            BusEvents.ERROR_RECEIVED.toString() -> {
                startOldCall(event)
                /*try {
                    if(!initOldCall) {
                        initOldCall = true
                        val fragment = supportFragmentManager.findFragmentByTag(JitsiCallActivity::class.java.simpleName) as JitsiCallActivity
                        fragment.onErrorRecieved(event.message)
                    }
                } catch (e: Exception) {
                }*/
            }
            WebRTCCallConstants.BusFragmentType.CALL_HUNGUP.toString() -> {
                HippoAudioManager.getInstance(this@MainCallingActivity).stop(false)
                finish()
            }
        }
    }

    @Synchronized
    private fun startOldCall(event: FayeMessage) {
        try {
            if(!initOldCall) {
                initOldCall = true
                val fragment = supportFragmentManager.findFragmentByTag(JitsiCallActivity::class.java.simpleName) as JitsiCallActivity
                fragment.onErrorRecieved(event.message)
            }
        } catch (e: Exception) {
        }
    }


    private fun randomVideoConferenceLink(): ArrayList<String> {
        val linkArray = ArrayList<String>()
        val ALLOWED_CHARACTERS = "qwertyuiopasdfghjklzxcvbnm"
        val random = Random()
        val sb = StringBuilder(10)
        for (i in 0 until 10)
            sb.append(ALLOWED_CHARACTERS[random.nextInt(ALLOWED_CHARACTERS.length)])
        linkArray.add(FuguAppConstant.CONFERENCING_LIVE)
        linkArray.add(sb.toString())
        videoCallModel?.roomName = sb.toString()

        return linkArray
    }


    //==============================================================================================
    // for IncomingJitsiCallActivity
    //==============================================================================================


    private fun incomingBusOpration(type: Int) {
        when(type) {
            WebRTCCallConstants.IncommintJitsiCall.START_MEDIA -> startMedia()
            WebRTCCallConstants.IncommintJitsiCall.UNREGISTER_BROADCAST -> {
                //mediaPlayer?.stop()
                HippoAudioManager.getInstance(this@MainCallingActivity).stop(false)
                try {
                    LocalBroadcastManager.getInstance(this).unregisterReceiver(mVideoConferenceHungup)
                } catch (e: Exception) {
                    e.printStackTrace()
                }
            }
            WebRTCCallConstants.IncommintJitsiCall.REGISTER_BROADCAST -> {
                try {
                    LocalBroadcastManager.getInstance(this).unregisterReceiver(mVideoConferenceHungup)
                } catch (e: Exception) {
                    e.printStackTrace()
                }
                LocalBroadcastManager.getInstance(this).registerReceiver(mVideoConferenceHungup,
                    IntentFilter(FuguAppConstant.VIDEO_CONFERENCE_HUNGUP_INTENT)
                )
            }
            WebRTCCallConstants.IncommintJitsiCall.STOP -> {
                try {
                    LocalBroadcastManager.getInstance(this).unregisterReceiver(mVideoConferenceHungup)
                } catch (e: Exception) {
                    e.printStackTrace()
                }
            }
            WebRTCCallConstants.IncommintJitsiCall.ANSWERCALL -> {
                onVideoConfActivityCreate(false)
            }
            WebRTCCallConstants.IncommintJitsiCall.REJECTCALL -> {

                HippoAudioManager.getInstance(this@MainCallingActivity).stop(false)

                val hungupIntent = Intent(this@MainCallingActivity, HungUpBroadcast::class.java)
                hungupIntent.putExtra("action", "rejectCall")
                hungupIntent.putExtra(WebRTCCallConstants.DEVICE_PAYLOAD, getDeviceDetails().toString())
                hungupIntent.putExtra(FuguAppConstant.INVITE_LINK, videoCallModel?.inviteLink)
                hungupIntent.putExtra(FuguAppConstant.CHANNEL_ID, videoCallModel?.channelId)
                sendBroadcast(hungupIntent)
                finish()
            }
        }
    }

    private fun startMedia() {
        HippoAudioManager.getInstance(this@MainCallingActivity).startIncomingRinger()
    }

    private val mVideoConferenceHungup = object : BroadcastReceiver() {
        override fun onReceive(context: Context?, intent: Intent?) {
            //mediaPlayer?.stop()
            HippoAudioManager.getInstance(this@MainCallingActivity).stop(false)
            finish()
        }
    }

    private fun getDeviceDetails(): JSONObject {
        val devicePayload = JSONObject()
        devicePayload.put(FuguAppConstant.DEVICE_ID, UniqueIMEIID.getUniqueIMEIId(this))
        devicePayload.put(FuguAppConstant.DEVICE_TYPE, FuguAppConstant.ANDROID_USER)
        devicePayload.put(FuguAppConstant.APP_VERSION, BuildConfig.VERSION_NAME)
        devicePayload.put(FuguAppConstant.DEVICE_DETAILS, CommonData.deviceDetails(this))
        return devicePayload
    }

    // Ending IncommingJitsi Call data
    //==============================================================================================

    //for VideoConfActivity here

    //==============================================================================================


    private fun jitsiActivityOperation(data: FragmentFlow) {
        when(data.type) {
            WebRTCCallConstants.JitsiCallActivity.POST_DATA -> {
                //Log.d("POST_DATA", "POST_DATA = "+ Gson().toJson(data))
                sendMessage(videoCallModel?.channelId!!, data?.json!!)
            }
            WebRTCCallConstants.JitsiCallActivity.OPEN_VIDEO_CONF -> {
                onVideoConfActivityCreate(true)
            }
            WebRTCCallConstants.JitsiCallActivity.PRE_LOAD_DATA -> {
                val serverURL: URL = getServerUrl()
                preInitCall(serverURL)
            }
            WebRTCCallConstants.JitsiCallActivity.OPEN_OLD_CALL -> {
                //Toast.makeText(this@MainCallingActivity, "Update your app", Toast.LENGTH_LONG).show()
                HippoCallConfig.getInstance().initOldCall(videoCallModel)
                finish()
            }
        }
    }

    private fun onVideoConfActivityCreate(hasAnswer: Boolean) {

        stopForegroundService()
        HippoAudioManager.getInstance(this@MainCallingActivity).stop(false)
        OngoingCallService.NotificationServiceState.isConferenceConnected = true
        if (!hasAnswer) {
            answerConference()
        }
        val serverURL: URL = getServerUrl()
        initCall(serverURL)
        startOngoingCallService()
        finish()
    }

    private fun stopForegroundService() {
        try {
            val startIntent = Intent(this@MainCallingActivity, VideoCallService::class.java)
            startIntent.action = "com.officechat.start"
            startIntent.putExtra("isHungUpToBeSent", false)
            stopService(startIntent)
        } catch (e: Exception) {
            e.printStackTrace()
        }
    }

    private fun startOngoingCallService() {
        val startIntent = Intent(this, OngoingCallService::class.java)
        startIntent.action = "com.officechat.notification.start"
        startIntent.putExtra(FuguAppConstant.MESSAGE_UNIQUE_ID, videoCallModel?.signalUniqueId)
        startIntent.putExtra(FuguAppConstant.INVITE_LINK, videoCallModel?.inviteLink)
        startIntent.putExtra(FuguAppConstant.CHANNEL_ID, videoCallModel?.channelId)
        ContextCompat.startForegroundService(this, startIntent)
    }

    private fun answerConference() {
        val userId = com.hippo.database.CommonData.getUserDetails().data.userId
        val fullName = com.hippo.database.CommonData.getUserDetails().data.fullName
        val startCallJson = JSONObject()
        startCallJson.put(FuguAppConstant.IS_SILENT, true)
        startCallJson.put(WebRTCCallConstants.VIDEO_CALL_TYPE, WebRTCCallConstants.JitsiCallType.ANSWER_CONFERENCE.toString())
        startCallJson.put(FuguAppConstant.USER_ID, userId)
        startCallJson.put(FuguAppConstant.CHANNEL_ID, videoCallModel?.channelId)
        startCallJson.put(FuguAppConstant.MESSAGE_TYPE, WebRTCCallConstants.VIDEO_CALL)
        startCallJson.put(WebRTCCallConstants.CALL_TYPE, "VIDEO")
        startCallJson.put(FuguAppConstant.MESSAGE_UNIQUE_ID, OngoingCallService.NotificationServiceState.muid)
        startCallJson.put(WebRTCCallConstants.DEVICE_PAYLOAD, getDeviceDetails())
        startCallJson.put(FuguAppConstant.INVITE_LINK, videoCallModel?.inviteLink)
        //ConnectionManager.sendMessage(intent?.getLongExtra(CHANNEL_ID, -1L)!!, startCallJson)
        startCallJson.put("message", "")
        startCallJson.put("is_typing", FuguAppConstant.TYPING_SHOW_MESSAGE)
        startCallJson.put("user_type", FuguAppConstant.ANDROID_USER)
        startCallJson.put("full_name", videoCallModel?.fullName)

        sendMessage(videoCallModel?.channelId!!, startCallJson)

    }

    private fun getServerUrl(): URL {
        var serverURL: URL
        try {
            serverURL = URL(FuguAppConstant.CONFERENCING_LIVE)
        } catch (e: MalformedURLException) {
            e.printStackTrace()
            throw RuntimeException("Invalid server URL!")
        }
        return serverURL

    }

    private fun initCall(serverURL: URL) {
        if(options == null) {
            val userInfo = JitsiMeetUserInfo()
            try {
                userInfo.displayName = videoCallModel?.myname
                if (!TextUtils.isEmpty(videoCallModel?.myImagePath))
                    userInfo.avatar = URL(videoCallModel?.myImagePath)
            } catch (e: Exception) {
                userInfo.displayName = "Fellow User"
            }
            var roomName = videoCallModel?.roomName

            try {
                if ((videoCallModel?.callType == "AUDIO")
                    || (videoCallModel?.inviteLink!!.contains("#config.startWithVideoMuted=true"))
                    || roomName?.contains("#config.startWithVideoMuted=true")!!
                ) {
                    val defaultOptions = JitsiMeetConferenceOptions.Builder()
                        .setServerURL(serverURL)
                        .setWelcomePageEnabled(false)
                        .setAudioOnly(true)
                        .setFeatureFlag("chat.enabled", false)
                        .setFeatureFlag("invite.enabled", false)
                        .setUserInfo(userInfo)
                        .build()
                    JitsiMeet.setDefaultConferenceOptions(defaultOptions)
                } else {
                    val defaultOptions = JitsiMeetConferenceOptions.Builder()
                        .setServerURL(serverURL)
                        .setWelcomePageEnabled(false)
                        .setAudioOnly(false)
                        .setFeatureFlag("chat.enabled", false)
                        .setFeatureFlag("invite.enabled", false)
                        .setUserInfo(userInfo)
                        .build()
                    JitsiMeet.setDefaultConferenceOptions(defaultOptions)
                }
            } catch (e: Exception) {
                val defaultOptions = JitsiMeetConferenceOptions.Builder()
                    .setServerURL(serverURL)
                    .setWelcomePageEnabled(false)
                    .setAudioOnly(false)
                    .setFeatureFlag("chat.enabled", false)
                    .setFeatureFlag("invite.enabled", false)
                    .setUserInfo(userInfo)
                    .build()
                JitsiMeet.setDefaultConferenceOptions(defaultOptions)
            }
            roomName = roomName?.replace("#config.startWithVideoMuted=true", "")
            options = JitsiMeetConferenceOptions.Builder()
                .setRoom(roomName)
                .build()
        }
        JitsiMeetActivity.launch(this, options)

    }

    var options: JitsiMeetConferenceOptions ?= null
    private fun preInitCall(serverURL: URL) {
        val userInfo = JitsiMeetUserInfo()
        try {
            userInfo.displayName = videoCallModel?.myname
            if(!TextUtils.isEmpty(videoCallModel?.myImagePath))
                userInfo.avatar = URL(videoCallModel?.myImagePath)
        } catch (e: Exception) {
            userInfo.displayName = "Fellow User"
        }



        //todo check this room thing right now
        var roomName = videoCallModel?.roomName
        /*if (!TextUtils.isEmpty(intent.getStringExtra("room_name"))) {
            roomName = intent.getStringExtra("room_name")
        } else {
            roomName = intent?.data?.lastPathSegment!!

        }*/

        try {
            if ((videoCallModel?.callType == "AUDIO") || (videoCallModel?.inviteLink!!.contains("#config.startWithVideoMuted=true")) || roomName?.contains("#config.startWithVideoMuted=true")!!) {
                val defaultOptions = JitsiMeetConferenceOptions.Builder()
                    .setServerURL(serverURL)
                    .setWelcomePageEnabled(false)
                    .setAudioOnly(true)
                    .setFeatureFlag("chat.enabled", false)
                    .setUserInfo(userInfo)
                    .build()
                JitsiMeet.setDefaultConferenceOptions(defaultOptions)
            } else {
                val defaultOptions = JitsiMeetConferenceOptions.Builder()
                    .setServerURL(serverURL)
                    .setWelcomePageEnabled(false)
                    .setAudioOnly(false)
                    .setFeatureFlag("chat.enabled", false)
                    .setUserInfo(userInfo)
                    .build()
                JitsiMeet.setDefaultConferenceOptions(defaultOptions)
            }
        } catch (e: Exception) {
            val defaultOptions = JitsiMeetConferenceOptions.Builder()
                .setServerURL(serverURL)
                .setWelcomePageEnabled(false)
                .setAudioOnly(false)
                .setFeatureFlag("chat.enabled", false)
                .setUserInfo(userInfo)
                .build()
            JitsiMeet.setDefaultConferenceOptions(defaultOptions)
        }
        roomName = roomName?.replace("#config.startWithVideoMuted=true", "")
        options = JitsiMeetConferenceOptions.Builder()
            .setRoom(roomName)
            .build()
    }
}


//class MainCallingActivity: AppCompatActivity() {
//
//    private var videoCallModel: VideoCallModel? = null
//    private var isConnected: Boolean = false
//    private var needToStartCall: Boolean = false
//    private var startOldCall: Boolean = false
//
//    override fun onCreate(savedInstanceState: Bundle?) {
//        super.onCreate(savedInstanceState)
//        setContentView(R.layout.hippo_activity_maincalling)
//        val win = window
//        win.addFlags(WindowManager.LayoutParams.FLAG_SHOW_WHEN_LOCKED or WindowManager.LayoutParams.FLAG_DISMISS_KEYGUARD)
//        win.addFlags(WindowManager.LayoutParams.FLAG_TURN_SCREEN_ON)
//
//        if (intent.hasExtra("videoCallModel")) {
//            videoCallModel = intent.extras.getParcelable("videoCallModel") as VideoCallModel
//
//            if(intent.hasExtra("answer_call")) {
//                needToStartCall = false
//
//            } else if(intent.hasExtra("incomming_call")) {
//                // check the link if empty don't do anything
//                needToStartCall = false
//            } else {
//                needToStartCall = true
//                val linkArray = randomVideoConferenceLink()
//                var inviteLink = linkArray[0] + "/" + linkArray[1]
//                if (videoCallModel?.callType!! == "AUDIO") {
//                    inviteLink += "#config.startWithVideoMuted=true"
//                }
//                videoCallModel?.inviteLink = inviteLink
//            }
//
//        }
//        if(HippoCallConfig.getInstance().client == null) {
//            setupFayeConnection()
//        } else {
//            try {
//                HippoConfig.getExistingClient {
//                    mClient = it
//                    if(!mClient!!.getmChannels().contains("/${videoCallModel?.channelId!!}")) {
//                        mClient!!.subscribeChannel("/${videoCallModel?.channelId!!}")
//                    } else {
//                        onStartCall()
//                    }
//                    isConnected = true
//                    setFayeListener(mClient!!)
//                }
//            } catch (e: Exception) {
//                e.printStackTrace()
//
//            }
//        }
//
//        if(intent.hasExtra("incomming_call")) {
//            openIncommingCallFragment()
//            val serverURL: URL = getServerUrl()
//            preInitCall(serverURL)
//        } else if(intent.hasExtra("answer_call")) {
//            onVideoConfActivityCreate(false)
//        } else {
//            openJitsiFragment()
//        }
//    }
//
//    private fun onStartCall() {
//        if(needToStartCall) {
//            Handler().postDelayed({
//                BusProvider.getInstance().post(FragmentFlow(WebRTCCallConstants.BusFragmentType.MAIN_CALL.toString(),
//                    1))
//                needToStartCall = false
//            }, 500)
//        }
//    }
//
//    override fun onResume() {
//        super.onResume()
//
//    }
//
//    override fun onPause() {
//        super.onPause()
//
//    }
//
//    override fun onStart() {
//        super.onStart()
//        BusProvider.getInstance().register(this)
//    }
//
//    override fun onStop() {
//        super.onStop()
//        BusProvider.getInstance().unregister(this)
//    }
//
//    override fun onBackPressed() {
//
//    }
//
//    override fun onDestroy() {
//        super.onDestroy()
//
//    }
//
//    private var mClient: FayeClient? = null
//
//    fun setupFayeConnection() {
//        HippoConfig.getExistingClient { client ->
//            mClient = client
//            isConnected = true
//            client.connectServer()
//            setFayeListener(client)
//        }
//    }
//
//    private fun setFayeListener(mClient: FayeClient) {
//        mClient.callListener = object : FayeCallClientListener {
//            override fun onConnectedServer(fc: FayeClient) {
//                mClient.subscribeChannel("/${videoCallModel?.channelId!!}")
//                BusProvider.getInstance().post(FayeMessage(FuguAppConstant.FayeBusEvent.CONNECTED.toString(), "", ""))
//                onStartCall()
//            }
//
//            override fun onDisconnectedServer(fc: FayeClient) {
//                BusProvider.getInstance().post(FayeMessage(FuguAppConstant.FayeBusEvent.DISCONNECTED.toString(), "", ""))
//            }
//
//            override fun onReceivedMessage(fc: FayeClient, msg: String, channel: String) {
//                HippoLog.e("msg", "" + msg)
//                if(!TextUtils.isEmpty(msg))
//                    BusProvider.getInstance().post(FayeMessage(FuguAppConstant.FayeBusEvent.MESSAGE_RECEIVED.toString(), channel, msg))
//            }
//
//            override fun onPongReceived() {
//                BusProvider.getInstance().post(FayeMessage(FuguAppConstant.FayeBusEvent.PING.toString(), "", ""))
//                sendPendingMessages()
//            }
//
//            override fun onWebSocketError() {
//                BusProvider.getInstance().post(FayeMessage(FuguAppConstant.FayeBusEvent.ERROR.toString(), "", ""))
//            }
//
//            override fun onErrorReceived(fc: FayeClient, msg: String, channel: String) {
//                if(!TextUtils.isEmpty(msg)) {
//                    BusProvider.getInstance().post(FayeMessage(FuguAppConstant.FayeBusEvent.ERROR.toString(), channel, msg))
//                }
//            }
//        }
//    }
//
//    private fun finishCall() {
//
//    }
//
//    private fun openJitsiFragment() {
//        var fragment = JitsiCallActivity()
//        val bundle = Bundle()
//        //bundle.putString("data", data)
//        bundle.putParcelable("videoCallModel", videoCallModel)
//        fragment.arguments = bundle
//
//        supportFragmentManager.beginTransaction()
//            .add(R.id.main_layout, fragment, JitsiCallActivity::class.java.simpleName)
//            .addToBackStack(JitsiCallActivity::class.java.simpleName)
//            .commitAllowingStateLoss()
//    }
//
//    private fun openIncommingCallFragment() {
//        var fragment = IncomingJitsiCallActivity()
//        val bundle = Bundle()
//        //bundle.putString("data", data)
//        bundle.putParcelable("videoCallModel", videoCallModel)
//        fragment.arguments = bundle
//
//        supportFragmentManager.beginTransaction()
//            .add(R.id.main_layout, fragment, IncomingJitsiCallActivity::class.java.simpleName)
//            .addToBackStack(IncomingJitsiCallActivity::class.java.simpleName)
//            .commitAllowingStateLoss()
//    }
//
//    private fun openIncommingJitsiCallActivity() {
//
//    }
//
//    public fun sendMessage(channelId: Long, jsonObject: JSONObject) {
//        if(mClient?.isFayeConnected!! && isConnected) {
//            mClient?.publish("/$channelId", jsonObject)
//        } else {
//            hashMap["/$channelId"] = jsonObject
//            objects.add(jsonObject)
//            System.out.println("~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~")
//        }
//    }
//
//    private var objects = java.util.ArrayList<JSONObject>()
//    private var hashMap = LinkedHashMap<String, JSONObject>()
//    private fun sendPendingMessages() {
//        System.out.println("@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@")
//        try {
//            if(hashMap.keys.iterator().hasNext()) {
//                val key = hashMap.keys.iterator().next();
//                val localObjects = java.util.ArrayList<JSONObject>()
//                localObjects.addAll(objects)
//                for(i in 0 until localObjects.size) {
//                    mClient?.publish("/$key", localObjects[i])
//                }
//                objects.clear()
//                hashMap.remove(key)
//
//                System.out.println("#####################################################")
//            }
//            /*while (hashMap.keys.iterator().hasNext()) {
//                val key = hashMap.keys.iterator().next();
//                for()
//                val value = hashMap.values.iterator().next();
//                mClient?.publish("/$key", value)
//                hashMap.remove(key)
//                System.out.println("#####################################################")
//            }*/
//        } catch (e: Exception) {
//            e.printStackTrace()
//        }
//
//    }
//
//
//    @Subscribe
//    public fun onBusFragmentType(data: FragmentFlow) {
//        when(data.fragmentType) {
//            WebRTCCallConstants.BusFragmentType.INCOMMING_JITSI_CALL.toString() -> {
//                incomingBusOpration(data.type)
//            }
//            WebRTCCallConstants.BusFragmentType.JITSI_CALL.toString() -> {
//                jitsiActivityOperation(data)
//            }
//            WebRTCCallConstants.BusFragmentType.INCOMING_VIDEO_CONF.toString() -> {
//
//            }
//        }
//    }
//
//
//    private fun randomVideoConferenceLink(): ArrayList<String> {
//        val linkArray = ArrayList<String>()
//        val ALLOWED_CHARACTERS = "qwertyuiopasdfghjklzxcvbnm"
//        val random = Random()
//        val sb = StringBuilder(10)
//        for (i in 0 until 10)
//            sb.append(ALLOWED_CHARACTERS[random.nextInt(ALLOWED_CHARACTERS.length)])
//
//        if (com.hippo.database.CommonData.getServerUrl() == FuguAppConstant.LIVE_SERVER
//            || com.hippo.database.CommonData.getServerUrl() == FuguAppConstant.BETA_LIVE_SERVER) {
//            linkArray.add(FuguAppConstant.CONFERENCING_LIVE)
//        } else {
//            linkArray.add(FuguAppConstant.CONFERENCING_TEST)
//        }
//
//
//        linkArray.add(sb.toString())
//        videoCallModel?.roomName = sb.toString()
//
//        return linkArray
//    }
//
//
//    //==============================================================================================
//    // for IncomingJitsiCallActivity
//    //==============================================================================================
//
//
//    var mediaPlayer: MediaPlayer? = null
//
//    private fun incomingBusOpration(type: Int) {
//        when(type) {
//            WebRTCCallConstants.IncommintJitsiCall.START_MEDIA -> startMedia()
//            WebRTCCallConstants.IncommintJitsiCall.UNREGISTER_BROADCAST -> {
//                mediaPlayer?.stop()
//                try {
//                    LocalBroadcastManager.getInstance(this).unregisterReceiver(mVideoConferenceHungup)
//                } catch (e: Exception) {
//                    e.printStackTrace()
//                }
//            }
//            WebRTCCallConstants.IncommintJitsiCall.REGISTER_BROADCAST -> {
//                try {
//                    LocalBroadcastManager.getInstance(this).unregisterReceiver(mVideoConferenceHungup)
//                } catch (e: Exception) {
//                    e.printStackTrace()
//                }
//                LocalBroadcastManager.getInstance(this).registerReceiver(mVideoConferenceHungup,
//                    IntentFilter(FuguAppConstant.VIDEO_CONFERENCE_HUNGUP_INTENT)
//                )
//            }
//            WebRTCCallConstants.IncommintJitsiCall.STOP -> {
//                try {
//                    LocalBroadcastManager.getInstance(this).unregisterReceiver(mVideoConferenceHungup)
//                } catch (e: Exception) {
//                    e.printStackTrace()
//                }
//            }
//            WebRTCCallConstants.IncommintJitsiCall.ANSWERCALL -> {
//                /*val videoIntent = Intent(this@MainCallingActivity, VideoConfActivity::class.java)
//                *//*val link = Paper.book(com.fuguagent.database.CommonData.name)
//                .read(SPLabels.SERVER_SELECTED, Config.getDefaultServerUrl())
//                if (link == Config.getLiveServerUrl()) {
//                    videoIntent.putExtra("base_url", FuguAppConstant.CONFERENCING_LIVE)
//                } else {
//                    videoIntent.putExtra("base_url", FuguAppConstant.CONFERENCING_TEST)
//                }*//*
//
//                videoIntent.putExtra("base_url", FuguAppConstant.CONFERENCING_TEST)
//
//                videoIntent.addFlags(Intent.FLAG_ACTIVITY_EXCLUDE_FROM_RECENTS)
//                videoIntent.putExtra(FuguAppConstant.INVITE_LINK, intent?.getStringExtra(FuguAppConstant.INVITE_LINK))
//                videoIntent.putExtra(FuguAppConstant.CHANNEL_ID, intent?.getLongExtra(FuguAppConstant.CHANNEL_ID, -1L))
//                videoIntent.putExtra("room_name", intent?.getStringExtra("room_name"))
//                videoIntent.putExtra("call_type", intent?.getStringExtra("call_type"))
//                startActivity(videoIntent)
//
//                finish()*/
//
//                onVideoConfActivityCreate(false)
//            }
//            WebRTCCallConstants.IncommintJitsiCall.REJECTCALL -> {
//                val hungupIntent = Intent(this@MainCallingActivity, HungUpBroadcast::class.java)
//                hungupIntent.putExtra("action", "rejectCall")
//                hungupIntent.putExtra(WebRTCCallConstants.DEVICE_PAYLOAD, getDeviceDetails().toString())
//                hungupIntent.putExtra(FuguAppConstant.INVITE_LINK, videoCallModel?.inviteLink)
//                hungupIntent.putExtra(FuguAppConstant.CHANNEL_ID, videoCallModel?.channelId)
//                sendBroadcast(hungupIntent)
//                finish()
//            }
//        }
//    }
//
//    private fun startMedia() {
//        var audio: AudioManager? = null
//        audio = getSystemService(Context.AUDIO_SERVICE) as AudioManager
//        audio?.isSpeakerphoneOn = true
//        mediaPlayer = MediaPlayer.create(this@MainCallingActivity, R.raw.video_call_ringtone)
//        mediaPlayer?.isLooping = true
//        mediaPlayer?.start()
//    }
//
//    private val mVideoConferenceHungup = object : BroadcastReceiver() {
//        override fun onReceive(context: Context?, intent: Intent?) {
//            mediaPlayer?.stop()
//            finish()
//        }
//    }
//
//    private fun getDeviceDetails(): JSONObject {
//        val devicePayload = JSONObject()
//        devicePayload.put(FuguAppConstant.DEVICE_ID, UniqueIMEIID.getUniqueIMEIId(this))
//        devicePayload.put(FuguAppConstant.DEVICE_TYPE, FuguAppConstant.ANDROID_USER)
//        devicePayload.put(FuguAppConstant.APP_VERSION, BuildConfig.VERSION_NAME)
//        devicePayload.put(FuguAppConstant.DEVICE_DETAILS, CommonData.deviceDetails(this))
//        return devicePayload
//    }
//
//    // Ending IncommingJitsi Call data
//    //==============================================================================================
//
//    //for VideoConfActivity here
//
//    //==============================================================================================
//
//
//    private fun jitsiActivityOperation(data: FragmentFlow) {
//        when(data.type) {
//            WebRTCCallConstants.JitsiCallActivity.POST_DATA -> {
//                HippoLog.d("POST_DATA", "POST_DATA = "+ Gson().toJson(data))
//                sendMessage(videoCallModel?.channelId!!, data?.json!!)
//            }
//            WebRTCCallConstants.JitsiCallActivity.OPEN_VIDEO_CONF -> {
//                onVideoConfActivityCreate(true)
//            }
//            WebRTCCallConstants.JitsiCallActivity.PRE_LOAD_DATA -> {
//                val serverURL: URL = getServerUrl()
//                preInitCall(serverURL)
//            }
//            WebRTCCallConstants.JitsiCallActivity.OPEN_OLD_CALL -> {
//                if(!startOldCall) {
//                    startOldCall = true
//                    HippoCallConfig.getInstance().initOldCall(videoCallModel)
//                    finish()
//                }
//            }
//        }
//    }
//
//    fun onVideoConfActivityCreate(hasAnswer: Boolean) {
//
//        stopForegroundService()
//        OngoingCallService.NotificationServiceState.isConferenceConnected = true
//        if (!hasAnswer) {
//            answerConference()
//        }
//        val serverURL: URL = getServerUrl()
//        initCall(serverURL)
//        startOngoingCallService()
//
////        removeFragment()
//        finish()
//    }
//
//    private fun checkAnswerTag(msg: String, channel: String) {
//        //if()
//        val data = JSONObject(msg)
//        if (data.optInt("message_type") != 18)
//            return
//        if (!data.optLong(FuguAppConstant.USER_ID).equals(videoCallModel?.userId!!)
//            && videoCallModel?.inviteLink == data.getString(FuguAppConstant.INVITE_LINK)) {
//            if(data.optString(FuguAppConstant.VIDEO_CALL_TYPE) == FuguAppConstant.JitsiCallType.ANSWER_CONFERENCE.toString()) {
//                finish()
//            }
//
//        }
//    }
//
//    var closeFlag = false
//    private fun removeFragment() {
//        //popBackStackImmediate()
//        closeFlag = true
//        val fm = supportFragmentManager
//        for (i in 0 until fm.backStackEntryCount - 1) {
//            fm.popBackStack()
//        }
//    }
//
//    private fun stopForegroundService() {
//        try {
//            val startIntent = Intent(this@MainCallingActivity, VideoCallService::class.java)
//            startIntent.action = "com.officechat.start"
//            startIntent.putExtra("isHungUpToBeSent", false)
//            stopService(startIntent)
//        } catch (e: Exception) {
//            e.printStackTrace()
//        }
//    }
//
//    private fun startOngoingCallService() {
//        val startIntent = Intent(this, OngoingCallService::class.java)
//        startIntent.action = "com.officechat.notification.start"
//        startIntent.putExtra(FuguAppConstant.INVITE_LINK, videoCallModel?.inviteLink)
//        startIntent.putExtra(FuguAppConstant.CHANNEL_ID, videoCallModel?.channelId)
//        ContextCompat.startForegroundService(this, startIntent)
//    }
//
//    private fun answerConference() {
//        val userId = com.hippo.database.CommonData.getUserDetails().data.userId
//        val fullName = com.hippo.database.CommonData.getUserDetails().data.fullName
//        val startCallJson = JSONObject()
//        startCallJson.put(FuguAppConstant.IS_SILENT, true)
//        startCallJson.put(WebRTCCallConstants.VIDEO_CALL_TYPE, WebRTCCallConstants.JitsiCallType.ANSWER_CONFERENCE.toString())
//        startCallJson.put(FuguAppConstant.USER_ID, userId)
//        startCallJson.put(FuguAppConstant.CHANNEL_ID, videoCallModel?.channelId)
//        startCallJson.put(FuguAppConstant.MESSAGE_TYPE, WebRTCCallConstants.VIDEO_CALL)
//        startCallJson.put(WebRTCCallConstants.CALL_TYPE, "VIDEO")
//        startCallJson.put(FuguAppConstant.MESSAGE_UNIQUE_ID, OngoingCallService.NotificationServiceState.muid)
//        startCallJson.put(WebRTCCallConstants.DEVICE_PAYLOAD, getDeviceDetails())
//        startCallJson.put(FuguAppConstant.INVITE_LINK, videoCallModel?.inviteLink)
//        //ConnectionManager.sendMessage(intent?.getLongExtra(CHANNEL_ID, -1L)!!, startCallJson)
//        startCallJson.put("message", "")
//        startCallJson.put("is_typing", FuguAppConstant.TYPING_SHOW_MESSAGE)
//        startCallJson.put("user_type", FuguAppConstant.ANDROID_USER)
//        startCallJson.put("full_name", videoCallModel?.fullName)
//
//        sendMessage(videoCallModel?.channelId!!, startCallJson)
//
//    }
//
//    private fun getServerUrl(): URL {
//        var serverURL: URL
//        try {
//            serverURL = if (com.hippo.database.CommonData.getServerUrl() == FuguAppConstant.LIVE_SERVER
//                || com.hippo.database.CommonData.getServerUrl() == FuguAppConstant.BETA_LIVE_SERVER) {
//                URL(FuguAppConstant.CONFERENCING_LIVE)
//            } else {
//                URL(FuguAppConstant.CONFERENCING_TEST)
//            }
//
//        } catch (e: MalformedURLException) {
//            e.printStackTrace()
//            throw RuntimeException("Invalid server URL!")
//        }
//        return serverURL
//
//    }
//
//    private fun initCall(serverURL: URL) {
//        if(options == null) {
//            val userInfo = JitsiMeetUserInfo()
//            try {
//                userInfo.displayName = videoCallModel?.myname
//                if (!TextUtils.isEmpty(videoCallModel?.myImagePath))
//                    userInfo.avatar = URL(videoCallModel?.myImagePath)
//            } catch (e: Exception) {
//                userInfo.displayName = "Fellow User"
//            }
//
//
//            var roomName = videoCallModel?.roomName
//            /*if (!TextUtils.isEmpty(intent.getStringExtra("room_name"))) {
//            roomName = intent.getStringExtra("room_name")
//        } else {
//            roomName = intent?.data?.lastPathSegment!!
//
//        }*/
//
//            try {
//                if ((videoCallModel?.callType == "AUDIO")
//                    || (videoCallModel?.inviteLink!!.contains("#config.startWithVideoMuted=true"))
//                    || roomName?.contains("#config.startWithVideoMuted=true")!!
//                ) {
//                    val defaultOptions = JitsiMeetConferenceOptions.Builder()
//                        .setServerURL(serverURL)
//                        .setWelcomePageEnabled(false)
//                        .setAudioOnly(true)
//                        .setFeatureFlag("chat.enabled", false)
//                        .setUserInfo(userInfo)
//                        .build()
//                    JitsiMeet.setDefaultConferenceOptions(defaultOptions)
//                } else {
//                    val defaultOptions = JitsiMeetConferenceOptions.Builder()
//                        .setServerURL(serverURL)
//                        .setWelcomePageEnabled(false)
//                        .setAudioOnly(false)
//                        .setFeatureFlag("chat.enabled", false)
//                        .setUserInfo(userInfo)
//                        .build()
//                    JitsiMeet.setDefaultConferenceOptions(defaultOptions)
//                }
//            } catch (e: Exception) {
//                val defaultOptions = JitsiMeetConferenceOptions.Builder()
//                    .setServerURL(serverURL)
//                    .setWelcomePageEnabled(false)
//                    .setAudioOnly(false)
//                    .setFeatureFlag("chat.enabled", false)
//                    .setUserInfo(userInfo)
//                    .build()
//                JitsiMeet.setDefaultConferenceOptions(defaultOptions)
//            }
//            roomName = roomName?.replace("#config.startWithVideoMuted=true", "")
//            options = JitsiMeetConferenceOptions.Builder()
//                .setRoom(roomName)
//                .build()
//        }
//        JitsiMeetActivity.launch(this, options)
//    }
//
//    var options: JitsiMeetConferenceOptions ?= null
//    private fun preInitCall(serverURL: URL) {
//        val userInfo = JitsiMeetUserInfo()
//        try {
//            userInfo.displayName = videoCallModel?.myname
//            if(!TextUtils.isEmpty(videoCallModel?.myImagePath))
//                userInfo.avatar = URL(videoCallModel?.myImagePath)
//        } catch (e: Exception) {
//            userInfo.displayName = "Fellow User"
//        }
//
//        var roomName = videoCallModel?.roomName
//
//        try {
//            if ((videoCallModel?.callType == "AUDIO") || (videoCallModel?.inviteLink!!.contains("#config.startWithVideoMuted=true")) || roomName?.contains("#config.startWithVideoMuted=true")!!) {
//                val defaultOptions = JitsiMeetConferenceOptions.Builder()
//                    .setServerURL(serverURL)
//                    .setWelcomePageEnabled(false)
//                    .setAudioOnly(true)
//                    .setFeatureFlag("chat.enabled", false)
//                    .setUserInfo(userInfo)
//                    .build()
//                JitsiMeet.setDefaultConferenceOptions(defaultOptions)
//            } else {
//                val defaultOptions = JitsiMeetConferenceOptions.Builder()
//                    .setServerURL(serverURL)
//                    .setWelcomePageEnabled(false)
//                    .setAudioOnly(false)
//                    .setFeatureFlag("chat.enabled", false)
//                    .setUserInfo(userInfo)
//                    .build()
//                JitsiMeet.setDefaultConferenceOptions(defaultOptions)
//            }
//        } catch (e: Exception) {
//            val defaultOptions = JitsiMeetConferenceOptions.Builder()
//                .setServerURL(serverURL)
//                .setWelcomePageEnabled(false)
//                .setAudioOnly(false)
//                .setFeatureFlag("chat.enabled", false)
//                .setUserInfo(userInfo)
//                .build()
//            JitsiMeet.setDefaultConferenceOptions(defaultOptions)
//        }
//        roomName = roomName?.replace("#config.startWithVideoMuted=true", "")
//        options = JitsiMeetConferenceOptions.Builder()
//            .setRoom(roomName)
//            .build()
//    }
//}