/*
 * Decompiled with CFR 0.152.
 */
package com.hippocall.confcall;

import android.content.Context;
import android.media.AudioAttributes;
import android.media.AudioManager;
import android.media.MediaPlayer;
import android.os.Bundle;
import android.os.CountDownTimer;
import android.os.Handler;
import android.os.Looper;
import android.os.Parcelable;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.Toast;
import androidx.appcompat.widget.AppCompatImageView;
import androidx.appcompat.widget.AppCompatTextView;
import androidx.fragment.app.Fragment;
import androidx.fragment.app.FragmentActivity;
import com.bumptech.glide.Glide;
import com.bumptech.glide.RequestBuilder;
import com.google.gson.Gson;
import com.hippo.constant.FuguAppConstant;
import com.hippo.eventbus.BusProvider;
import com.hippo.helper.BusEvents;
import com.hippo.helper.FayeMessage;
import com.hippo.utils.UniqueIMEIID;
import com.hippocall.CommonData;
import com.hippocall.R;
import com.hippocall.VideoCallModel;
import com.hippocall.WebRTCCallConstants;
import com.hippocall.confcall.JitsiCallActivity;
import com.hippocall.confcall.OngoingCallService;
import com.hippocall.model.FayeVideoCallResponse;
import com.hippocall.model.FragmentFlow;
import com.squareup.otto.Subscribe;
import de.hdodenhof.circleimageview.CircleImageView;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONException;
import org.json.JSONObject;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u009a\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\t\n\u0002\b\u0003\u0018\u00002\u00020\u00012\u00020\u0002B\u0005\u00a2\u0006\u0002\u0010\u0003J\b\u0010+\u001a\u00020,H\u0002J\u0010\u0010-\u001a\u00020.2\u0006\u0010/\u001a\u00020\u0005H\u0002J\b\u00100\u001a\u00020.H\u0002J\u0010\u00101\u001a\u00020.2\u0006\u00102\u001a\u000203H\u0002J\b\u00104\u001a\u00020.H\u0002J\u0006\u00105\u001a\u00020.J\u0010\u00106\u001a\u00020.2\u0006\u00107\u001a\u000208H\u0007J\u0010\u00109\u001a\u00020.2\u0006\u0010:\u001a\u00020\nH\u0002J\u0012\u0010;\u001a\u00020.2\b\u0010<\u001a\u0004\u0018\u00010=H\u0016J&\u0010>\u001a\u0004\u0018\u0001032\u0006\u0010?\u001a\u00020@2\b\u0010A\u001a\u0004\u0018\u00010B2\b\u0010<\u001a\u0004\u0018\u00010=H\u0016J\b\u0010C\u001a\u00020.H\u0016J\u000e\u0010D\u001a\u00020.2\u0006\u0010:\u001a\u00020\nJ\u0010\u0010E\u001a\u00020.2\u0006\u0010F\u001a\u00020GH\u0007J\b\u0010H\u001a\u00020.H\u0016J\b\u0010I\u001a\u00020.H\u0016J\u001a\u0010J\u001a\u00020.2\u0006\u00102\u001a\u0002032\b\u0010<\u001a\u0004\u0018\u00010=H\u0016J\u001a\u0010K\u001a\u00020.2\u0006\u0010L\u001a\u00020\u00072\b\u0010M\u001a\u0004\u0018\u00010,H\u0002J\u0018\u0010N\u001a\u00020.2\u0006\u0010O\u001a\u00020P2\u0006\u0010M\u001a\u00020,H\u0002J\u0010\u0010Q\u001a\u00020.2\u0006\u0010/\u001a\u00020\u0005H\u0002J\u0010\u0010R\u001a\u00020.2\u0006\u0010/\u001a\u00020\u0005H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000f\u001a\u0004\u0018\u00010\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0011\u001a\u0004\u0018\u00010\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0013\u001a\u0004\u0018\u00010\u0014X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\u0016\"\u0004\b\u0017\u0010\u0018R\u000e\u0010\u0019\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u001a\u001a\u0004\u0018\u00010\u001bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001c\u0010\u001d\"\u0004\b\u001e\u0010\u001fR\u001a\u0010 \u001a\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b!\u0010\"\"\u0004\b#\u0010$R\u0010\u0010%\u001a\u0004\u0018\u00010&X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010'\u001a\u0004\u0018\u00010&X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010(\u001a\u0004\u0018\u00010&X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010)\u001a\u0004\u0018\u00010*X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006S"}, d2={"Lcom/hippocall/confcall/JitsiCallActivity;", "Landroidx/fragment/app/Fragment;", "Lcom/hippo/constant/FuguAppConstant;", "()V", "initOldCall", "", "initalCalls", "", "initalCallsIOS", "inviteLink", "", "isReadyForConnection", "isReadyForConnectionIOS", "ivCalledPersonImage", "Lde/hdodenhof/circleimageview/CircleImageView;", "ivHangUp", "Landroidx/appcompat/widget/AppCompatImageView;", "mInitiateStartCalltimer", "Landroid/os/CountDownTimer;", "mListener", "Landroid/media/AudioManager$OnAudioFocusChangeListener;", "getMListener", "()Landroid/media/AudioManager$OnAudioFocusChangeListener;", "setMListener", "(Landroid/media/AudioManager$OnAudioFocusChangeListener;)V", "maxCalls", "mediaPlayer", "Landroid/media/MediaPlayer;", "getMediaPlayer", "()Landroid/media/MediaPlayer;", "setMediaPlayer", "(Landroid/media/MediaPlayer;)V", "muid", "getMuid", "()Ljava/lang/String;", "setMuid", "(Ljava/lang/String;)V", "tvCallStatus", "Landroidx/appcompat/widget/AppCompatTextView;", "tvCallType", "tvCalledPersonName", "videoCallModel", "Lcom/hippocall/VideoCallModel;", "getDeviceDetails", "Lorg/json/JSONObject;", "hangupCall", "", "isSilent", "initCall", "initViews", "view", "Landroid/view/View;", "initiateOutgoingRinging", "onBackPressed", "onBusFragmentType", "data", "Lcom/hippocall/model/FragmentFlow;", "onCalling", "messageJson", "onCreate", "savedInstanceState", "Landroid/os/Bundle;", "onCreateView", "inflater", "Landroid/view/LayoutInflater;", "container", "Landroid/view/ViewGroup;", "onDestroy", "onErrorRecieved", "onFayeMessageEvent", "event", "Lcom/hippo/helper/FayeMessage;", "onStart", "onStop", "onViewCreated", "sendDate", "type", "jsonObject", "sendMessage", "channelId", "", "startCall", "startCallIOS", "hippocall_release"})
public final class JitsiCallActivity
extends Fragment
implements FuguAppConstant {
    private VideoCallModel videoCallModel;
    private AppCompatImageView ivHangUp;
    private String inviteLink = "";
    private CountDownTimer mInitiateStartCalltimer;
    private int initalCalls = 1;
    private int initalCallsIOS = 1;
    private int maxCalls = 30;
    private boolean isReadyForConnection;
    private boolean isReadyForConnectionIOS;
    private AppCompatTextView tvCallStatus;
    private AppCompatTextView tvCalledPersonName;
    private AppCompatTextView tvCallType;
    private CircleImageView ivCalledPersonImage;
    @Nullable
    private AudioManager.OnAudioFocusChangeListener mListener;
    @Nullable
    private MediaPlayer mediaPlayer;
    @NotNull
    private String muid;
    private boolean initOldCall;
    private HashMap _$_findViewCache;

    @Nullable
    public final AudioManager.OnAudioFocusChangeListener getMListener() {
        return this.mListener;
    }

    public final void setMListener(@Nullable AudioManager.OnAudioFocusChangeListener onAudioFocusChangeListener) {
        this.mListener = onAudioFocusChangeListener;
    }

    @Nullable
    public final MediaPlayer getMediaPlayer() {
        return this.mediaPlayer;
    }

    public final void setMediaPlayer(@Nullable MediaPlayer mediaPlayer) {
        this.mediaPlayer = mediaPlayer;
    }

    @NotNull
    public final String getMuid() {
        return this.muid;
    }

    public final void setMuid(@NotNull String string) {
        Intrinsics.checkParameterIsNotNull((Object)string, (String)"<set-?>");
        this.muid = string;
    }

    @Nullable
    public View onCreateView(@NotNull LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        Intrinsics.checkParameterIsNotNull((Object)inflater, (String)"inflater");
        return inflater.inflate(R.layout.activity_jitsi_call, container, false);
    }

    public void onViewCreated(@NotNull View view, @Nullable Bundle savedInstanceState) {
        Intrinsics.checkParameterIsNotNull((Object)view, (String)"view");
        super.onViewCreated(view, savedInstanceState);
        this.initalCalls = 1;
        this.initalCallsIOS = 1;
        this.initViews(view);
        OngoingCallService.NotificationServiceState.INSTANCE.setMuid(this.muid);
        if (this.videoCallModel != null) {
            AppCompatTextView appCompatTextView = this.tvCalledPersonName;
            if (appCompatTextView != null) {
                VideoCallModel videoCallModel = this.videoCallModel;
                appCompatTextView.setText((CharSequence)(videoCallModel != null ? videoCallModel.getChannelName() : null));
            }
            VideoCallModel videoCallModel = this.videoCallModel;
            String string = videoCallModel != null ? videoCallModel.getCallType() : null;
            if (string == null) {
                Intrinsics.throwNpe();
            }
            if (Intrinsics.areEqual((Object)string, (Object)"VIDEO")) {
                AppCompatTextView appCompatTextView2 = this.tvCallType;
                if (appCompatTextView2 != null) {
                    appCompatTextView2.setText((CharSequence)"Video Call");
                }
            } else {
                AppCompatTextView appCompatTextView3 = this.tvCallType;
                if (appCompatTextView3 != null) {
                    appCompatTextView3.setText((CharSequence)"Audio Call");
                }
            }
            VideoCallModel videoCallModel2 = this.videoCallModel;
            RequestBuilder requestBuilder = (RequestBuilder)Glide.with((Fragment)this).load(videoCallModel2 != null ? videoCallModel2.getUserThumbnailImage() : null).placeholder(R.drawable.hippo_ic_call_placeholder);
            CircleImageView circleImageView = this.ivCalledPersonImage;
            if (circleImageView == null) {
                Intrinsics.throwNpe();
            }
            requestBuilder.into((ImageView)circleImageView);
        }
        this.initiateOutgoingRinging();
        new CountDownTimer(this, 60000L, 60000L){
            final /* synthetic */ JitsiCallActivity this$0;

            public void onFinish() {
                block0: {
                    Log.e((String)"Timer", (String)"Done");
                    FragmentActivity fragmentActivity = this.this$0.getActivity();
                    if (fragmentActivity == null) break block0;
                    fragmentActivity.finish();
                }
            }

            public void onTick(long millisUntilFinished) {
            }
            {
                this.this$0 = $outer;
                super($super_call_param$1, $super_call_param$2);
            }
        }.start();
        BusProvider.getInstance().register((Object)this);
    }

    @Subscribe
    public final void onBusFragmentType(@NotNull FragmentFlow data) {
        Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
        if (Intrinsics.areEqual((Object)data.getFragmentType(), (Object)WebRTCCallConstants.BusFragmentType.MAIN_CALL.toString()) && data.getType() == 1) {
            this.initCall();
        }
    }

    public void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        if (this.getArguments() != null) {
            Bundle bundle = this.getArguments();
            if (bundle == null) {
                Intrinsics.throwNpe();
            }
            Parcelable parcelable = bundle.getParcelable("videoCallModel");
            if (parcelable == null) {
                throw new TypeCastException("null cannot be cast to non-null type com.hippocall.VideoCallModel");
            }
            this.videoCallModel = (VideoCallModel)parcelable;
        }
    }

    private final void initCall() {
        new Handler(Looper.getMainLooper()).post(new Runnable(this){
            final /* synthetic */ JitsiCallActivity this$0;

            public final void run() {
                JitsiCallActivity.access$setMInitiateStartCalltimer$p(this.this$0, new CountDownTimer(this, 300000L, 2000L){
                    final /* synthetic */ initCall.1 this$0;

                    public void onFinish() {
                        block0: {
                            JitsiCallActivity.access$hangupCall(this.this$0.this$0, true);
                            FragmentActivity fragmentActivity = this.this$0.this$0.getActivity();
                            if (fragmentActivity == null) break block0;
                            fragmentActivity.finish();
                        }
                    }

                    public void onTick(long millisUntilFinished) {
                        if (JitsiCallActivity.access$getInitalCalls$p(this.this$0.this$0) <= JitsiCallActivity.access$getMaxCalls$p(this.this$0.this$0) && !JitsiCallActivity.access$isReadyForConnection$p(this.this$0.this$0)) {
                            if (JitsiCallActivity.access$getInitalCalls$p(this.this$0.this$0) == 1) {
                                JitsiCallActivity.access$startCall(this.this$0.this$0, false);
                            } else {
                                JitsiCallActivity.access$startCall(this.this$0.this$0, true);
                            }
                            JitsiCallActivity jitsiCallActivity = this.this$0.this$0;
                            JitsiCallActivity.access$setInitalCalls$p(jitsiCallActivity, JitsiCallActivity.access$getInitalCalls$p(jitsiCallActivity) + 1);
                        }
                        if (JitsiCallActivity.access$getInitalCallsIOS$p(this.this$0.this$0) <= JitsiCallActivity.access$getMaxCalls$p(this.this$0.this$0) && !JitsiCallActivity.access$isReadyForConnectionIOS$p(this.this$0.this$0)) {
                            if (JitsiCallActivity.access$getInitalCallsIOS$p(this.this$0.this$0) == 1) {
                                JitsiCallActivity.access$startCallIOS(this.this$0.this$0, false);
                            } else {
                                JitsiCallActivity.access$startCallIOS(this.this$0.this$0, true);
                            }
                            JitsiCallActivity jitsiCallActivity = this.this$0.this$0;
                            JitsiCallActivity.access$setInitalCallsIOS$p(jitsiCallActivity, JitsiCallActivity.access$getInitalCallsIOS$p(jitsiCallActivity) + 1);
                        }
                    }
                    {
                        this.this$0 = $outer;
                        super($super_call_param$1, $super_call_param$2);
                    }
                }.start());
            }
            {
                this.this$0 = jitsiCallActivity;
            }
        });
    }

    public void onStop() {
        try {
            this.isReadyForConnection = true;
            this.isReadyForConnectionIOS = true;
            CountDownTimer countDownTimer = this.mInitiateStartCalltimer;
            if (countDownTimer != null) {
                countDownTimer.cancel();
            }
            BusProvider.getInstance().unregister((Object)this);
        }
        catch (Exception exception) {
            // empty catch block
        }
        super.onStop();
    }

    public void onDestroy() {
        this.isReadyForConnection = true;
        this.isReadyForConnectionIOS = true;
        CountDownTimer countDownTimer = this.mInitiateStartCalltimer;
        if (countDownTimer != null) {
            countDownTimer.cancel();
        }
        MediaPlayer mediaPlayer = this.mediaPlayer;
        if (mediaPlayer != null) {
            mediaPlayer.stop();
        }
        super.onDestroy();
    }

    private final void startCall(boolean isSilent) {
        JSONObject startCallJson = new JSONObject();
        startCallJson.put(WebRTCCallConstants.Companion.getIS_SILENT(), isSilent);
        startCallJson.put(WebRTCCallConstants.Companion.getVIDEO_CALL_TYPE(), (Object)WebRTCCallConstants.JitsiCallType.START_CONFERENCE.toString());
        VideoCallModel videoCallModel = this.videoCallModel;
        startCallJson.put("user_id", (Object)(videoCallModel != null ? Long.valueOf(videoCallModel.getUserId()) : null));
        VideoCallModel videoCallModel2 = this.videoCallModel;
        startCallJson.put("channel_id", (Object)(videoCallModel2 != null ? Long.valueOf(videoCallModel2.getChannelId()) : null));
        startCallJson.put("message_type", WebRTCCallConstants.Companion.getVIDEO_CALL());
        VideoCallModel videoCallModel3 = this.videoCallModel;
        startCallJson.put(WebRTCCallConstants.Companion.getCALL_TYPE(), (Object)(videoCallModel3 != null ? videoCallModel3.getCallType() : null));
        startCallJson.put("muid", (Object)this.muid);
        startCallJson.put(WebRTCCallConstants.Companion.getDEVICE_PAYLOAD(), (Object)this.getDeviceDetails());
        VideoCallModel videoCallModel4 = this.videoCallModel;
        String string = videoCallModel4 != null ? videoCallModel4.getInviteLink() : null;
        if (string == null) {
            Intrinsics.throwNpe();
        }
        this.inviteLink = string;
        VideoCallModel videoCallModel5 = this.videoCallModel;
        startCallJson.put("invite_link", (Object)(videoCallModel5 != null ? videoCallModel5.getInviteLink() : null));
        VideoCallModel videoCallModel6 = this.videoCallModel;
        Long l = videoCallModel6 != null ? Long.valueOf(videoCallModel6.getChannelId()) : null;
        if (l == null) {
            Intrinsics.throwNpe();
        }
        this.sendMessage(l, startCallJson);
    }

    private final void startCallIOS(boolean isSilent) {
        JSONObject startCallJson = new JSONObject();
        startCallJson.put(WebRTCCallConstants.Companion.getIS_SILENT(), isSilent);
        startCallJson.put(WebRTCCallConstants.Companion.getVIDEO_CALL_TYPE(), (Object)WebRTCCallConstants.JitsiCallType.START_CONFERENCE_IOS.toString());
        VideoCallModel videoCallModel = this.videoCallModel;
        startCallJson.put("user_id", (Object)(videoCallModel != null ? Long.valueOf(videoCallModel.getUserId()) : null));
        VideoCallModel videoCallModel2 = this.videoCallModel;
        startCallJson.put("channel_id", (Object)(videoCallModel2 != null ? Long.valueOf(videoCallModel2.getChannelId()) : null));
        startCallJson.put("message_type", WebRTCCallConstants.Companion.getVIDEO_CALL());
        VideoCallModel videoCallModel3 = this.videoCallModel;
        startCallJson.put(WebRTCCallConstants.Companion.getCALL_TYPE(), (Object)(videoCallModel3 != null ? videoCallModel3.getCallType() : null));
        startCallJson.put("muid", (Object)this.muid);
        startCallJson.put(WebRTCCallConstants.Companion.getDEVICE_PAYLOAD(), (Object)this.getDeviceDetails());
        VideoCallModel videoCallModel4 = this.videoCallModel;
        startCallJson.put("invite_link", (Object)(videoCallModel4 != null ? videoCallModel4.getInviteLink() : null));
        VideoCallModel videoCallModel5 = this.videoCallModel;
        Long l = videoCallModel5 != null ? Long.valueOf(videoCallModel5.getChannelId()) : null;
        if (l == null) {
            Intrinsics.throwNpe();
        }
        this.sendMessage(l, startCallJson);
    }

    private final void hangupCall(boolean isSilent) {
        JSONObject startCallJson = new JSONObject();
        startCallJson.put(WebRTCCallConstants.Companion.getIS_SILENT(), isSilent);
        startCallJson.put(WebRTCCallConstants.Companion.getVIDEO_CALL_TYPE(), (Object)WebRTCCallConstants.JitsiCallType.HUNGUP_CONFERENCE.toString());
        VideoCallModel videoCallModel = this.videoCallModel;
        startCallJson.put("user_id", (Object)(videoCallModel != null ? Long.valueOf(videoCallModel.getUserId()) : null));
        VideoCallModel videoCallModel2 = this.videoCallModel;
        startCallJson.put("channel_id", (Object)(videoCallModel2 != null ? Long.valueOf(videoCallModel2.getChannelId()) : null));
        startCallJson.put("message_type", WebRTCCallConstants.Companion.getVIDEO_CALL());
        VideoCallModel videoCallModel3 = this.videoCallModel;
        startCallJson.put(WebRTCCallConstants.Companion.getCALL_TYPE(), (Object)(videoCallModel3 != null ? videoCallModel3.getCallType() : null));
        startCallJson.put("muid", (Object)this.muid);
        startCallJson.put(WebRTCCallConstants.Companion.getDEVICE_PAYLOAD(), (Object)this.getDeviceDetails());
        startCallJson.put("invite_link", (Object)this.inviteLink);
        VideoCallModel videoCallModel4 = this.videoCallModel;
        Long l = videoCallModel4 != null ? Long.valueOf(videoCallModel4.getChannelId()) : null;
        if (l == null) {
            Intrinsics.throwNpe();
        }
        this.sendMessage(l, startCallJson);
    }

    private final void initViews(View view) {
        block0: {
            this.ivHangUp = (AppCompatImageView)view.findViewById(R.id.ivHangUp);
            this.tvCallStatus = (AppCompatTextView)view.findViewById(R.id.tvCallStatus);
            this.tvCalledPersonName = (AppCompatTextView)view.findViewById(R.id.tvCalledPersonName);
            this.tvCallType = (AppCompatTextView)view.findViewById(R.id.tvCallType);
            this.ivCalledPersonImage = (CircleImageView)view.findViewById(R.id.ivCalledPersonImage);
            AppCompatImageView appCompatImageView = this.ivHangUp;
            if (appCompatImageView == null) break block0;
            appCompatImageView.setOnClickListener(new View.OnClickListener(this){
                final /* synthetic */ JitsiCallActivity this$0;

                public final void onClick(View it) {
                    block0: {
                        JitsiCallActivity.access$hangupCall(this.this$0, true);
                        FragmentActivity fragmentActivity = this.this$0.getActivity();
                        if (fragmentActivity == null) break block0;
                        fragmentActivity.finish();
                    }
                }
                {
                    this.this$0 = jitsiCallActivity;
                }
            });
        }
    }

    private final void initiateOutgoingRinging() {
        this.mListener = initiateOutgoingRinging.1.INSTANCE;
        new Handler().postDelayed(new Runnable(this){
            final /* synthetic */ JitsiCallActivity this$0;

            public final void run() {
                block6: {
                    FragmentActivity fragmentActivity = this.this$0.getActivity();
                    Object object = fragmentActivity != null ? fragmentActivity.getSystemService("audio") : null;
                    if (object == null) {
                        throw new TypeCastException("null cannot be cast to non-null type android.media.AudioManager");
                    }
                    AudioManager audio = (AudioManager)object;
                    audio.setMode(3);
                    if (audio.isBluetoothA2dpOn()) {
                        audio.startBluetoothSco();
                        audio.setSpeakerphoneOn(false);
                        audio.setBluetoothScoOn(true);
                        audio.requestAudioFocus(this.this$0.getMListener(), 3, 1);
                    } else {
                        audio.stopBluetoothSco();
                        audio.setBluetoothScoOn(false);
                        VideoCallModel videoCallModel = JitsiCallActivity.access$getVideoCallModel$p(this.this$0);
                        audio.setSpeakerphoneOn(StringsKt.equals$default((String)(videoCallModel != null ? videoCallModel.getCallType() : null), (String)"VIDEO", (boolean)false, (int)2, null));
                    }
                    AudioAttributes aa = new AudioAttributes.Builder().setUsage(2).setContentType(1).build();
                    VideoCallModel videoCallModel = JitsiCallActivity.access$getVideoCallModel$p(this.this$0);
                    if (StringsKt.equals$default((String)(videoCallModel != null ? videoCallModel.getCallType() : null), (String)"VIDEO", (boolean)false, (int)2, null)) {
                        this.this$0.setMediaPlayer(MediaPlayer.create((Context)((Context)this.this$0.getActivity()), (int)R.raw.ringing));
                    } else {
                        this.this$0.setMediaPlayer(MediaPlayer.create((Context)((Context)this.this$0.getActivity()), (int)R.raw.ringing, (AudioAttributes)aa, (int)1));
                    }
                    MediaPlayer mediaPlayer = this.this$0.getMediaPlayer();
                    if (mediaPlayer != null) {
                        mediaPlayer.setLooping(true);
                    }
                    MediaPlayer mediaPlayer2 = this.this$0.getMediaPlayer();
                    if (mediaPlayer2 == null) break block6;
                    mediaPlayer2.start();
                }
            }
            {
                this.this$0 = jitsiCallActivity;
            }
        }, 100L);
    }

    public final void onBackPressed() {
    }

    private final JSONObject getDeviceDetails() {
        JSONObject devicePayload = new JSONObject();
        devicePayload.put("device_id", (Object)UniqueIMEIID.getUniqueIMEIId((Context)((Context)this.getActivity())));
        devicePayload.put("device_type", 1);
        devicePayload.put("app_version", (Object)"2.5.4");
        devicePayload.put("device_details", (Object)CommonData.deviceDetails((Context)this.getActivity()));
        return devicePayload;
    }

    public void onStart() {
        super.onStart();
    }

    @Subscribe
    public final void onFayeMessageEvent(@NotNull FayeMessage event) {
        Intrinsics.checkParameterIsNotNull((Object)event, (String)"event");
        Log.d((String)"onFayeMessageEvent", (String)("onFayeMessageEvent " + event.type));
        String string = event.type;
        if (Intrinsics.areEqual((Object)string, (Object)FuguAppConstant.FayeBusEvent.MESSAGE_RECEIVED.toString())) {
            String string2 = event.message;
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"event.message");
            this.onCalling(string2);
        } else if (Intrinsics.areEqual((Object)string, (Object)FuguAppConstant.FayeBusEvent.ERROR.toString()) || Intrinsics.areEqual((Object)string, (Object)BusEvents.ERROR_RECEIVED.toString())) {
            String string3 = event.message;
            Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"event.message");
            this.onErrorRecieved(string3);
        }
    }

    private final void onCalling(String messageJson) {
        try {
            JSONObject data = new JSONObject(messageJson);
            Log.e((String)"Video_CONF Reply-->", (String)messageJson.toString());
            if (data.optInt("message_type") != 18) {
                return;
            }
            Long l = data.optLong("user_id");
            VideoCallModel videoCallModel = this.videoCallModel;
            Long l2 = videoCallModel != null ? Long.valueOf(videoCallModel.getUserId()) : null;
            if (l2 == null) {
                Intrinsics.throwNpe();
            }
            if (!l.equals(l2) && Intrinsics.areEqual((Object)this.inviteLink, (Object)data.getString("invite_link"))) {
                System.out.println("==================================================================================");
                String string = data.optString("video_call_type");
                if (Intrinsics.areEqual((Object)string, (Object)FuguAppConstant.JitsiCallType.READY_TO_CONNECT_CONFERENCE.toString())) {
                    String string2 = data.getString("invite_link");
                    Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"data.getString(INVITE_LINK)");
                    OngoingCallService.NotificationServiceState.INSTANCE.setInviteLink(string2);
                    FragmentActivity fragmentActivity = this.getActivity();
                    if (fragmentActivity != null) {
                        fragmentActivity.runOnUiThread(new Runnable(this){
                            final /* synthetic */ JitsiCallActivity this$0;

                            public final void run() {
                                block0: {
                                    AppCompatTextView appCompatTextView = JitsiCallActivity.access$getTvCallStatus$p(this.this$0);
                                    if (appCompatTextView == null) break block0;
                                    appCompatTextView.setText((CharSequence)"Ringing...");
                                }
                            }
                            {
                                this.this$0 = jitsiCallActivity;
                            }
                        });
                    }
                    this.isReadyForConnection = true;
                    JSONObject startCallJson = new JSONObject();
                    startCallJson.put(WebRTCCallConstants.Companion.getIS_SILENT(), true);
                    startCallJson.put(WebRTCCallConstants.Companion.getVIDEO_CALL_TYPE(), (Object)WebRTCCallConstants.JitsiCallType.OFFER_CONFERENCE.toString());
                    VideoCallModel videoCallModel2 = this.videoCallModel;
                    startCallJson.put("user_id", (Object)String.valueOf(videoCallModel2 != null ? Long.valueOf(videoCallModel2.getUserId()) : null));
                    VideoCallModel videoCallModel3 = this.videoCallModel;
                    startCallJson.put("channel_id", (Object)(videoCallModel3 != null ? Long.valueOf(videoCallModel3.getChannelId()) : null));
                    startCallJson.put("message_type", WebRTCCallConstants.Companion.getVIDEO_CALL());
                    VideoCallModel videoCallModel4 = this.videoCallModel;
                    startCallJson.put(WebRTCCallConstants.Companion.getCALL_TYPE(), (Object)(videoCallModel4 != null ? videoCallModel4.getCallType() : null));
                    startCallJson.put(WebRTCCallConstants.Companion.getDEVICE_PAYLOAD(), (Object)this.getDeviceDetails());
                    startCallJson.put("muid", (Object)this.muid);
                    startCallJson.put("invite_link", (Object)this.inviteLink);
                    VideoCallModel videoCallModel5 = this.videoCallModel;
                    Long l3 = videoCallModel5 != null ? Long.valueOf(videoCallModel5.getChannelId()) : null;
                    if (l3 == null) {
                        Intrinsics.throwNpe();
                    }
                    this.sendMessage(l3, startCallJson);
                } else if (Intrinsics.areEqual((Object)string, (Object)FuguAppConstant.JitsiCallType.READY_TO_CONNECT_CONFERENCE_IOS.toString())) {
                    String string3 = data.getString("invite_link");
                    Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"data.getString(INVITE_LINK)");
                    OngoingCallService.NotificationServiceState.INSTANCE.setInviteLink(string3);
                    FragmentActivity fragmentActivity = this.getActivity();
                    if (fragmentActivity != null) {
                        fragmentActivity.runOnUiThread(new Runnable(this){
                            final /* synthetic */ JitsiCallActivity this$0;

                            public final void run() {
                                block0: {
                                    AppCompatTextView appCompatTextView = JitsiCallActivity.access$getTvCallStatus$p(this.this$0);
                                    if (appCompatTextView == null) break block0;
                                    appCompatTextView.setText((CharSequence)"Ringing...");
                                }
                            }
                            {
                                this.this$0 = jitsiCallActivity;
                            }
                        });
                    }
                    this.isReadyForConnectionIOS = true;
                    JSONObject startCallJson = new JSONObject();
                    startCallJson.put(WebRTCCallConstants.Companion.getIS_SILENT(), true);
                    startCallJson.put(WebRTCCallConstants.Companion.getVIDEO_CALL_TYPE(), (Object)WebRTCCallConstants.JitsiCallType.OFFER_CONFERENCE.toString());
                    VideoCallModel videoCallModel6 = this.videoCallModel;
                    startCallJson.put("user_id", (Object)String.valueOf(videoCallModel6 != null ? Long.valueOf(videoCallModel6.getUserId()) : null));
                    VideoCallModel videoCallModel7 = this.videoCallModel;
                    startCallJson.put("channel_id", (Object)(videoCallModel7 != null ? Long.valueOf(videoCallModel7.getChannelId()) : null));
                    startCallJson.put("message_type", WebRTCCallConstants.Companion.getVIDEO_CALL());
                    VideoCallModel videoCallModel8 = this.videoCallModel;
                    startCallJson.put(WebRTCCallConstants.Companion.getCALL_TYPE(), (Object)(videoCallModel8 != null ? videoCallModel8.getCallType() : null));
                    startCallJson.put(WebRTCCallConstants.Companion.getDEVICE_PAYLOAD(), (Object)this.getDeviceDetails());
                    startCallJson.put("muid", (Object)this.muid);
                    startCallJson.put("invite_link", (Object)this.inviteLink);
                    VideoCallModel videoCallModel9 = this.videoCallModel;
                    Long l4 = videoCallModel9 != null ? Long.valueOf(videoCallModel9.getChannelId()) : null;
                    if (l4 == null) {
                        Intrinsics.throwNpe();
                    }
                    this.sendMessage(l4, startCallJson);
                    this.sendDate(WebRTCCallConstants.JitsiCallActivity.Companion.getPRE_LOAD_DATA(), null);
                } else if (Intrinsics.areEqual((Object)string, (Object)FuguAppConstant.JitsiCallType.ANSWER_CONFERENCE.toString())) {
                    this.isReadyForConnectionIOS = true;
                    this.isReadyForConnection = true;
                    String string4 = data.getString("invite_link");
                    Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"data.getString(\"invite_link\")");
                    List linkArray = StringsKt.split$default((CharSequence)StringsKt.replace$default((String)string4, (String)"#config.startWithVideoMuted=true", (String)"", (boolean)false, (int)4, null), (String[])new String[]{"/"}, (boolean)false, (int)0, (int)6, null);
                    if (!OngoingCallService.NotificationServiceState.INSTANCE.isConferenceServiceRunning()) {
                        OngoingCallService.NotificationServiceState.INSTANCE.setConferenceServiceRunning(true);
                        this.sendDate(WebRTCCallConstants.JitsiCallActivity.Companion.getOPEN_VIDEO_CONF(), null);
                    }
                } else if (Intrinsics.areEqual((Object)string, (Object)FuguAppConstant.JitsiCallType.REJECT_CONFERENCE.toString())) {
                    CountDownTimer countDownTimer = this.mInitiateStartCalltimer;
                    if (countDownTimer != null) {
                        countDownTimer.cancel();
                    }
                    FragmentActivity fragmentActivity = this.getActivity();
                    if (fragmentActivity != null) {
                        fragmentActivity.runOnUiThread(new Runnable(this){
                            final /* synthetic */ JitsiCallActivity this$0;

                            public final void run() {
                                block0: {
                                    AppCompatTextView appCompatTextView = JitsiCallActivity.access$getTvCallStatus$p(this.this$0);
                                    if (appCompatTextView == null) break block0;
                                    appCompatTextView.setText((CharSequence)"Call Rejected");
                                }
                            }
                            {
                                this.this$0 = jitsiCallActivity;
                            }
                        });
                    }
                    MediaPlayer mediaPlayer = this.mediaPlayer;
                    if (mediaPlayer != null) {
                        mediaPlayer.stop();
                    }
                    AudioAttributes aa = new AudioAttributes.Builder().setUsage(2).setContentType(1).build();
                    VideoCallModel videoCallModel10 = this.videoCallModel;
                    this.mediaPlayer = StringsKt.equals$default((String)(videoCallModel10 != null ? videoCallModel10.getCallType() : null), (String)"VIDEO", (boolean)false, (int)2, null) ? MediaPlayer.create((Context)((Context)this.getActivity()), (int)R.raw.busy_tone) : MediaPlayer.create((Context)((Context)this.getActivity()), (int)R.raw.busy_tone, (AudioAttributes)aa, (int)1);
                    MediaPlayer mediaPlayer2 = this.mediaPlayer;
                    if (mediaPlayer2 != null) {
                        mediaPlayer2.setLooping(false);
                    }
                    MediaPlayer mediaPlayer3 = this.mediaPlayer;
                    if (mediaPlayer3 != null) {
                        mediaPlayer3.start();
                    }
                    new Handler(Looper.getMainLooper()).postDelayed(new Runnable(this){
                        final /* synthetic */ JitsiCallActivity this$0;

                        public final void run() {
                            block0: {
                                FragmentActivity fragmentActivity = this.this$0.getActivity();
                                if (fragmentActivity == null) break block0;
                                fragmentActivity.finish();
                            }
                        }
                        {
                            this.this$0 = jitsiCallActivity;
                        }
                    }, 3000L);
                } else if (Intrinsics.areEqual((Object)string, (Object)FuguAppConstant.JitsiCallType.USER_BUSY_CONFERENCE.toString())) {
                    FragmentActivity fragmentActivity = this.getActivity();
                    if (fragmentActivity != null) {
                        fragmentActivity.runOnUiThread(new Runnable(this){
                            final /* synthetic */ JitsiCallActivity this$0;

                            public final void run() {
                                block4: {
                                    AppCompatTextView appCompatTextView = JitsiCallActivity.access$getTvCallStatus$p(this.this$0);
                                    if (appCompatTextView != null) {
                                        appCompatTextView.setText((CharSequence)"User Busy on another Call");
                                    }
                                    if (this.this$0.getMediaPlayer() == null) break block4;
                                    MediaPlayer mediaPlayer = this.this$0.getMediaPlayer();
                                    if (mediaPlayer != null) {
                                        mediaPlayer.stop();
                                    }
                                    this.this$0.setMediaPlayer(MediaPlayer.create((Context)((Context)this.this$0.getActivity()), (int)R.raw.busy_tone));
                                    MediaPlayer mediaPlayer2 = this.this$0.getMediaPlayer();
                                    if (mediaPlayer2 != null) {
                                        mediaPlayer2.setLooping(false);
                                    }
                                    MediaPlayer mediaPlayer3 = this.this$0.getMediaPlayer();
                                    if (mediaPlayer3 != null) {
                                        mediaPlayer3.start();
                                    }
                                }
                            }
                            {
                                this.this$0 = jitsiCallActivity;
                            }
                        });
                    }
                    new Handler(Looper.getMainLooper()).postDelayed(new Runnable(this){
                        final /* synthetic */ JitsiCallActivity this$0;

                        public final void run() {
                            block0: {
                                FragmentActivity fragmentActivity = this.this$0.getActivity();
                                if (fragmentActivity == null) break block0;
                                fragmentActivity.finish();
                            }
                        }
                        {
                            this.this$0 = jitsiCallActivity;
                        }
                    }, 3000L);
                }
            }
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
    }

    public final void onErrorRecieved(@NotNull String messageJson) {
        block0: {
            Intrinsics.checkParameterIsNotNull((Object)messageJson, (String)"messageJson");
            FragmentActivity fragmentActivity = this.getActivity();
            if (fragmentActivity == null) break block0;
            fragmentActivity.runOnUiThread(new Runnable(this, messageJson){
                final /* synthetic */ JitsiCallActivity this$0;
                final /* synthetic */ String $messageJson;

                public final void run() {
                    try {
                        FayeVideoCallResponse fayeVideoCallResponse;
                        FayeVideoCallResponse fayeVideoCallResponse2 = fayeVideoCallResponse = (FayeVideoCallResponse)new Gson().fromJson(this.$messageJson, FayeVideoCallResponse.class);
                        Intrinsics.checkExpressionValueIsNotNull((Object)fayeVideoCallResponse2, (String)"fayeVideoCallResponse");
                        Integer n = fayeVideoCallResponse2.getStatusCode();
                        if (n != null && n == 415) {
                            Log.e((String)"Jitsi Error", (String)this.$messageJson);
                            CountDownTimer countDownTimer = JitsiCallActivity.access$getMInitiateStartCalltimer$p(this.this$0);
                            if (countDownTimer != null) {
                                countDownTimer.cancel();
                            }
                            AppCompatTextView appCompatTextView = JitsiCallActivity.access$getTvCalledPersonName$p(this.this$0);
                            CharSequence name = appCompatTextView != null ? appCompatTextView.getText() : null;
                            Toast.makeText((Context)((Context)this.this$0.getActivity()), (CharSequence)(name + " does not have the updated app, Calling using old SDK... "), (int)1).show();
                            new CountDownTimer(this, 2000L, 1000L){
                                final /* synthetic */ onErrorRecieved.1 this$0;

                                public void onFinish() {
                                    if (!JitsiCallActivity.access$getInitOldCall$p(this.this$0.this$0)) {
                                        JitsiCallActivity.access$setInitOldCall$p(this.this$0.this$0, true);
                                        JitsiCallActivity.access$sendDate(this.this$0.this$0, WebRTCCallConstants.JitsiCallActivity.Companion.getOPEN_OLD_CALL(), null);
                                    }
                                }

                                public void onTick(long millisUntilFinished) {
                                }
                                {
                                    this.this$0 = $outer;
                                    super($super_call_param$1, $super_call_param$2);
                                }
                            }.start();
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                {
                    this.this$0 = jitsiCallActivity;
                    this.$messageJson = string;
                }
            });
        }
    }

    private final void sendMessage(long channelId, JSONObject jsonObject) {
        jsonObject.put("message", (Object)"");
        jsonObject.put("is_typing", 0);
        jsonObject.put("user_type", 1);
        VideoCallModel videoCallModel = this.videoCallModel;
        jsonObject.put(WebRTCCallConstants.Companion.getFULL_NAME(), (Object)(videoCallModel != null ? videoCallModel.getMyname() : null));
        VideoCallModel videoCallModel2 = this.videoCallModel;
        jsonObject.put(WebRTCCallConstants.Companion.getUSER_THUMBNAIL_IMAGE(), (Object)(videoCallModel2 != null ? videoCallModel2.getMyImagePath() : null));
        this.sendDate(WebRTCCallConstants.JitsiCallActivity.Companion.getPOST_DATA(), jsonObject);
    }

    private final void sendDate(int type, JSONObject jsonObject) {
        try {
            BusProvider.getInstance().post((Object)new FragmentFlow(WebRTCCallConstants.BusFragmentType.JITSI_CALL.toString(), type, jsonObject, ""));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public JitsiCallActivity() {
        String string = UUID.randomUUID().toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"UUID.randomUUID().toString()");
        this.muid = string;
    }

    @Nullable
    public static final /* synthetic */ CountDownTimer access$getMInitiateStartCalltimer$p(JitsiCallActivity $this) {
        return $this.mInitiateStartCalltimer;
    }

    public static final /* synthetic */ void access$setMInitiateStartCalltimer$p(JitsiCallActivity $this, @Nullable CountDownTimer countDownTimer) {
        $this.mInitiateStartCalltimer = countDownTimer;
    }

    public static final /* synthetic */ void access$hangupCall(JitsiCallActivity $this, boolean isSilent) {
        $this.hangupCall(isSilent);
    }

    public static final /* synthetic */ int access$getInitalCalls$p(JitsiCallActivity $this) {
        return $this.initalCalls;
    }

    public static final /* synthetic */ void access$setInitalCalls$p(JitsiCallActivity $this, int n) {
        $this.initalCalls = n;
    }

    public static final /* synthetic */ int access$getMaxCalls$p(JitsiCallActivity $this) {
        return $this.maxCalls;
    }

    public static final /* synthetic */ void access$setMaxCalls$p(JitsiCallActivity $this, int n) {
        $this.maxCalls = n;
    }

    public static final /* synthetic */ boolean access$isReadyForConnection$p(JitsiCallActivity $this) {
        return $this.isReadyForConnection;
    }

    public static final /* synthetic */ void access$setReadyForConnection$p(JitsiCallActivity $this, boolean bl) {
        $this.isReadyForConnection = bl;
    }

    public static final /* synthetic */ void access$startCall(JitsiCallActivity $this, boolean isSilent) {
        $this.startCall(isSilent);
    }

    public static final /* synthetic */ int access$getInitalCallsIOS$p(JitsiCallActivity $this) {
        return $this.initalCallsIOS;
    }

    public static final /* synthetic */ void access$setInitalCallsIOS$p(JitsiCallActivity $this, int n) {
        $this.initalCallsIOS = n;
    }

    public static final /* synthetic */ boolean access$isReadyForConnectionIOS$p(JitsiCallActivity $this) {
        return $this.isReadyForConnectionIOS;
    }

    public static final /* synthetic */ void access$setReadyForConnectionIOS$p(JitsiCallActivity $this, boolean bl) {
        $this.isReadyForConnectionIOS = bl;
    }

    public static final /* synthetic */ void access$startCallIOS(JitsiCallActivity $this, boolean isSilent) {
        $this.startCallIOS(isSilent);
    }

    @Nullable
    public static final /* synthetic */ VideoCallModel access$getVideoCallModel$p(JitsiCallActivity $this) {
        return $this.videoCallModel;
    }

    public static final /* synthetic */ void access$setVideoCallModel$p(JitsiCallActivity $this, @Nullable VideoCallModel videoCallModel) {
        $this.videoCallModel = videoCallModel;
    }

    @Nullable
    public static final /* synthetic */ AppCompatTextView access$getTvCallStatus$p(JitsiCallActivity $this) {
        return $this.tvCallStatus;
    }

    public static final /* synthetic */ void access$setTvCallStatus$p(JitsiCallActivity $this, @Nullable AppCompatTextView appCompatTextView) {
        $this.tvCallStatus = appCompatTextView;
    }

    @Nullable
    public static final /* synthetic */ AppCompatTextView access$getTvCalledPersonName$p(JitsiCallActivity $this) {
        return $this.tvCalledPersonName;
    }

    public static final /* synthetic */ void access$setTvCalledPersonName$p(JitsiCallActivity $this, @Nullable AppCompatTextView appCompatTextView) {
        $this.tvCalledPersonName = appCompatTextView;
    }

    public static final /* synthetic */ boolean access$getInitOldCall$p(JitsiCallActivity $this) {
        return $this.initOldCall;
    }

    public static final /* synthetic */ void access$setInitOldCall$p(JitsiCallActivity $this, boolean bl) {
        $this.initOldCall = bl;
    }

    public static final /* synthetic */ void access$sendDate(JitsiCallActivity $this, int type, @Nullable JSONObject jsonObject) {
        $this.sendDate(type, jsonObject);
    }

    public View _$_findCachedViewById(int n) {
        View view;
        if (this._$_findViewCache == null) {
            this._$_findViewCache = new HashMap();
        }
        if ((view = (View)this._$_findViewCache.get(n)) == null) {
            View view2 = this.getView();
            if (view2 == null) {
                return null;
            }
            view = view2.findViewById(n);
            this._$_findViewCache.put(n, view);
        }
        return view;
    }

    public void _$_clearFindViewByIdCache() {
        if (this._$_findViewCache != null) {
            this._$_findViewCache.clear();
        }
    }

    public /* synthetic */ void onDestroyView() {
        super.onDestroyView();
        this._$_clearFindViewByIdCache();
    }
}

