package com.hippocall

import android.text.TextUtils
import android.util.Log
import com.hippo.constant.FuguAppConstant
import com.hippo.eventbus.BusProvider
import com.hippocall.model.FayeMessage
import faye.FayeCallClientListener
import faye.FayeClient
import faye.FayeClientListener
import faye.MetaMessage
import org.json.JSONException
import org.json.JSONObject
import java.util.*

/**
 * Created by gurmail on 2019-12-28.
 * @author gurmail
 */
object ConnectionManager {

    private var mClient: FayeClient? = null
    private var meta = MetaMessage()
    private var fayeConnecting = false
    private var hashMap = LinkedHashMap<String, JSONObject>()
    private var listener: FayeCallClientListener? = null

    fun initConnection() {
        mClient = getConnection()
        if(mClient != null && !mClient?.isFayeConnected!!) {
            mClient?.connectServer()
        } else if(mClient?.isFayeConnected!!) {
            fayeConnecting = true
            sendPendingMessages()
            BusProvider.getInstance().post(FayeMessage(FuguAppConstant.FayeBusEvent.CONNECTED.toString(), "", ""))
        }
        setListener()
    }

    fun initConnection(client: FayeClient) {
        if(client == null) {
            mClient = getConnection()
            if(mClient != null && !mClient?.isFayeConnected!!) {
                mClient?.connectServer()
            } else if(mClient?.isFayeConnected!!) {
                fayeConnecting = true
                sendPendingMessages()
                BusProvider.getInstance().post(FayeMessage(FuguAppConstant.FayeBusEvent.CONNECTED.toString(), "", ""))
            }
        } else {
            mClient = client
            setListener()
        }
    }

    private fun getConnection(): FayeClient {
        if(mClient == null && HippoCallConfig.getInstance().getmClient() != null) {
            mClient = HippoCallConfig.getInstance().getmClient()
            setListener()
        }
        /*if (mClient == null && !fayeConnecting) {
            fayeConnecting = true
            meta = MetaMessage()
            val jsonExt = JSONObject()
            try {
                if (MyApplication.getInstance().getUserData() != null) {
                    jsonExt.put("user_id", MyApplication.getInstance().userData.userId)
                    jsonExt.put("device_type", 1)
                    jsonExt.put("source", 2)
                }
            } catch (e: JSONException) {
                e.printStackTrace()
            }

            meta.setAllExt(jsonExt.toString())
            mClient = FayeClient(Config.getFayeServerUrl() + "faye", meta)
            setListener()
        }*/
        return mClient!!
    }

    private fun setListener() {
        if(mClient != null) {
            mClient!!.callListener = object : FayeCallClientListener {
                override fun onConnectedServer(fc: FayeClient?) {
                    fayeConnecting = true
                    sendPendingMessages()
                    listener?.onConnectedServer(fc)
                    BusProvider.getInstance().post(FayeMessage(FuguAppConstant.FayeBusEvent.CONNECTED.toString(), "", ""))
                }

                override fun onDisconnectedServer(fc: FayeClient?) {
                    fayeConnecting = false
                    BusProvider.getInstance().post(FayeMessage(FuguAppConstant.FayeBusEvent.DISCONNECTED.toString(), "", ""))
                    listener?.onDisconnectedServer(fc)
                    print(6)
                }

                override fun onReceivedMessage(fc: FayeClient?, msg: String?, channel: String?) {
                    fayeConnecting = true
                    BusProvider.getInstance().post(FayeMessage(FuguAppConstant.FayeBusEvent.MESSAGE_RECEIVED.toString(), channel, msg))
                    print(7)
                    listener?.onReceivedMessage(fc, msg, channel)
                    Log.d("123456", "after 7 msg ~~~> "+msg)
                }

                override fun onPongReceived() {
                    fayeConnecting = true
                    BusProvider.getInstance().post(FayeMessage(FuguAppConstant.FayeBusEvent.PING.toString(), "", ""))
                    listener?.onPongReceived()
                    print(8)
                }

                override fun onWebSocketError() {
                    fayeConnecting = false
                    BusProvider.getInstance().post(FayeMessage(FuguAppConstant.FayeBusEvent.ERROR.toString(), "", ""))
                    listener?.onWebSocketError()
                    print(9)
                }

                override fun onErrorReceived(fc: FayeClient?, msg: String?, channel: String?) {
                    fayeConnecting = false
                    if(!TextUtils.isEmpty(msg))
                        BusProvider.getInstance().post(FayeMessage(FuguAppConstant.FayeBusEvent.ERROR.toString(), channel, msg))
                    listener?.onErrorReceived(fc, msg, channel)
                    print(10)
                }
            }
        }
    }

    public fun subscribeChannel(channelId: Long) {
        mClient?.subscribeChannel("/$channelId")
    }

    public fun unSubscribeChannel(channelId: Long) {
        mClient?.unsubscribeChannel("/$channelId")
    }

    public fun sendMessage(channelId: Long, jsonObject: JSONObject) {
        if(mClient?.isFayeConnected!!) {
            mClient?.publish("/$channelId", jsonObject)
        } else {
            hashMap["/$channelId"] = jsonObject
        }
    }

    private fun sendPendingMessages() {
        if(hashMap.size>0) {
            for ((key, value) in hashMap) {
                mClient?.publish("/$key", value)
            }
        }
    }

    public fun distroyObj() {
        if(mClient != null && mClient?.isFayeConnected!!) {
            mClient!!.disconnectServer()
        }
    }

    public fun setListener(listener: FayeCallClientListener) {
        this.listener = listener
    }

    private fun print(no: Int) {
        android.util.Log.i("step", "Step = "+no)
    }

}