package com.hippocall.confcall

import android.app.*
import android.content.BroadcastReceiver
import android.content.Context
import android.content.Intent
import android.content.IntentFilter
import android.graphics.BitmapFactory
import android.media.AudioAttributes
import android.media.MediaPlayer
import android.os.*
import android.widget.RemoteViews
import androidx.core.app.NotificationCompat
import androidx.localbroadcastmanager.content.LocalBroadcastManager
import com.hippo.BuildConfig
import com.hippo.HippoConfig
import com.hippo.constant.FuguAppConstant
import com.hippo.constant.FuguAppConstant.*
import com.hippo.utils.HippoLog
import com.hippo.utils.UniqueIMEIID
import com.hippocall.*
import com.hippocall.confcall.OngoingCallService.NotificationServiceState.channelId
import com.hippocall.confcall.OngoingCallService.NotificationServiceState.inviteLink
import com.hippocall.confcall.OngoingCallService.NotificationServiceState.isConferenceConnected
import com.hippocall.confcall.OngoingCallService.NotificationServiceState.isConferenceServiceRunning
import com.hippocall.WebRTCCallConstants.Companion.CALL_TYPE
import com.hippocall.WebRTCCallConstants.Companion.DEVICE_PAYLOAD
import com.hippocall.WebRTCCallConstants.Companion.FULL_NAME
import com.hippocall.WebRTCCallConstants.Companion.IS_SILENT
import com.hippocall.WebRTCCallConstants.Companion.MESSAGE_TYPE
import com.hippocall.WebRTCCallConstants.Companion.MESSAGE_UNIQUE_ID
import com.hippocall.WebRTCCallConstants.Companion.USER_ID
import com.hippocall.WebRTCCallConstants.Companion.USER_THUMBNAIL_IMAGE
import org.json.JSONObject

class OngoingCallService : Service(), WebRTCCallConstants {
    private var mBinder: IBinder = LocalBinder()
    override fun onBind(intent: Intent?): IBinder? {
        return mBinder
    }

    object NotificationServiceState {
        var isConferenceServiceRunning = false
        var isConferenceConnected = false
        var inviteLink = ""
        var channelId = -1L
        var muid = ""
    }

    inner class LocalBinder : Binder() {
        val serverInstance: OngoingCallService
            get() = this@OngoingCallService
    }

    override fun onCreate() {
        super.onCreate()


        if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.O) {
            val notificationManager = getSystemService(Context.NOTIFICATION_SERVICE) as NotificationManager
            var notificationChannel = NotificationChannel("IncomingCall",
                    "IncomingCall", NotificationManager.IMPORTANCE_HIGH)
            notificationChannel.setSound(null, null)
            notificationManager.createNotificationChannel(notificationChannel)
        }

        LocalBroadcastManager.getInstance(this@OngoingCallService)
                .registerReceiver(mCallTerminated, IntentFilter("CALL TERMINATED"))
        LocalBroadcastManager.getInstance(this@OngoingCallService)
                .registerReceiver(mInternetIssue, IntentFilter("INTERNET_ISSUE"))

    }


    private val mInternetIssue = object : BroadcastReceiver() {
        override fun onReceive(context: Context?, intent: Intent?) {
            var mediaPlayer: MediaPlayer? = null
            var aa = AudioAttributes.Builder()
                    .setUsage(AudioAttributes.USAGE_VOICE_COMMUNICATION)
                    .setContentType(AudioAttributes.CONTENT_TYPE_SPEECH)
                    .build()
            mediaPlayer = MediaPlayer.create(this@OngoingCallService, R.raw.busy_tone)
            mediaPlayer?.setLooping(true)
            mediaPlayer?.start()

            Handler(Looper.getMainLooper()).postDelayed({
                mediaPlayer?.stop()
            }, 3000)

        }
    }

    private val mCallTerminated = object : BroadcastReceiver() {
        override fun onReceive(context: Context?, intent: Intent?) {
            HippoLog.e("CALL_TERMINATED", "CALL_TERMINATED")
            val userId = com.hippo.database.CommonData.getUserDetails().data.userId
            val startCallJson = JSONObject()
            startCallJson.put(IS_SILENT, true)
            startCallJson.put(WebRTCCallConstants.VIDEO_CALL_TYPE, WebRTCCallConstants.JitsiCallType.HUNGUP_CONFERENCE.toString())
            startCallJson.put(USER_ID, userId)
            startCallJson.put(CHANNEL_ID, channelId)
            startCallJson.put(MESSAGE_TYPE, WebRTCCallConstants.VIDEO_CALL)
            startCallJson.put(CALL_TYPE, "VIDEO")
            startCallJson.put(DEVICE_PAYLOAD, getDeviceDetails())
            startCallJson.put(INVITE_LINK, inviteLink)
            startCallJson.put(MESSAGE_UNIQUE_ID,NotificationServiceState.muid)
            startCallJson.put("message", "")
            startCallJson.put("is_typing", FuguAppConstant.TYPING_SHOW_MESSAGE)
            startCallJson.put("user_type", FuguAppConstant.ANDROID_USER)
            // todo: send message in faye
            //sendMessage(channelId, startCallJson)
            HippoCallConfig.getInstance().sendMessage(channelId, startCallJson)

            /*if (isConferenceConnected) {
                val intent = Intent(applicationContext, CallFeedbackActivity::class.java)
                intent.addFlags(android.content.Intent.FLAG_ACTIVITY_NEW_TASK)
                intent.addFlags(android.content.Intent.FLAG_ACTIVITY_NO_ANIMATION)
                startActivity(intent)
            }*/

            isConferenceServiceRunning = false
            isConferenceConnected = false
            stopSelf()
        }
    }


    override fun onStartCommand(intent: Intent?, flags: Int, startId: Int): Int {
        isConferenceServiceRunning = true
        if (intent!!.hasExtra(INCOMING_VIDEO_CONFERENCE)) {
            createIncomingCallNotification(intent)
        } else {
            createOngoingCallNotification(intent)
        }

        return START_STICKY
    }

    private fun createIncomingCallNotification(intent: Intent) {
        val notificationIntent = Intent(this, MainCallingActivity::class.java)
        val customView = RemoteViews(packageName, R.layout.cutom_call_notification)
        customView.setTextViewText(R.id.name, com.hippo.database.CommonData.getAppName())
        notificationIntent.putExtra("room_name", intent?.getStringExtra("room_name"))
        inviteLink = intent?.getStringExtra(INVITE_LINK)
        channelId = intent?.getLongExtra(CHANNEL_ID, -1L)

        try {
            notificationIntent.putExtra("incomming_call", "incomming_call")
            val videoCallModel = intent.extras.getParcelable("videoCallModel") as VideoCallModel
            notificationIntent.putExtra("videoCallModel", videoCallModel)
        } catch (e: Exception) {
        }

        notificationIntent.putExtra(INVITE_LINK, inviteLink)
        notificationIntent.putExtra(CHANNEL_ID, channelId)
        notificationIntent.putExtra(FULL_NAME, intent.getStringExtra(FULL_NAME))
        notificationIntent.putExtra(USER_THUMBNAIL_IMAGE, intent.getStringExtra(USER_THUMBNAIL_IMAGE))
        notificationIntent.putExtra(CALL_TYPE, intent.getStringExtra(CALL_TYPE))
        notificationIntent.putExtra(MESSAGE_UNIQUE_ID, intent.getStringExtra(MESSAGE_UNIQUE_ID))
        notificationIntent.action = Intent.ACTION_MAIN
        notificationIntent.addFlags(Intent.FLAG_ACTIVITY_SINGLE_TOP or Intent.FLAG_ACTIVITY_CLEAR_TOP)
        notificationIntent.addFlags(Intent.FLAG_ACTIVITY_EXCLUDE_FROM_RECENTS)

        val hungupIntent = Intent(this, HungUpBroadcast::class.java)
        hungupIntent.putExtra("action", "rejectCall")
        hungupIntent.putExtra(INVITE_LINK, inviteLink)
        hungupIntent.putExtra(CHANNEL_ID, channelId)
        notificationIntent.putExtra(MESSAGE_UNIQUE_ID, intent.getStringExtra(MESSAGE_UNIQUE_ID))
        hungupIntent.putExtra(DEVICE_PAYLOAD, getDeviceDetails().toString())

        val answerIntent = Intent(this, MainCallingActivity::class.java)
        answerIntent.action = Intent.ACTION_ANSWER
        answerIntent.addFlags(Intent.FLAG_ACTIVITY_SINGLE_TOP or Intent.FLAG_ACTIVITY_CLEAR_TOP)
        answerIntent.addFlags(Intent.FLAG_ACTIVITY_EXCLUDE_FROM_RECENTS)
        answerIntent.putExtra("room_name", intent?.getStringExtra("room_name"))
        answerIntent.putExtra("call_type", intent?.getStringExtra("call_type"))
        answerIntent.putExtra(MESSAGE_UNIQUE_ID, intent.getStringExtra(MESSAGE_UNIQUE_ID))
        answerIntent.putExtra("answer_call", "answer_call")
        answerIntent.putExtra(INVITE_LINK, inviteLink)
        answerIntent.putExtra(CHANNEL_ID, channelId)

        try {
            val videoCallModel = intent.extras.getParcelable("videoCallModel") as VideoCallModel
            answerIntent.putExtra("videoCallModel", videoCallModel)
        } catch (e: Exception) {
        }

        val pendingIntent = PendingIntent.getActivity(this, 0,
                notificationIntent, PendingIntent.FLAG_UPDATE_CURRENT)

        val hungupPendingIntent = PendingIntent.getBroadcast(this, 0,
                hungupIntent, PendingIntent.FLAG_UPDATE_CURRENT)

        val answerPendingIntent = PendingIntent.getActivity(this, 0,
                answerIntent, PendingIntent.FLAG_UPDATE_CURRENT)

        customView.setTextViewText(R.id.name, intent?.getStringExtra(FULL_NAME))
        if (intent?.getStringExtra(CALL_TYPE).equals("VIDEO")) {
            customView.setTextViewText(R.id.callType, "Incoming Video Call")
        } else {
            customView.setTextViewText(R.id.callType, "Incoming Audio Call")
        }
        //todo: download image here
        //customView.setImageViewBitmap(R.id.photo, Utils.getCircleBitmap(NotificationImageManager().getImageBitmap(intent?.getStringExtra(USER_THUMBNAIL_IMAGE))))
        customView.setOnClickPendingIntent(R.id.btnAnswer, answerPendingIntent)
        customView.setOnClickPendingIntent(R.id.btnDecline, hungupPendingIntent)

        if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.O) {

            val notification = NotificationCompat.Builder(this, "IncomingCall")
            notification.setContentTitle(com.hippo.database.CommonData.getAppName())
            notification.setTicker("Call_STATUS")
            notification.setContentText("IncomingCall")
            notification.setSmallIcon(HippoCallConfig.getInstance().hippoCallPushIcon)
            notification.setDefaults(Notification.DEFAULT_LIGHTS or Notification.DEFAULT_SOUND)
            notification.setCategory(NotificationCompat.CATEGORY_CALL)
            notification.setVibrate(null)
            notification.setOngoing(true)
            notification.setFullScreenIntent(pendingIntent, true)
            notification.priority = getPriority()
            notification.setStyle(NotificationCompat.DecoratedCustomViewStyle())
            notification.setCustomContentView(customView)
            notification.setCustomBigContentView(customView)

            startForeground(1122, notification.build())
            val notificationManager = getSystemService(Context.NOTIFICATION_SERVICE) as NotificationManager
            if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.O) {
                var notificationChannel = NotificationChannel("IncomingCall",
                        "IncomingCall", NotificationManager.IMPORTANCE_HIGH)
                notificationChannel.setSound(null, null)
                notificationManager.createNotificationChannel(notificationChannel)
            }
        } else {

            val notification = NotificationCompat.Builder(this)
            notification.setContentTitle(com.hippo.database.CommonData.getAppName())
            notification.setTicker("Call_STATUS")
            notification.setContentText("IncomingCall")

            notification.setSmallIcon(HippoCallConfig.getInstance().hippoCallPushIcon)
            notification.setLargeIcon(BitmapFactory.decodeResource(this.resources, HippoCallConfig.getInstance().hippoCallPushIcon))
            notification.setDefaults(Notification.DEFAULT_LIGHTS or Notification.DEFAULT_SOUND)
            notification.setVibrate(null)
            notification.setContentIntent(pendingIntent)
            notification.setOngoing(true)
            notification.setCategory(NotificationCompat.CATEGORY_CALL)
            notification.priority = getPriority()
            val hangupAction = NotificationCompat.Action.Builder(
                    android.R.drawable.sym_action_chat, "HANG UP", hungupPendingIntent)
                    .build()
            notification.addAction(hangupAction)
            startForeground(1122, notification.build())
            val notificationManager = getSystemService(Context.NOTIFICATION_SERVICE) as NotificationManager
        }
    }

    private fun createOngoingCallNotification(intent: Intent?) {

        try {
            inviteLink = intent?.getStringExtra(INVITE_LINK)!!
            channelId = intent?.getLongExtra(CHANNEL_ID, -1L)!!
        } catch (e: Exception) {
            e.printStackTrace()
        }

        val notification: NotificationCompat.Builder
        if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.O) {
            notification = NotificationCompat.Builder(this, "NotificationService")
            notification.setContentTitle(com.hippo.database.CommonData.getAppName())
            notification.setContentText("Ongoing Call")
            notification.setSmallIcon(HippoCallConfig.getInstance().hippoCallPushIcon)
            notification.setLargeIcon(BitmapFactory.decodeResource(this.resources, HippoCallConfig.getInstance().hippoCallPushIcon))
            notification.setDefaults(Notification.DEFAULT_LIGHTS or Notification.DEFAULT_SOUND)
            notification.setVibrate(null)
            notification.setOngoing(true)
            notification.priority = getPriority()
            val notificationManager = getSystemService(Context.NOTIFICATION_SERVICE) as NotificationManager
            if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.O) {
                val notificationChannel = NotificationChannel("NotificationService",
                        "NotificationService", NotificationManager.IMPORTANCE_LOW)
                notificationChannel.setSound(null, null)
                notificationManager.createNotificationChannel(notificationChannel)
            }
            startForeground(1124, notification.build())

        } else {
            notification = NotificationCompat.Builder(this)
            notification.setContentTitle(com.hippo.database.CommonData.getAppName())
            notification.setContentText("Ongoing Call")
            notification.setSmallIcon(HippoCallConfig.getInstance().hippoCallPushIcon)
            notification.setLargeIcon(BitmapFactory.decodeResource(this.resources, HippoCallConfig.getInstance().hippoCallPushIcon))
            notification.setDefaults(Notification.DEFAULT_LIGHTS or Notification.DEFAULT_SOUND)
            notification.setVibrate(null)
            notification.setOngoing(true)
            notification.priority = getPriority()
            startForeground(1124, notification.build())
        }
    }

    override fun onDestroy() {
        super.onDestroy()
        isConferenceServiceRunning = false
        LocalBroadcastManager.getInstance(this).unregisterReceiver(mCallTerminated)
        LocalBroadcastManager.getInstance(this).unregisterReceiver(mInternetIssue)
    }

    private fun getPriority(): Int {

        return if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.N) {
            NotificationManager.IMPORTANCE_HIGH
        } else {
            Notification.PRIORITY_MAX
        }
    }

    private fun getDeviceDetails(): JSONObject {
        val devicePayload = JSONObject()
        devicePayload.put(FuguAppConstant.DEVICE_ID, UniqueIMEIID.getUniqueIMEIId(this))
        devicePayload.put(FuguAppConstant.DEVICE_TYPE, FuguAppConstant.ANDROID_USER)
        devicePayload.put(FuguAppConstant.APP_VERSION, BuildConfig.VERSION_NAME)
        devicePayload.put(FuguAppConstant.DEVICE_DETAILS, CommonData.deviceDetails(this))
        return devicePayload
    }
}