package com.hippocall;

import android.app.ActivityManager;
import android.content.Context;
import android.content.Intent;
import android.media.AudioManager;
import android.os.Build;
import android.os.CountDownTimer;
import android.os.Handler;
import android.os.Looper;

import androidx.core.content.ContextCompat;
import androidx.fragment.app.Fragment;
import androidx.localbroadcastmanager.content.LocalBroadcastManager;
import android.text.TextUtils;
import android.widget.Toast;

import com.hippo.CallData;
import com.hippo.HippoConfig;
import com.hippo.constant.FuguAppConstant;
import com.hippo.utils.DateUtils;
import com.hippo.utils.HippoLog;
import com.hippo.utils.UniqueIMEIID;
import com.hippocall.model.Message;
import faye.FayeCallClientListener;
import faye.FayeClient;
import org.json.JSONArray;
import org.json.JSONObject;

import java.text.SimpleDateFormat;
import java.util.*;

import static android.content.Context.ACTIVITY_SERVICE;

/**
 * Created by gurmail on 04/01/19.
 *
 * @author gurmail
 */
public class HippoCallConfig implements CallData, FuguAppConstant {

    private static HippoCallConfig instance;
    private UpdateView updateView;
    private Boolean state = true;
    private CountDownTimer countDown;
    private StringAttributes actionString;
    private int hippoCallPushIcon = R.drawable.hippo_default_notif_icon;
    private int hippoCallsmaillPushIcon = R.drawable.hippo_default_notif_icon;

    private String INCOMING_CALL = "incoming Call";

    protected boolean isNetworkConnected() {
        return state;
    }

    private HippoCallConfig() {

    }

    public void hasExtraView(Boolean view) {
        CommonData.setExtraView(view);
    }

    public static HippoCallConfig getInstance() {
        if(instance == null) {
            synchronized (HippoCallConfig.class) {
                if(instance == null)
                    instance = new HippoCallConfig();
            }
        }
        return instance;
    }

    public void setScreenActionString(StringAttributes actionString) {
        this.actionString = actionString;
        CommonData.setScreenActionString(actionString);
    }

    public StringAttributes getStringAttributes() {
        if(actionString != null) {
            actionString = CommonData.getScreenActionString();
        }
        if(actionString ==null) {
            actionString = getScreenString();
        }
        return actionString;
    }

    protected void setTimmerListener(UpdateView updateView) {
        this.updateView = updateView;
    }


    public void setCallBackListener() {
        HippoConfig.getInstance().setCallListener(this);
    }

    private void sendUserBusyBroadcast(Context context, long channelId, String messageUniqueId,
                                       String videoCallType, long userId) {
        Intent videoCallIntent = new Intent(VIDEO_CALL_INTENT);
        videoCallIntent.putExtra(CHANNEL_ID, channelId);
        videoCallIntent.putExtra(MESSAGE_UNIQUE_ID, messageUniqueId);
        videoCallIntent.putExtra(VIDEO_CALL_TYPE, videoCallType);
        videoCallIntent.putExtra(USER_ID, userId);
        LocalBroadcastManager.getInstance(context).sendBroadcast(videoCallIntent);
    }

    @Override
    public void onNotificationReceived(Context context, JSONObject data) {
        try {
            onCallIncomming(context, data);
        } catch (Exception e) {
            if(HippoConfig.DEBUG)
                e.printStackTrace();
        }
    }

    @Override
    public void networkStatus(int status) {
        this.state = status > 0;
        if(updateView != null) {
            HippoLog.e("TAG", ">>>>>>>>>>No internet connection<<<<<<<");
            updateView.onNetworkStatusChange(status);
        }
    }

    @Override
    public void onCallClick(Context context, int callType, Long channelId, Long userId, boolean isAgentFlow,
                            boolean isAllowCall, String fullname, String image) {

        mClient = null;
        Intent videoIntent = new Intent(context.getApplicationContext(), FuguCallActivity.class);
        videoIntent.addFlags(Intent.FLAG_ACTIVITY_NEW_TASK);
        videoIntent.addFlags(Intent.FLAG_ACTIVITY_EXCLUDE_FROM_RECENTS);

        if(!isMyServiceRunning(context, VideoCallService.class)) {
            Message turnCredentials = new AppContants().getTurnCredentials();
            String messageUniqueId = UUID.randomUUID().toString();

            String activityLaunchState = WebRTCCallConstants.AcitivityLaunchState.SELF.toString();

            String typeCall = WebRTCCallConstants.CallType.VIDEO.toString();
            if(callType == 2)
                typeCall = WebRTCCallConstants.CallType.AUDIO.toString();

            VideoCallModel videoCallModel = new VideoCallModel(channelId,
                    image, fullname, userId, -1, fullname,
                    turnCredentials.getTurnApiKey(),
                    turnCredentials.getUsername(),
                    turnCredentials.getCredentials(),
                    (ArrayList<String>) (turnCredentials.getIceServers().getStun()),
                    (ArrayList<String>) (turnCredentials.getIceServers().getTurn()),
                    activityLaunchState,
                    messageUniqueId,
                    typeCall);
            videoIntent.putExtra("videoCallModel", videoCallModel);
        }
        context.startActivity(videoIntent);
    }

    private Long timeInMillis(String timeStamp) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'", Locale.US);
        Long timeInMilliseconds = 0L;
        try {
            Date mDate = sdf.parse(DateUtils.getInstance().convertToLocal(timeStamp));
            timeInMilliseconds = mDate.getTime();
        } catch (Exception e) {
            e.printStackTrace();
        }
        return timeInMilliseconds;
    }



    private void onCallIncomming(Context context, JSONObject jsonObject) throws Exception {
        HippoLog.v("TAG", "jsonObject = "+jsonObject.toString());
        ActivityManager mngr = (ActivityManager) context.getSystemService(ACTIVITY_SERVICE);
        List<ActivityManager.RunningTaskInfo> taskList = mngr.getRunningTasks(10);
        Long userId = CommonData.getUserId();

        String fullname = jsonObject.optString("full_name");
        Long channelId = jsonObject.optLong("channel_id");
        String messageUniqueId = jsonObject.optString("muid");
        String videoCallType = jsonObject.optString("video_call_type", "");

        String callType = jsonObject.optString("call_type", "");
        String activityLaunchState = WebRTCCallConstants.AcitivityLaunchState.OTHER.toString();

        String userImage = !TextUtils.isEmpty(jsonObject.optString("user_image"))
                ? jsonObject.optString("user_image")
                : !TextUtils.isEmpty(jsonObject.optString("thumbnail_url"))
                ? jsonObject.optString("thumbnail_url")
                : jsonObject.optString("image_url", "");

        if (!taskList.get(0).topActivity.getClassName().equals("com.hippocall.FuguCallActivity")
                && !isMyServiceRunning(context, VideoCallService.class)
                && jsonObject.getInt(NOTIFICATION_TYPE) == 14//VIDEO_CALL_NOTIFICATION
                && jsonObject.has(VIDEO_CALL_TYPE)
                && (jsonObject.optString(VIDEO_CALL_TYPE).equals("START_CALL"))
                && userId.compareTo(-1L) != 0
                && !jsonObject.optString(DEVICE_ID, "").equals(UniqueIMEIID.getUniqueIMEIId(context))
                && userId.compareTo(jsonObject.optLong(USER_ID)) != 0
                && System.currentTimeMillis() - timeInMillis(jsonObject.getString("date_time")) < 30000) {


            Message turnCredentials = new AppContants().getTurnCredentials();
            Intent videoIntent = new Intent(context.getApplicationContext(), FuguCallActivity.class);

            new Handler(Looper.getMainLooper()).postDelayed(new Runnable() {
                @Override
                public void run() {
                    countDown = new CountDownTimer(30000, 1000) {
                        @Override
                        public void onTick(long millisUntilFinished) {
                            //HippoLog.e("Socket Connection Timer", millisUntilFinished + "");
                        }

                        @Override
                        public void onFinish() {

                            ActivityManager mngr = (ActivityManager) context.getSystemService(ACTIVITY_SERVICE);
                            List<ActivityManager.RunningTaskInfo> taskList = mngr.getRunningTasks(10);

                            if (!taskList.get(0).topActivity.getClassName().contains("hippocall")) {
                                //SocketConnection.INSTANCE.disconnectSocket();
                                mClient.unsubscribeChannel("/"+channelId);
                            }
                        }
                    };
                    countDown.start();
                }
            }, 0);


            VideoCallModel videoCallModel = new VideoCallModel(channelId,
                    userImage,
                    fullname,
                    userId,
                    -1,
                    fullname,
                    turnCredentials.getTurnApiKey(),
                    turnCredentials.getUsername(),
                    turnCredentials.getCredentials(),
                    (ArrayList<String>) (turnCredentials.getIceServers().getStun()),
                    (ArrayList<String>) (turnCredentials.getIceServers().getTurn()),
                    activityLaunchState,
                    messageUniqueId,
                    callType.toUpperCase());

            videoIntent.addFlags(Intent.FLAG_ACTIVITY_NEW_TASK);
            videoIntent.addFlags(Intent.FLAG_ACTIVITY_EXCLUDE_FROM_RECENTS);
            videoIntent.putExtra("videoCallModel", videoCallModel);


            HippoConfig.getExistingClient(client -> {
                mClient = client;
                mClient.connectServer();

                mClient.setCallListener(new FayeCallClientListener() {
                    @Override
                    public void onConnectedServer(FayeClient fc) {
                        mClient.subscribeChannel("/"+channelId);
                    }

                    @Override
                    public void onDisconnectedServer(FayeClient fc) {

                    }

                    @Override
                    public void onReceivedMessage(FayeClient fc, String msg, String channel) {
                        //HippoLog.e("msg", ""+msg);
                        try {
                            callRecieved(context, msg, videoIntent, jsonObject, videoCallModel, userId);
                        } catch (Exception e) {
                            e.printStackTrace();
                        }
                    }

                    @Override
                    public void onPongReceived() {
                        HippoLog.e("HippoCallConfig", "onPongReceived");
                    }

                    @Override
                    public void onWebSocketError() {
                        HippoLog.e("HippoCallConfig", "onWebSocketError");
                    }

                    @Override
                    public void onErrorReceived(FayeClient fc, String msg, String channel) {

                    }
                });
            });


        } else if(!taskList.get(0).topActivity.getClassName().equals("com.hippocall.FuguCallActivity")
                && !isMyServiceRunning(context, VideoCallService.class)
                && jsonObject.getInt(NOTIFICATION_TYPE) == 14//VIDEO_CALL_NOTIFICATION
                && jsonObject.has(VIDEO_CALL_TYPE)
                && (jsonObject.optString(VIDEO_CALL_TYPE).equals("CALL_HUNG_UP"))
                && userId.compareTo(-1L) != 0
                && !jsonObject.optString(DEVICE_ID, "").equals(UniqueIMEIID.getUniqueIMEIId(context))
                && userId.compareTo(jsonObject.optLong(USER_ID)) != 0
                && System.currentTimeMillis() - timeInMillis(jsonObject.getString("date_time")) < 30000) {

            Intent startIntent = new Intent(context.getApplicationContext(), VideoCallService.class);
            startIntent.setAction("com.fuguchat.stop");
            context.stopService(startIntent);
        } else {
            if(jsonObject.getInt(NOTIFICATION_TYPE) == 14//VIDEO_CALL_NOTIFICATION
                    && jsonObject.has(VIDEO_CALL_TYPE)
                    && (jsonObject.optString(VIDEO_CALL_TYPE).equals("START_CALL"))) {

                HippoConfig.getExistingClient(client -> {
                    if(client.isConnectedServer()) {
                        try {
                            JSONObject json = new JSONObject();

                            json.put(FuguAppConstant.VIDEO_CALL_TYPE, WebRTCCallConstants.VideoCallType.USER_BUSY.toString());
                            json.put(FuguAppConstant.IS_SILENT, true);
                            json.put(FuguAppConstant.USER_ID, userId);
                            json.put(FuguAppConstant.FULL_NAME, fullname);
                            json.put(FuguAppConstant.MESSAGE_TYPE, FuguAppConstant.VIDEO_CALL);
                            json.put(FuguAppConstant.IS_TYPING, TYPING_SHOW_MESSAGE);
                            json.put(FuguAppConstant.MESSAGE_UNIQUE_ID, messageUniqueId);

                            JSONObject devicePayload = new JSONObject();
                            devicePayload.put(FuguAppConstant.DEVICE_ID, CommonData.getUniqueIMEIId(context));
                            devicePayload.put(FuguAppConstant.DEVICE_TYPE, FuguAppConstant.ANDROID_USER);
                            devicePayload.put(FuguAppConstant.APP_VERSION, BuildConfig.VERSION_NAME);
                            devicePayload.put(FuguAppConstant.DEVICE_DETAILS, CommonData.deviceDetails(context));
                            json.put("device_payload", devicePayload);

                            client.publish("/" + channelId, json);
                        } catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                });
            } else {
              sendUserBusyBroadcast(context, channelId, messageUniqueId, videoCallType, userId);
            }
        }
    }

    protected boolean isCallActive(Context context) {
        AudioManager manager = (AudioManager) context.getSystemService(Context.AUDIO_SERVICE);
        return manager.getMode() == AudioManager.MODE_IN_CALL;
    }

    private void callRecieved(Context context, String messageJson, Intent videoIntent, JSONObject notificationJson,
                              VideoCallModel videoCallModel, Long myUserId) {
        try {
            JSONObject json = new JSONObject(messageJson);
            if (json.has(MESSAGE_TYPE) && json.getInt(MESSAGE_TYPE) == 18 &&
                    json.getString("muid").equals(notificationJson.getString("muid"))) {
                HippoLog.e("VIDEO_JSON", json.toString());

                if (json.getString(VIDEO_CALL_TYPE).equals("START_CALL")) {
                    JSONObject readyToConnectJson = new JSONObject();
                    readyToConnectJson.put(VIDEO_CALL_TYPE, "READY_TO_CONNECT");
                    readyToConnectJson.put(IS_SILENT, true);
                    readyToConnectJson.put("user_id", myUserId);
                    readyToConnectJson.put(MESSAGE_TYPE, VIDEO_CALL);
                    readyToConnectJson.put(IS_TYPING, TYPING_SHOW_MESSAGE);
                    readyToConnectJson.put("muid", notificationJson.getString("muid"));
                    addTurnCredentialsAndDeviceDetails(context, readyToConnectJson, videoCallModel,
                            notificationJson.getString("channel_id"), videoCallModel.getCallType());
                } else if (json.getString(VIDEO_CALL_TYPE).equals("VIDEO_OFFER")) {
                    if (!isCallActive(context)) {
                        ActivityManager mngr = (ActivityManager) context.getSystemService(ACTIVITY_SERVICE);
                        List<ActivityManager.RunningTaskInfo> taskList = mngr.getRunningTasks(10);
                        countDown.cancel();
                        if (!taskList.get(0).topActivity.getClassName().equals("com.hippocall.FuguCallActivity")
                                && !isMyServiceRunning(context, VideoCallService.class)
                                && !taskList.get(0).topActivity.getClassName().contains("GrantPermissionsActivity")) {
                            videoIntent.putExtra("video_offer", messageJson);
                            if (Build.VERSION.SDK_INT > Build.VERSION_CODES.P) {
                                startCallForegroundService(context, INCOMING_CALL, videoCallModel);
                            } else {
                                context.startActivity(videoIntent);
                            }

//                            context.startActivity(videoIntent);
                        }
                    } else {
                        JSONObject readyToConnectJson = new JSONObject();
                        readyToConnectJson.put(VIDEO_CALL_TYPE, "USER_BUSY");
                        readyToConnectJson.put(IS_SILENT, true);
                        readyToConnectJson.put("user_id", myUserId);
                        readyToConnectJson.put(MESSAGE_TYPE, VIDEO_CALL);
                        readyToConnectJson.put(IS_TYPING, TYPING_SHOW_MESSAGE);
                        readyToConnectJson.put("muid", notificationJson.getString("muid"));
                        addTurnCredentialsAndDeviceDetails(context, readyToConnectJson, videoCallModel,
                                notificationJson.getString("channel_id"), videoCallModel.getCallType());
                    }
                } else if(json.getString(VIDEO_CALL_TYPE).equals("CALL_HUNG_UP")) {
                    ActivityManager mngr = (ActivityManager) context.getSystemService(ACTIVITY_SERVICE);
                    List<ActivityManager.RunningTaskInfo> taskList = mngr.getRunningTasks(10);
                    HippoLog.e("Type~~~~~~>", json.getString(VIDEO_CALL_TYPE));
                    if(!taskList.get(0).topActivity.getClassName().equals("com.hippocall.FuguCallActivity")
                            && isMyServiceRunning(context, VideoCallService.class)
                            && json.getInt(MESSAGE_TYPE) == 18
                            && json.has(VIDEO_CALL_TYPE)
                            && (json.optString(VIDEO_CALL_TYPE).equals("CALL_HUNG_UP"))) {

                        Intent startIntent = new Intent(context.getApplicationContext(), VideoCallService.class);
                        startIntent.setAction("com.fuguchat.stop");
                        context.stopService(startIntent);
                    }
                }
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void startCallForegroundService(Context context, String status, VideoCallModel videoCallModel) {
        Intent startIntent = new Intent(context.getApplicationContext(), VideoCallService.class);
        String channelName = "";
        channelName = videoCallModel.getChannelName();
        startIntent.setAction("com.fuguchat.start");
        startIntent.putExtra(CALL_STATUS, status);
        startIntent.putExtra(CHANNEL_NAME, channelName);
        startIntent.putExtra(VIDEO_CALL_MODEL, videoCallModel);
        startIntent.putExtra(INIT_FULL_SCREEN_SERVICE, true);
        new Thread(new Runnable() {
            @Override
            public void run() {
                CommonData.setVideoCallModel(videoCallModel);
            }
        }).start();
        try {
            ContextCompat.startForegroundService(context, startIntent);
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void addTurnCredentialsAndDeviceDetails(Context context, JSONObject readyToConnectJson,
                                                    VideoCallModel videoCallModel, String channelId, String callType) {
        try {
            JSONArray stunServers = new JSONArray();
            JSONArray turnServers = new JSONArray();
            JSONObject videoCallCredentials = new JSONObject();

            videoCallCredentials.put("turnApiKey", videoCallModel.getTurnApiKey());
            videoCallCredentials.put("username", videoCallModel.getTurnUserName());
            videoCallCredentials.put("credential", videoCallModel.getTurnCredential());
            for (int i = 0; i < videoCallModel.getStunServers().size(); i++) {
                stunServers.put(videoCallModel.getStunServers().get(i));
            }
            for (int i = 0; i < videoCallModel.getTurnServers().size(); i++) {
                turnServers.put(videoCallModel.getTurnServers().get(i));
            }


            JSONObject devicePayload = new JSONObject();
            devicePayload.put(FuguAppConstant.DEVICE_ID, UniqueIMEIID.getUniqueIMEIId(context));
            devicePayload.put(FuguAppConstant.DEVICE_TYPE, FuguAppConstant.ANDROID_USER);
            devicePayload.put(FuguAppConstant.APP_VERSION, "2.0.5");
            devicePayload.put(FuguAppConstant.DEVICE_DETAILS, CommonData.deviceDetails(context));

            videoCallCredentials.put("stun", stunServers);
            videoCallCredentials.put("turn", turnServers);
            readyToConnectJson.put("turn_creds", videoCallCredentials);
            readyToConnectJson.put("device_payload", devicePayload);

            readyToConnectJson.put("call_type", callType);

            publishSignalToFaye(channelId, readyToConnectJson);
        } catch (Exception e) {

        }
    }

    private void publishSignalToFaye(String channelId, JSONObject signalJson) {
        if (mClient != null) {
            mClient.publish("/"+channelId, signalJson);
        }
    }


    @Override
    public void onExternalClick(Context context, String callType, Long userId, String otherUserName,
                                String fuguPeerChatParams, String otheruserImageUrl) {
        int callValue = VIDEO_CALL_VIEW;
        String activityLaunchState = WebRTCCallConstants.AcitivityLaunchState.SELF.toString();
        if(callType.equalsIgnoreCase("audio")) {
            callValue = AUDIO_CALL_VIEW;
        } else if(callType.equalsIgnoreCase("video")) {
            callValue = VIDEO_CALL_VIEW;
        } else {
            Toast.makeText(context, "Call type should be audio/video", Toast.LENGTH_SHORT).show();
            return;
        }

        mClient = null;

        String path = otheruserImageUrl;
        if(TextUtils.isEmpty(path))
            path = "";

        Intent videoIntent = new Intent(context, FuguCallActivity.class);

        videoIntent.addFlags(Intent.FLAG_ACTIVITY_NEW_TASK);
        videoIntent.addFlags(Intent.FLAG_ACTIVITY_EXCLUDE_FROM_RECENTS);

        videoIntent.putExtra(FuguAppConstant.PEER_CHAT_PARAMS, fuguPeerChatParams);
        if(!isMyServiceRunning(context, VideoCallService.class)) {
            Message turnCredentials = new AppContants().getTurnCredentials();
            String messageUniqueId = UUID.randomUUID().toString();

            VideoCallModel videoCallModel = new VideoCallModel(-1,
                    path,
                    otherUserName,
                    userId,
                    -1,
                    otherUserName,
                    turnCredentials.getTurnApiKey(),
                    turnCredentials.getUsername(),
                    turnCredentials.getCredentials(),
                    (ArrayList<String>) (turnCredentials.getIceServers().getStun()),
                    (ArrayList<String>) (turnCredentials.getIceServers().getTurn()),
                    activityLaunchState,
                    messageUniqueId,
                    callType.toUpperCase());
            videoIntent.putExtra("videoCallModel", videoCallModel);
        }
        context.startActivity(videoIntent);

    }

    public void setFragment(Fragment fragment) {
        this.fragment = fragment;
        if(updateView != null)
            updateView.updateFragment(fragment);
    }

    public void timerVisibility(int status) {
        if(updateView != null)
            updateView.timerVisibilityStatus(status);
    }

    public void setTimer(String txt) {
        if(updateView != null)
            updateView.updateTimer(txt);
    }

    public void openOnGoingCall(Context context, OnScreenChangeListener changeListener) {
        if(isMyServiceRunning(context, VideoCallService.class)) {
            Intent videoIntent = new Intent(context.getApplicationContext(), FuguCallActivity.class);
            videoIntent.addFlags(Intent.FLAG_ACTIVITY_NEW_TASK);
            videoIntent.addFlags(Intent.FLAG_ACTIVITY_EXCLUDE_FROM_RECENTS);
            context.startActivity(videoIntent);
            if(changeListener != null)
                changeListener.onScreenStatus(true);
        } else {
            if(changeListener != null)
                changeListener.onScreenStatus(false);
        }
    }

    public void sendCustomData(Context context, CustomDataAttributes data) {
        if(updateView == null) {
            try {
                Intent videoCallIntent = new Intent(VIDEO_CALL_INTENT);
                videoCallIntent.putExtra("custom_data", "CUSTOM_DATA");
                JSONObject json = new JSONObject();
                json.put("unique_id", data.getUniqueId());
                json.put("flag", data.getFlag());
                if(!TextUtils.isEmpty(data.getMessage()))
                    json.put("message", data.getMessage());

                videoCallIntent.putExtra("data", json.toString());
                LocalBroadcastManager.getInstance(context).sendBroadcast(videoCallIntent);
            } catch (Exception e) {

            }
        } else {
            try {
                JSONObject json = new JSONObject();
                json.put("unique_id", data.getUniqueId());
                json.put("flag", data.getFlag());
                if(!TextUtils.isEmpty(data.getMessage()))
                    json.put("message", data.getMessage());
                updateView.sendCustomData(json);
            } catch (Exception e) {

            }
        }
    }

    public void setHippoCallPushIcon(int hippoCallPushIcon) {
        this.hippoCallPushIcon = hippoCallPushIcon;
    }

    public int getHippoCallPushIcon() {
        return hippoCallPushIcon;
    }

    public int getHippoCallsmaillPushIcon() {
        return hippoCallsmaillPushIcon;
    }

    public void setHippoCallsmaillPushIcon(int hippoCallsmaillPushIcon) {
        this.hippoCallsmaillPushIcon = hippoCallsmaillPushIcon;
    }

    private Fragment fragment;
    protected Fragment getFragment() {
        return fragment;
    }

    private FayeClient mClient = null;

    protected FayeClient getClient() {
        return mClient;
    }

    protected boolean isMyServiceRunning(Context context, Class<?> serviceClass) {
        ActivityManager manager = (ActivityManager) context.getSystemService(Context.ACTIVITY_SERVICE);
        for (ActivityManager.RunningServiceInfo service : manager.getRunningServices(Integer.MAX_VALUE)) {
            if (serviceClass.getName().equals(service.service.getClassName())) {
                return true;
            }
        }
        return false;
    }

    private StringAttributes getScreenString() {
        StringAttributes attributes = new StringAttributes.Builder()
                .setAndString("and")
                .setMuteString("sound mute")
                .setCameraOffString("camera closed")
                .setVideoPaused("Video paused")
                .showUserName(true)
                .build();

        return attributes;
    }


    public void clearData() {
        mClient = null;
    }
}
