/*
 * Decompiled with CFR 0.152.
 */
package com.hippocall;

import android.app.ActivityManager;
import android.content.Context;
import android.content.Intent;
import android.media.AudioManager;
import android.os.Build;
import android.os.CountDownTimer;
import android.os.Handler;
import android.os.Looper;
import android.os.Parcelable;
import android.text.TextUtils;
import android.widget.Toast;
import androidx.core.content.ContextCompat;
import androidx.fragment.app.Fragment;
import androidx.localbroadcastmanager.content.LocalBroadcastManager;
import com.hippo.CallData;
import com.hippo.HippoConfig;
import com.hippo.constant.FuguAppConstant;
import com.hippo.utils.DateUtils;
import com.hippo.utils.HippoLog;
import com.hippo.utils.UniqueIMEIID;
import com.hippocall.AppContants;
import com.hippocall.CommonData;
import com.hippocall.CustomDataAttributes;
import com.hippocall.FuguCallActivity;
import com.hippocall.OnScreenChangeListener;
import com.hippocall.R;
import com.hippocall.StringAttributes;
import com.hippocall.UpdateView;
import com.hippocall.VideoCallModel;
import com.hippocall.VideoCallService;
import com.hippocall.WebRTCCallConstants;
import com.hippocall.model.Message;
import faye.FayeCallClientListener;
import faye.FayeClient;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.UUID;
import org.json.JSONArray;
import org.json.JSONObject;

public class HippoCallConfig
implements CallData,
FuguAppConstant {
    private static HippoCallConfig instance;
    private UpdateView updateView;
    private Boolean state = true;
    private CountDownTimer countDown;
    private StringAttributes actionString;
    private int hippoCallPushIcon = R.drawable.hippo_default_notif_icon;
    private String INCOMING_CALL = "incoming Call...";
    private Fragment fragment;
    private FayeClient mClient = null;

    protected boolean isNetworkConnected() {
        return this.state;
    }

    private HippoCallConfig() {
    }

    public void hasExtraView(Boolean view) {
        CommonData.setExtraView(view);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static HippoCallConfig getInstance() {
        if (instance != null) return instance;
        Class<HippoCallConfig> clazz = HippoCallConfig.class;
        synchronized (HippoCallConfig.class) {
            if (instance != null) return instance;
            instance = new HippoCallConfig();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public void setScreenActionString(StringAttributes actionString) {
        this.actionString = actionString;
        CommonData.setScreenActionString(actionString);
    }

    public StringAttributes getStringAttributes() {
        if (this.actionString != null) {
            this.actionString = CommonData.getScreenActionString();
        }
        if (this.actionString == null) {
            this.actionString = this.getScreenString();
        }
        return this.actionString;
    }

    protected void setTimmerListener(UpdateView updateView) {
        this.updateView = updateView;
    }

    public void setCallBackListener() {
        HippoConfig.getInstance().setCallListener((CallData)this);
    }

    private void sendUserBusyBroadcast(Context context, long channelId, String messageUniqueId, String videoCallType, long userId) {
        Intent videoCallIntent = new Intent("hippo_video_call_intent");
        videoCallIntent.putExtra("channel_id", channelId);
        videoCallIntent.putExtra("muid", messageUniqueId);
        videoCallIntent.putExtra("video_call_type", videoCallType);
        videoCallIntent.putExtra("user_id", userId);
        LocalBroadcastManager.getInstance((Context)context).sendBroadcast(videoCallIntent);
    }

    public void onNotificationReceived(Context context, JSONObject data) {
        block2: {
            try {
                this.onCallIncomming(context, data);
            }
            catch (Exception e) {
                if (!HippoConfig.DEBUG) break block2;
                e.printStackTrace();
            }
        }
    }

    public void networkStatus(int status) {
        this.state = status > 0;
        if (this.updateView != null) {
            HippoLog.e((String)"TAG", (String)">>>>>>>>>>No internet connection<<<<<<<");
            this.updateView.onNetworkStatusChange(status);
        }
    }

    public void onCallClick(Context context, int callType, Long channelId, Long userId, boolean isAgentFlow, boolean isAllowCall, String fullname, String image) {
        Intent videoIntent = new Intent(context.getApplicationContext(), FuguCallActivity.class);
        videoIntent.addFlags(0x10000000);
        videoIntent.addFlags(0x800000);
        if (!this.isMyServiceRunning(context, VideoCallService.class)) {
            Message turnCredentials = new AppContants().getTurnCredentials();
            String messageUniqueId = UUID.randomUUID().toString();
            String activityLaunchState = WebRTCCallConstants.AcitivityLaunchState.SELF.toString();
            String typeCall = WebRTCCallConstants.CallType.VIDEO.toString();
            if (callType == 2) {
                typeCall = WebRTCCallConstants.CallType.AUDIO.toString();
            }
            VideoCallModel videoCallModel = new VideoCallModel(channelId, image, fullname, userId, -1L, fullname, turnCredentials.getTurnApiKey(), turnCredentials.getUsername(), turnCredentials.getCredentials(), (ArrayList)turnCredentials.getIceServers().getStun(), (ArrayList)turnCredentials.getIceServers().getTurn(), activityLaunchState, messageUniqueId, typeCall);
            videoIntent.putExtra("videoCallModel", (Parcelable)videoCallModel);
        }
        context.startActivity(videoIntent);
    }

    private Long timeInMillis(String timeStamp) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'", Locale.US);
        Long timeInMilliseconds = 0L;
        try {
            Date mDate = sdf.parse(DateUtils.getInstance().convertToLocal(timeStamp));
            timeInMilliseconds = mDate.getTime();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return timeInMilliseconds;
    }

    private void onCallIncomming(final Context context, final JSONObject jsonObject) throws Exception {
        String userImage;
        HippoLog.v((String)"TAG", (String)("jsonObject = " + jsonObject.toString()));
        ActivityManager mngr = (ActivityManager)context.getSystemService("activity");
        List taskList = mngr.getRunningTasks(10);
        final Long userId = CommonData.getUserId();
        String fullname = jsonObject.optString("full_name");
        final Long channelId = jsonObject.optLong("channel_id");
        String messageUniqueId = jsonObject.optString("muid");
        String videoCallType = jsonObject.optString("video_call_type", "");
        String callType = jsonObject.optString("call_type", "");
        String activityLaunchState = WebRTCCallConstants.AcitivityLaunchState.OTHER.toString();
        String string = !TextUtils.isEmpty((CharSequence)jsonObject.optString("user_image")) ? jsonObject.optString("user_image") : (userImage = !TextUtils.isEmpty((CharSequence)jsonObject.optString("thumbnail_url")) ? jsonObject.optString("thumbnail_url") : jsonObject.optString("image_url", ""));
        if (!((ActivityManager.RunningTaskInfo)taskList.get((int)0)).topActivity.getClassName().equals("com.hippocall.FuguCallActivity") && !this.isMyServiceRunning(context, VideoCallService.class) && jsonObject.getInt("notification_type") == 14 && jsonObject.has("video_call_type") && jsonObject.optString("video_call_type").equals("START_CALL") && userId.compareTo(-1L) != 0 && !jsonObject.optString("device_id", "").equals(UniqueIMEIID.getUniqueIMEIId((Context)context)) && userId.compareTo(jsonObject.optLong("user_id")) != 0 && System.currentTimeMillis() - this.timeInMillis(jsonObject.getString("date_time")) < 30000L) {
            Message turnCredentials = new AppContants().getTurnCredentials();
            final Intent videoIntent = new Intent(context.getApplicationContext(), FuguCallActivity.class);
            new Handler(Looper.getMainLooper()).postDelayed(new Runnable(){

                @Override
                public void run() {
                    HippoCallConfig.this.countDown = new CountDownTimer(30000L, 1000L){

                        public void onTick(long millisUntilFinished) {
                        }

                        public void onFinish() {
                            ActivityManager mngr = (ActivityManager)context.getSystemService("activity");
                            List taskList = mngr.getRunningTasks(10);
                            if (!((ActivityManager.RunningTaskInfo)taskList.get((int)0)).topActivity.getClassName().contains("hippocall")) {
                                HippoCallConfig.this.mClient.unsubscribeChannel("/" + channelId);
                            }
                        }
                    };
                    HippoCallConfig.this.countDown.start();
                }
            }, 0L);
            final VideoCallModel videoCallModel = new VideoCallModel(channelId, userImage, fullname, userId, -1L, fullname, turnCredentials.getTurnApiKey(), turnCredentials.getUsername(), turnCredentials.getCredentials(), (ArrayList)turnCredentials.getIceServers().getStun(), (ArrayList)turnCredentials.getIceServers().getTurn(), activityLaunchState, messageUniqueId, callType.toUpperCase());
            videoIntent.addFlags(0x10000000);
            videoIntent.addFlags(0x800000);
            videoIntent.putExtra("videoCallModel", (Parcelable)videoCallModel);
            HippoConfig.getExistingClient(client -> {
                this.mClient = client;
                this.mClient.connectServer();
                this.mClient.setCallListener(new FayeCallClientListener(){

                    public void onConnectedServer(FayeClient fc) {
                        HippoCallConfig.this.mClient.subscribeChannel("/" + channelId);
                    }

                    public void onDisconnectedServer(FayeClient fc) {
                    }

                    public void onReceivedMessage(FayeClient fc, String msg, String channel) {
                        try {
                            HippoCallConfig.this.callRecieved(context, msg, videoIntent, jsonObject, videoCallModel, userId);
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }

                    public void onPongReceived() {
                        HippoLog.e((String)"HippoCallConfig", (String)"onPongReceived");
                    }

                    public void onWebSocketError() {
                        HippoLog.e((String)"HippoCallConfig", (String)"onWebSocketError");
                    }

                    public void onErrorReceived(FayeClient fc, String msg, String channel) {
                    }
                });
            });
        } else if (!((ActivityManager.RunningTaskInfo)taskList.get((int)0)).topActivity.getClassName().equals("com.hippocall.FuguCallActivity") && !this.isMyServiceRunning(context, VideoCallService.class) && jsonObject.getInt("notification_type") == 14 && jsonObject.has("video_call_type") && jsonObject.optString("video_call_type").equals("CALL_HUNG_UP") && userId.compareTo(-1L) != 0 && !jsonObject.optString("device_id", "").equals(UniqueIMEIID.getUniqueIMEIId((Context)context)) && userId.compareTo(jsonObject.optLong("user_id")) != 0 && System.currentTimeMillis() - this.timeInMillis(jsonObject.getString("date_time")) < 30000L) {
            Intent startIntent = new Intent(context.getApplicationContext(), VideoCallService.class);
            startIntent.setAction("com.fuguchat.stop");
            context.stopService(startIntent);
        } else if (jsonObject.getInt("notification_type") == 14 && jsonObject.has("video_call_type") && jsonObject.optString("video_call_type").equals("START_CALL")) {
            HippoConfig.getExistingClient(client -> {
                if (client.isConnectedServer()) {
                    try {
                        JSONObject json = new JSONObject();
                        json.put("video_call_type", (Object)WebRTCCallConstants.VideoCallType.USER_BUSY.toString());
                        json.put("is_silent", true);
                        json.put("user_id", (Object)userId);
                        json.put("full_name", (Object)fullname);
                        json.put("message_type", 18);
                        json.put("is_typing", 0);
                        json.put("muid", (Object)messageUniqueId);
                        JSONObject devicePayload = new JSONObject();
                        devicePayload.put("device_id", (Object)CommonData.getUniqueIMEIId(context));
                        devicePayload.put("device_type", 1);
                        devicePayload.put("app_version", (Object)"1.0");
                        devicePayload.put("device_details", (Object)CommonData.deviceDetails(context));
                        json.put("device_payload", (Object)devicePayload);
                        client.publish("/" + channelId, json);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            });
        } else {
            this.sendUserBusyBroadcast(context, channelId, messageUniqueId, videoCallType, userId);
        }
    }

    protected boolean isCallActive(Context context) {
        AudioManager manager = (AudioManager)context.getSystemService("audio");
        return manager.getMode() == 2;
    }

    private void callRecieved(Context context, String messageJson, Intent videoIntent, JSONObject notificationJson, VideoCallModel videoCallModel, Long myUserId) {
        try {
            JSONObject json = new JSONObject(messageJson);
            if (json.has("message_type") && json.getInt("message_type") == 18 && json.getString("muid").equals(notificationJson.getString("muid"))) {
                HippoLog.e((String)"VIDEO_JSON", (String)json.toString());
                if (json.getString("video_call_type").equals("START_CALL")) {
                    JSONObject readyToConnectJson = new JSONObject();
                    readyToConnectJson.put("video_call_type", (Object)"READY_TO_CONNECT");
                    readyToConnectJson.put("is_silent", true);
                    readyToConnectJson.put("user_id", (Object)myUserId);
                    readyToConnectJson.put("message_type", 18);
                    readyToConnectJson.put("is_typing", 0);
                    readyToConnectJson.put("muid", (Object)notificationJson.getString("muid"));
                    this.addTurnCredentialsAndDeviceDetails(context, readyToConnectJson, videoCallModel, notificationJson.getString("channel_id"), videoCallModel.getCallType());
                } else if (json.getString("video_call_type").equals("VIDEO_OFFER")) {
                    if (!this.isCallActive(context)) {
                        ActivityManager mngr = (ActivityManager)context.getSystemService("activity");
                        List taskList = mngr.getRunningTasks(10);
                        this.countDown.cancel();
                        if (Build.VERSION.SDK_INT > 28) {
                            if (!(((ActivityManager.RunningTaskInfo)taskList.get((int)0)).topActivity.getClassName().equals("com.hippocall.FuguCallActivity") || this.isMyServiceRunning(context, VideoCallService.class) || ((ActivityManager.RunningTaskInfo)taskList.get((int)0)).topActivity.getClassName().contains("GrantPermissionsActivity"))) {
                                videoIntent.putExtra("video_offer", messageJson);
                                this.startCallForegroundService(context, this.INCOMING_CALL, videoCallModel);
                            }
                        } else {
                            context.startActivity(videoIntent);
                        }
                    } else {
                        JSONObject readyToConnectJson = new JSONObject();
                        readyToConnectJson.put("video_call_type", (Object)"USER_BUSY");
                        readyToConnectJson.put("is_silent", true);
                        readyToConnectJson.put("user_id", (Object)myUserId);
                        readyToConnectJson.put("message_type", 18);
                        readyToConnectJson.put("is_typing", 0);
                        readyToConnectJson.put("muid", (Object)notificationJson.getString("muid"));
                        this.addTurnCredentialsAndDeviceDetails(context, readyToConnectJson, videoCallModel, notificationJson.getString("channel_id"), videoCallModel.getCallType());
                    }
                } else if (json.getString("video_call_type").equals("CALL_HUNG_UP")) {
                    ActivityManager mngr = (ActivityManager)context.getSystemService("activity");
                    List taskList = mngr.getRunningTasks(10);
                    HippoLog.e((String)"Type~~~~~~>", (String)json.getString("video_call_type"));
                    if (!((ActivityManager.RunningTaskInfo)taskList.get((int)0)).topActivity.getClassName().equals("com.hippocall.FuguCallActivity") && this.isMyServiceRunning(context, VideoCallService.class) && json.getInt("message_type") == 18 && json.has("video_call_type") && json.optString("video_call_type").equals("CALL_HUNG_UP")) {
                        Intent startIntent = new Intent(context.getApplicationContext(), VideoCallService.class);
                        startIntent.setAction("com.fuguchat.stop");
                        context.stopService(startIntent);
                    }
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void startCallForegroundService(Context context, String status, final VideoCallModel videoCallModel) {
        Intent startIntent = new Intent(context.getApplicationContext(), VideoCallService.class);
        String channelName = "";
        channelName = videoCallModel.getChannelName();
        startIntent.setAction("com.fuguchat.start");
        startIntent.putExtra("call_status", status);
        startIntent.putExtra("channel_name", channelName);
        startIntent.putExtra("video_Call_model", (Parcelable)videoCallModel);
        startIntent.putExtra("init_full_screen_service", true);
        new Thread(new Runnable(){

            @Override
            public void run() {
                CommonData.setVideoCallModel(videoCallModel);
            }
        }).start();
        try {
            ContextCompat.startForegroundService((Context)context, (Intent)startIntent);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void addTurnCredentialsAndDeviceDetails(Context context, JSONObject readyToConnectJson, VideoCallModel videoCallModel, String channelId, String callType) {
        try {
            int i;
            JSONArray stunServers = new JSONArray();
            JSONArray turnServers = new JSONArray();
            JSONObject videoCallCredentials = new JSONObject();
            videoCallCredentials.put("turnApiKey", (Object)videoCallModel.getTurnApiKey());
            videoCallCredentials.put("username", (Object)videoCallModel.getTurnUserName());
            videoCallCredentials.put("credential", (Object)videoCallModel.getTurnCredential());
            for (i = 0; i < videoCallModel.getStunServers().size(); ++i) {
                stunServers.put((Object)videoCallModel.getStunServers().get(i));
            }
            for (i = 0; i < videoCallModel.getTurnServers().size(); ++i) {
                turnServers.put((Object)videoCallModel.getTurnServers().get(i));
            }
            JSONObject devicePayload = new JSONObject();
            devicePayload.put("device_id", (Object)UniqueIMEIID.getUniqueIMEIId((Context)context));
            devicePayload.put("device_type", 1);
            devicePayload.put("app_version", (Object)"2.0.5");
            devicePayload.put("device_details", (Object)CommonData.deviceDetails(context));
            videoCallCredentials.put("stun", (Object)stunServers);
            videoCallCredentials.put("turn", (Object)turnServers);
            readyToConnectJson.put("turn_creds", (Object)videoCallCredentials);
            readyToConnectJson.put("device_payload", (Object)devicePayload);
            readyToConnectJson.put("call_type", (Object)callType);
            this.publishSignalToFaye(channelId, readyToConnectJson);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void publishSignalToFaye(String channelId, JSONObject signalJson) {
        if (this.mClient != null) {
            this.mClient.publish("/" + channelId, signalJson);
        }
    }

    public void onExternalClick(Context context, String callType, Long userId, String otherUserName, String fuguPeerChatParams, String otheruserImageUrl) {
        int callValue = 1;
        String activityLaunchState = WebRTCCallConstants.AcitivityLaunchState.SELF.toString();
        if (callType.equalsIgnoreCase("audio")) {
            callValue = 2;
        } else if (callType.equalsIgnoreCase("video")) {
            callValue = 1;
        } else {
            Toast.makeText((Context)context, (CharSequence)"Call type should be audio/video", (int)0).show();
            return;
        }
        this.mClient = null;
        String path = otheruserImageUrl;
        if (TextUtils.isEmpty((CharSequence)path)) {
            path = "";
        }
        Intent videoIntent = new Intent(context, FuguCallActivity.class);
        videoIntent.addFlags(0x10000000);
        videoIntent.addFlags(0x800000);
        videoIntent.putExtra("peer_chat_params", fuguPeerChatParams);
        if (!this.isMyServiceRunning(context, VideoCallService.class)) {
            Message turnCredentials = new AppContants().getTurnCredentials();
            String messageUniqueId = UUID.randomUUID().toString();
            VideoCallModel videoCallModel = new VideoCallModel(-1L, path, otherUserName, userId, -1L, otherUserName, turnCredentials.getTurnApiKey(), turnCredentials.getUsername(), turnCredentials.getCredentials(), (ArrayList)turnCredentials.getIceServers().getStun(), (ArrayList)turnCredentials.getIceServers().getTurn(), activityLaunchState, messageUniqueId, callType.toUpperCase());
            videoIntent.putExtra("videoCallModel", (Parcelable)videoCallModel);
        }
        context.startActivity(videoIntent);
    }

    public void setFragment(Fragment fragment) {
        this.fragment = fragment;
        if (this.updateView != null) {
            this.updateView.updateFragment(fragment);
        }
    }

    public void timerVisibility(int status) {
        if (this.updateView != null) {
            this.updateView.timerVisibilityStatus(status);
        }
    }

    public void setTimer(String txt) {
        if (this.updateView != null) {
            this.updateView.updateTimer(txt);
        }
    }

    public void openOnGoingCall(Context context, OnScreenChangeListener changeListener) {
        if (this.isMyServiceRunning(context, VideoCallService.class)) {
            Intent videoIntent = new Intent(context.getApplicationContext(), FuguCallActivity.class);
            videoIntent.addFlags(0x10000000);
            videoIntent.addFlags(0x800000);
            context.startActivity(videoIntent);
            if (changeListener != null) {
                changeListener.onScreenStatus(true);
            }
        } else if (changeListener != null) {
            changeListener.onScreenStatus(false);
        }
    }

    public void sendCustomData(Context context, CustomDataAttributes data) {
        if (this.updateView == null) {
            try {
                Intent videoCallIntent = new Intent("hippo_video_call_intent");
                videoCallIntent.putExtra("custom_data", "CUSTOM_DATA");
                JSONObject json = new JSONObject();
                json.put("unique_id", (Object)data.getUniqueId());
                json.put("flag", (Object)data.getFlag());
                if (!TextUtils.isEmpty((CharSequence)data.getMessage())) {
                    json.put("message", (Object)data.getMessage());
                }
                videoCallIntent.putExtra("data", json.toString());
                LocalBroadcastManager.getInstance((Context)context).sendBroadcast(videoCallIntent);
            }
            catch (Exception videoCallIntent) {}
        } else {
            try {
                JSONObject json = new JSONObject();
                json.put("unique_id", (Object)data.getUniqueId());
                json.put("flag", (Object)data.getFlag());
                if (!TextUtils.isEmpty((CharSequence)data.getMessage())) {
                    json.put("message", (Object)data.getMessage());
                }
                this.updateView.sendCustomData(json);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void setHippoCallPushIcon(int hippoCallPushIcon) {
        this.hippoCallPushIcon = hippoCallPushIcon;
    }

    public int getHippoCallPushIcon() {
        return this.hippoCallPushIcon;
    }

    protected Fragment getFragment() {
        return this.fragment;
    }

    protected FayeClient getClient() {
        return this.mClient;
    }

    protected boolean isMyServiceRunning(Context context, Class<?> serviceClass) {
        ActivityManager manager = (ActivityManager)context.getSystemService("activity");
        for (ActivityManager.RunningServiceInfo service : manager.getRunningServices(Integer.MAX_VALUE)) {
            if (!serviceClass.getName().equals(service.service.getClassName())) continue;
            return true;
        }
        return false;
    }

    private StringAttributes getScreenString() {
        StringAttributes attributes = new StringAttributes.Builder().setAndString("and").setMuteString("sound mute").setCameraOffString("camera closed").setVideoPaused("Video paused").showUserName(true).build();
        return attributes;
    }
}

