/*
 * Decompiled with CFR 0.152.
 */
package com.hippo.aws;

import android.os.AsyncTask;
import com.hippo.aws.AsyncTaskResult;
import com.hippo.aws.ImageUploadInterface;
import java.io.File;
import java.util.Arrays;
import java.util.concurrent.TimeUnit;
import okhttp3.ConnectionSpec;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;

public class UploadTask
extends AsyncTask<String, Void, AsyncTaskResult<Void>> {
    private static final int NETWORK_TIMEOUT_SEC = 60;
    private final String imagePath;
    private final String url;
    private final ImageUploadInterface imageUploadInterface;
    private File file;

    public UploadTask(String url, String imagePath, File file, ImageUploadInterface imageUploadInterface) {
        this.url = url;
        this.imagePath = imagePath;
        this.imageUploadInterface = imageUploadInterface;
        this.file = file;
    }

    protected AsyncTaskResult doInBackground(String ... params) {
        try {
            Request uploadFileRequest;
            OkHttpClient client;
            Response uploadResponse;
            if (this.file == null) {
                this.file = new File(this.imagePath);
            }
            if (!(uploadResponse = (client = new OkHttpClient.Builder().connectionSpecs(Arrays.asList(ConnectionSpec.MODERN_TLS, ConnectionSpec.CLEARTEXT)).connectTimeout(60L, TimeUnit.SECONDS).readTimeout(60L, TimeUnit.SECONDS).writeTimeout(60L, TimeUnit.SECONDS).build()).newCall(uploadFileRequest = new Request.Builder().url(this.url).put(RequestBody.create((MediaType)MediaType.parse((String)""), (File)this.file)).build()).execute()).isSuccessful()) {
                return new AsyncTaskResult(new Exception("Upload file response code: " + uploadResponse.code()));
            }
            return new AsyncTaskResult(null);
        }
        catch (Exception e) {
            return new AsyncTaskResult(e);
        }
    }

    protected void onPostExecute(AsyncTaskResult result) {
        super.onPostExecute((Object)result);
        if (result.hasError()) {
            if (this.imageUploadInterface != null) {
                this.imageUploadInterface.failureUpload(result.getError());
            }
        } else if (this.imageUploadInterface != null) {
            this.imageUploadInterface.sucessfullupload();
        }
    }
}

