/*
 * Decompiled with CFR 0.152.
 */
package com.hippo.activity;

import android.app.Activity;
import android.content.Context;
import android.content.DialogInterface;
import android.graphics.Bitmap;
import android.net.UrlQuerySanitizer;
import android.os.Build;
import android.os.Bundle;
import android.os.Handler;
import android.os.Message;
import android.text.TextUtils;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.webkit.JsResult;
import android.webkit.WebChromeClient;
import android.webkit.WebResourceRequest;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import android.widget.ImageView;
import android.widget.ProgressBar;
import android.widget.RelativeLayout;
import android.widget.TextView;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.fragment.app.DialogFragment;
import com.google.gson.Gson;
import com.hippo.HippoColorConfig;
import com.hippo.HippoConfig;
import com.hippo.R;
import com.hippo.activity.FuguChatActivity;
import com.hippo.activity.PrePaymentActivity;
import com.hippo.database.CommonData;
import com.hippo.langs.Restring;
import com.hippo.model.MakePayment;
import com.hippo.model.PaymentResponse;
import com.hippo.model.payment.AddedPaymentGateway;
import com.hippo.payment.PaymentConstants;
import com.hippo.payment.RazorPayData;
import com.hippo.retrofit.APIError;
import com.hippo.retrofit.ResponseResolver;
import com.hippo.retrofit.RestClient;
import com.hippo.utils.HippoLog;
import com.hippo.utils.UniqueIMEIID;
import com.hippo.utils.loadingBox.ProgressWheel;
import com.razorpay.Checkout;
import org.json.JSONObject;
import retrofit2.Callback;

public class PaymentDialogFragment
extends DialogFragment {
    private RelativeLayout rootToolbar;
    private ImageView ivBackBtn;
    private TextView tvToolbarName;
    private RelativeLayout loadingLayout;
    private ProgressWheel progressWheel;
    private TextView textView;
    private MakePayment paymentData;
    private ProgressBar pbWebPageLoader;
    private WebView webView;
    private HippoColorConfig hippoColorConfig;
    private FuguChatActivity chatActivity;
    private PrePaymentActivity paymentActivity;
    public OnInputListener onInputListener;
    private AddedPaymentGateway paymentGateway;
    String url = "";
    boolean directOpen = false;

    static PaymentDialogFragment newInstance(String url, String paymentData, AddedPaymentGateway paymentGateway) {
        PaymentDialogFragment fragment = new PaymentDialogFragment();
        Bundle bundle = new Bundle();
        bundle.putString("url", url);
        bundle.putString("paymentData", paymentData);
        bundle.putBoolean("fullScreen", true);
        bundle.putString("paymentGateway", new Gson().toJson((Object)paymentGateway));
        bundle.putBoolean("direct_open", false);
        if (!TextUtils.isEmpty((CharSequence)url)) {
            bundle.putBoolean("direct_open", true);
        }
        fragment.setArguments(bundle);
        return fragment;
    }

    @Nullable
    public View onCreateView(@NonNull LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        this.getDialog().getWindow().setSoftInputMode(16);
        return inflater.inflate(R.layout.activity_webview, container, false);
    }

    public void onViewCreated(@NonNull View view, @Nullable Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);
        String title = Restring.getString((Context)this.getActivity(), R.string.fugu_payment);
        this.rootToolbar = (RelativeLayout)view.findViewById(R.id.my_toolbar);
        this.tvToolbarName = (TextView)view.findViewById(R.id.tv_toolbar_name);
        this.ivBackBtn = (ImageView)view.findViewById(R.id.ivBackBtn);
        this.loadingLayout = (RelativeLayout)view.findViewById(R.id.loadingLayout);
        this.progressWheel = (ProgressWheel)view.findViewById(R.id.circle_progress);
        this.textView = (TextView)view.findViewById(R.id.text);
        String text = Restring.getString((Context)this.getActivity(), R.string.hippo_payment_loader);
        this.textView.setText((CharSequence)text);
        this.hippoColorConfig = CommonData.getColorConfig();
        this.rootToolbar.setBackgroundColor(this.hippoColorConfig.getHippoActionBarBg());
        this.tvToolbarName.setTextColor(this.hippoColorConfig.getHippoActionBarText());
        this.tvToolbarName.setText((CharSequence)title);
        this.pbWebPageLoader = (ProgressBar)view.findViewById(R.id.pbWebPageLoader);
        this.webView = (WebView)view.findViewById(R.id.webView);
        if (!this.directOpen && this.paymentGateway.getGatewayId() == 1 && !TextUtils.isEmpty((CharSequence)this.paymentGateway.getKeyId())) {
            this.paymentData.setIsSdkFlow(1);
        } else {
            this.setWebViewProperties(this.webView);
            this.webView.setWebViewClient((WebViewClient)new MyWebViewClient());
        }
        try {
            this.getActivity().getWindow().setSoftInputMode(16);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.ivBackBtn.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (PaymentDialogFragment.this.onInputListener != null) {
                    PaymentDialogFragment.this.onInputListener.closeFragment();
                }
                PaymentDialogFragment.this.dismiss();
            }
        });
        if (!TextUtils.isEmpty((CharSequence)this.url)) {
            this.handleLayout(1);
            this.webView.loadUrl(this.url);
        } else {
            this.handleLayout(0);
            this.createPaymentLink(this.paymentData);
        }
    }

    private void handleLayout(int value) {
        if (value == 0) {
            this.loadingLayout.setVisibility(0);
            this.webView.setVisibility(8);
        } else if (value == 2) {
            this.progressWheel.setVisibility(8);
            String text = Restring.getString((Context)this.getActivity(), R.string.hippo_something_went_wrong);
            this.textView.setText((CharSequence)text);
        } else {
            this.loadingLayout.setVisibility(8);
            this.webView.setVisibility(0);
        }
    }

    private void setWebViewProperties(final WebView webView) {
        webView.setWebViewClient((WebViewClient)new MyWebViewClient());
        webView.setWebChromeClient(new WebChromeClient());
        webView.getSettings().setLoadsImagesAutomatically(true);
        webView.getSettings().setJavaScriptEnabled(true);
        webView.getSettings().setDomStorageEnabled(true);
        webView.setScrollBarStyle(0);
        webView.getSettings().setJavaScriptCanOpenWindowsAutomatically(true);
        webView.getSettings().setSupportMultipleWindows(true);
        if (Build.VERSION.SDK_INT >= 21) {
            webView.getSettings().setMixedContentMode(0);
        }
        webView.getSettings().setAllowFileAccessFromFileURLs(true);
        webView.getSettings().setAllowUniversalAccessFromFileURLs(true);
        webView.getSettings().setAllowFileAccess(true);
        webView.getSettings().setAllowContentAccess(true);
        webView.getSettings().setLightTouchEnabled(true);
        webView.setWebChromeClient(new WebChromeClient(){

            public boolean onCreateWindow(WebView view, boolean dialog, boolean userGesture, Message resultMsg) {
                WebView newView = new WebView((Context)PaymentDialogFragment.this.getActivity());
                newView.setLayoutParams((ViewGroup.LayoutParams)new RelativeLayout.LayoutParams(-1, -1));
                if ((long)PaymentDialogFragment.this.paymentGateway.getGatewayId().intValue() == PaymentConstants.PaymentValue.RAZORPAY.intValue) {
                    webView.addView((View)newView);
                }
                if ((long)PaymentDialogFragment.this.paymentGateway.getGatewayId().intValue() == PaymentConstants.PaymentValue.RAZORPAY.intValue) {
                    PaymentDialogFragment.this.setWebViewProperties(newView);
                } else {
                    PaymentDialogFragment.this.setWebViewProperties(webView);
                }
                WebView.WebViewTransport transport = (WebView.WebViewTransport)resultMsg.obj;
                transport.setWebView(newView);
                resultMsg.sendToTarget();
                return true;
            }

            public void onCloseWindow(WebView window) {
                HippoLog.e("onCloseWindow", window + "");
                webView.removeView((View)window);
                super.onCloseWindow(window);
            }

            public boolean onJsAlert(WebView view, String url, String message, JsResult result) {
                HippoLog.e("URL onJsAlert", url + "");
                return super.onJsAlert(view, url, message, result);
            }
        });
    }

    public void onAttach(Context context) {
        super.onAttach(context);
        try {
            this.onInputListener = (OnInputListener)this.getActivity();
        }
        catch (ClassCastException e) {
            HippoLog.e("TAG", "onAttach: " + e.getMessage());
        }
        if (this.getActivity() instanceof FuguChatActivity) {
            this.chatActivity = (FuguChatActivity)this.getActivity();
        } else if (this.getActivity() instanceof PrePaymentActivity) {
            this.paymentActivity = (PrePaymentActivity)this.getActivity();
        }
    }

    public void onResume() {
        super.onResume();
    }

    public void onDismiss(DialogInterface dialog) {
        if (this.onInputListener != null) {
            this.onInputListener.closeFragment();
        }
        super.onDismiss(dialog);
    }

    public void onClick(View v) {
        if (v.getId() == R.id.ivBackBtn) {
            // empty if block
        }
    }

    public void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.url = this.getArguments().getString("url");
        this.directOpen = this.getArguments().getBoolean("direct_open");
        this.paymentData = (MakePayment)new Gson().fromJson(this.getArguments().getString("paymentData"), MakePayment.class);
        this.paymentGateway = (AddedPaymentGateway)new Gson().fromJson(this.getArguments().getString("paymentGateway"), AddedPaymentGateway.class);
        HippoLog.e("URL", "URL = " + this.url);
        this.setStyle(0, R.style.FullScreenDialogStyle);
    }

    public void onDestroyView() {
        super.onDestroyView();
    }

    private boolean onOverrideUrlLoading(WebView view, String url) {
        HippoLog.e("loaded URL", url + " <<<<<<<<<<<<<<<<<<<<<<<<<<<<");
        UrlQuerySanitizer sanitizer = new UrlQuerySanitizer(url);
        String transactionId = "";
        String jobPaymentDetailId = "";
        if ((long)this.paymentGateway.getGatewayId().intValue() == PaymentConstants.PaymentValue.RAZORPAY.intValue) {
            transactionId = sanitizer.getValue("rzp_payment_id");
        } else if ((long)this.paymentGateway.getGatewayId().intValue() == PaymentConstants.PaymentValue.BILLPLZ.intValue) {
            transactionId = sanitizer.getValue("billplz[id]");
        } else if ((long)this.paymentGateway.getGatewayId().intValue() == PaymentConstants.PaymentValue.PAYFORT.intValue) {
            transactionId = sanitizer.getValue("transactionId");
            jobPaymentDetailId = sanitizer.getValue("job_payment_detail_id");
        } else {
            transactionId = sanitizer.getValue("transactionId") != null ? sanitizer.getValue("transactionId") : sanitizer.getValue("transaction_id");
        }
        try {
            if (url.startsWith("http:") || url.startsWith("https:")) {
                view.loadUrl(url);
                if (url.contains("success.html") || url.contains("Success.html")) {
                    new Handler().postDelayed(new Runnable(){

                        @Override
                        public void run() {
                            PaymentDialogFragment.this.dismiss();
                        }
                    }, 2500L);
                } else if (url.contains("error.html")) {
                    new Handler().postDelayed(new Runnable(){

                        @Override
                        public void run() {
                            PaymentDialogFragment.this.dismiss();
                        }
                    }, 2500L);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return true;
    }

    private void createPaymentLink(MakePayment makePayment) {
        makePayment.setPayment_gateway_id(this.paymentGateway.getGatewayId());
        makePayment.setIs_multi_gateway_flow(1);
        makePayment.setDevice_details(CommonData.deviceDetailString((Context)this.getActivity()));
        makePayment.setApp_version(265);
        makePayment.setDevice_id(UniqueIMEIID.getUniqueIMEIId((Context)this.getActivity()));
        makePayment.setSource_type(1);
        makePayment.setDevice_type(1);
        if (!TextUtils.isEmpty((CharSequence)HippoConfig.getInstance().getCurrentLanguage())) {
            makePayment.setLang(HippoConfig.getInstance().getCurrentLanguage());
        }
        RestClient.getApiInterface().createPaymentLink(makePayment).enqueue((Callback)new ResponseResolver<PaymentResponse>((Activity)this.getActivity(), Boolean.valueOf(false), Boolean.valueOf(true)){

            @Override
            public void success(PaymentResponse response) {
                if (!TextUtils.isEmpty((CharSequence)response.getData().getOrderId())) {
                    RazorPayData options = new RazorPayData();
                    options.setCurrency(response.getData().getCurrency());
                    options.setDescription(response.getData().getDescription());
                    options.setPhoneNo(response.getData().getPhoneNumber());
                    options.setAmount(response.getData().getAmount());
                    options.setUserEmail(response.getData().getUserEmail());
                    options.setName(response.getData().getName());
                    options.setAuthOrderId(response.getData().getAuth_order_id());
                    options.setReferenceId(response.getData().getReference_id());
                    PaymentDialogFragment.this.startRazorPayPayment(options, response.getData().getApiKey());
                } else if (!TextUtils.isEmpty((CharSequence)response.getData().getPaymentUrl())) {
                    PaymentDialogFragment.this.handleLayout(1);
                    PaymentDialogFragment.this.webView.loadUrl(response.getData().getPaymentUrl());
                } else {
                    PaymentDialogFragment.this.handleLayout(2);
                }
            }

            @Override
            public void failure(APIError error) {
                PaymentDialogFragment.this.handleLayout(2);
            }
        });
    }

    private void startRazorPayPayment(RazorPayData options, String apiKey) {
        try {
            Checkout checkout = new Checkout();
            checkout.setKeyID(apiKey);
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("order_id", (Object)options.getOrderId());
            jsonObject.put("phone_no", (Object)options.getPhoneNo());
            jsonObject.put("user_email", (Object)options.getUserEmail());
            jsonObject.put("description", (Object)options.getDescription());
            jsonObject.put("amount", options.getAmount());
            jsonObject.put("currency", (Object)options.getCurrency());
            jsonObject.put("name", (Object)options.getName());
            if (!TextUtils.isEmpty((CharSequence)options.getUserEmail())) {
                jsonObject.put("prefill.email", (Object)options.getUserEmail());
            }
            if (!TextUtils.isEmpty((CharSequence)options.getPhoneNo())) {
                jsonObject.put("prefill.contact", (Object)options.getPhoneNo());
            }
            jsonObject.put("prefill.method", (Object)"upi");
            jsonObject.put("prefill.vpa", (Object)"");
            this.startRazorPayPayment((Activity)this.getActivity(), jsonObject, apiKey);
        }
        catch (Exception e) {
            e.printStackTrace();
            Gson gson = new Gson();
            JSONObject jObj = new JSONObject();
            try {
                jObj = new JSONObject(gson.toJson((Object)options, RazorPayData.class));
            }
            catch (Exception e1) {
                e1.printStackTrace();
            }
            this.startRazorPayPayment((Activity)this.getActivity(), jObj, apiKey);
        }
    }

    private void startRazorPayPayment(Activity activity, JSONObject options, String apiKeys) {
        Checkout checkout = new Checkout();
        checkout.setKeyID(apiKeys);
        try {
            options.remove("auth_order_id");
            options.put("prefill.email", (Object)options.remove("user_email").toString());
            options.put("prefill.contact", (Object)options.remove("phone_no").toString());
            options.put("prefill.method", (Object)"upi");
            options.put("prefill.vpa", (Object)"");
            Log.i((String)"RazorpayBaseActivity", (String)("startRazorPayPayment options= " + options));
            checkout.setFullScreenDisable(true);
            checkout.open(activity, options);
            this.loadingLayout.setVisibility(8);
        }
        catch (Exception e) {
            e.printStackTrace();
            Log.e((String)"TAG", (String)"Error in starting Razorpay Checkout");
        }
    }

    private class MyWebViewClient
    extends WebViewClient {
        private MyWebViewClient() {
        }

        public boolean shouldOverrideUrlLoading(WebView view, WebResourceRequest request) {
            if (Build.VERSION.SDK_INT >= 21) {
                return PaymentDialogFragment.this.onOverrideUrlLoading(view, request.getUrl().toString());
            }
            return true;
        }

        public boolean shouldOverrideUrlLoading(WebView view, String url) {
            return PaymentDialogFragment.this.onOverrideUrlLoading(view, url);
        }

        public void onPageStarted(WebView view, String url, Bitmap favicon) {
            super.onPageStarted(view, url, favicon);
        }

        public void onPageFinished(WebView view, String url) {
            try {
                if (PaymentDialogFragment.this.pbWebPageLoader != null) {
                    PaymentDialogFragment.this.pbWebPageLoader.setVisibility(4);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            super.onPageFinished(view, url);
        }
    }

    public static interface OnInputListener {
        public void closeFragment();
    }
}

