/*
 * Decompiled with CFR 0.152.
 */
package com.hippo.adapter;

import android.content.Context;
import android.text.TextUtils;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.RatingBar;
import android.widget.RelativeLayout;
import android.widget.TextView;
import androidx.annotation.NonNull;
import androidx.appcompat.widget.AppCompatImageView;
import androidx.appcompat.widget.AppCompatTextView;
import androidx.cardview.widget.CardView;
import androidx.core.content.ContextCompat;
import androidx.recyclerview.widget.RecyclerView;
import com.bumptech.glide.Glide;
import com.bumptech.glide.load.Transformation;
import com.bumptech.glide.load.engine.DiskCacheStrategy;
import com.bumptech.glide.request.BaseRequestOptions;
import com.bumptech.glide.request.RequestOptions;
import com.hippo.R;
import com.hippo.adapter.AgentViewListener;
import com.hippo.adapter.OnRecyclerListener;
import com.hippo.model.Message;
import com.hippo.utils.RoundedCornersTransformation;
import com.hippo.utils.showmoretextview.ShowMoreTextView;

public class AgentSnapAdapter
extends RecyclerView.Adapter<ViewHolder>
implements OnRecyclerListener {
    private Context mContext;
    private LayoutInflater mLayoutInflater;
    private AgentViewListener viewListener;
    private OnRecyclerListener itemClickListener;
    private Message message;

    public AgentSnapAdapter(Context mContext, Message message, AgentViewListener viewListener) {
        this.mContext = mContext;
        this.viewListener = viewListener;
        this.message = message;
        this.itemClickListener = this.itemClickListener;
        this.mLayoutInflater = LayoutInflater.from((Context)mContext);
    }

    @NonNull
    public ViewHolder onCreateViewHolder(@NonNull ViewGroup viewGroup, int i) {
        return new ViewHolder(this.mLayoutInflater.inflate(R.layout.hippo_agent_snap_itam, viewGroup, false), this);
    }

    public long getItemId(int position) {
        try {
            return Integer.parseInt(this.message.getContentValue().get(position).getCardId());
        }
        catch (NumberFormatException e) {
            return position;
        }
    }

    public void onBindViewHolder(@NonNull ViewHolder viewHolder, int pos) {
        viewHolder.agentName.setText((CharSequence)this.message.getContentValue().get(pos).getTitle());
        String desc = this.message.getContentValue().get(pos).getDescription();
        if (pos == 0) {
            viewHolder.fakeView.setVisibility(0);
        } else {
            viewHolder.fakeView.setVisibility(8);
        }
        if (TextUtils.isEmpty((CharSequence)desc)) {
            viewHolder.userSubCategory.setVisibility(8);
        } else {
            viewHolder.userSubCategory.setVisibility(0);
            viewHolder.userSubCategory.setText(desc);
        }
        try {
            if (!TextUtils.isEmpty((CharSequence)this.message.getContentValue().get(pos).getRatingValue())) {
                viewHolder.starLayout.setVisibility(0);
                viewHolder.starText.setText((CharSequence)("" + this.message.getContentValue().get(pos).getRatingValue()));
            } else {
                viewHolder.starLayout.setVisibility(8);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            viewHolder.starLayout.setVisibility(8);
        }
        RequestOptions myOptions = (RequestOptions)((RequestOptions)((RequestOptions)((RequestOptions)((RequestOptions)RequestOptions.bitmapTransform((Transformation)new RoundedCornersTransformation(this.mContext, 4, 1)).placeholder(ContextCompat.getDrawable((Context)this.mContext, (int)R.drawable.hippo_placeholder))).fitCenter()).dontAnimate()).diskCacheStrategy(DiskCacheStrategy.ALL)).error(ContextCompat.getDrawable((Context)this.mContext, (int)R.drawable.hippo_placeholder));
        Glide.with((Context)this.mContext).load(this.message.getContentValue().get(pos).getImageUrl()).apply((BaseRequestOptions)myOptions).into((ImageView)viewHolder.userImageView);
    }

    public int getItemCount() {
        int size = 0;
        if (this.message != null && this.message.getContentValue() != null) {
            size = this.message.getContentValue().size();
        }
        return size;
    }

    @Override
    public void onItemClick(View viewClicked, View parentView, int position) {
    }

    @Override
    public void onItemClick(View parentView, int position) {
    }

    @Override
    public void onItemLongClick(View viewClicked, View parentView, int position, boolean isRightConcent) {
    }

    public class ViewHolder
    extends RecyclerView.ViewHolder {
        private CardView cardview;
        private AppCompatImageView userImageView;
        private AppCompatTextView agentName;
        private ShowMoreTextView userSubCategory;
        private View fakeView;
        private RatingBar ratingBar;
        private RelativeLayout starLayout;
        private TextView starText;
        private ImageView info;
        private LinearLayout info_layout;

        public ViewHolder(View itemView, OnRecyclerListener itemClickListener) {
            super(itemView);
            this.cardview = (CardView)itemView.findViewById(R.id.cardView);
            this.userImageView = (AppCompatImageView)itemView.findViewById(R.id.userImage);
            this.agentName = (AppCompatTextView)itemView.findViewById(R.id.agentName);
            this.ratingBar = (RatingBar)itemView.findViewById(R.id.ratingBar2);
            this.starLayout = (RelativeLayout)itemView.findViewById(R.id.starLayout);
            this.starText = (TextView)itemView.findViewById(R.id.starText);
            this.userSubCategory = (ShowMoreTextView)itemView.findViewById(R.id.agentDesc);
            this.userSubCategory.setShowingLine(2);
            this.info = (ImageView)itemView.findViewById(R.id.info);
            this.info_layout = (LinearLayout)itemView.findViewById(R.id.info_layout);
            this.fakeView = itemView.findViewById(R.id.fakeView);
            this.userSubCategory.setVisibility(8);
            this.cardview.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    if (AgentSnapAdapter.this.viewListener != null) {
                        String userId = AgentSnapAdapter.this.message.getContentValue().get(ViewHolder.this.getAdapterPosition()).getCardId();
                        AgentSnapAdapter.this.viewListener.onCardClickListener(AgentSnapAdapter.this.message, userId, ViewHolder.this.getAdapterPosition());
                    }
                }
            });
            this.info_layout.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    if (AgentSnapAdapter.this.viewListener != null) {
                        String userId = AgentSnapAdapter.this.message.getContentValue().get(ViewHolder.this.getAdapterPosition()).getCardId();
                        AgentSnapAdapter.this.viewListener.onShowProfile(AgentSnapAdapter.this.message, userId, ViewHolder.this.getAdapterPosition());
                    }
                }
            });
        }
    }
}

