/*
 * Decompiled with CFR 0.152.
 */
package com.hippo.utils;

import android.app.Activity;
import android.text.TextUtils;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.hippo.HippoConfig;
import com.hippo.UnreadCountFor;
import com.hippo.database.CommonData;
import com.hippo.helper.P2pUnreadCount;
import com.hippo.model.FuguConversation;
import com.hippo.model.FuguGetConversationsResponse;
import com.hippo.model.HippoUnreadCountParams;
import com.hippo.model.UnreadCountResponse;
import com.hippo.retrofit.APIError;
import com.hippo.retrofit.CommonParams;
import com.hippo.retrofit.ResponseResolver;
import com.hippo.retrofit.RestClient;
import com.hippo.utils.HippoLog;
import com.hippo.utils.UnreadCount;
import java.util.ArrayList;
import retrofit2.Callback;

public class UnreadCountApi {
    private ArrayList<FuguConversation> fuguConversationList = new ArrayList();

    public void getConversations(Activity activity, String enUserId) {
        try {
            if (CommonData.getHasUnreadCount()) {
                int count = CommonData.getTotalUnreadCount();
                System.out.println("from saved count = " + count);
                HippoLog.e("count", "from saved count = " + count);
                if (HippoConfig.getInstance().getCallbackListener() != null) {
                    HippoConfig.getInstance().getCallbackListener().count(count);
                }
                return;
            }
        }
        catch (Exception count) {
            // empty catch block
        }
        CommonParams commonParams = new CommonParams.Builder().add("app_secret_key", HippoConfig.getInstance().getAppKey()).add("en_user_id", enUserId).add("app_version", 263).add("device_type", 1).build();
        RestClient.getApiInterface().getConversations(commonParams.getMap()).enqueue((Callback)new ResponseResolver<FuguGetConversationsResponse>(activity, Boolean.valueOf(false), Boolean.valueOf(false)){

            @Override
            public void success(FuguGetConversationsResponse fuguGetConversationsResponse) {
                try {
                    UnreadCountApi.this.fuguConversationList.clear();
                    UnreadCountApi.this.fuguConversationList.addAll(fuguGetConversationsResponse.getData().getFuguConversationList());
                    new UnreadCount().execute(new ArrayList[]{UnreadCountApi.this.fuguConversationList});
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }

            @Override
            public void failure(APIError error) {
            }
        });
    }

    public void getChannelUnreadCount(Activity activity, String enUserId, final String transactionId, String userUniqueKey, ArrayList<String> otherUserUniqueKeys, final UnreadCountFor countUnread) {
        CommonParams commonParams = new CommonParams.Builder().add("app_secret_key", HippoConfig.getInstance().getAppKey()).add("en_user_id", enUserId).add("user_unique_key", userUniqueKey).add("other_user_unique_key", otherUserUniqueKeys).add("transaction_id", transactionId).add("app_version", 263).add("device_type", 1).build();
        Gson gson = new GsonBuilder().create();
        JsonArray otherUsersArray = null;
        if (otherUserUniqueKeys != null) {
            otherUsersArray = gson.toJsonTree(otherUserUniqueKeys).getAsJsonArray();
        }
        HippoUnreadCountParams params = new HippoUnreadCountParams(HippoConfig.getInstance().getAppKey(), transactionId, userUniqueKey, otherUsersArray, enUserId);
        if (!TextUtils.isEmpty((CharSequence)HippoConfig.getInstance().getCurrentLanguage())) {
            params.setLang(HippoConfig.getInstance().getCurrentLanguage());
        }
        try {
            P2pUnreadCount.INSTANCE.removeTransactionId(transactionId);
            P2pUnreadCount.INSTANCE.setLocalTransactionId(transactionId, otherUserUniqueKeys.get(0));
        }
        catch (Exception exception) {
            // empty catch block
        }
        RestClient.getApiInterface().fetchUnreadCountFor(params).enqueue((Callback)new ResponseResolver<UnreadCountResponse>(activity, Boolean.valueOf(false), Boolean.valueOf(false)){

            @Override
            public void success(UnreadCountResponse response) {
                try {
                    int count = response.getData().getUnreadCount();
                    Long channelId = response.getData().getChannelId();
                    if (countUnread != null) {
                        countUnread.unreadCountFor(transactionId, count);
                    }
                    P2pUnreadCount.INSTANCE.updateChannelId(transactionId, channelId, count, "");
                }
                catch (Exception e) {
                    e.printStackTrace();
                    P2pUnreadCount.INSTANCE.updateChannelId(transactionId, -2L, 0, "");
                }
            }

            @Override
            public void failure(APIError error) {
                P2pUnreadCount.INSTANCE.updateChannelId(transactionId, -2L, 0, "");
            }
        });
    }

    public static interface CountUnread {
        public void countValue(int var1);
    }
}

