/*
 * Decompiled with CFR 0.152.
 */
package com.hippo.activity;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.graphics.Bitmap;
import android.os.Build;
import android.os.Bundle;
import android.os.Message;
import android.text.TextUtils;
import android.util.Log;
import android.view.View;
import android.view.ViewGroup;
import android.webkit.JsResult;
import android.webkit.WebChromeClient;
import android.webkit.WebResourceRequest;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import android.widget.ImageView;
import android.widget.ProgressBar;
import android.widget.RelativeLayout;
import android.widget.TextView;
import com.google.gson.Gson;
import com.hippo.HippoColorConfig;
import com.hippo.HippoConfig;
import com.hippo.R;
import com.hippo.activity.FuguBaseActivity;
import com.hippo.activity.FuguChatActivity;
import com.hippo.database.CommonData;
import com.hippo.eventbus.BusProvider;
import com.hippo.fragment.PaymentCancelDialog;
import com.hippo.helper.BusEvents;
import com.hippo.helper.FayeMessage;
import com.hippo.langs.Restring;
import com.hippo.model.payment.AddedPaymentGateway;
import com.hippo.model.payment.PaymentListResponse;
import com.hippo.model.payment.PaymentUrl;
import com.hippo.model.payment.PrePaymentData;
import com.hippo.payment.PaymentConstants;
import com.hippo.payment.RazorPayData;
import com.hippo.retrofit.APIError;
import com.hippo.retrofit.ResponseResolver;
import com.hippo.retrofit.RestClient;
import com.hippo.utils.HippoLog;
import com.hippo.utils.loadingBox.ProgressWheel;
import com.razorpay.Checkout;
import com.razorpay.PaymentData;
import com.razorpay.PaymentResultWithDataListener;
import com.squareup.otto.Subscribe;
import faye.ConnectionManager;
import org.json.JSONObject;
import retrofit2.Callback;

public class PrePaymentActivity
extends FuguBaseActivity
implements PaymentResultWithDataListener {
    private RelativeLayout rootToolbar;
    private ImageView ivBackBtn;
    private TextView tvToolbarName;
    private RelativeLayout loadingLayout;
    private ProgressWheel progressWheel;
    private TextView textView;
    private ProgressBar pbWebPageLoader;
    private WebView webView;
    private HippoColorConfig hippoColorConfig;
    private FuguChatActivity chatActivity;
    private PrePaymentData paymentData;
    public OnInputListener onInputListener;
    private AddedPaymentGateway paymentGateway;
    String url = "";
    private String channelId;
    boolean btnClicked;

    public void onPaymentSuccess(String s, PaymentData paymentData) {
        if (HippoConfig.getInstance().getPrePaymentCallBack() != null) {
            HippoConfig.getInstance().getPrePaymentCallBack().onPaymentSuccess();
        }
        this.onSuccessActivity();
    }

    public void onPaymentError(int i, String s, PaymentData paymentData) {
        if (HippoConfig.getInstance().getPrePaymentCallBack() != null) {
            HippoConfig.getInstance().getPrePaymentCallBack().onPaymentfailed();
        }
        this.onFailureActivity();
    }

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.activity_pre_webview);
        String data = this.getIntent().getStringExtra("data");
        this.paymentData = (PrePaymentData)new Gson().fromJson(data, PrePaymentData.class);
        for (AddedPaymentGateway gateway : CommonData.getPaymentList()) {
            if (gateway.getGatewayId().intValue() != this.paymentData.getPayment_gateway_id()) continue;
            this.paymentGateway = gateway;
            break;
        }
        HippoLog.e("URL", "URL = " + this.url);
        String title = Restring.getString((Context)this, R.string.fugu_payment);
        this.rootToolbar = (RelativeLayout)this.findViewById(R.id.my_toolbar);
        this.tvToolbarName = (TextView)this.findViewById(R.id.tv_toolbar_name);
        this.ivBackBtn = (ImageView)this.findViewById(R.id.ivBackBtn);
        this.loadingLayout = (RelativeLayout)this.findViewById(R.id.loadingLayout);
        this.progressWheel = (ProgressWheel)this.findViewById(R.id.circle_progress);
        this.textView = (TextView)this.findViewById(R.id.text);
        String text = Restring.getString((Context)this, R.string.hippo_payment_loader);
        this.textView.setText((CharSequence)text);
        this.hippoColorConfig = CommonData.getColorConfig();
        this.rootToolbar.setBackgroundColor(this.hippoColorConfig.getHippoActionBarBg());
        this.tvToolbarName.setTextColor(this.hippoColorConfig.getHippoActionBarText());
        this.tvToolbarName.setText((CharSequence)title);
        this.pbWebPageLoader = (ProgressBar)this.findViewById(R.id.pbWebPageLoader);
        this.webView = (WebView)this.findViewById(R.id.webView);
        try {
            this.getWindow().setSoftInputMode(16);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.ivBackBtn.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                PrePaymentActivity.this.showDialog();
            }
        });
        this.setWebViewProperties(this.webView);
        this.webView.setWebViewClient((WebViewClient)new MyWebViewClient());
        String keyId = "";
        if (this.paymentData.getPayment_gateway_id() == 1 && this.paymentGateway != null && !TextUtils.isEmpty((CharSequence)this.paymentGateway.getKeyId())) {
            keyId = this.paymentGateway.getKeyId();
        }
        if (!TextUtils.isEmpty((CharSequence)keyId)) {
            this.paymentData.setIsSdkFlow(1);
            this.getChannelData(false);
            this.handleLayout(0);
        } else if (!TextUtils.isEmpty((CharSequence)this.url)) {
            this.handleLayout(1);
            this.webView.loadUrl(this.url);
        } else {
            this.handleLayout(0);
            this.getChannelData(false);
        }
    }

    protected void onStart() {
        super.onStart();
        BusProvider.getInstance().register((Object)this);
    }

    protected void onStop() {
        super.onStop();
        BusProvider.getInstance().unregister((Object)this);
    }

    protected void onDestroy() {
        super.onDestroy();
        if (!TextUtils.isEmpty((CharSequence)this.channelId)) {
            ConnectionManager.INSTANCE.unsubScribeChannel(this.channelId);
        }
    }

    public void onBackPressed() {
        this.showDialog();
    }

    private void handleLayout(int value) {
        if (value == 0) {
            this.loadingLayout.setVisibility(0);
            this.webView.setVisibility(8);
        } else if (value == 2) {
            this.progressWheel.setVisibility(8);
            String text = Restring.getString((Context)this, R.string.hippo_something_wentwrong);
            this.textView.setText((CharSequence)text);
        } else {
            this.loadingLayout.setVisibility(8);
            this.webView.setVisibility(0);
        }
    }

    private void setWebViewProperties(final WebView webView) {
        webView.setWebViewClient((WebViewClient)new MyWebViewClient());
        webView.setWebChromeClient(new WebChromeClient());
        webView.getSettings().setLoadsImagesAutomatically(true);
        webView.getSettings().setJavaScriptEnabled(true);
        webView.getSettings().setDomStorageEnabled(true);
        webView.setScrollBarStyle(0);
        webView.getSettings().setJavaScriptCanOpenWindowsAutomatically(true);
        webView.getSettings().setSupportMultipleWindows(true);
        if (Build.VERSION.SDK_INT >= 21) {
            webView.getSettings().setMixedContentMode(0);
        }
        webView.getSettings().setAllowFileAccessFromFileURLs(true);
        webView.getSettings().setAllowUniversalAccessFromFileURLs(true);
        webView.getSettings().setAllowFileAccess(true);
        webView.getSettings().setAllowContentAccess(true);
        webView.getSettings().setLightTouchEnabled(true);
        webView.setWebChromeClient(new WebChromeClient(){

            public boolean onCreateWindow(WebView view, boolean dialog, boolean userGesture, Message resultMsg) {
                WebView newView = new WebView((Context)PrePaymentActivity.this);
                newView.setLayoutParams((ViewGroup.LayoutParams)new RelativeLayout.LayoutParams(-1, -1));
                if ((long)PrePaymentActivity.this.paymentGateway.getGatewayId().intValue() == PaymentConstants.PaymentValue.RAZORPAY.intValue) {
                    webView.addView((View)newView);
                }
                if ((long)PrePaymentActivity.this.paymentGateway.getGatewayId().intValue() == PaymentConstants.PaymentValue.RAZORPAY.intValue) {
                    PrePaymentActivity.this.setWebViewProperties(newView);
                } else {
                    PrePaymentActivity.this.setWebViewProperties(webView);
                }
                WebView.WebViewTransport transport = (WebView.WebViewTransport)resultMsg.obj;
                transport.setWebView(newView);
                resultMsg.sendToTarget();
                return true;
            }

            public void onCloseWindow(WebView window) {
                HippoLog.e("onCloseWindow", window + "");
                webView.removeView((View)window);
                super.onCloseWindow(window);
            }

            public boolean onJsAlert(WebView view, String url, String message, JsResult result) {
                HippoLog.e("URL onJsAlert", url + "");
                return super.onJsAlert(view, url, message, result);
            }
        });
    }

    private boolean onOverrideUrlLoading(WebView view, String url) {
        try {
            if (url.startsWith("http:") || url.startsWith("https:")) {
                view.loadUrl(url);
                if (url.contains("success.html") || url.contains("Success.html")) {
                    if (HippoConfig.getInstance().getPrePaymentCallBack() != null) {
                        HippoConfig.getInstance().getPrePaymentCallBack().onPaymentSuccess();
                    }
                    this.onSuccessActivity();
                } else if (url.contains("error.html")) {
                    if (HippoConfig.getInstance().getPrePaymentCallBack() != null) {
                        HippoConfig.getInstance().getPrePaymentCallBack().onPaymentfailed();
                    }
                    this.onFailureActivity();
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return true;
    }

    private void getChannelData(Boolean loader) {
        if (!TextUtils.isEmpty((CharSequence)HippoConfig.getInstance().getCurrentLanguage())) {
            this.paymentData.setLang(HippoConfig.getInstance().getCurrentLanguage());
        }
        RestClient.getApiInterface().getPrePaymentMethod(this.paymentData).enqueue((Callback)new ResponseResolver<PaymentListResponse>((Activity)this, loader, Boolean.valueOf(true)){

            @Override
            public void success(PaymentListResponse paymentListResponse) {
                PrePaymentActivity.this.channelId = "/" + paymentListResponse.getData().getChannelId();
                PrePaymentActivity.this.subscribeChannels(PrePaymentActivity.this.channelId);
                if (!TextUtils.isEmpty((CharSequence)paymentListResponse.getData().getPaymentUrl().getOrderId())) {
                    PaymentUrl paymentUrl = new PaymentUrl();
                    paymentUrl = paymentListResponse.getData().getPaymentUrl();
                    RazorPayData options = new RazorPayData();
                    options.setOrderId(paymentUrl.getOrderId());
                    options.setCurrency(paymentUrl.getCurrency());
                    options.setDescription(paymentUrl.getDescription());
                    options.setPhoneNo(paymentUrl.getPhoneNumber());
                    options.setAmount(paymentUrl.getAmount());
                    options.setUserEmail(paymentUrl.getUserEmail());
                    options.setName(paymentUrl.getName());
                    options.setAuthOrderId(paymentUrl.getAuth_order_id());
                    options.setReferenceId(paymentUrl.getReference_id());
                    PrePaymentActivity.this.startRazorPayPayment(options, paymentUrl.getApiKey());
                } else if (!TextUtils.isEmpty((CharSequence)paymentListResponse.getData().getPaymentUrl().getPaymentUrl())) {
                    PrePaymentActivity.this.handleLayout(1);
                    PrePaymentActivity.this.webView.loadUrl(paymentListResponse.getData().getPaymentUrl().getPaymentUrl());
                } else {
                    PrePaymentActivity.this.handleLayout(2);
                }
            }

            @Override
            public void failure(APIError error) {
            }
        });
    }

    private void subscribeChannels(String channel) {
        ConnectionManager.INSTANCE.subScribeChannel(channel);
    }

    @Subscribe
    public void onFayeMessage(FayeMessage events) {
        if (!events.type.equalsIgnoreCase(BusEvents.CONNECTED_SERVER.toString())) {
            if (events.type.equalsIgnoreCase(BusEvents.RECEIVED_MESSAGE.toString())) {
                this.handleResponse(events.message, events.channelId);
            } else if (events.type.equalsIgnoreCase(BusEvents.PONG_RECEIVED.toString()) || events.type.equalsIgnoreCase(BusEvents.DISCONNECTED_SERVER.toString()) || events.type.equalsIgnoreCase(BusEvents.ERROR_RECEIVED.toString()) || events.type.equalsIgnoreCase(BusEvents.WEBSOCKET_ERROR.toString()) || events.type.equalsIgnoreCase(BusEvents.NOT_CONNECTED.toString())) {
                // empty if block
            }
        }
    }

    private void handleResponse(String message, String msgChannelId) {
        if (!this.isFinishing() && !TextUtils.isEmpty((CharSequence)msgChannelId) && !TextUtils.isEmpty((CharSequence)this.channelId) && msgChannelId.equalsIgnoreCase(this.channelId)) {
            try {
                JSONObject object = new JSONObject(message);
                if (object.optInt("message_type") == 22 && object.has("custom_action") && object.optJSONObject("custom_action").optInt("selected_id") > 0) {
                    if (HippoConfig.getInstance().getPrePaymentCallBack() != null) {
                        HippoConfig.getInstance().getPrePaymentCallBack().onPaymentSuccess();
                    }
                    this.onSuccessActivity();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private void showDialog() {
        PaymentCancelDialog bottomSheetFragment = PaymentCancelDialog.newInstance();
        bottomSheetFragment.show(this.getSupportFragmentManager(), bottomSheetFragment.getTag());
    }

    public void cancelPayment() {
        this.finish();
    }

    private synchronized void onSuccessActivity() {
        if (!this.btnClicked) {
            this.btnClicked = true;
            Intent intent = new Intent();
            intent.putExtra("status", 1);
            this.setResult(-1, intent);
            this.finish();
        }
    }

    private synchronized void onFailureActivity() {
        if (!this.btnClicked) {
            this.btnClicked = true;
            Intent intent = new Intent();
            intent.putExtra("status", 2);
            this.setResult(-1, intent);
            this.finish();
        }
    }

    private void startRazorPayPayment(RazorPayData options, String apiKey) {
        try {
            Checkout checkout = new Checkout();
            checkout.setKeyID(apiKey);
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("order_id", (Object)options.getOrderId());
            jsonObject.put("phone_no", (Object)options.getPhoneNo());
            jsonObject.put("user_email", (Object)options.getUserEmail());
            jsonObject.put("description", (Object)options.getDescription());
            jsonObject.put("amount", options.getAmount());
            jsonObject.put("currency", (Object)options.getCurrency());
            jsonObject.put("name", (Object)options.getName());
            if (!TextUtils.isEmpty((CharSequence)options.getUserEmail())) {
                jsonObject.put("prefill.email", (Object)options.getUserEmail());
            }
            if (!TextUtils.isEmpty((CharSequence)options.getPhoneNo())) {
                jsonObject.put("prefill.contact", (Object)options.getPhoneNo());
            }
            jsonObject.put("prefill.method", (Object)"");
            jsonObject.put("prefill.vpa", (Object)"");
            this.startRazorPayPayment((Activity)this, jsonObject, apiKey);
        }
        catch (Exception e) {
            e.printStackTrace();
            Gson gson = new Gson();
            JSONObject jObj = new JSONObject();
            try {
                jObj = new JSONObject(gson.toJson((Object)options, RazorPayData.class));
            }
            catch (Exception e1) {
                e1.printStackTrace();
            }
            this.startRazorPayPayment((Activity)this, jObj, apiKey);
        }
    }

    private void startRazorPayPayment(Activity activity, JSONObject options, String apiKeys) {
        Checkout checkout = new Checkout();
        checkout.setKeyID(apiKeys);
        try {
            options.remove("auth_order_id");
            if (options.has("user_email")) {
                options.put("prefill.email", (Object)options.remove("user_email").toString());
            }
            if (options.has("phone_no")) {
                options.put("prefill.contact", (Object)options.remove("phone_no").toString());
            }
            options.put("prefill.method", (Object)"");
            options.put("prefill.vpa", (Object)"");
            Log.i((String)"RazorpayBaseActivity", (String)("startRazorPayPayment options= " + options));
            checkout.setFullScreenDisable(true);
            checkout.open(activity, options);
        }
        catch (Exception e) {
            e.printStackTrace();
            Log.e((String)"TAG", (String)"Error in starting Razorpay Checkout");
        }
    }

    private class MyWebViewClient
    extends WebViewClient {
        private MyWebViewClient() {
        }

        public boolean shouldOverrideUrlLoading(WebView view, WebResourceRequest request) {
            if (Build.VERSION.SDK_INT >= 21) {
                return PrePaymentActivity.this.onOverrideUrlLoading(view, request.getUrl().toString());
            }
            return true;
        }

        public boolean shouldOverrideUrlLoading(WebView view, String url) {
            return PrePaymentActivity.this.onOverrideUrlLoading(view, url);
        }

        public void onPageStarted(WebView view, String url, Bitmap favicon) {
            super.onPageStarted(view, url, favicon);
        }

        public void onPageFinished(WebView view, String url) {
            try {
                if (PrePaymentActivity.this.pbWebPageLoader != null) {
                    PrePaymentActivity.this.pbWebPageLoader.setVisibility(4);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            super.onPageFinished(view, url);
        }
    }

    public static interface OnInputListener {
        public void closeFragment();
    }
}

