/*
 * Decompiled with CFR 0.152.
 */
package com.hippo.fragment;

import android.app.Activity;
import android.content.BroadcastReceiver;
import android.content.ComponentName;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.content.IntentFilter;
import android.graphics.PorterDuff;
import android.os.Bundle;
import android.text.TextUtils;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.RelativeLayout;
import android.widget.TextView;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.appcompat.app.AlertDialog;
import androidx.localbroadcastmanager.content.LocalBroadcastManager;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import androidx.swiperefreshlayout.widget.SwipeRefreshLayout;
import com.google.gson.Gson;
import com.hippo.DeeplinKData;
import com.hippo.HippoConfig;
import com.hippo.HippoConfigAttributes;
import com.hippo.MobileCampaignBuilder;
import com.hippo.NotificationListener;
import com.hippo.R;
import com.hippo.activity.BaseFragment;
import com.hippo.adapter.CampaignAdapter;
import com.hippo.apis.ApiGetMobileNotification;
import com.hippo.database.CommonData;
import com.hippo.interfaces.OnClearNotificationListener;
import com.hippo.interfaces.OnItemClickListener;
import com.hippo.langs.Restring;
import com.hippo.model.FuguConversation;
import com.hippo.model.FuguPutUserDetailsResponse;
import com.hippo.model.promotional.CustomAttributes;
import com.hippo.model.promotional.Data;
import com.hippo.model.promotional.PromotionResponse;
import com.hippo.utils.filepicker.ToastUtil;
import com.hippo.utils.swipetoshow.SwipeHolder;
import com.hippo.utils.swipetoshow.SwipeOnItemTouchAdapter;
import java.util.ArrayList;
import java.util.HashSet;
import org.json.JSONException;
import org.json.JSONObject;
import org.json.JSONTokener;

public class CampaignFragment
extends BaseFragment
implements OnItemClickListener,
SwipeRefreshLayout.OnRefreshListener {
    private static final String TAG = CampaignFragment.class.getSimpleName();
    private View rootView;
    private TextView tvToolbarName;
    private RelativeLayout myToolbar;
    private TextView delete;
    private SwipeRefreshLayout refreshLayout;
    private RecyclerView recyclerView;
    private CampaignAdapter campaignAdapter;
    private MobileCampaignBuilder campaignBuilder;
    private int startOffset = 0;
    private int offset = 20;
    private ArrayList<Data> arrayList = new ArrayList();
    private LinearLayoutManager layoutManager;
    private int pastVisiblesItems;
    private int visibleItemCount;
    private int totalItemCount;
    private boolean hasMorePages;
    private boolean isPagingApiInProgress;
    private TextView titleError;
    private ImageView ivBackBtn;
    private LinearLayout llNoNotifications;
    private BroadcastReceiver mMessageReceiverChat = new BroadcastReceiver(){

        public void onReceive(Context context, Intent intent) {
            try {
                JSONObject json = new JSONObject(intent.getStringExtra("message"));
                if (json.getInt("is_announcement_push") == 1) {
                    Data broadcast = new Data(Integer.parseInt(HippoConfig.getInstance().getUserData().getUserId().toString()));
                    broadcast.setChannelId(json.getInt("channel_id"));
                    broadcast.setCreatedAt(json.getString("date_time"));
                    broadcast.setDisableReply(json.getInt("disable_reply"));
                    broadcast.setDescription(json.getString("message"));
                    CustomAttributes attr2 = (CustomAttributes)new Gson().fromJson(json.getString("custom_attributes"), CustomAttributes.class);
                    broadcast.setCustomAttributes(attr2);
                    broadcast.setTitle(json.getString("title"));
                    broadcast.setAddedFromBroadcast(true);
                    if (CampaignFragment.this.arrayList == null) {
                        CampaignFragment.this.arrayList = new ArrayList();
                    }
                    CampaignFragment.this.arrayList.add(0, broadcast);
                    if (CampaignFragment.this.campaignAdapter != null) {
                        CampaignFragment.this.campaignAdapter.notifyDataSetChanged();
                    }
                }
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
        }
    };
    HippoConfigAttributes attributes;

    public void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
    }

    @Nullable
    public View onCreateView(@NonNull LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        this.rootView = inflater.inflate(R.layout.hippo_campaigns_layout, container, false);
        return this.rootView;
    }

    public void onAttach(Context context) {
        super.onAttach(context);
        HippoConfig.getInstance().setAnnouncementActivity(true);
    }

    public void onDestroy() {
        super.onDestroy();
        HippoConfig.getInstance().setAnnouncementActivity(false);
        LocalBroadcastManager.getInstance((Context)this.getActivity()).unregisterReceiver(this.mMessageReceiverChat);
    }

    public void onViewCreated(@NonNull View view, @Nullable Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);
        LocalBroadcastManager.getInstance((Context)this.getActivity()).registerReceiver(this.mMessageReceiverChat, new IntentFilter("notification_received"));
        this.campaignBuilder = HippoConfig.getInstance().getMobileCampaignBuilder();
        this.refreshLayout = (SwipeRefreshLayout)view.findViewById(R.id.swipe_refresh);
        this.titleError = (TextView)view.findViewById(R.id.title_error);
        this.recyclerView = (RecyclerView)view.findViewById(R.id.recyclerView);
        this.refreshLayout.setOnRefreshListener((SwipeRefreshLayout.OnRefreshListener)this);
        this.refreshLayout.setColorSchemeResources(new int[]{R.color.hippo_white});
        this.refreshLayout.setProgressBackgroundColorSchemeResource(R.color.fugu_theme_color_primary);
        this.refreshLayout.setSize(1);
        this.llNoNotifications = (LinearLayout)view.findViewById(R.id.llNoNotifications);
        this.myToolbar = (RelativeLayout)view.findViewById(R.id.my_toolbar);
        this.tvToolbarName = (TextView)view.findViewById(R.id.tv_toolbar_name);
        this.myToolbar.setBackgroundColor(CommonData.getColorConfig().getHippoActionBarBg());
        this.tvToolbarName.setTextColor(CommonData.getColorConfig().getHippoActionBarText());
        this.delete = (TextView)view.findViewById(R.id.deleteTxt);
        String title = Restring.getString((Context)this.getActivity(), R.string.hippo_notifications_title);
        String errorTxt = Restring.getString((Context)this.getActivity(), R.string.hippo_no_notifications);
        String clearText = Restring.getString((Context)this.getActivity(), R.string.hippo_clear_all_notification);
        if (this.campaignBuilder != null && !TextUtils.isEmpty((CharSequence)this.campaignBuilder.getNotificationTitle())) {
            title = this.campaignBuilder.getNotificationTitle();
        }
        if (this.campaignBuilder != null && !TextUtils.isEmpty((CharSequence)this.campaignBuilder.getEmptyNotificationText())) {
            errorTxt = this.campaignBuilder.getEmptyNotificationText();
        }
        if (this.campaignBuilder != null && !TextUtils.isEmpty((CharSequence)this.campaignBuilder.getClearText())) {
            clearText = this.campaignBuilder.getClearText();
        }
        this.tvToolbarName.setText((CharSequence)title);
        this.titleError.setText((CharSequence)errorTxt);
        this.delete.setText((CharSequence)clearText);
        this.delete.setTextColor(CommonData.getColorConfig().getHippoActionBarText());
        this.layoutManager = new LinearLayoutManager(this.getContext());
        this.layoutManager.setOrientation(1);
        this.recyclerView.setLayoutManager((RecyclerView.LayoutManager)this.layoutManager);
        boolean hideImahe = false;
        if (this.campaignBuilder != null && this.campaignBuilder.isHideDownloadBtn()) {
            hideImahe = true;
        }
        String clear = "";
        if (this.campaignBuilder != null && !TextUtils.isEmpty((CharSequence)this.campaignBuilder.getClearBtn())) {
            clear = this.campaignBuilder.getClearBtn();
        }
        this.campaignAdapter = new CampaignAdapter((Activity)this.getActivity(), this, null, this.recyclerView, this, hideImahe, clear);
        this.recyclerView.setAdapter((RecyclerView.Adapter)this.campaignAdapter);
        this.ivBackBtn = (ImageView)view.findViewById(R.id.ivBackBtn);
        this.ivBackBtn.getDrawable().setColorFilter(CommonData.getColorConfig().getHippoActionBarText(), PorterDuff.Mode.SRC_ATOP);
        this.setTextSize(this.tvToolbarName, 20.0f);
        this.setTextSize(this.delete, 13.4f);
        this.setTextSize(this.titleError, 18.0f);
        if (this.getActivity().getIntent().hasExtra("dataMessage")) {
            this.getSavedData(false);
            if (this.arrayList.size() > 0) {
                this.setDataFromPush(this.getActivity().getIntent().getStringExtra("dataMessage"));
            } else {
                this.getSavedData(true);
            }
        } else {
            this.getSavedData(true);
        }
        this.recyclerView.addOnScrollListener(new RecyclerView.OnScrollListener(){

            public void onScrolled(RecyclerView recyclerView, int dx, int dy) {
                super.onScrolled(recyclerView, dx, dy);
                if (dy > 0) {
                    CampaignFragment.this.visibleItemCount = CampaignFragment.this.layoutManager.getChildCount();
                    CampaignFragment.this.totalItemCount = CampaignFragment.this.layoutManager.getItemCount();
                    CampaignFragment.this.pastVisiblesItems = CampaignFragment.this.layoutManager.findFirstVisibleItemPosition();
                    if (!CampaignFragment.this.isPagingApiInProgress && CampaignFragment.this.hasMorePages && CampaignFragment.this.visibleItemCount + CampaignFragment.this.pastVisiblesItems >= CampaignFragment.this.totalItemCount) {
                        CampaignFragment.this.startOffset = CampaignFragment.this.arrayList.size();
                        CampaignFragment.this.fetchData();
                    }
                }
            }
        });
        this.recyclerView.addOnItemTouchListener((RecyclerView.OnItemTouchListener)new SwipeOnItemTouchAdapter((Context)this.getActivity(), this.recyclerView, (RecyclerView.LayoutManager)this.layoutManager){

            @Override
            public void onItemHiddenClick(SwipeHolder swipeHolder, int position) {
                CampaignFragment.this.clearData(((Data)CampaignFragment.this.arrayList.get(position)).getChannelId(), position);
                swipeHolder.reset();
            }

            @Override
            public void onItemClick(int position) {
            }
        });
        this.delete.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                CampaignFragment.this.clearData(-1L, -1);
            }
        });
        this.ivBackBtn.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                try {
                    CampaignFragment.this.getActivity().onBackPressed();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
    }

    private void setDataFromPush(String pushMessage) {
        try {
            JSONObject json = new JSONObject(pushMessage);
            if (json.getInt("is_announcement_push") == 1) {
                Data broadcast = new Data(Integer.parseInt(HippoConfig.getInstance().getUserData().getUserId().toString()));
                broadcast.setChannelId(json.getInt("channel_id"));
                broadcast.setCreatedAt(json.getString("date_time"));
                broadcast.setDisableReply(json.getInt("disable_reply"));
                broadcast.setDescription(json.getString("message"));
                CustomAttributes attr2 = (CustomAttributes)new Gson().fromJson(json.getString("custom_attributes"), CustomAttributes.class);
                broadcast.setCustomAttributes(attr2);
                broadcast.setTitle(json.getString("title"));
                broadcast.setAddedFromBroadcast(true);
                if (this.arrayList == null) {
                    this.arrayList = new ArrayList();
                }
                this.arrayList.add(0, broadcast);
                if (this.campaignAdapter != null) {
                    this.campaignAdapter.notifyDataSetChanged();
                }
                if (this.arrayList.size() > 0) {
                    this.delete.setVisibility(0);
                } else {
                    this.delete.setVisibility(8);
                }
            }
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
    }

    private HippoConfigAttributes getAttributes() {
        if (this.attributes == null) {
            this.attributes = CommonData.getAttributes();
        }
        return this.attributes;
    }

    public void setTextSize(TextView textView, float size) {
        textView.setTextSize(2, size);
    }

    public void onRefresh() {
        if (this.isNetworkAvailable()) {
            this.startOffset = 0;
            this.fetchData();
        } else {
            this.refreshLayout.setRefreshing(false);
        }
    }

    public static JSONObject objectToJSONObject(Object object) {
        Object json = null;
        JSONObject jsonObject = null;
        try {
            json = new JSONTokener(object.toString()).nextValue();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (json instanceof JSONObject) {
            jsonObject = (JSONObject)json;
        }
        return jsonObject;
    }

    @Override
    public void onClickListener(int position) {
        block13: {
            try {
                if (this.campaignBuilder != null && this.campaignBuilder.getListener() != null) {
                    String data = new Gson().toJson((Object)this.arrayList.get(position).getCustomAttributes());
                    this.campaignBuilder.getListener().onItemClickListener(data);
                }
            }
            catch (Exception data) {
                // empty catch block
            }
            try {
                DeeplinKData deeplinKData;
                if (this.arrayList.get(position).getCustomAttributes() == null || TextUtils.isEmpty((CharSequence)this.arrayList.get(position).getCustomAttributes().getDeeplink()) || !this.arrayList.get(position).getCustomAttributes().getDeeplink().equals("3x67AU1") || CommonData.getAttributes().getDeepLinks() == null || (deeplinKData = CommonData.getAttributes().getDeepLinks().get(this.arrayList.get(position).getCustomAttributes().getDeeplink())) == null || TextUtils.isEmpty((CharSequence)deeplinKData.getPakageName()) || TextUtils.isEmpty((CharSequence)deeplinKData.getClassFullPath())) break block13;
                FuguPutUserDetailsResponse.Data userData = CommonData.getUserDetails().getData();
                String businessName = userData.getBusinessName();
                long userId = userData.getUserId();
                String enUserId = userData.getEn_user_id();
                FuguConversation conversation = new FuguConversation();
                conversation.setLabel(this.arrayList.get(position).getTitle());
                conversation.setLabelId(Long.valueOf(this.arrayList.get(position).getChannelId()));
                conversation.setDefaultMessage("");
                conversation.setBusinessName(businessName);
                conversation.setUserId(userId);
                conversation.setEnUserId(enUserId);
                conversation.setOpenChat(true);
                conversation.setUserName(userData.getFullName());
                conversation.setIsTimeSet(1);
                conversation.setChatType(0);
                conversation.setStatus(1);
                boolean skipBot = false;
                try {
                    JSONObject jsonObject = CampaignFragment.objectToJSONObject(this.arrayList.get(position).getCustomAttributes().getData());
                    if (jsonObject.optInt("skip_bot", 0) == 1) {
                        skipBot = true;
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                Intent notificationIntent = new Intent();
                if (skipBot) {
                    notificationIntent.putExtra("is_skip_bot", 1);
                }
                notificationIntent.putExtra("conversation", new Gson().toJson((Object)conversation, FuguConversation.class));
                String packageName = deeplinKData.getPakageName();
                String className = deeplinKData.getClassFullPath();
                notificationIntent.setComponent(new ComponentName(packageName, className));
                this.startActivity(notificationIntent);
                if (this.campaignBuilder != null) {
                    if (this.campaignBuilder.isCloseActivityOnClick()) {
                        this.getActivity().finish();
                    } else if (this.campaignBuilder.isCloseOnlyDeepLink() && !TextUtils.isEmpty((CharSequence)this.arrayList.get(position).getCustomAttributes().getDeeplink())) {
                        this.getActivity().finish();
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public void onLoadMore() {
    }

    private void getSavedData(boolean hitFetchData) {
        PromotionResponse response = CommonData.getPromotionResponse();
        this.arrayList = new ArrayList();
        if (response != null && response.getData() != null && response.getData().size() > 0) {
            this.arrayList.addAll(response.getData());
            if (this.campaignAdapter != null) {
                this.campaignAdapter.setData(this.arrayList);
            }
        }
        if (this.arrayList.size() < 1) {
            this.refreshLayout.setRefreshing(true);
        }
        if (hitFetchData) {
            this.fetchData();
        }
    }

    public void fetchDataforSeeMore(int channelId) {
        this.startOffset = 0;
        this.fetchData(channelId);
    }

    private void fetchData() {
        this.fetchData(0);
    }

    private void fetchData(final int channelId) {
        if (this.isNetworkAvailable()) {
            if (this.startOffset != 0) {
                this.isPagingApiInProgress = true;
                this.campaignAdapter.showPaginationProgressBar(true, true);
            }
            new ApiGetMobileNotification((Activity)this.getActivity(), new NotificationListener(){

                @Override
                public void onSucessListener(PromotionResponse response) {
                    try {
                        HashSet<String> unreadDate;
                        if (CampaignFragment.this.arrayList == null) {
                            CampaignFragment.this.arrayList = new ArrayList();
                        }
                        if (CampaignFragment.this.startOffset == 0) {
                            CampaignFragment.this.arrayList.clear();
                            CommonData.savePromotionResponse(response);
                        }
                        if (CampaignFragment.this.startOffset != 0) {
                            CampaignFragment.this.isPagingApiInProgress = false;
                            CampaignFragment.this.campaignAdapter.showPaginationProgressBar(false, true);
                        }
                        if ((unreadDate = CommonData.getAnnouncementCount()).size() > 0) {
                            HashSet<String> list = new HashSet<String>();
                            for (Data data : response.getData()) {
                                list.add(String.valueOf(data.getChannelId()));
                            }
                            if (list.size() > 0) {
                                unreadDate.removeAll(list);
                                if (HippoConfig.getInstance().getCallbackListener() != null) {
                                    HippoConfig.getInstance().getCallbackListener().unreadAnnouncementsCount(unreadDate.size());
                                }
                                CommonData.setAnnouncementCount(unreadDate);
                            }
                        }
                        CampaignFragment.this.arrayList.addAll(response.getData());
                        if (channelId > 0) {
                            for (int i = 0; i < CampaignFragment.this.arrayList.size(); ++i) {
                                if (((Data)CampaignFragment.this.arrayList.get(i)).getChannelId() != channelId) continue;
                                ((Data)CampaignFragment.this.arrayList.get(i)).setShowMore(2);
                                ((Data)CampaignFragment.this.arrayList.get(i)).setAddedFromBroadcast(false);
                                break;
                            }
                        }
                        if (CampaignFragment.this.arrayList.size() == 0) {
                            CampaignFragment.this.llNoNotifications.setVisibility(0);
                            CampaignFragment.this.delete.setVisibility(8);
                        } else {
                            CampaignFragment.this.llNoNotifications.setVisibility(8);
                            CampaignFragment.this.delete.setVisibility(0);
                        }
                        if (CampaignFragment.this.campaignAdapter != null) {
                            CampaignFragment.this.campaignAdapter.setData(CampaignFragment.this.arrayList);
                        }
                        CampaignFragment.this.refreshLayout.setRefreshing(false);
                        if (response.getData().size() == 0) {
                            CampaignFragment.this.hasMorePages = false;
                        } else {
                            CampaignFragment.this.hasMorePages = true;
                        }
                        Log.e((String)"SIZE", (String)("TOTAL SIZE = " + CampaignFragment.this.arrayList.size()));
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }

                @Override
                public void onFailureListener() {
                    CampaignFragment.this.refreshLayout.setRefreshing(false);
                    if (CampaignFragment.this.startOffset != 0) {
                        CampaignFragment.this.isPagingApiInProgress = false;
                        CampaignFragment.this.campaignAdapter.showPaginationProgressBar(false, true);
                    }
                    if (CampaignFragment.this.arrayList.size() == 0) {
                        CampaignFragment.this.llNoNotifications.setVisibility(0);
                    } else {
                        CampaignFragment.this.llNoNotifications.setVisibility(8);
                    }
                }

                @Override
                public void onItemClickListener(String url) {
                }
            }).getNotificationData(this.startOffset, this.offset);
        } else {
            String text = Restring.getString((Context)this.getActivity(), R.string.fugu_not_connected_to_internet);
            ToastUtil.getInstance((Context)this.getActivity()).showToast(text);
            this.refreshLayout.setRefreshing(false);
            if (this.startOffset != 0) {
                this.isPagingApiInProgress = false;
                this.campaignAdapter.showPaginationProgressBar(false, true);
            }
        }
    }

    private void deleteAll() {
        new AlertDialog.Builder((Context)this.getActivity()).setMessage((CharSequence)"Are you sure you want to clear all notifications?").setPositiveButton((CharSequence)"Yes", new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                CampaignFragment.this.clearData(-1L, -1);
            }
        }).setNegativeButton((CharSequence)"No", new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
            }
        }).create().show();
    }

    public void clearData(long channelId, int position) {
        if (this.isNetworkAvailable()) {
            new ApiGetMobileNotification((Activity)this.getActivity(), new OnClearNotificationListener(){

                @Override
                public void onSucessListener(int position) {
                    if (position > -1) {
                        CampaignFragment.this.campaignAdapter.notifyItemRemoved(position);
                        CampaignFragment.this.arrayList.remove(position);
                        String text = Restring.getString((Context)CampaignFragment.this.getActivity(), R.string.hippo_notifications_deleted);
                        if (CampaignFragment.this.campaignBuilder != null && !TextUtils.isEmpty((CharSequence)CampaignFragment.this.campaignBuilder.getDeleteMessage())) {
                            text = CampaignFragment.this.campaignBuilder.getDeleteMessage();
                        }
                        ToastUtil.getInstance((Context)CampaignFragment.this.getActivity()).showToast(text);
                    } else {
                        CampaignFragment.this.arrayList.clear();
                        CampaignFragment.this.campaignAdapter.notifyDataSetChanged();
                    }
                    if (CampaignFragment.this.arrayList.size() == 0) {
                        CampaignFragment.this.delete.setVisibility(8);
                        CampaignFragment.this.llNoNotifications.setVisibility(0);
                    }
                }

                @Override
                public void onFailure() {
                }
            }).clearNotification(channelId, position);
        } else {
            String text = Restring.getString((Context)this.getActivity(), R.string.fugu_not_connected_to_internet);
            ToastUtil.getInstance((Context)this.getActivity()).showToast(text);
        }
    }
}

