/*
 * Decompiled with CFR 0.152.
 */
package com.hippo.adapter;

import android.content.Context;
import android.text.TextUtils;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.RelativeLayout;
import androidx.annotation.NonNull;
import androidx.appcompat.widget.AppCompatImageView;
import androidx.appcompat.widget.AppCompatTextView;
import androidx.cardview.widget.CardView;
import androidx.core.content.ContextCompat;
import androidx.recyclerview.widget.RecyclerView;
import com.bumptech.glide.Glide;
import com.bumptech.glide.load.Transformation;
import com.bumptech.glide.load.engine.DiskCacheStrategy;
import com.bumptech.glide.request.BaseRequestOptions;
import com.bumptech.glide.request.RequestOptions;
import com.hippo.HippoColorConfig;
import com.hippo.R;
import com.hippo.callback.OnTeamClickListener;
import com.hippo.database.CommonData;
import com.hippo.model.searchagent.AgentsList;
import com.hippo.utils.ProgressBarDisplayRunnable;
import com.hippo.utils.RoundedCornersTransformation;
import java.util.ArrayList;

public class SearchAgentAdapter
extends RecyclerView.Adapter<RecyclerView.ViewHolder> {
    private Context mContext;
    private OnTeamClickListener itemClickListener;
    private HippoColorConfig hippoColorConfig;
    private ArrayList<AgentsList> arrayList;
    private RecyclerView recyclerView;
    private static final int VIEW_TYPE = 1;
    private static final int VIEW_TYPE_LOADING = 2;
    private ProgressBarDisplayRunnable progressBarDisplayRunnable;

    public SearchAgentAdapter(ArrayList<AgentsList> arrayList, RecyclerView recyclerView, OnTeamClickListener itemClickListener) {
        this.arrayList = arrayList;
        this.recyclerView = recyclerView;
        this.itemClickListener = itemClickListener;
        this.hippoColorConfig = CommonData.getColorConfig();
    }

    @NonNull
    public RecyclerView.ViewHolder onCreateViewHolder(@NonNull ViewGroup viewGroup, int viewType) {
        this.mContext = viewGroup.getContext();
        if (viewType == 2) {
            return new LoadMoreHolder(LayoutInflater.from((Context)this.mContext).inflate(R.layout.hippo_layout_loaddata, viewGroup, false));
        }
        return new ViewHolder(LayoutInflater.from((Context)this.mContext).inflate(R.layout.hippo_agent_itam, viewGroup, false), this.itemClickListener);
    }

    public void onBindViewHolder(@NonNull RecyclerView.ViewHolder holder, int pos) {
        if (holder instanceof ViewHolder) {
            ViewHolder viewHolder = (ViewHolder)holder;
            AgentsList item = this.arrayList.get(pos);
            viewHolder.agentName.setText((CharSequence)item.getTitle());
            viewHolder.agentDesc.setText((CharSequence)item.getDescription());
            try {
                if (!TextUtils.isEmpty((CharSequence)item.getRating())) {
                    viewHolder.starLayout.setVisibility(0);
                    viewHolder.starText.setText((CharSequence)("" + item.getRating()));
                } else {
                    viewHolder.starLayout.setVisibility(8);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                viewHolder.starLayout.setVisibility(8);
            }
            if (TextUtils.isEmpty((CharSequence)item.getOnline_status())) {
                viewHolder.status.setVisibility(8);
            } else {
                viewHolder.status.setVisibility(0);
                if (item.getOnline_status().equalsIgnoreCase("AVAILABLE")) {
                    viewHolder.status.setBackgroundResource(R.drawable.hippo_circle_online);
                } else {
                    viewHolder.status.setBackgroundResource(R.drawable.hippo_circle_offline);
                }
            }
            RequestOptions myOptions = (RequestOptions)((RequestOptions)((RequestOptions)((RequestOptions)((RequestOptions)RequestOptions.bitmapTransform((Transformation)new RoundedCornersTransformation(this.mContext, 4, 1)).placeholder(ContextCompat.getDrawable((Context)this.mContext, (int)R.drawable.hippo_placeholder))).fitCenter()).dontAnimate()).diskCacheStrategy(DiskCacheStrategy.ALL)).error(ContextCompat.getDrawable((Context)this.mContext, (int)R.drawable.hippo_man));
            Glide.with((Context)this.mContext).load(item.getImage_url()).apply((BaseRequestOptions)myOptions).into((ImageView)viewHolder.userImage);
        }
    }

    public int getItemCount() {
        return this.arrayList == null ? 0 : this.arrayList.size();
    }

    public int getItemViewType(int position) {
        try {
            if (this.arrayList.get(position).getId().equalsIgnoreCase("-3")) {
                return 2;
            }
            return 1;
        }
        catch (Exception e) {
            return 1;
        }
    }

    public void showPaginationProgressBar(boolean show, boolean notifyAdapter) {
        if (this.arrayList == null || this.arrayList.size() == 0) {
            return;
        }
        boolean isProgressBarExist = this.arrayList.get(this.arrayList.size() - 1).getId().equals("-3");
        if (show) {
            if (!isProgressBarExist) {
                this.arrayList.add(ProgressBarModel.getInstance());
                if (notifyAdapter) {
                    this.recyclerView.post((Runnable)this.getProgressDisplayRunnable(true, this.arrayList.size()));
                }
            }
        } else if (this.arrayList.remove(ProgressBarModel.getInstance()) && notifyAdapter) {
            this.recyclerView.post((Runnable)this.getProgressDisplayRunnable(false, this.arrayList.size()));
        }
    }

    private ProgressBarDisplayRunnable getProgressDisplayRunnable(boolean isInsert, int position) {
        if (this.progressBarDisplayRunnable == null) {
            this.progressBarDisplayRunnable = new ProgressBarDisplayRunnable(this);
        }
        this.progressBarDisplayRunnable.setInsert(isInsert);
        this.progressBarDisplayRunnable.setPosition(position);
        return this.progressBarDisplayRunnable;
    }

    private static class ProgressBarModel {
        private static AgentsList progressBarModel;

        private ProgressBarModel() {
        }

        public static AgentsList getInstance() {
            if (progressBarModel == null) {
                progressBarModel = new AgentsList("-3", "", "", "", "", "");
            }
            return progressBarModel;
        }
    }

    public class ViewHolder
    extends RecyclerView.ViewHolder {
        private CardView cardView;
        private AppCompatImageView userImage;
        private AppCompatTextView agentName;
        private AppCompatTextView agentDesc;
        private AppCompatTextView starText;
        private RelativeLayout starLayout;
        private AppCompatImageView status;

        public ViewHolder(View itemView, final OnTeamClickListener itemClickListener) {
            super(itemView);
            this.cardView = (CardView)itemView.findViewById(R.id.cardView);
            this.userImage = (AppCompatImageView)itemView.findViewById(R.id.userImage);
            this.agentName = (AppCompatTextView)itemView.findViewById(R.id.agentName);
            this.agentDesc = (AppCompatTextView)itemView.findViewById(R.id.agentDesc);
            this.starText = (AppCompatTextView)itemView.findViewById(R.id.starText);
            this.starLayout = (RelativeLayout)itemView.findViewById(R.id.starLayout);
            this.status = (AppCompatImageView)itemView.findViewById(R.id.status);
            this.cardView.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    itemClickListener.onAgentSelected((AgentsList)SearchAgentAdapter.this.arrayList.get(ViewHolder.this.getAdapterPosition()), ViewHolder.this.getAdapterPosition());
                }
            });
        }
    }

    public class LoadMoreHolder
    extends RecyclerView.ViewHolder {
        public LoadMoreHolder(View itemView) {
            super(itemView);
        }
    }
}

