/*
 * Decompiled with CFR 0.152.
 */
package com.hippo.fragment;

import android.content.Context;
import android.os.Bundle;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.TextView;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.google.android.material.bottomsheet.BottomSheetDialog;
import com.google.android.material.bottomsheet.BottomSheetDialogFragment;
import com.hippo.R;
import com.hippo.activity.PrePaymentActivity;
import com.hippo.langs.Restring;

public class PaymentCancelDialog
extends BottomSheetDialogFragment {
    private Button no;
    private Button yes;
    private TextView title;
    private TextView description;

    public static PaymentCancelDialog newInstance() {
        PaymentCancelDialog frag = new PaymentCancelDialog();
        Bundle args = new Bundle();
        frag.setArguments(args);
        return frag;
    }

    public void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
    }

    @Nullable
    public View onCreateView(@NonNull LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        new BottomSheetDialog(this.requireContext(), this.getTheme());
        return inflater.inflate(R.layout.cancel_bottom_sheet, container, false);
    }

    public void onViewCreated(@NonNull View view, @Nullable Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);
        this.no = (Button)view.findViewById(R.id.hippo_no);
        this.yes = (Button)view.findViewById(R.id.hippo_yes);
        this.title = (TextView)view.findViewById(R.id.title);
        this.description = (TextView)view.findViewById(R.id.description);
        final PrePaymentActivity activity = (PrePaymentActivity)this.getActivity();
        this.title.setText((CharSequence)Restring.getString((Context)activity, R.string.hippo_cancel_payment));
        this.description.setText((CharSequence)Restring.getString((Context)activity, R.string.cancel_payment_text));
        this.yes.setText((CharSequence)Restring.getString((Context)activity, R.string.hippo_yes_cancel));
        this.no.setText((CharSequence)Restring.getString((Context)activity, R.string.hippo_no));
        this.no.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                PaymentCancelDialog.this.dismiss();
            }
        });
        this.yes.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                try {
                    activity.cancelPayment();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                PaymentCancelDialog.this.dismiss();
            }
        });
    }

    public int getTheme() {
        return R.style.AppBottomSheetDialogTheme;
    }
}

