/*
 * Decompiled with CFR 0.152.
 */
package com.hippo.utils.filepicker;

import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.database.Cursor;
import android.net.Uri;
import android.os.Build;
import android.os.Environment;
import android.util.DisplayMetrics;
import android.view.WindowManager;
import com.hippo.constant.FuguAppConstant;
import java.io.File;
import java.util.List;

public class Util
implements FuguAppConstant.MimeTypeConstants {
    private static final String AppName = "Hippo";
    private static final int NOT_FOUND = -1;
    public static final char EXTENSION_SEPARATOR = '.';
    private static final char UNIX_SEPARATOR = '/';
    private static final char WINDOWS_SEPARATOR = '\\';

    public static boolean detectIntent(Context ctx, Intent intent) {
        PackageManager packageManager = ctx.getPackageManager();
        List list = packageManager.queryIntentActivities(intent, 65536);
        return list.size() > 0;
    }

    public static String getDurationString(long duration) {
        String secondStr;
        long hours = duration % 86400000L / 3600000L;
        long minutes = duration % 3600000L / 60000L;
        long seconds = duration % 60000L / 1000L;
        String hourStr = hours < 10L ? "0" + hours : hours + "";
        String minuteStr = minutes < 10L ? "0" + minutes : minutes + "";
        String string2 = secondStr = seconds < 10L ? "0" + seconds : seconds + "";
        if (hours != 0L) {
            return hourStr + ":" + minuteStr + ":" + secondStr;
        }
        return minuteStr + ":" + secondStr;
    }

    public static int getScreenWidth(Context ctx) {
        WindowManager wm = (WindowManager)ctx.getSystemService("window");
        DisplayMetrics dm = new DisplayMetrics();
        wm.getDefaultDisplay().getMetrics(dm);
        return dm.widthPixels;
    }

    public static int getScreenHeight(Context ctx) {
        WindowManager wm = (WindowManager)ctx.getSystemService("window");
        DisplayMetrics dm = new DisplayMetrics();
        wm.getDefaultDisplay().getMetrics(dm);
        return dm.heightPixels;
    }

    public static int dip2px(Context context, float dpValue) {
        float scale = context.getResources().getDisplayMetrics().density;
        return (int)(dpValue * scale + 0.5f);
    }

    public static int px2dip(Context context, float pxValue) {
        float scale = context.getResources().getDisplayMetrics().density;
        return (int)(pxValue / scale + 0.5f);
    }

    public static String extractFileNameWithSuffix(String url) {
        return url.substring(url.lastIndexOf("/") + 1);
    }

    public static String extractFileNameWithoutSuffix(String url) {
        try {
            return url.substring(url.lastIndexOf("/") + 1, url.lastIndexOf("."));
        }
        catch (StringIndexOutOfBoundsException e) {
            try {
                return url.substring(url.lastIndexOf("/") + 1);
            }
            catch (Exception e1) {
                e1.printStackTrace();
                e.printStackTrace();
                return "";
            }
        }
    }

    public static String getMuid(String name) {
        try {
            return name.substring(name.lastIndexOf("_") + 1, name.lastIndexOf("."));
        }
        catch (StringIndexOutOfBoundsException e) {
            e.printStackTrace();
            return "";
        }
    }

    public static String extractPathWithSeparator(String url) {
        return url.substring(0, url.lastIndexOf("/") + 1);
    }

    public static String extractPathWithoutSeparator(String url) {
        return url.substring(0, url.lastIndexOf("/"));
    }

    public static String extractFileSuffix(String url) {
        if (url.contains(".")) {
            return url.substring(url.lastIndexOf(".") + 1);
        }
        return "";
    }

    public static String getFilePath(Context context, Uri contentUri) {
        if (Build.VERSION.SDK_INT >= 26) {
            try {
                File file = new File(contentUri.getPath());
                String[] split = file.getPath().split(":");
                return Util.getPath(context, contentUri);
            }
            catch (Exception e) {
                return Util.getPath(context, contentUri);
            }
        }
        return Util.getPath(context, contentUri);
    }

    /*
     * Exception decompiling
     */
    public static String getPath(Context context, Uri uri) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [5[CATCHBLOCK]], but top level block is 3[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static boolean isExternalStorageDocument(Uri uri) {
        return "com.android.externalstorage.documents".equals(uri.getAuthority());
    }

    public static boolean isDownloadsDocument(Uri uri) {
        return "com.android.providers.downloads.documents".equals(uri.getAuthority());
    }

    public static boolean isGoogleDriveDocument(Uri uri) {
        return "com.google.android.apps.docs.storage".equals(uri.getAuthority());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getDataColumn(Context context, Uri uri, String selection, String[] selectionArgs) {
        Cursor cursor = null;
        String column = "_data";
        String[] projection = new String[]{"_data"};
        try {
            cursor = context.getContentResolver().query(uri, projection, selection, selectionArgs, null);
            if (cursor != null && cursor.moveToFirst()) {
                int index = cursor.getColumnIndexOrThrow("_data");
                String string2 = cursor.getString(index);
                return string2;
            }
        }
        finally {
            if (cursor != null) {
                cursor.close();
            }
        }
        return null;
    }

    public static boolean isGooglePhotosUri(Uri uri) {
        return "com.google.android.apps.photos.content".equals(uri.getAuthority());
    }

    public static boolean isMediaDocument(Uri uri) {
        return "com.android.providers.media.documents".equals(uri.getAuthority());
    }

    public static File getDirectory(FileType type) {
        try {
            String strFolder = Environment.getExternalStorageDirectory() + File.separator + AppName + File.separator + type.directory;
            File folder = new File(strFolder);
            if (!folder.exists()) {
                folder.mkdirs();
            }
            return folder;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String getExtension(String filename) {
        if (filename == null) {
            return null;
        }
        int index = Util.indexOfExtension(filename);
        if (index == -1) {
            return "";
        }
        return filename.substring(index + 1);
    }

    public static int indexOfExtension(String filename) {
        if (filename == null) {
            return -1;
        }
        int extensionPos = filename.lastIndexOf(46);
        int lastSeparator = Util.indexOfLastSeparator(filename);
        return lastSeparator > extensionPos ? -1 : extensionPos;
    }

    public static int indexOfLastSeparator(String filename) {
        if (filename == null) {
            return -1;
        }
        int lastUnixPos = filename.lastIndexOf(47);
        int lastWindowsPos = filename.lastIndexOf(92);
        return Math.max(lastUnixPos, lastWindowsPos);
    }

    public static String humanReadableByteCount(long bytes, boolean si) {
        int unit;
        int n = unit = si ? 1024 : 1024;
        if (bytes < (long)unit) {
            return bytes + " B";
        }
        int exp = (int)(Math.log(bytes) / Math.log(unit));
        String pre = (si ? "kMGTPE" : "KMGTPE").charAt(exp - 1) + (si ? "" : "i");
        return String.format("%.2f %sB", (double)bytes / Math.pow(unit, exp), pre);
    }

    public static String humanReadableSize(long bytes, boolean si) {
        int unit;
        int n = unit = si ? 1024 : 1024;
        if (bytes < (long)unit) {
            return bytes + " B";
        }
        int exp = (int)(Math.log(bytes) / Math.log(unit));
        String pre = (si ? "kMGTPE" : "KMGTPE").charAt(exp - 1) + (si ? "" : "i");
        return String.format("%.0f %sB", (double)bytes / Math.pow(unit, exp), pre);
    }

    public static String getDirectoryPath(String folder) {
        return Environment.getExternalStorageDirectory() + File.separator + AppName + File.separator + folder;
    }

    public static String getOrCreateDirectoryPath(String folderName) {
        String path = Environment.getExternalStorageDirectory() + File.separator + AppName + File.separator + folderName;
        File folder = new File(path);
        if (!folder.exists()) {
            folder.mkdirs();
        }
        return path;
    }

    public static String setImageFullPath(String fileName) {
        String destinationDirectoryPath = Util.getOrCreateDirectoryPath(FuguAppConstant.FOLDER_TYPE.get("image"));
        return destinationDirectoryPath + File.separator + fileName;
    }

    public static String getFileName(String filename, String muid) {
        if (!filename.contains(muid)) {
            String ext = Util.getExtension(filename);
            String name = Util.extractFileNameWithoutSuffix(filename);
            filename = name + "_" + muid + "." + ext;
        }
        return filename;
    }

    static enum FileType {
        LOG_FILE("logs", ".log"),
        IMAGE_FILE("snapshots", ""),
        GENERAL_FILE("public", ".txt"),
        PRIVATE_FILE("system", ".sys");

        public final String extension;
        public final String directory;

        private FileType(String relativePath, String extension) {
            this.extension = extension;
            this.directory = relativePath;
        }
    }
}

