package com.hippo.adapter

import android.content.Context
import android.view.LayoutInflater
import android.view.View
import android.view.ViewGroup
import androidx.recyclerview.widget.RecyclerView
import com.hippo.R
import com.hippo.callback.OnTeamClickListener
import com.hippo.model.searchagent.Team
import kotlinx.android.synthetic.main.hippo_team_item.view.*

/**
 * Created by gurmail on 03/12/20.
 * @author gurmail
 */
class SearchTeamAdapter(var arralyList: ArrayList<Team>, val onItemListener: OnTeamClickListener) :
    RecyclerView.Adapter<SearchTeamAdapter.ViewHolder>() {

    var context: Context? = null
    override fun onCreateViewHolder(
        parent: ViewGroup,
        viewType: Int
    ): SearchTeamAdapter.ViewHolder {
        context = parent.context
        return ViewHolder(
            LayoutInflater.from(context).inflate(R.layout.hippo_team_item, parent, false)
        )
    }

    override fun getItemCount(): Int {
        return arralyList.size
    }

    override fun onBindViewHolder(holder: SearchTeamAdapter.ViewHolder, position: Int) {
        holder.bind(arralyList[position], onItemListener)
    }

    class ViewHolder(itemView: View) : RecyclerView.ViewHolder(itemView) {
        fun bind(item: Team, onItemListener: OnTeamClickListener) {
            itemView.teamName.text = item.tag_name
            itemView.teamName.setOnClickListener {
                onItemListener.onItemSelected(item, adapterPosition)
            }
        }
    }
}