package com.hippo.adapter;

import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.TextView;

import androidx.annotation.NonNull;
import androidx.recyclerview.widget.RecyclerView;

import com.hippo.R;
import com.hippo.interfaces.onCountrySelect;

public class CountryAdapter extends RecyclerView.Adapter<CountryAdapter.ViewHolder> {
    private final onCountrySelect listner;
    String country[];
    private LayoutInflater mLayoutInflater;

    public CountryAdapter(Context mContext, String country[], onCountrySelect listner) {
        this.country = country;
        this.listner = listner;
        mLayoutInflater = LayoutInflater.from(mContext);

    }

    @NonNull
    @Override
    public ViewHolder onCreateViewHolder(@NonNull ViewGroup parent, int viewType) {
        return new ViewHolder(mLayoutInflater.inflate(R.layout.text_country, parent, false));

    }

    @Override
    public void onBindViewHolder(@NonNull ViewHolder holder, int position) {
        holder.countryTV.setText(country[position]);
        holder.countryTV.setTag(position);
        holder.countryTV.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View view) {
                int pos = (int) view.getTag();
                listner.onCountrySelected(country[pos], pos);
            }
        });

    }

    @Override
    public int getItemCount() {
        return country.length;
    }

    public class ViewHolder extends RecyclerView.ViewHolder {
        TextView countryTV;

        public ViewHolder(@NonNull View itemView) {
            super(itemView);
            countryTV = itemView.findViewById(R.id.countryTV);
        }
    }
}
