package com.hippo.adapter

import android.view.LayoutInflater
import android.view.View
import android.view.ViewGroup
import androidx.recyclerview.widget.RecyclerView
import com.hippo.R
import com.hippo.callback.OnTeamClickListener
import com.hippo.model.searchagent.Team
import kotlinx.android.synthetic.main.list_item_skills.view.*

class ChipsAdapter(val chipsContents: ArrayList<Team>,var listener: OnTeamClickListener) : RecyclerView.Adapter<ChipsAdapter.ChipViewHolder>() {

    inner class ChipViewHolder(itemView: View) : RecyclerView.ViewHolder(itemView) {
        fun bind(chipContent: Team) {
            with(itemView) {
                chipTextView.text = chipContent.tag_name

                removeChipButton.setOnClickListener {
                    val index = chipsContents.indexOf(chipContent)
                    chipsContents.remove(chipContent)
                    notifyItemRemoved(index)
                    listener.onSkillRemoved()

                }
            }
        }
    }

    override fun onCreateViewHolder(parent: ViewGroup, viewType: Int): ChipViewHolder {
        val v = LayoutInflater.from(parent.context).inflate(R.layout.list_item_skills, parent, false)
        return ChipViewHolder(v)
    }

    override fun getItemCount() = chipsContents.size

    override fun onBindViewHolder(holder: ChipViewHolder, position: Int) = holder.bind(chipsContents[position])
}