/*
 * Decompiled with CFR 0.152.
 */
package com.hippo.fragment;

import android.content.Context;
import android.content.DialogInterface;
import android.os.Bundle;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import android.widget.TextView;
import android.widget.Toast;
import androidx.appcompat.app.AlertDialog;
import com.google.android.material.bottomsheet.BottomSheetDialogFragment;
import com.hippo.R;
import com.hippo.activity.FuguChatActivity;
import com.hippo.constant.FuguAppConstant;
import com.hippo.database.CommonData;
import com.hippo.langs.Restring;
import com.hippo.model.Message;
import com.hippo.utils.DateUtils;
import java.util.Date;

public class BottomSheetMsgFragment
extends BottomSheetDialogFragment
implements FuguAppConstant,
View.OnClickListener {
    private LinearLayout copy;
    private LinearLayout delete;
    private LinearLayout edit;
    private FuguChatActivity fuguChatActivity;
    private int position;
    private String Muid;
    private int messsagetype;
    private boolean IsSelf;
    private int MessageStatus;
    private String SentAtUtc;
    private TextView tvDelete;
    private TextView ivEditTxt;
    private TextView copyTxt;
    private Boolean isReplied;
    private Boolean isAlreadyDelete;

    public static BottomSheetMsgFragment newInstance(int pos, Message message, boolean isSelf, boolean isReplied, boolean isAlreadyDelete) {
        BottomSheetMsgFragment frag = new BottomSheetMsgFragment();
        Bundle args = new Bundle();
        frag.setArguments(args);
        frag.setPostion(pos);
        frag.setMuid(message.getMuid());
        frag.setIsSelf(isSelf);
        frag.setMessageType(message.getOriginalMessageType());
        frag.setMessageStatus(message.getMessageStatus());
        frag.setSentAtUtc(message.getSentAtUtc());
        frag.setReplied(isReplied);
        frag.setAlreadyDelete(isAlreadyDelete);
        return frag;
    }

    private void setAlreadyDelete(boolean isAlreadyDelete) {
        this.isAlreadyDelete = isAlreadyDelete;
    }

    private void setReplied(boolean isReplied) {
        this.isReplied = isReplied;
    }

    private void setSentAtUtc(String sentAtUtc) {
        this.SentAtUtc = sentAtUtc;
    }

    private void setMessageStatus(int messsageStatus) {
        this.MessageStatus = messsageStatus;
    }

    private void setIsSelf(boolean isSelf) {
        this.IsSelf = isSelf;
    }

    private void setMessageType(int messageType) {
        this.messsagetype = messageType;
    }

    private void setMuid(String muid) {
        this.Muid = muid;
    }

    private void setPostion(int pos) {
        this.position = pos;
    }

    public int getTheme() {
        return R.style.AppBottomSheetDialogTheme;
    }

    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
    }

    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        View view = inflater.inflate(R.layout.hippo_message_bottom_sheet, container, false);
        this.fuguChatActivity = (FuguChatActivity)this.getActivity();
        this.copy = (LinearLayout)view.findViewById(R.id.copy);
        this.delete = (LinearLayout)view.findViewById(R.id.delete);
        this.edit = (LinearLayout)view.findViewById(R.id.edit);
        this.copyTxt = (TextView)view.findViewById(R.id.copyTxt);
        this.tvDelete = (TextView)view.findViewById(R.id.tvDelete);
        this.ivEditTxt = (TextView)view.findViewById(R.id.ivEditTxt);
        this.copyTxt.setText((CharSequence)Restring.getString((Context)this.getActivity(), R.string.hippo_copy_text));
        this.tvDelete.setText((CharSequence)Restring.getString((Context)this.getActivity(), R.string.hippo_delete_text));
        this.ivEditTxt.setText((CharSequence)Restring.getString((Context)this.getActivity(), R.string.hippo_edit_text));
        this.tvDelete = (TextView)view.findViewById(R.id.tvDelete);
        String localDate = DateUtils.getFormattedDate(new Date());
        int newTime = DateUtils.getTimeInMinutes(DateUtils.getInstance().convertToUTC(localDate));
        int oldTime = DateUtils.getTimeInMinutes(this.SentAtUtc);
        int editableDuration = CommonData.getUserDetails().getData().getEditDeleteDuration();
        if (!this.isAlreadyDelete.booleanValue() && this.IsSelf && this.messsagetype == 1 && editableDuration > -1 && (editableDuration == 0 || Math.abs(newTime - oldTime) <= editableDuration)) {
            this.edit.setVisibility(0);
            this.delete.setVisibility(0);
        } else {
            this.edit.setVisibility(8);
            this.delete.setVisibility(8);
        }
        this.copy.setOnClickListener((View.OnClickListener)this);
        this.delete.setOnClickListener((View.OnClickListener)this);
        this.edit.setOnClickListener((View.OnClickListener)this);
        return view;
    }

    public void onClick(View v) {
        this.dismiss();
        int id2 = v.getId();
        if (id2 == R.id.edit) {
            this.fuguChatActivity.editText(this.position);
        } else if (id2 == R.id.copy) {
            this.fuguChatActivity.copyText(this.position, this.isReplied);
            Toast.makeText((Context)this.getActivity(), (CharSequence)Restring.getString((Context)this.getActivity(), R.string.hippo_copy_to_clipboard), (int)0).show();
        } else if (id2 == R.id.delete) {
            if (this.fuguChatActivity.isNetworkAvailable() || this.MessageStatus != 1 && this.MessageStatus != 2 && this.MessageStatus != 3) {
                new AlertDialog.Builder((Context)this.fuguChatActivity).setMessage((CharSequence)Restring.getString((Context)this.fuguChatActivity, R.string.hippo_delete_this_message)).setPositiveButton((CharSequence)Restring.getString((Context)this.fuguChatActivity, R.string.hippo_delete_for_everyone), new DialogInterface.OnClickListener(){

                    public void onClick(DialogInterface dialog, int which) {
                        BottomSheetMsgFragment.this.fuguChatActivity.deleteMessage(BottomSheetMsgFragment.this.position, BottomSheetMsgFragment.this.Muid, BottomSheetMsgFragment.this.MessageStatus);
                    }
                }).setNegativeButton((CharSequence)Restring.getString((Context)this.fuguChatActivity, R.string.hippo_no), new DialogInterface.OnClickListener(){

                    public void onClick(DialogInterface dialog, int which) {
                    }
                }).show();
            } else {
                new AlertDialog.Builder((Context)this.fuguChatActivity).setMessage((CharSequence)Restring.getString((Context)this.fuguChatActivity, R.string.fugu_not_connected_to_internet)).setPositiveButton((CharSequence)Restring.getString((Context)this.fuguChatActivity, R.string.fugu_ok), new DialogInterface.OnClickListener(){

                    public void onClick(DialogInterface dialog, int which) {
                    }
                }).show();
            }
        }
    }

    public void onCancel(DialogInterface dialog) {
        if (this.fuguChatActivity != null) {
            this.fuguChatActivity.setOnLongClickValue();
        }
        super.onCancel(dialog);
    }
}

