/*
 * Decompiled with CFR 0.152.
 */
package com.hippo.database.dao;

import android.database.Cursor;
import androidx.room.EntityDeletionOrUpdateAdapter;
import androidx.room.EntityInsertionAdapter;
import androidx.room.RoomDatabase;
import androidx.room.RoomSQLiteQuery;
import androidx.room.SharedSQLiteStatement;
import androidx.room.util.CursorUtil;
import androidx.room.util.DBUtil;
import androidx.sqlite.db.SupportSQLiteQuery;
import androidx.sqlite.db.SupportSQLiteStatement;
import com.hippo.database.dao.ChannelInfoDao;
import com.hippo.database.entity.ChannelInfo;
import java.util.ArrayList;
import java.util.List;

public final class ChannelInfoDao_Impl
implements ChannelInfoDao {
    private final RoomDatabase __db;
    private final EntityInsertionAdapter<ChannelInfo> __insertionAdapterOfChannelInfo;
    private final EntityDeletionOrUpdateAdapter<ChannelInfo> __deletionAdapterOfChannelInfo;
    private final SharedSQLiteStatement __preparedStmtOfDeleteChannelInfo;
    private final SharedSQLiteStatement __preparedStmtOfUpdateChannelInfo;

    public ChannelInfoDao_Impl(RoomDatabase __db) {
        this.__db = __db;
        this.__insertionAdapterOfChannelInfo = new EntityInsertionAdapter<ChannelInfo>(__db){

            public String createQuery() {
                return "INSERT OR REPLACE INTO `ChannelInfo` (`channelId`,`updatedAt`) VALUES (?,?)";
            }

            public void bind(SupportSQLiteStatement stmt, ChannelInfo value) {
                stmt.bindLong(1, (long)value.getChannelId());
                stmt.bindLong(2, value.getUpdatedAt());
            }
        };
        this.__deletionAdapterOfChannelInfo = new EntityDeletionOrUpdateAdapter<ChannelInfo>(__db){

            public String createQuery() {
                return "DELETE FROM `ChannelInfo` WHERE `channelId` = ?";
            }

            public void bind(SupportSQLiteStatement stmt, ChannelInfo value) {
                stmt.bindLong(1, (long)value.getChannelId());
            }
        };
        this.__preparedStmtOfDeleteChannelInfo = new SharedSQLiteStatement(__db){

            public String createQuery() {
                String _query = "Delete from ChannelInfo where channelId = ?";
                return "Delete from ChannelInfo where channelId = ?";
            }
        };
        this.__preparedStmtOfUpdateChannelInfo = new SharedSQLiteStatement(__db){

            public String createQuery() {
                String _query = "Update ChannelInfo SET updatedAt =? where channelId =?";
                return "Update ChannelInfo SET updatedAt =? where channelId =?";
            }
        };
    }

    @Override
    public void updateChannel(ChannelInfo channelInfo) {
        this.__db.assertNotSuspendingTransaction();
        this.__db.beginTransaction();
        try {
            this.__insertionAdapterOfChannelInfo.insert((Object)channelInfo);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void deleteChannels(ChannelInfo ... channelInfo) {
        this.__db.assertNotSuspendingTransaction();
        this.__db.beginTransaction();
        try {
            this.__deletionAdapterOfChannelInfo.handleMultiple((Object[])channelInfo);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deleteChannelInfo(int channelId) {
        this.__db.assertNotSuspendingTransaction();
        SupportSQLiteStatement _stmt = this.__preparedStmtOfDeleteChannelInfo.acquire();
        int _argIndex = 1;
        _stmt.bindLong(_argIndex, (long)channelId);
        this.__db.beginTransaction();
        try {
            _stmt.executeUpdateDelete();
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
            this.__preparedStmtOfDeleteChannelInfo.release(_stmt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateChannelInfo(long value, int id2) {
        this.__db.assertNotSuspendingTransaction();
        SupportSQLiteStatement _stmt = this.__preparedStmtOfUpdateChannelInfo.acquire();
        int _argIndex = 1;
        _stmt.bindLong(_argIndex, value);
        _argIndex = 2;
        _stmt.bindLong(_argIndex, (long)id2);
        this.__db.beginTransaction();
        try {
            _stmt.executeUpdateDelete();
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
            this.__preparedStmtOfUpdateChannelInfo.release(_stmt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<ChannelInfo> getChannelInfo() {
        String _sql = "Select * from ChannelInfo Order by updatedAt";
        RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"Select * from ChannelInfo Order by updatedAt", (int)0);
        this.__db.assertNotSuspendingTransaction();
        Cursor _cursor = DBUtil.query((RoomDatabase)this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
        try {
            int _cursorIndexOfChannelId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"channelId");
            int _cursorIndexOfUpdatedAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"updatedAt");
            ArrayList<ChannelInfo> _result = new ArrayList<ChannelInfo>(_cursor.getCount());
            while (_cursor.moveToNext()) {
                int _tmpChannelId = _cursor.getInt(_cursorIndexOfChannelId);
                long _tmpUpdatedAt = _cursor.getLong(_cursorIndexOfUpdatedAt);
                ChannelInfo _item = new ChannelInfo(_tmpChannelId, _tmpUpdatedAt);
                _result.add(_item);
            }
            ArrayList<ChannelInfo> arrayList = _result;
            return arrayList;
        }
        finally {
            _cursor.close();
            _statement.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<ChannelInfo> getChannelInfo(long timeStamp) {
        String _sql = "Select * from channelinfo where updatedAt < ?";
        RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"Select * from channelinfo where updatedAt < ?", (int)1);
        int _argIndex = 1;
        _statement.bindLong(_argIndex, timeStamp);
        this.__db.assertNotSuspendingTransaction();
        Cursor _cursor = DBUtil.query((RoomDatabase)this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
        try {
            int _cursorIndexOfChannelId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"channelId");
            int _cursorIndexOfUpdatedAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"updatedAt");
            ArrayList<ChannelInfo> _result = new ArrayList<ChannelInfo>(_cursor.getCount());
            while (_cursor.moveToNext()) {
                int _tmpChannelId = _cursor.getInt(_cursorIndexOfChannelId);
                long _tmpUpdatedAt = _cursor.getLong(_cursorIndexOfUpdatedAt);
                ChannelInfo _item = new ChannelInfo(_tmpChannelId, _tmpUpdatedAt);
                _result.add(_item);
            }
            ArrayList<ChannelInfo> arrayList = _result;
            return arrayList;
        }
        finally {
            _cursor.close();
            _statement.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ChannelInfo getChannelInfo(int channelId) {
        String _sql = "Select * from ChannelInfo where channelId = ? Order by updatedAt";
        RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"Select * from ChannelInfo where channelId = ? Order by updatedAt", (int)1);
        int _argIndex = 1;
        _statement.bindLong(_argIndex, (long)channelId);
        this.__db.assertNotSuspendingTransaction();
        Cursor _cursor = DBUtil.query((RoomDatabase)this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
        try {
            ChannelInfo _result;
            int _cursorIndexOfChannelId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"channelId");
            int _cursorIndexOfUpdatedAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"updatedAt");
            if (_cursor.moveToFirst()) {
                int _tmpChannelId = _cursor.getInt(_cursorIndexOfChannelId);
                long _tmpUpdatedAt = _cursor.getLong(_cursorIndexOfUpdatedAt);
                _result = new ChannelInfo(_tmpChannelId, _tmpUpdatedAt);
            } else {
                _result = null;
            }
            ChannelInfo channelInfo = _result;
            return channelInfo;
        }
        finally {
            _cursor.close();
            _statement.release();
        }
    }
}

