/*
 * Decompiled with CFR 0.152.
 */
package com.hippo.adapter;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.content.res.AssetManager;
import android.graphics.Typeface;
import android.text.TextUtils;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewTreeObserver;
import android.widget.Button;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;
import androidx.annotation.NonNull;
import androidx.core.app.ActivityOptionsCompat;
import androidx.core.content.ContextCompat;
import androidx.recyclerview.widget.RecyclerView;
import com.bumptech.glide.Glide;
import com.bumptech.glide.RequestBuilder;
import com.bumptech.glide.load.Transformation;
import com.bumptech.glide.load.engine.DiskCacheStrategy;
import com.bumptech.glide.load.resource.bitmap.CenterCrop;
import com.bumptech.glide.load.resource.bitmap.RoundedCorners;
import com.bumptech.glide.request.BaseRequestOptions;
import com.bumptech.glide.request.RequestOptions;
import com.hippo.HippoColorConfig;
import com.hippo.HippoConfig;
import com.hippo.R;
import com.hippo.activity.ImageDisplayActivityNew;
import com.hippo.database.CommonData;
import com.hippo.interfaces.OnItemClickListener;
import com.hippo.langs.Restring;
import com.hippo.model.Image;
import com.hippo.model.promotional.Data;
import com.hippo.utils.DateUtils;
import com.hippo.utils.ProgressBarDisplayRunnable;
import com.hippo.utils.RoundedCornersTransformation;
import com.hippo.utils.Utils;
import java.io.Serializable;
import java.util.ArrayList;

public class CampaignAdapter
extends RecyclerView.Adapter<RecyclerView.ViewHolder> {
    private Context mContext;
    private OnItemClickListener itemClickListener;
    private HippoColorConfig hippoColorConfig;
    private ArrayList<Data> arrayList;
    private RecyclerView recyclerView;
    private static final int VIEW_TYPE = 1;
    private static final int VIEW_TYPE_LOADING = 2;
    private String outputFormat = "dd MMM, yy h:mm a";
    private Typeface customBold;
    private Typeface customNormal;
    private ProgressBarDisplayRunnable progressBarDisplayRunnable;

    public CampaignAdapter(Activity activity, ArrayList<Data> arrayList, RecyclerView recyclerView, OnItemClickListener itemClickListener) {
        this.arrayList = arrayList;
        this.recyclerView = recyclerView;
        this.itemClickListener = itemClickListener;
        this.hippoColorConfig = CommonData.getColorConfig();
        if (HippoConfig.getInstance().getMobileCampaignBuilder() != null && !TextUtils.isEmpty((CharSequence)HippoConfig.getInstance().getMobileCampaignBuilder().getParseFormat())) {
            this.outputFormat = HippoConfig.getInstance().getMobileCampaignBuilder().getParseFormat();
        }
        this.customBold = Typeface.createFromAsset((AssetManager)activity.getAssets(), (String)"fonts/ProximaNova-Sbold.ttf");
        this.customNormal = Typeface.createFromAsset((AssetManager)activity.getAssets(), (String)"fonts/ProximaNova-Reg.ttf");
    }

    public void setData(ArrayList<Data> arrayList) {
        this.arrayList = arrayList;
        this.notifyDataSetChanged();
    }

    @NonNull
    public RecyclerView.ViewHolder onCreateViewHolder(@NonNull ViewGroup viewGroup, int viewType) {
        this.mContext = viewGroup.getContext();
        if (viewType == 2) {
            return new LoadMoreHolder(LayoutInflater.from((Context)this.mContext).inflate(R.layout.hippo_layout_loaddata, viewGroup, false));
        }
        return new ViewHolder(LayoutInflater.from((Context)this.mContext).inflate(R.layout.hippo_item_campaign, viewGroup, false));
    }

    private static int countLines(String str) {
        String[] lines = str.split("\r\n|\r|\n");
        return lines.length;
    }

    public void onBindViewHolder(@NonNull RecyclerView.ViewHolder holder, int pos) {
        if (holder instanceof ViewHolder) {
            String text;
            final ViewHolder viewHolder = (ViewHolder)holder;
            viewHolder.title.setText((CharSequence)this.arrayList.get(pos).getTitle());
            String description = this.arrayList.get(pos).getDescription();
            int count = CampaignAdapter.countLines(description);
            viewHolder.description.setText((CharSequence)description);
            viewHolder.tvMsg.setText((CharSequence)description);
            viewHolder.clearBtn.setText((CharSequence)Restring.getString(this.mContext, R.string.hippo_clear));
            if (this.arrayList.get(pos).getShowMore() == 2) {
                text = Restring.getString(this.mContext, R.string.hippo_read_less);
                viewHolder.readStatus.setText((CharSequence)text);
                viewHolder.tvMsg.setVisibility(8);
                viewHolder.description.setVisibility(0);
                viewHolder.readStatus.setVisibility(0);
            } else if (count > 0 && description.length() < 160) {
                viewHolder.description.setVisibility(0);
                viewHolder.tvMsg.setVisibility(8);
                viewHolder.readStatus.setVisibility(8);
            } else {
                text = Restring.getString(this.mContext, R.string.hippo_read_more);
                viewHolder.readStatus.setText((CharSequence)text);
                viewHolder.readStatus.setVisibility(0);
                viewHolder.tvMsg.setVisibility(0);
                viewHolder.description.setVisibility(8);
            }
            String time = DateUtils.getRelativeDate(DateUtils.getInstance().convertToLocal(this.arrayList.get(pos).getCreatedAt()), true);
            viewHolder.dateTime.setText((CharSequence)time);
            String imagePath = "";
            try {
                imagePath = this.arrayList.get(pos).getCustomAttributes().getImage().getImageUrl();
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (TextUtils.isEmpty((CharSequence)imagePath)) {
                viewHolder.imageView.setVisibility(8);
            } else {
                float dpCalculation = this.mContext.getResources().getDisplayMetrics().density;
                ViewTreeObserver vto = viewHolder.mainLayout.getViewTreeObserver();
                vto.addOnPreDrawListener(new ViewTreeObserver.OnPreDrawListener(){

                    public boolean onPreDraw() {
                        int finalHeight;
                        viewHolder.mainLayout.getViewTreeObserver().removeOnPreDrawListener((ViewTreeObserver.OnPreDrawListener)this);
                        int finalWidth = viewHolder.mainLayout.getMeasuredWidth();
                        ((ViewHolder)viewHolder).imageView.getLayoutParams().height = finalHeight = (int)((double)finalWidth / 2.5);
                        Log.e((String)"finalWidth", (String)("finalWidth = " + finalWidth));
                        Log.e((String)"finalHeight", (String)("finalHeight = " + finalHeight));
                        viewHolder.imageView.setVisibility(0);
                        return true;
                    }
                });
                RequestOptions myOptions = (RequestOptions)((RequestOptions)((RequestOptions)((RequestOptions)RequestOptions.bitmapTransform((Transformation)new RoundedCornersTransformation(this.mContext, 10, 1)).placeholder(ContextCompat.getDrawable((Context)this.mContext, (int)R.drawable.hippo_placeholder))).dontAnimate()).diskCacheStrategy(DiskCacheStrategy.ALL)).error(ContextCompat.getDrawable((Context)this.mContext, (int)R.drawable.hippo_placeholder));
                ((RequestBuilder)((RequestBuilder)Glide.with((Context)this.mContext).load(imagePath).fitCenter()).apply((BaseRequestOptions)myOptions).transform(new Transformation[]{new CenterCrop(), new RoundedCorners(12)})).into(viewHolder.imageView);
            }
            viewHolder.title.setTypeface(this.customBold);
            viewHolder.description.setTypeface(this.customNormal);
            viewHolder.tvMsg.setTypeface(this.customNormal);
            viewHolder.dateTime.setTypeface(this.customNormal);
            viewHolder.readStatus.setTypeface(this.customNormal);
        }
    }

    public int getItemCount() {
        return this.arrayList == null ? 0 : this.arrayList.size();
    }

    public int getItemViewType(int position) {
        try {
            if (this.arrayList.get(position).getUserId() == -3) {
                return 2;
            }
            return 1;
        }
        catch (Exception e) {
            return 1;
        }
    }

    public void showPaginationProgressBar(boolean show, boolean notifyAdapter) {
        boolean isProgressBarExist;
        if (this.arrayList == null || this.arrayList.size() == 0) {
            return;
        }
        boolean bl = isProgressBarExist = this.arrayList.get(this.arrayList.size() - 1).getUserId() == -3;
        if (show) {
            if (!isProgressBarExist) {
                this.arrayList.add(ProgressBarModel.getInstance());
                if (notifyAdapter) {
                    this.recyclerView.post((Runnable)this.getProgressDisplayRunnable(true, this.arrayList.size()));
                }
            }
        } else if (this.arrayList.remove(ProgressBarModel.getInstance()) && notifyAdapter) {
            this.recyclerView.post((Runnable)this.getProgressDisplayRunnable(false, this.arrayList.size()));
        }
    }

    private ProgressBarDisplayRunnable getProgressDisplayRunnable(boolean isInsert, int position) {
        if (this.progressBarDisplayRunnable == null) {
            this.progressBarDisplayRunnable = new ProgressBarDisplayRunnable(this);
        }
        this.progressBarDisplayRunnable.setInsert(isInsert);
        this.progressBarDisplayRunnable.setPosition(position);
        return this.progressBarDisplayRunnable;
    }

    public void setTextSize(TextView textView, float size) {
        textView.setTextSize(2, size);
    }

    private void showImageDialog(Activity activity, String imgUrl, ImageView imageView) {
        try {
            if (!Utils.preventMultipleClicks()) {
                return;
            }
            Intent profileImageIntent = new Intent((Context)activity, ImageDisplayActivityNew.class);
            Image profileImage = new Image(imgUrl, imgUrl, "imageOne", "", "");
            profileImageIntent.putExtra("image", (Serializable)profileImage);
            ActivityOptionsCompat options = ActivityOptionsCompat.makeSceneTransitionAnimation((Activity)activity, (View)imageView, (String)"imageOne");
            activity.startActivity(profileImageIntent, options.toBundle());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static class ProgressBarModel {
        private static Data progressBarModel;

        private ProgressBarModel() {
        }

        public static Data getInstance() {
            if (progressBarModel == null) {
                progressBarModel = new Data(-3);
            }
            return progressBarModel;
        }
    }

    public class ViewHolder
    extends RecyclerView.ViewHolder {
        private LinearLayout mainLayout;
        private ImageView imageView;
        private TextView title;
        private TextView description;
        private TextView dateTime;
        private TextView tvMsg;
        private TextView readStatus;
        private Button clearBtn;

        public ViewHolder(View itemView) {
            super(itemView);
            this.mainLayout = (LinearLayout)itemView.findViewById(R.id.mainLayout);
            this.imageView = (ImageView)itemView.findViewById(R.id.ivImage);
            this.title = (TextView)itemView.findViewById(R.id.tvTitle);
            this.description = (TextView)itemView.findViewById(R.id.tvDescription);
            this.tvMsg = (TextView)itemView.findViewById(R.id.tvMsg);
            this.readStatus = (TextView)itemView.findViewById(R.id.readStatus);
            this.dateTime = (TextView)itemView.findViewById(R.id.tvDateTime);
            this.clearBtn = (Button)itemView.findViewById(R.id.clearBtn);
            CampaignAdapter.this.setTextSize(this.title, 16.0f);
            CampaignAdapter.this.setTextSize(this.description, 14.0f);
            CampaignAdapter.this.setTextSize(this.readStatus, 14.0f);
            CampaignAdapter.this.setTextSize(this.dateTime, 13.4f);
            this.mainLayout.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    if (CampaignAdapter.this.itemClickListener != null) {
                        CampaignAdapter.this.itemClickListener.onClickListener(ViewHolder.this.getAdapterPosition());
                    }
                }
            });
            this.readStatus.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    if (ViewHolder.this.description.getVisibility() == 0) {
                        ((Data)CampaignAdapter.this.arrayList.get(ViewHolder.this.getAdapterPosition())).setShowMore(1);
                    } else {
                        ((Data)CampaignAdapter.this.arrayList.get(ViewHolder.this.getAdapterPosition())).setShowMore(2);
                    }
                    CampaignAdapter.this.notifyItemChanged(ViewHolder.this.getAdapterPosition());
                }
            });
            this.imageView.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    String imagePath = "";
                    try {
                        imagePath = ((Data)CampaignAdapter.this.arrayList.get(ViewHolder.this.getAdapterPosition())).getCustomAttributes().getImage().getImageUrl();
                        CampaignAdapter.this.showImageDialog((Activity)CampaignAdapter.this.mContext, imagePath, ViewHolder.this.imageView);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            });
        }
    }

    public class LoadMoreHolder
    extends RecyclerView.ViewHolder {
        public LoadMoreHolder(View itemView) {
            super(itemView);
        }
    }
}

