package com.hippo.adapter;

import android.content.Context;
import android.text.TextUtils;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.RelativeLayout;

import androidx.annotation.NonNull;
import androidx.appcompat.widget.AppCompatImageView;
import androidx.appcompat.widget.AppCompatTextView;
import androidx.cardview.widget.CardView;
import androidx.core.content.ContextCompat;
import androidx.recyclerview.widget.RecyclerView;

import com.bumptech.glide.Glide;
import com.bumptech.glide.load.engine.DiskCacheStrategy;
import com.bumptech.glide.request.RequestOptions;
import com.hippo.HippoColorConfig;
import com.hippo.R;
import com.hippo.callback.OnTeamClickListener;
import com.hippo.database.CommonData;
import com.hippo.model.searchagent.AgentsList;
import com.hippo.utils.ProgressBarDisplayRunnable;
import com.hippo.utils.RoundedCornersTransformation;

import java.util.ArrayList;

/**
 * Created by gurmail on 03/12/20.
 *
 * @author gurmail
 */

public class SearchAgentAdapter extends RecyclerView.Adapter<RecyclerView.ViewHolder> {

    private Context mContext;
    private OnTeamClickListener itemClickListener;
    private AgentInfoSelected agentInfoSelected;
    private HippoColorConfig hippoColorConfig;
    private ArrayList<AgentsList> arrayList;
    private RecyclerView recyclerView;
    private static final int VIEW_TYPE = 1;
    private static final int VIEW_TYPE_LOADING = 2;

    public SearchAgentAdapter(ArrayList<AgentsList> arrayList, RecyclerView recyclerView, OnTeamClickListener itemClickListener) {
        this.arrayList = arrayList;
        this.recyclerView = recyclerView;
        this.itemClickListener = itemClickListener;
        hippoColorConfig = CommonData.getColorConfig();
    }

    public SearchAgentAdapter(ArrayList<AgentsList> arrayList, RecyclerView recyclerView, OnTeamClickListener itemClickListener, AgentInfoSelected agentInfoSelected) {
        this.arrayList = arrayList;
        this.recyclerView = recyclerView;
        this.itemClickListener = itemClickListener;
        this.agentInfoSelected = agentInfoSelected;
        hippoColorConfig = CommonData.getColorConfig();
    }

    @NonNull
    @Override
    public RecyclerView.ViewHolder onCreateViewHolder(@NonNull ViewGroup viewGroup, int viewType) {
        mContext = viewGroup.getContext();
        if (viewType == VIEW_TYPE_LOADING) {
            return new SearchAgentAdapter.LoadMoreHolder(LayoutInflater.from(mContext)
                    .inflate(R.layout.hippo_layout_loaddata, viewGroup, false));
        } else {
            return new SearchAgentAdapter.ViewHolder(LayoutInflater.from(mContext).inflate(R.layout.hippo_agent_itam, viewGroup, false), itemClickListener);
        }
    }

    @Override
    public void onBindViewHolder(@NonNull RecyclerView.ViewHolder holder, int pos) {
        if (holder instanceof SearchAgentAdapter.ViewHolder) {
            final SearchAgentAdapter.ViewHolder viewHolder = (SearchAgentAdapter.ViewHolder) holder;
            AgentsList item = arrayList.get(pos);
            viewHolder.agentName.setText(item.getTitle());
            viewHolder.agentDesc.setText(item.getDescription());

            try {
                if (!TextUtils.isEmpty(item.getRating())) {
                    viewHolder.starLayout.setVisibility(View.VISIBLE);
                    viewHolder.starText.setText("" + item.getRating());
                } else {
                    viewHolder.starLayout.setVisibility(View.GONE);
                }
            } catch (Exception e) {
                e.printStackTrace();
                viewHolder.starLayout.setVisibility(View.GONE);
            }

            if (TextUtils.isEmpty(item.getOnline_status())) {
                viewHolder.status.setVisibility(View.GONE);
            } else {
                viewHolder.status.setVisibility(View.VISIBLE);
                if (item.getOnline_status().equalsIgnoreCase("AVAILABLE")) {
                    viewHolder.status.setBackgroundResource(R.drawable.hippo_circle_online);
                } else {
                    viewHolder.status.setBackgroundResource(R.drawable.hippo_circle_offline);
                }
            }

            RequestOptions myOptions = RequestOptions
                    .bitmapTransform(new RoundedCornersTransformation(mContext, 4, 1))
                    .placeholder(ContextCompat.getDrawable(mContext, R.drawable.hippo_placeholder))
                    .fitCenter()
                    .dontAnimate()
                    .diskCacheStrategy(DiskCacheStrategy.ALL)
                    .error(ContextCompat.getDrawable(mContext, R.drawable.hippo_man));
            Glide.with(mContext).load(item.getImage_url())
                    .apply(myOptions)
                    .into(viewHolder.userImage);


        }
    }

    @Override
    public int getItemCount() {
        return (arrayList == null) ? 0 : arrayList.size();
    }

    @Override
    public int getItemViewType(int position) {
        try {
            if (arrayList.get(position).getId().equalsIgnoreCase("-3")) {
                return VIEW_TYPE_LOADING;
            } else {
                return VIEW_TYPE;
            }
        } catch (Exception e) {
            return VIEW_TYPE;
        }
    }

    public class LoadMoreHolder extends RecyclerView.ViewHolder {
        public LoadMoreHolder(View itemView) {
            super(itemView);

        }
    }

    public class ViewHolder extends RecyclerView.ViewHolder {
        private CardView cardView;
        private AppCompatImageView userImage;
        private AppCompatTextView agentName;
        private AppCompatTextView agentDesc;
        private AppCompatTextView starText;
        private RelativeLayout starLayout;
        private AppCompatImageView status;
        private LinearLayout info;

        public ViewHolder(@NonNull View itemView, final OnTeamClickListener itemClickListener) {
            super(itemView);
            cardView = itemView.findViewById(R.id.cardView);
            userImage = itemView.findViewById(R.id.userImage);
            agentName = itemView.findViewById(R.id.agentName);
            agentDesc = itemView.findViewById(R.id.agentDesc);
            starText = itemView.findViewById(R.id.starText);
            starLayout = itemView.findViewById(R.id.starLayout);
            status = itemView.findViewById(R.id.status);
            info = itemView.findViewById(R.id.info);

            cardView.setOnClickListener(new View.OnClickListener() {
                @Override
                public void onClick(View v) {
                    itemClickListener.onAgentSelected(arrayList.get(getAdapterPosition()), getAdapterPosition());
                }
            });

            info.setOnClickListener(new View.OnClickListener() {
                @Override
                public void onClick(View view) {
                    if (agentInfoSelected!=null)
                        agentInfoSelected.onAgentInfoSelected(arrayList.get(getAdapterPosition()), getAdapterPosition());
                }
            });
        }
    }

    public void showPaginationProgressBar(boolean show, boolean notifyAdapter) {
        if (arrayList == null || arrayList.size() == 0)
            return;

        boolean isProgressBarExist = arrayList.get(arrayList.size() - 1).getId().equals("-3");
        if (show) {
            if (!isProgressBarExist) {
                arrayList.add(SearchAgentAdapter.ProgressBarModel.getInstance());
                if (notifyAdapter) {
                    recyclerView.post(getProgressDisplayRunnable(true, arrayList.size()));
                }
            }
        } else {
            if (arrayList.remove(SearchAgentAdapter.ProgressBarModel.getInstance())) {
                if (notifyAdapter) {
                    recyclerView.post(getProgressDisplayRunnable(false, arrayList.size()));
                }
            }
        }
    }

    private ProgressBarDisplayRunnable progressBarDisplayRunnable;

    private ProgressBarDisplayRunnable getProgressDisplayRunnable(boolean isInsert, int position) {
        if (progressBarDisplayRunnable == null) {
            progressBarDisplayRunnable = new ProgressBarDisplayRunnable(this);
        }
        progressBarDisplayRunnable.setInsert(isInsert);
        progressBarDisplayRunnable.setPosition(position);

        return progressBarDisplayRunnable;
    }


    private static class ProgressBarModel {
        private static AgentsList progressBarModel;

        private ProgressBarModel() {
        }

        public static AgentsList getInstance() {
            if (progressBarModel == null)
                progressBarModel = new AgentsList("-3", "", "", "", "", "");
            return progressBarModel;
        }
    }

    public interface AgentInfoSelected {
        void onAgentInfoSelected(AgentsList agentsList, int adapterPosition);
    }

}
