/*
 * Decompiled with CFR 0.152.
 */
package com.hippo.payment;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.os.Handler;
import android.util.Log;
import android.view.View;
import com.google.gson.Gson;
import com.hippo.R;
import com.hippo.activity.FuguBaseActivity;
import com.hippo.database.CommonData;
import com.hippo.payment.RazorPayData;
import com.hippo.utils.filepicker.ToastUtil;
import com.razorpay.Checkout;
import com.razorpay.PaymentData;
import com.razorpay.PaymentResultWithDataListener;
import java.io.Serializable;
import java.lang.reflect.Type;
import java.util.HashMap;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONObject;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0012\u0010\u0012\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u0015H\u0014J \u0010\u0016\u001a\u00020\u00132\u0006\u0010\u0017\u001a\u00020\u00052\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0016J\u0018\u0010\u001c\u001a\u00020\u00132\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0016J \u0010\u001d\u001a\u00020\u00132\u0006\u0010\u001e\u001a\u00020\u00192\u0006\u0010\u001f\u001a\u00020\u00192\u0006\u0010 \u001a\u00020\u0019H\u0002J\u001e\u0010!\u001a\u00020\u00132\u0006\u0010\u0010\u001a\u00020\u00052\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u000f\u001a\u00020\u0005J\u001e\u0010\"\u001a\u00020\u00132\u0006\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020(J\u001e\u0010\"\u001a\u00020\u00132\u0006\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020)2\u0006\u0010'\u001a\u00020(R\u0014\u0010\u0004\u001a\u00020\u00058BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R*\u0010\n\u001a\u0004\u0018\u00010\t2\b\u0010\b\u001a\u0004\u0018\u00010\t8F@BX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u0014\u0010\u000f\u001a\u00020\u00058BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0007R\u0014\u0010\u0010\u001a\u00020\u00058BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0007\u00a8\u0006*"}, d2={"Lcom/hippo/payment/RazorPayment;", "Lcom/hippo/activity/FuguBaseActivity;", "Lcom/razorpay/PaymentResultWithDataListener;", "()V", "authOrderId", "", "getAuthOrderId", "()I", "<set-?>", "Landroid/os/Handler;", "handler", "getHandler", "()Landroid/os/Handler;", "setHandler", "(Landroid/os/Handler;)V", "isFromNegativeBalanceSettle", "refId", "getRefId", "onCreate", "", "savedInstanceState", "Landroid/os/Bundle;", "onPaymentError", "i", "s", "", "paymentData", "Lcom/razorpay/PaymentData;", "onPaymentSuccess", "razorpayCallbackIntentService", "paymentId", "signature", "error", "setPurchaseSubscriptionResponse", "startRazorPayPayment", "activity", "Landroid/app/Activity;", "options", "Lcom/hippo/payment/RazorPayData;", "isUPI", "", "Lorg/json/JSONObject;", "hippo_release"})
public final class RazorPayment
extends FuguBaseActivity
implements PaymentResultWithDataListener {
    @Nullable
    private Handler handler;
    private HashMap _$_findViewCache;

    public void onPaymentSuccess(@NotNull String s, @NotNull PaymentData paymentData) {
        Intrinsics.checkParameterIsNotNull((Object)s, (String)"s");
        Intrinsics.checkParameterIsNotNull((Object)paymentData, (String)"paymentData");
        String paymentId = paymentData.getPaymentId();
        String signature = paymentData.getSignature();
        String string2 = paymentId;
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"paymentId");
        String string3 = signature;
        Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"signature");
        this.razorpayCallbackIntentService(string2, string3, "");
        ToastUtil.getInstance((Context)this).showToast("Payment done");
    }

    public void onPaymentError(int i, @NotNull String s, @NotNull PaymentData paymentData) {
        Intrinsics.checkParameterIsNotNull((Object)s, (String)"s");
        Intrinsics.checkParameterIsNotNull((Object)paymentData, (String)"paymentData");
        this.razorpayCallbackIntentService("-1", "-1", s);
        ToastUtil.getInstance((Context)this).showToast("Payment failed " + s);
        this.finish();
    }

    @Override
    protected void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        Intent intent = this.getIntent();
        Serializable serializable = intent != null ? intent.getSerializableExtra("razorpayObj") : null;
        if (serializable == null) {
            throw new TypeCastException("null cannot be cast to non-null type com.hippo.payment.RazorPayData");
        }
        RazorPayData options = (RazorPayData)serializable;
        this.startRazorPayPayment((Activity)this, options, false);
    }

    public final void startRazorPayPayment(@NotNull Activity activity, @NotNull RazorPayData options, boolean isUPI) {
        Intrinsics.checkParameterIsNotNull((Object)activity, (String)"activity");
        Intrinsics.checkParameterIsNotNull((Object)options, (String)"options");
        try {
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("order_id", (Object)options.getOrderId());
            jsonObject.put("phone_no", (Object)options.getPhoneNo());
            jsonObject.put("user_email", (Object)options.getUserEmail());
            jsonObject.put("description", (Object)options.getDescription());
            jsonObject.put("auth_order_id", (Object)options.getAuthOrderId());
            jsonObject.put("amount", options.getAmount());
            jsonObject.put("currency", (Object)options.getCurrency());
            jsonObject.put("name", (Object)options.getName());
            this.startRazorPayPayment(activity, jsonObject, isUPI);
        }
        catch (Exception e) {
            e.printStackTrace();
            Gson gson = new Gson();
            JSONObject jObj = new JSONObject();
            try {
                jObj = new JSONObject(gson.toJson((Object)options, (Type)((Object)RazorPayData.class)));
            }
            catch (Exception e1) {
                e1.printStackTrace();
            }
            this.startRazorPayPayment(activity, jObj, isUPI);
        }
    }

    public final void startRazorPayPayment(@NotNull Activity activity, @NotNull JSONObject options, boolean isUPI) {
        Intrinsics.checkParameterIsNotNull((Object)activity, (String)"activity");
        Intrinsics.checkParameterIsNotNull((Object)options, (String)"options");
        Checkout checkout = new Checkout();
        checkout.setKeyID("rzp_live_fsWpMDBnrFvyiW");
        checkout.setImage(R.drawable.hippo_apple);
        try {
            options.remove("auth_order_id");
            Object object = options.remove("user_email");
            if (object == null) {
                Intrinsics.throwNpe();
            }
            options.put("prefill.email", (Object)object.toString());
            Object object2 = options.remove("phone_no");
            if (object2 == null) {
                Intrinsics.throwNpe();
            }
            options.put("prefill.contact", (Object)object2.toString());
            options.put("prefill.method", (Object)"upi");
            options.put("prefill.vpa", (Object)"");
            Log.i((String)"RazorpayBaseActivity", (String)("startRazorPayPayment options=" + options));
            checkout.setFullScreenDisable(true);
            checkout.open(activity, options);
        }
        catch (Exception e) {
            e.printStackTrace();
            Log.e((String)"TAG", (String)"Error in starting Razorpay Checkout");
        }
    }

    private final void razorpayCallbackIntentService(String paymentId, String signature, String error) {
    }

    public final void setPurchaseSubscriptionResponse(int refId, int authOrderId, int isFromNegativeBalanceSettle) {
        CommonData.saveData("sp_rzp_order_id", refId);
        CommonData.saveData("sp_rzp_auth_order_id", authOrderId);
        CommonData.saveData("sp_negative_balance_settle", isFromNegativeBalanceSettle);
    }

    private final int getRefId() {
        return CommonData.getInt("sp_rzp_order_id", -1);
    }

    private final int getAuthOrderId() {
        return CommonData.getInt("sp_rzp_auth_order_id", -1);
    }

    private final int isFromNegativeBalanceSettle() {
        return CommonData.getInt("sp_negative_balance_settle", 0);
    }

    @Nullable
    public final Handler getHandler() {
        if (this.handler == null) {
            this.handler = new Handler();
        }
        return this.handler;
    }

    private final void setHandler(Handler handler) {
        this.handler = handler;
    }

    public View _$_findCachedViewById(int n) {
        View view;
        if (this._$_findViewCache == null) {
            this._$_findViewCache = new HashMap();
        }
        if ((view = (View)this._$_findViewCache.get(n)) == null) {
            view = this.findViewById(n);
            this._$_findViewCache.put(n, view);
        }
        return view;
    }

    public void _$_clearFindViewByIdCache() {
        if (this._$_findViewCache != null) {
            this._$_findViewCache.clear();
        }
    }
}

