package com.hippo.fragment;

import android.os.Bundle;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import android.widget.TextView;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;

import com.google.android.material.bottomsheet.BottomSheetDialog;
import com.google.android.material.bottomsheet.BottomSheetDialogFragment;
import com.google.gson.Gson;
import com.hippo.R;
import com.hippo.activity.FuguChatActivity;
import com.hippo.adapter.CountryAdapter;
import com.hippo.adapter.PaymentGatewayAdapter;
import com.hippo.apis.GetPaymentGateway;
import com.hippo.callback.OnPaymentItemClickListener;
import com.hippo.callback.OnPaymentListListener;
import com.hippo.database.CommonData;
import com.hippo.interfaces.onCountrySelect;
import com.hippo.langs.Restring;
import com.hippo.model.HippoPayment;
import com.hippo.model.payment.AddedPaymentGateway;
import com.hippo.utils.loadingBox.ProgressWheel;

import java.lang.reflect.Array;
import java.util.ArrayList;

/**
 * Created by gurmail on 2020-05-06.
 *
 * @author gurmail
 */
public class BottomSheetCountry extends BottomSheetDialogFragment implements onCountrySelect {

    private static onCountrySelect onCountrySelect;
    private RecyclerView recyclerView;
    private String country[] = {"All", "India", "USA", "China", "Japan"};
    private CountryAdapter countryAdapter;
    private LinearLayoutManager layoutManager;


    public static BottomSheetCountry newInstance(Bundle args,onCountrySelect listner) {
        onCountrySelect=listner;
        BottomSheetCountry frag = new BottomSheetCountry();
        frag.setArguments(args);
        return frag;
    }

    @Override
    public void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);

    }

    @Nullable
    @Override
    public View onCreateView(@NonNull LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        new BottomSheetDialog(requireContext(), getTheme());
        return inflater.inflate(R.layout.country_bottom_sheet, container, false);
    }

    @Override
    public void onViewCreated(@NonNull View view, @Nullable Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);
        recyclerView = view.findViewById(R.id.recyclerView);
        layoutManager = new LinearLayoutManager(getContext());
        layoutManager.setOrientation(LinearLayoutManager.VERTICAL);
        recyclerView.setLayoutManager(layoutManager);
        countryAdapter=new CountryAdapter(getActivity(),country,this);
        recyclerView.setAdapter(countryAdapter);

    }

    @Override
    public int getTheme() {
        return R.style.AppBottomSheetDialogTheme;
    }


    @Override
    public void onCountrySelected(String country, int position) {
        onCountrySelect.onCountrySelected(country,position);
        dismiss();
    }
}
