package com.hippo.activity

import android.app.Activity
import android.content.Intent
import android.os.Bundle
import android.view.View
import android.widget.AdapterView
import android.widget.ArrayAdapter
import android.widget.Toast
import androidx.recyclerview.widget.LinearLayoutManager
import androidx.recyclerview.widget.RecyclerView
import com.hippo.BuildConfig
import com.hippo.HippoConfig
import com.hippo.R
import com.hippo.adapter.SearchAgentAdapter
import com.hippo.adapter.SearchTeamAdapter
import com.hippo.callback.OnTeamClickListener
import com.hippo.constant.FuguAppConstant
import com.hippo.fragment.BottomSheetCountry
import com.hippo.interfaces.onCountrySelect
import com.hippo.langs.Restring
import com.hippo.model.searchagent.AgentsList
import com.hippo.model.searchagent.SearchAgentList
import com.hippo.model.searchagent.SearchAgentResponse
import com.hippo.model.searchagent.Team
import com.hippo.retrofit.APIError
import com.hippo.retrofit.CommonParams
import com.hippo.retrofit.ResponseResolver
import com.hippo.retrofit.RestClient
import com.hippo.utils.SearchViewNetworkQueryHelper
import kotlinx.android.synthetic.main.activity_search_agent.*
import org.json.JSONArray


/**
 * Created by gurmail on 03/12/20.
 * @author gurmail
 */
class SearchAgentActivity : FuguBaseActivity(), SearchViewNetworkQueryHelper.SearchCallbacks,
        OnTeamClickListener, onCountrySelect {

    private var tag_id: Int = 0
    private var mSearchNetworkQueryHelper: SearchViewNetworkQueryHelper? = null
    private lateinit var searchAdapter: SearchTeamAdapter
    private lateinit var agentAdapter: SearchAgentAdapter
    private val arralyList: ArrayList<Team> = ArrayList()
    private val agentArrayList: ArrayList<AgentsList> = ArrayList()

    private var layoutManager: LinearLayoutManager? = null
    private var pastVisiblesItems = 0
    private var visibleItemCount: Int = 0
    private var totalItemCount: Int = 0
    private var hasMorePages = false
    private var isPagingApiInProgress = false
    private var teamId = -1
    private var startOffset = 0
    private val offset = 20
    private var muid = ""
    private var messagePos = -1

    var country = arrayOf("All", "India", "USA", "China", "Japan")

    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
        setContentView(R.layout.activity_search_agent)

        if (intent.hasExtra("muid"))
            muid = intent.getStringExtra("muid")
        if (intent.hasExtra("messagePos"))
            messagePos = intent.getIntExtra("messagePos", -1)

        mSearchNetworkQueryHelper = SearchViewNetworkQueryHelper(etInputData, this)
        mSearchNetworkQueryHelper?.suggestCountThreshold = 3
        mSearchNetworkQueryHelper?.suggestWaitThreshold = 300

        arralyList.clear()
        searchAdapter = SearchTeamAdapter(arralyList, this)
        recyclerView.adapter = searchAdapter

        layoutManager = LinearLayoutManager(this)
        layoutManager?.orientation = LinearLayoutManager.VERTICAL
        agentRecyclerView.layoutManager = layoutManager
        agentRecyclerView.visibility = View.GONE
        recyclerView.visibility = View.VISIBLE
        agentAdapter = SearchAgentAdapter(agentArrayList, agentRecyclerView, this)
        agentRecyclerView.adapter = agentAdapter

        agentRecyclerView.addOnScrollListener(object : RecyclerView.OnScrollListener() {
            override fun onScrolled(recyclerView: RecyclerView, dx: Int, dy: Int) {
                super.onScrolled(recyclerView, dx, dy)
                if (dy > 0) {
                    visibleItemCount = layoutManager?.childCount!!
                    totalItemCount = layoutManager!!.itemCount
                    pastVisiblesItems = layoutManager!!.findFirstVisibleItemPosition()
                    if (!isPagingApiInProgress && hasMorePages) {
                        if (visibleItemCount + pastVisiblesItems >= totalItemCount) {
                            isPagingApiInProgress = true
                            startOffset = agentArrayList.size
                            loadAgentData(teamId, startOffset, offset)
                        }
                    }
                }
            }
        })

//        countrySP.setOnItemSelectedListener(this)
        countryTV.setOnClickListener(View.OnClickListener {
            val bundle = Bundle()
            val bottomSheetPopup = BottomSheetCountry.newInstance(bundle, this)
            bottomSheetPopup.show(supportFragmentManager, bottomSheetPopup.tag)
        });
        //Creating the ArrayAdapter instance having the country list

//        val countryAdapter: ArrayAdapter<*> = ArrayAdapter<Any?>(this, android.R.layout.simple_spinner_item, country)
//        countryAdapter.setDropDownViewResource(android.R.layout.simple_spinner_dropdown_item)

        ivBackBtn?.setOnClickListener {
            onBackPressed()
        }

    }

    override fun showAllData() {
        circle_progress?.visibility = View.GONE
        action_view?.visibility = View.VISIBLE
    }

    override fun showLoader() {
        circle_progress?.visibility = View.VISIBLE
        action_view?.visibility = View.GONE
    }

    override fun performQuery(query: String?) {
//        circle_progress?.visibility = View.GONE
//        action_view?.visibility = View.VISIBLE

        if (query != null && query.length > 2)
            searchTeam(query, false)
    }

    private fun searchTeam(teamName: String, isCountrySelection: Boolean) {
        val params = CommonParams.Builder()
                .add(FuguAppConstant.APP_SECRET_KEY, HippoConfig.getInstance().getAppKey())
                .add(FuguAppConstant.DEVICE_TYPE, FuguAppConstant.ANDROID_USER)
                .add(FuguAppConstant.APP_VERSION, BuildConfig.VERSION_NAME)
                .add(FuguAppConstant.APP_VERSION_CODE, BuildConfig.VERSION_CODE)
                .add("team_name", teamName)
                .build()

        RestClient.getApiInterface().searchTeams(params.map).enqueue(object : ResponseResolver<SearchAgentResponse>(this, false, true) {
            override fun success(t: SearchAgentResponse?) {
                arralyList.clear()
                arralyList.addAll(t?.data!!)
                circle_progress?.visibility = View.GONE

                if (isCountrySelection) {
                    if (arralyList.size > 0) {
                        tag_id = arralyList.get(0).tag_id
                    }

                } else {
                    action_view?.visibility = View.VISIBLE

                    agentRecyclerView.visibility = View.GONE
                    recyclerView.visibility = View.VISIBLE


                    searchAdapter.notifyDataSetChanged()

                    if (arralyList.size == 0) {
                        llNoNotifications.setVisibility(View.VISIBLE)
                        agentRecyclerView.visibility = View.GONE
                        recyclerView.visibility = View.GONE
                    } else {
                        llNoNotifications.setVisibility(View.GONE)
                    }

                }
            }

            override fun failure(error: APIError?) {

            }
        })
    }

    override fun onItemSelected(teamId: Int, pos: Int) {
        this.teamId = teamId
        startOffset = 0
        loadAgentData(teamId, startOffset, offset)
    }

    override fun onAgentSelected(agentData: AgentsList, pos: Int) {
        val intent = Intent()
        intent.putExtra("data", agentData)
        intent.putExtra("muid", muid)
        intent.putExtra("messagePos", messagePos)
        setResult(Activity.RESULT_OK, intent)
        finish()
    }

    private fun loadAgentData(teamId: Int, startOffset: Int, endOffset: Int) {
        val params = CommonParams.Builder()
                .add(FuguAppConstant.APP_SECRET_KEY, HippoConfig.getInstance().getAppKey())
                .add(FuguAppConstant.DEVICE_TYPE, FuguAppConstant.ANDROID_USER)
                .add(FuguAppConstant.APP_VERSION, BuildConfig.VERSION_NAME)
                .add(FuguAppConstant.APP_VERSION_CODE, BuildConfig.VERSION_CODE)
                .add("start_offset", startOffset)
                .add("end_offset", endOffset)
                .build()

        if (tag_id > 0) {
            val jsonArray = JSONArray()
            jsonArray.put(tag_id)
            jsonArray.put(teamId)
            params.map.put("tag_ids", jsonArray)
        } else {
            params.map.put("tag_id", teamId)
        }


//        tag_ids or tag_id
//        tag_ids : [<Country tag_id>,<skill_tag_id>]
        RestClient.getApiInterface().getTeamAgentsCard(params.map).enqueue(object : ResponseResolver<SearchAgentList>(this, true, true) {
            override fun success(t: SearchAgentList?) {
                if (startOffset == 0) {
                    agentArrayList.clear()
                    agentRecyclerView.visibility = View.VISIBLE
                    recyclerView.visibility = View.GONE
                }

                if (startOffset != 0) {
                    isPagingApiInProgress = false
                    agentAdapter.showPaginationProgressBar(false, true)
                }

                agentArrayList.addAll(t!!.data)

                if (agentArrayList.size == 0) {
                    llNoNotifications.setVisibility(View.VISIBLE)
                    agentRecyclerView.visibility = View.GONE
                    recyclerView.visibility = View.GONE
                } else {
                    llNoNotifications.setVisibility(View.GONE)
                }

                if (agentAdapter != null) {
                    agentAdapter.notifyDataSetChanged()
                }
                isPagingApiInProgress = false
                hasMorePages = t.data.size != 0
            }

            override fun failure(error: APIError?) {
                isPagingApiInProgress = false
            }
        })
    }


    override fun onCountrySelected(country: String, position: Int) {
        if (position > 0)
            searchTeam(country, true)
        else
            tag_id = 0

        countryTV.text = country
    }


}
