/*
 * Decompiled with CFR 0.152.
 */
package com.hippo.utils;

import android.app.Activity;
import android.text.TextUtils;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.hippo.HippoConfig;
import com.hippo.UnreadCountFor;
import com.hippo.database.CommonData;
import com.hippo.model.FuguConversation;
import com.hippo.model.FuguGetConversationsResponse;
import com.hippo.model.HippoUnreadCountParams;
import com.hippo.model.UnreadCountModel;
import com.hippo.model.UnreadCountResponse;
import com.hippo.retrofit.APIError;
import com.hippo.retrofit.CommonParams;
import com.hippo.retrofit.ResponseResolver;
import com.hippo.retrofit.RestClient;
import java.util.ArrayList;
import retrofit2.Callback;

public class UnreadCountApi {
    private ArrayList<FuguConversation> fuguConversationList = new ArrayList();
    private ArrayList<UnreadCountModel> unreadCountModels = new ArrayList();

    public void getConversations(Activity activity, String enUserId, final CountUnread countUnread) {
        CommonParams commonParams = new CommonParams.Builder().add("app_secret_key", HippoConfig.getInstance().getAppKey()).add("en_user_id", enUserId).add("app_version", 260).add("device_type", 1).build();
        RestClient.getApiInterface().getConversations(commonParams.getMap()).enqueue((Callback)new ResponseResolver<FuguGetConversationsResponse>(activity, Boolean.valueOf(false), Boolean.valueOf(false)){

            @Override
            public void success(FuguGetConversationsResponse fuguGetConversationsResponse) {
                try {
                    CommonData.setConversationList(fuguGetConversationsResponse.getData().getFuguConversationList());
                    int count = 0;
                    UnreadCountApi.this.fuguConversationList.clear();
                    UnreadCountApi.this.fuguConversationList.addAll(fuguGetConversationsResponse.getData().getFuguConversationList());
                    for (int i = 0; i < UnreadCountApi.this.fuguConversationList.size(); ++i) {
                        count += ((FuguConversation)UnreadCountApi.this.fuguConversationList.get(i)).getUnreadCount();
                    }
                    countUnread.countValue(count);
                    UnreadCountApi.this.updateCount(UnreadCountApi.this.fuguConversationList);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }

            @Override
            public void failure(APIError error) {
            }
        });
    }

    private void updateCount(ArrayList<FuguConversation> fuguConversationList) {
        try {
            int count = 0;
            this.unreadCountModels.clear();
            CommonData.setUnreadCount(this.unreadCountModels);
            for (int i = 0; i < fuguConversationList.size(); ++i) {
                if (fuguConversationList.get(i).getUnreadCount() <= 0) continue;
                UnreadCountModel countModel = new UnreadCountModel(fuguConversationList.get(i).getChannelId(), fuguConversationList.get(i).getLabelId(), fuguConversationList.get(i).getUnreadCount());
                this.unreadCountModels.add(countModel);
                count += fuguConversationList.get(i).getUnreadCount();
            }
            CommonData.setUnreadCount(this.unreadCountModels);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void getChannelUnreadCount(Activity activity, String enUserId, String transactionId, String userUniqueKey, ArrayList<String> otherUserUniqueKeys, final UnreadCountFor countUnread) {
        CommonParams commonParams = new CommonParams.Builder().add("app_secret_key", HippoConfig.getInstance().getAppKey()).add("en_user_id", enUserId).add("user_unique_key", userUniqueKey).add("other_user_unique_key", otherUserUniqueKeys).add("transaction_id", transactionId).add("app_version", 260).add("device_type", 1).build();
        Gson gson = new GsonBuilder().create();
        JsonArray otherUsersArray = null;
        if (otherUserUniqueKeys != null) {
            otherUsersArray = gson.toJsonTree(otherUserUniqueKeys).getAsJsonArray();
        }
        HippoUnreadCountParams params = new HippoUnreadCountParams(HippoConfig.getInstance().getAppKey(), transactionId, userUniqueKey, otherUsersArray, enUserId);
        if (!TextUtils.isEmpty((CharSequence)HippoConfig.getInstance().getCurrentLanguage())) {
            params.setLang(HippoConfig.getInstance().getCurrentLanguage());
        }
        RestClient.getApiInterface().fetchUnreadCountFor(params).enqueue((Callback)new ResponseResolver<UnreadCountResponse>(activity, Boolean.valueOf(false), Boolean.valueOf(true)){

            @Override
            public void success(UnreadCountResponse response) {
                try {
                    int count = response.getData().getUnreadCount();
                    Long channelId = response.getData().getChannelId();
                    if (channelId != null) {
                        HippoConfig.getInstance().unreadCountFor(channelId, count);
                    } else {
                        countUnread.unreadCountFor(count);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }

            @Override
            public void failure(APIError error) {
            }
        });
    }

    public static interface CountUnread {
        public void countValue(int var1);
    }
}

