/*
 * Decompiled with CFR 0.152.
 */
package com.hippo.support.Utils;

import android.text.TextUtils;
import com.hippo.HippoConfig;
import com.hippo.model.CustomAttributes;
import com.hippo.support.model.HippoSendQueryParams;
import com.hippo.support.model.TagsModel;
import com.hippo.support.model.callbackModel.OpenChatParams;
import java.util.ArrayList;

public class CommonSupportParam {
    public OpenChatParams getOpenChatParam(String categoryName, String transactionId, String userUniqueId, int supportId, ArrayList<String> pathList, String subHeader) {
        String channelName = this.getChannelName(pathList.get(pathList.size() - 1), userUniqueId, supportId, transactionId);
        String message = this.getMessage(userUniqueId, transactionId, categoryName, pathList.get(pathList.size() - 1), null, subHeader);
        transactionId = !TextUtils.isEmpty((CharSequence)transactionId) ? transactionId + "_" + supportId : userUniqueId + "_" + supportId;
        String[] data = new String[]{message};
        ArrayList<String> tagsList = new ArrayList<String>();
        tagsList.add(categoryName);
        CustomAttributes attributes = this.getAttributes(pathList, userUniqueId, transactionId, null);
        return new OpenChatParams(transactionId, userUniqueId, channelName, tagsList, data, attributes);
    }

    public HippoSendQueryParams getSubmitQueryParams(String categoryName, String transactionId, String userUniqueId, int supportId, ArrayList<String> pathList, String textboxMsg, String subHeader) {
        String channelName = this.getChannelName(pathList.get(pathList.size() - 1), userUniqueId, supportId, transactionId);
        String message = this.getMessage(userUniqueId, transactionId, categoryName, pathList.get(pathList.size() - 1), textboxMsg, subHeader);
        transactionId = !TextUtils.isEmpty((CharSequence)transactionId) ? transactionId + "_" + supportId : userUniqueId + "_" + supportId;
        String[] msg = new String[]{message};
        ArrayList<TagsModel> tags = new ArrayList<TagsModel>();
        tags.add(new TagsModel(categoryName));
        HippoSendQueryParams params = new HippoSendQueryParams(HippoConfig.getInstance().getAppKey(), -1L, transactionId, HippoConfig.getInstance().getUserData().getUserId(), channelName, tags, msg, HippoConfig.getInstance().getUserData().getEnUserId(), 1);
        CustomAttributes attributes = this.getAttributes(pathList, userUniqueId, transactionId, textboxMsg);
        params.setCustomAttributes(attributes);
        return params;
    }

    private String getChannelName(String pageTitle, String userUniqueId, int supportId, String transactionId) {
        String channelName = pageTitle + " #" + userUniqueId + "_" + supportId;
        if (!TextUtils.isEmpty((CharSequence)transactionId)) {
            channelName = pageTitle + " #" + transactionId;
        }
        return channelName;
    }

    private String getMessage(String userUniqueId, String transactionId, String categoryName, String pageTitle, String edittextBoxText, String subHeader) {
        String message = "";
        message = "[User ID: " + userUniqueId + "]";
        if (!TextUtils.isEmpty((CharSequence)transactionId)) {
            message = message + "\n[Transaction ID: " + transactionId + "]";
        }
        message = message + "\n[Request type: " + categoryName + "]";
        message = message + "\n[Request] ";
        if (!TextUtils.isEmpty((CharSequence)edittextBoxText)) {
            message = message + edittextBoxText;
        } else if (!TextUtils.isEmpty((CharSequence)subHeader)) {
            message = message + pageTitle + "->" + subHeader;
        }
        return message;
    }

    private CustomAttributes getAttributes(ArrayList<String> pathList, String userUniqueId, String transactionId, String query) {
        String attributesPath = "";
        for (String str : pathList) {
            if (TextUtils.isEmpty((CharSequence)attributesPath)) {
                attributesPath = attributesPath + str;
                continue;
            }
            attributesPath = attributesPath + " -> " + str;
        }
        CustomAttributes attributes = new CustomAttributes();
        attributes.setPath(attributesPath);
        attributes.setUserId(userUniqueId);
        if (!TextUtils.isEmpty((CharSequence)transactionId)) {
            attributes.setTransactionId(transactionId);
        }
        if (!TextUtils.isEmpty((CharSequence)query)) {
            attributes.setQuery(query);
        }
        return attributes;
    }
}

