/*
 * Decompiled with CFR 0.152.
 */
package faye;

import android.os.Handler;
import android.os.Message;
import com.hippo.utils.HippoLog;
import java.net.URI;
import org.java_websocket.client.WebSocketClient;
import org.java_websocket.exceptions.InvalidDataException;
import org.java_websocket.framing.Framedata;
import org.java_websocket.handshake.ClientHandshake;
import org.java_websocket.handshake.ServerHandshake;

public class WebSocket
extends WebSocketClient {
    private static final String LOG_TAG = WebSocket.class.getSimpleName();
    public static final int ON_OPEN = 1;
    public static final int ON_CLOSE = 2;
    public static final int ON_MESSAGE = 3;
    public static final int ON_ERROR = 4;
    public static final int ON_PONG = 5;
    public static final int ON_NOT_CONNECTED = 6;
    private Handler messageHandler;

    public WebSocket(URI serverUri, Handler handler) {
        super(serverUri);
        this.messageHandler = handler;
    }

    public void onOpen(ServerHandshake serverHandshake) {
        this.messageHandler.sendMessage(Message.obtain((Handler)this.messageHandler, (int)1));
    }

    public void onMessage(String s) {
        System.out.println("==================================================");
        System.out.println(s);
        System.out.println("==================================================");
        this.messageHandler.sendMessage(Message.obtain((Handler)this.messageHandler, (int)3, (Object)s));
    }

    public void onClose(int code, String reason, boolean remote) {
        HippoLog.i(LOG_TAG, "code: " + code + ", reason: " + reason + ", remote: " + remote);
        this.messageHandler.sendMessage(Message.obtain((Handler)this.messageHandler, (int)2));
    }

    public void onError(Exception e) {
        HippoLog.e(LOG_TAG, "On WebSocket Error:" + e);
        this.messageHandler.sendMessage(Message.obtain((Handler)this.messageHandler, (int)6));
    }

    public void setConnectionLostTimeout(int connectionLostTimeout) {
        super.setConnectionLostTimeout(connectionLostTimeout);
        HippoLog.i(LOG_TAG, "connectionLostTimeout: " + connectionLostTimeout);
    }

    protected void startConnectionLostTimer() {
        super.startConnectionLostTimer();
        HippoLog.e(LOG_TAG, "On startConnectionLostTimer");
    }

    public boolean reconnectBlocking() throws InterruptedException {
        return super.reconnectBlocking();
    }

    public void onWebsocketPong(org.java_websocket.WebSocket conn, Framedata f) {
        super.onWebsocketPong(conn, f);
        this.messageHandler.sendMessage(Message.obtain((Handler)this.messageHandler, (int)5, (Object)f));
        HippoLog.e(LOG_TAG, "On onWebsocketPong");
    }

    public void onWebsocketHandshakeReceivedAsClient(org.java_websocket.WebSocket conn, ClientHandshake request, ServerHandshake response) throws InvalidDataException {
        super.onWebsocketHandshakeReceivedAsClient(conn, request, response);
        HippoLog.e(LOG_TAG, "On onWebsocketHandshakeReceivedAsClient");
    }

    public boolean connectBlocking() throws InterruptedException {
        HippoLog.e(LOG_TAG, "On connectBlocking");
        return super.connectBlocking();
    }
}

